<?php
  global $foodbookAttr;
  $text = FoodBook\Inc\Text::getText();
  $options = get_option('foodbook_options');

  $column       = '4';
  $shortCodeCat = '';
  $layout       = 'grid';
  $sidebar      = 'yes';
  $search       = 'yes';
  $paddingTop   = '120px';
  $paddingBottom  = '120px';
  $branch_id    = '';
  $is_shortcode = false;


  if( !empty( $foodbookAttr ) ) {

    $column = foodbook_bootstrap_column_map( $foodbookAttr['col'] );
    $shortCodeCat    = !empty(  $foodbookAttr['cat'] ) ? $foodbookAttr['cat'] : '';
    $layout          = !empty(  $foodbookAttr['layout'] ) ? $foodbookAttr['layout'] : '';
    $sidebar         = !empty(  $foodbookAttr['sidebar'] ) ? $foodbookAttr['sidebar'] : '';
    $search          = !empty(  $foodbookAttr['search'] ) ? $foodbookAttr['search'] : '';
    $paddingTop      = !empty(  $foodbookAttr['padding_top'] ) ? $foodbookAttr['padding_top'] : '0px';
    $paddingBottom   = !empty(  $foodbookAttr['padding_bottom'] ) ? $foodbookAttr['padding_bottom'] : '0px';
    // Check
    if( !empty(  $foodbookAttr['branch_id'] ) ) {
      $branch_id = $foodbookAttr['branch_id'];
      $is_shortcode = true;
    }

  } else {

    $column = !empty(  $options['product-column'] ) ? $options['product-column'] : '';
    $layout = !empty(  $options['product-layout'] ) ? $options['product-layout'] : 'grid';
    $search = !empty( $options['search-section'] ) && $options['search-section'] == 'yes' ? 'yes' : 'no';

  }
?>

<div class="fb__wrapper" style="padding-top:<?php echo esc_attr( $paddingTop ); ?>;padding-bottom: <?php echo esc_attr( $paddingBottom ); ?>">
  <!-- Search -->
  <?php 
  if( $search == 'yes' ) {
    include FOODBOOK_DIR_PATH.'view/template-part-woo-search.php';
  }
    
  ?>
  <!-- End Search -->
  <!-- Product -->
  <section>
    <div class="fb_container">
      <div class="fb_row">
        <?php
        // Sidebar
        $wrapCol = '12';
        if( $sidebar == 'yes' ) {
          $wrapCol = '9';
          include FOODBOOK_DIR_PATH.'view/template-part-woo-sidebar.php';
        }
        ?>
        <div class="fb_col_lg_<?php echo esc_attr( $wrapCol ); ?>">
          <!-- Section Title -->
          <div class="fb_section_title">
            <h3><?php echo esc_html( $text['all_items'] ); ?></h3>
            <?php
            // product filter by branch
            do_action( 'foodbook_product_page_branch_selectbox', $is_shortcode );
            ?>
            <select name="orderby" class="orderby-filter" aria-label="Shop order">
                <option value="menu_order" selected="selected"><?php esc_html_e( 'Default sorting', 'foodbook' ); ?></option>
                <option value="popularity"><?php esc_html_e( 'Sort by popularity', 'foodbook' ); ?></option>
                <option value="rating"><?php esc_html_e( 'Sort by average rating', 'foodbook' ); ?></option>
                <option value="date"><?php esc_html_e( 'Sort by latest', 'foodbook' ); ?></option>
                <option value="price"><?php esc_html_e( 'Sort by price: low to high', 'foodbook' ); ?></option>
                <option value="price-desc"><?php esc_html_e( 'Sort by price: high to low', 'foodbook' ); ?></option>
            </select>
          </div>
          <!-- Section Title -->
          <!-- Product List -->
          <div class="fb_row foodbook-products" data-branchid="<?php echo esc_attr( $branch_id ); ?>" data-cat="<?php echo esc_attr( $shortCodeCat ); ?>" data-col="<?php echo esc_attr( $column ); ?>" data-layout="<?php echo esc_attr( $layout ); ?>"></div>
          <!-- End Product List -->
        </div>
      </div>
    </div>
  </section>
  <!-- End Product -->
  
</div>
