<script type="text/html" id="tmpl-fb_product_content">
<!-- Step Content -->
<div class="fb_steps_content step-product-info">
  <form action="#" id="fbs_single_add_to_cart_button" method="post" class="fb_product_details_form">
    <div class="fb_row">
      <div class="fb_col_lg_6">
        <div class="fb_row">
          <div class="fb_col_md_6">
            <!-- Product Details Image -->
            <# if( ! _.isEmpty(data.galleryimgs) ){ #>
            <!-- Place somewhere in the <body> of your page -->
            <div id="slider" class="flexslider fb_product_details_img">
              <ul class="slides">
                <li><img src={{data.thumbnail}} /></li>
                <# _.each( data.galleryimgs, function( item, key ) { #>
                  <li><img src={{item}} alt={{key}} /></li>
                <#} ) #>
                <!-- items mirrored twice, total of 12 -->
              </ul>
            </div>
            <div id="carousel" class="flexslider gallery-nav">
              <ul class="slides">
                <li><img src={{data.thumbnail}} /></li>
                <# _.each( data.galleryimgs, function( item, key ) { #>
                  <li><img src={{item}} alt={{key}} /></li>
                <#} ) #>
                <!-- items mirrored twice, total of 12 -->
              </ul>
            </div>
            <# } else{ #> 
            <div class="fb_product_details_img">
              <img src={{data.thumbnail}} alt="" />
            </div>
            <#} #>
          <!-- End Product Details Image -->
          <# if( data.description ) { #>
          <h5><?php esc_html_e( 'Description:', 'foodbook' ); ?></h5>
          <div class="fb_product_summary">{{{data.description}}}</div>
          <# } #>

          </div>
          <div class="fb_col_md_6">
            <!-- Product Details Content -->
            <div class="fb_product_details_content">
              <h3 class="fb_product_title">{{data.title}}</h3>
              <# if( data.nutrition ){ #>
              <div class="product-nutrition">
                <ul>
                <# _.each( data.nutrition, function( item, key ) { #>
                    <li><span>{{item.title}}</span><span class="nutrition-qty">{{item.quantity}}</span></li>
                <#} ) #>
                </ul>
              </div>
              <#}#>

              <# if( foodbookobj.is_enable_reviews == 'yes' ) { #>
              <div class="fb-product-reviews">
                <div class="fb_star_rating">{{{data.star_rating}}}</div>
                <span class="woocommerce-review-link fb-product-review">(<span class="count">{{data.reviewcount}}</span> <?php esc_html_e( 'customer reviews', 'foodbook'); ?>)</span>
              </div> 
              <#}#>
              <h6>
              <?php esc_html_e( 'Price:', 'foodbook' ); ?>
              <p class="fb_product_price"> {{{data.price_html}}} </p>
              </h6>
              <div class="fb_product_summary">{{{data.short_description}}}</div>
              <!-- Extra Options -->
              <div class="fb_extra_options">
                <ul class="fb_list_unstyled fb_attribute_list" data-attribute-count={{data.attributes_count}}>
                <# _.each( data.attributes, function( items, key ) {  #>
                  <li class="fb_label_title" data-product-attribute={{items.attribute}}>
                    <h5>{{key}} <span>*</span></h5>
                  </li>
                  <# _.each( items.options, function( item ) { #>
                  <li>
                    <# var t = items.name; var checked = ''; if( data.defaultAttributes == item.slug ) {  checked = 'checked' } #>
                    <span class="fb_custom_checkbox">
                      <label>
                        <input
                          type="radio"
                          value="{{item.name}}"
                          name="{{items.attribute}}"
                          data-attr-slug="{{item.slug}}"
                          data-name-attr="{{items.attribute}}"
                          data-name="{{item.name}}"
                          class="fb-product-attribute"
                          {{checked}}
                        />
                        <span class="fb_input_text">{{{item.name}}}</span>
                        <span class="fb_custom_checkmark"></span>
                      </label>
                    </span>
                    <span class="fb-variable-price"></span>
                  </li>
                  <# } ) } ) #>
                </ul>
              </div>
              <!-- End Extra Options -->
              <!-- Quantity -->
              <div class="fb_d_flex fb_align_items_center fb_justify_content_between">
                <span class="fb_label_title"><?php esc_html_e( 'Quantity', 'foodbook' ); ?></span>

                <div class="fb_quantity fb_d_flex fb_align_items_center">
                  <span class="fb_minus fb_d_flex fb_align_items_center fb_justify_content_center">
                    <img src="<?php echo FOODBOOK_DIR_URL.'assets/img/icon/minus.svg'; ?>" class="fb_svg" alt=""/>
                  </span>
                  <input type="number" class="fb_quantity_input" name="fb_quantity" value="1" min="1" disabled />
                  <span class="fb_plus fb_d_flex fb_align_items_center fb_justify_content_center" >
                    <img src="<?php echo FOODBOOK_DIR_URL.'assets/img/icon/plus.svg'; ?>" class="fb_svg" alt="" />
                  </span>
                </div>
              </div>
              <!-- End Quantity -->
            </div>
            <!-- End Product Details Content -->
          </div>
        </div>
      </div>
      <div class="fb_col_lg_6">
        <div class="fb_row">
          <div class="fb_col_12">
            
            <!-- Card -->
            <div class="fb_card fb_mt_50 fb_mt_lg_0">
              <div class="extra-items-group-wrapper">
                <!-- Extra features List -->
                <# _.each( data.extraFeatured, function( item, i ) { #>
                <#
                var getListType = item.list_type,
                    listType = 'checkbox',
                    inputName = 'fb_product_extra_options',
                    $parentIndex = i;

                if( getListType != 'checkbox' ) {

                  listType =  'radio';
                  inputName =  'fb_product_extra_options_'+i;

                }

                #>

                <div class="fb_form_input_list">
                  <div class="fb_features_list_title_wrap">
                      <h5 class="input_list_title">
                        {{item.group_title}}
                        <# if( item.group_required_number ){ #>
                          <span>*</span>
                        <#}#>
                      </h5>
                      <# 
                      if( item.group_required_number && item.group_required_number_max ){  
                      #>
                      <p class="required-msg"> <?php echo sprintf( __( 'Please choose at list %s and max %s options.', 'foodbook' ), "{{item.group_required_number}}","{{item.group_required_number_max}}" ); ?></p>
                      
                      <#}#>

                      <# 
                      if( !item.group_required_number && item.group_required_number_max ){  
                      #>
                      <p class="required-msg"> <?php echo sprintf( __( 'You could choose max %s options.', 'foodbook' ), "{{item.group_required_number_max}}" ); ?></p>
                      
                      <#}#>

                      <# 
                      if( item.group_required_number && !item.group_required_number_max ){  
                      #>
                      <p class="required-msg"> <?php echo sprintf( __( 'Please choose at list %s options.', 'foodbook' ), "{{item.group_required_number}}" ); ?></p>
                      
                      <#}#>

                      <# 
                      if( item.group_required_number || item.group_required_number_max ){  
                      #>
                      <input type="hidden" name="items_required_status[]" value="false" class="selectedcount">
                      <#}#>
                  </div>
                  
                  <ul class="fb_list_unstyled" data-extra-group="group_{{$parentIndex}}" data-extra-max-count="{{item.group_required_number_max}}" data-extra-required-count="{{item.group_required_number}}">
                    <# _.each( item.group_feature, function( item, i ) {
                    var p = item.price,
                        dataPrice = p.replace(',', '.'),
                        formatType = 'en-IN';

                        if( foodbookobj.wc_decimal_separator == ',' ) {
                          formatType = 'de-DE';
                        }

                    var y = new Intl.NumberFormat(formatType).format(dataPrice);
                    #>
                    <li>
                      <span class="fb_custom_checkbox extra_item_checkbox fb_w_100">
                        <label>
                          <input
                            class="product-extra-options"
                            type="{{listType}}"
                            data-price="{{dataPrice}}"                          
                            data-formatted-price ="{{item.title}} : <?php echo foodbook_price_number_formating( "{{y}}", false ); ?>";
                            value="{{dataPrice}}"
                            name="{{inputName}}[]"
                          />
                          <span
                            class="fb_input_text fb_d_flex fb_align_items_center fb_justify_content_between fb_w_100"
                            >{{item.title}}
                            <span>+ <?php echo foodbook_price_number_formating( "{{y}}", false ); ?></span>
                          </span>
                          <span class="fb_custom_checkmark"></span>
                        </label>
                      </span>
                    </li>
                    <# } ) #>
                    
                  </ul>
                </div>
                <# }  ) #>
              </div>
              <!-- End Extra features List -->

              <!-- Input List -->
              <div class="fb_form_input_list">
                <h5 class="input_list_title">{{foodbookobj.get_text.product_instructions}}</h5>
                <textarea
                  class="fb_input_style"
                  placeholder="<?php esc_attr_e( 'Add instructions...', 'foodbook' ); ?>"
                  name="item_instructions"
                ></textarea>
              </div>
              <!-- End Input List -->

              <!-- Total Price -->
              <div class="fb_label_title fb_total_price fb_d_flex fb_align_items_center fb_justify_content_between">
                <span><?php esc_html_e( 'Total Price', 'foodbook' ); ?></span>
                <span class="fb_total_Price" data-item-price={{data.price}}><?php echo foodbook_currency_symbol_position( "{{data.display_price}}" , false ); ?></span>
              </div>
              <!-- End Tolal Price -->
              <input type="hidden" name="product_id" value={{data.id}} />
              <input type="hidden" name="variation_id" class="variation_id" value="" />
              <input type="hidden" name="product_sku" value={{data.sku}} />
              <!-- Add To Cart -->
              <?php 
              $options = get_option('foodbook_options');
              if( !empty( $options['show-cart-button'] ) && $options['show-cart-button'] == 'yes'  ):
              ?>
              <button type="submit" class="fb_btn_fill fb_w_100 fb_add_to_cart_ajax ajax_add_to_cart" ><?php esc_html_e( 'Add to cart', 'foodbook' ); ?></button>
              <?php
              endif;
              ?>

              <div class="fb-after-cart-button" style="display:none"></div>
              <!-- End Add To Cart -->
            </div>
            <!-- End Card -->
          </div>
        </div>
      </div>
    </div>
  </form>
</div>
<!-- End Step Content -->

</script>