<?php 
namespace FoodBook;
/**
 *
 * @package     Foodbook
 * @author      ThemeLooks
 * @copyright   2020 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

class Custom_Hooks {

  function __construct() {
    // Delivery type html
    add_action( 'foodbook_delivery_types', [ $this, 'delivery_types_html' ] );
  }

  public function delivery_types_html() {
    $deliveryTime = get_option('foodbook_options');
    ?>
    <div class="fb_multiform">
      <!-- Form Selector Group -->  
      <label for="fb_delivery_type" class="fb_input_label fb_mb_0">
				<?php esc_html_e( 'Delivery Type', 'foodbook' ) ?><span class="fb-required">*</span>
			</label>        
      <ul class="fb_list_unstyled fb_form_selector_list fb_mt_5">
			<?php 

      $types = [
        [
          'title' => esc_html__( 'Delivery', 'foodbook' ),
          'class' => 'delivery-type-delivery',
          'value' => 'Delivery',
          'compare' => 'delivery'
        ],
        [
          'title' => esc_html__( 'Pickup by me', 'foodbook' ),
          'class' => 'delivery-type-pickup',
          'value' => 'Pickup',
          'compare' => 'pickup'
        ]

      ];

      $getTypes = apply_filters( 'foodbook_add_delivery_type', $types );

      foreach( $getTypes as $type ) {

        if( $deliveryTime['delivery-options'] == $type['compare'] || $deliveryTime['delivery-options'] == 'all' ) {

          $checked = $deliveryTime['delivery-options'] == $type['compare'] ? 'checked' : '';

          echo '<li class="fb_single_form_selector">
            <span class="fb_custom_checkbox">
              <label>
                <input type="radio" value="'.esc_attr( $type['value'] ).'" class="shipping_method '.esc_attr( $type['class'] ).'" name="fb_delivery_options" '.esc_attr( $checked ).'>
                <span class="fb_label_title">'.esc_html( $type['title'] ).'</span>
                <span class="fb_custom_checkmark"></span>
              </label>
            </span>
          </li>';
        }
        
      }
      ?>
      </ul>
          <!-- End Form Selector Group -->
    </div>
    <?php
  }

}

// Hooks class init
new Custom_Hooks();