<?php 
namespace FoodBook\Inc;
/**
 *
 * @package     Foodbook
 * @author      ThemeLooks
 * @copyright   2020 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

class Text {

  public static function getText() {
    return self::definedText();
  }

  public static function definedText() {

    $getText = [
      'view_cart'           => esc_html__( 'View Cart', 'foodbook' ),
      'buy_more'            => foodbook_getOptionData( 'buy-more-btn-text', esc_html__( 'Buy More', 'foodbook' ) ),
      'cart_added_error'    => esc_html__( 'Product don\'t added in the cart. please try again.', 'foodbook' ),
      'review_success_msg'  => esc_html__( 'Review has been submitted successfully.', 'foodbook' ),
      'review_error_msg'    => esc_html__( 'Review submission Failed. Please try again.', 'foodbook' ),
      'show_more'           => esc_html__( 'Show More', 'foodbook' ),
      'show_less'           => esc_html__( 'Less', 'foodbook' ),
      'loading'             => esc_html__( 'Loading', 'foodbook' ),
      'new_order_placed'    => esc_html__( 'New Order Placed', 'foodbook' ),
      'start_order'         => foodbook_getOptionData( 'start-order-btn-text', esc_html__( 'Start Order', 'foodbook' ) ),
      'delivery_available_success' => esc_html__( 'Delivery is available', 'foodbook' ),
      'delivery_available_error'   => esc_html__( 'Sorry, We are not available to delivery in your area', 'foodbook' ),
      'dac_title'                  => foodbook_getOptionData( 'delivery-availability-checker-text', esc_html__( 'Delivery Availability Checker', 'foodbook' ) ),
      'rl_title'                  => foodbook_getOptionData( 'rest-locat-text', esc_html__( 'Restaurant Location', 'foodbook' ) ),
      'dp_date_text'       => esc_html__( 'Deliver/Pickup Date', 'foodbook' ),
      'dp_time_text'       => esc_html__( 'Deliver/Pickup Time', 'foodbook' ),
      'dp_today_text'      => esc_html__( 'Today Delivery/Pickup', 'foodbook' ),
      'dp_schedule_text'   => esc_html__( 'Schedule Delivery/Pickup', 'foodbook' ),
      'boy_assigned_success'   => esc_html__( 'Delivery boy assigned success', 'foodbook' ),
      'boy_assigned_failed'   => esc_html__( 'Delivery boy assigned failed', 'foodbook' ),
      'Order_transfer_success'   => esc_html__( 'Order transfer success', 'foodbook' ),
      'Order_transfer_failed'    => esc_html__( 'Order transfer failed', 'foodbook' ),
      'availability_check'   => foodbook_getOptionData( 'availability-check-btn-text', esc_html__( 'Availability Check', 'foodbook' ) ),
      'list_type'   => esc_html__( 'List Type', 'foodbook' ),
      'checkbox'    => esc_html__( 'Checkbox', 'foodbook' ),
      'radio'       => esc_html__( 'Radio', 'foodbook' ),
      'categories_text'           => foodbook_getOptionData( 'categories-text', esc_html__( 'Categories', 'foodbook' ) ),
      'special_offer'             => foodbook_getOptionData( 'special-offer-text', esc_html__( 'Special Offer', 'foodbook' ) ),
      'all_items'                 => foodbook_getOptionData( 'all-items-text', esc_html__( 'All Items', 'foodbook' ) ),
      'product_instructions'      => foodbook_getOptionData( 'special-instructions-text', esc_html__( 'Special Instructions?', 'foodbook' ) ),
      'feature_section_title'     => esc_html__( 'Feature Section Title', 'foodbook' ),
      'min_required_number'       => esc_html__( 'Feature minimum required number', 'foodbook' ),
      'max_required_number'       => esc_html__( 'Feature max required number', 'foodbook' ),
      'frature_title'             => esc_html__( 'Frature Title', 'foodbook' ),
      'price'                     => esc_html__( 'Price', 'foodbook' ),
      'add_group'                 => esc_html__( 'Add Group', 'foodbook' ),
      'remove_group'              => esc_html__( 'Remove Group', 'foodbook' ),
      'add'                       => esc_html__( 'Add', 'foodbook' ),
      'add_features'              => esc_html__( 'Add Features', 'foodbook' ),
      'remove'                    => esc_html__( 'Remove', 'foodbook' ),
      'slot_full_text'            => esc_html__( 'This time slot is full. Try another time slot', 'foodbook' ),
      'valid_slot_not_available'  => esc_html__( 'Your selected time slot is not available for order.', 'foodbook' ),
      'valid_break_time'          => esc_html__( 'This is break time. Not available for order.', 'foodbook' ),
      'valid_delivery_time_field' => esc_html__( 'Deliver/Pickup Time is a required field.', 'foodbook' ),
      'valid_delivery_date_field' => esc_html__( 'Deliver/Pickup Date is a required field.', 'foodbook' ),
      'valid_delivery_type_field' => esc_html__( 'Deliver/Pickup type is a required field.', 'foodbook' ),
      'valid_branch_field'        => esc_html__( 'Deliver/Pickup Branch Name is a required field.', 'foodbook' ),
      'location_zip_code'        => esc_html__( 'Select Your Location Zip Code', 'foodbook' ),
      'valid_inrestaurant_table_number_field' => esc_html__( 'Restaurant Table Number is a required field.', 'foodbook' ),
      'nutrition_title'           => esc_html__( 'Nutrition Title', 'foodbook' ),
      'quantity'                  => esc_html__( 'Quantity', 'foodbook' ),
      'branch_select_msg'         => esc_html__( 'Please select the branch', 'foodbook' ),
      'table_number_label'        => esc_html__( 'Select Table Number', 'foodbook' ),
      'addcart_ranch_select_alert_msg' => esc_html__( 'Please Select the branch before add to cart', 'foodbook' ),
      'closing_time_msg'   => foodbook_getOptionData( 'closing-time-msg', esc_html__( 'This is closing time. So you can\'t order.', 'foodbook' ) ),
      'asap_text' => esc_html__( 'As Soon As Possible', 'foodbook' ),
    ];

    return apply_filters( 'foodbook_define_text', $getText );

  }


}
