<?php 
namespace FoodBook;
/**
 *
 * @package     Foodbook
 * @author      ThemeLooks
 * @copyright   2020 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

class Product_Layout {

  /**
   * [product_layout_grid description]
   * @return [type] [description]
   */
  public function product_layout_grid( $product, $options, $column, $imgUrl ) {
    ?>

    <div class="fb_col_lg_<?php echo esc_attr( $column ); ?> fb_col_sm_6 fb_text_center">
        <!-- Single Product -->
        <div class="fb_single_product_item">
          <!-- Product Thumb -->
          <div class="fb_product_top">
            <!-- Product Thumb -->
            <div class="fb_product_thumb">
              <img src="<?php echo esc_url( $imgUrl ); ?>" alt="<?php echo esc_attr( $product->get_name() ); ?>" />
            </div>
            <!-- End Product Thumb -->
            <!-- Overlay -->
            <div class="fb_overlay_content">
              <a class="fb_order_button fb_order_cart_button" href="#" data-pid="<?php echo esc_attr( $product->get_id() ); ?>" data-toggle="fbPopupModal" data-target="fb_popup_modal">
                <?php
                $btnIcon      = isset( $options['order-btn-icon'] ) ? $options['order-btn-icon'] : '';
                $btnHoverIcon = isset( $options['order-btn-hover-icon'] ) ? $options['order-btn-hover-icon'] : '';
                
                // Button Icon
                if( !empty( $btnIcon ) ) {
                  echo '<img src="'.esc_url( $btnIcon ).'" class="fb_svg" alt="'.esc_attr__( 'cart icon', 'foodbook' ).'" />';
                } else {
                  $icon = FOODBOOK_DIR_URL.'assets/img/icon/cart-btn.svg';
                  echo '<img src="'.esc_url( $icon ).'" class="fb_svg" alt="'.esc_attr__( 'cart icon', 'foodbook' ).'" />';
                }
                //
                if( !empty( $btnHoverIcon ) ) {
                  echo '<img src="'.esc_url( $btnHoverIcon ).'" class="fb_svg order-hover-icon" alt="'.esc_attr__( 'cart hover icon', 'foodbook' ).'" />';
                } else {
                  $btnHoverIcon = FOODBOOK_DIR_URL.'assets/img/icon/cart-btn-white.svg';
                  echo '<img src="'.esc_url( $btnHoverIcon ).'" class="fb_svg order-hover-icon" alt="'.esc_attr__( 'cart hover icon', 'foodbook' ).'" />';
                }
                
                // Order Button text 
                if( !empty( $options['order-btn-text'] ) ) {
                  echo esc_html( $options['order-btn-text'] );
                } else {
                  esc_html_e( 'Order Now', 'foodbook' );
                }
                ?>
              </a>
            </div>
            <!-- End Overlay -->
            <!-- OnSale -->
            <?php 
            if( !empty( $product->get_regular_price() ) && !empty( $product->get_sale_price() )  ) {
              echo '<span class="fb_badge">'.esc_html__( 'On sale', 'foodbook' ).'</span>';
            }
            ?>
            <!-- End OnSale -->
          </div>
          <!-- End Product Thumb -->
          <!-- Product Content -->
          <div class="fb_product_content">
            <!-- Title -->
            <h4 class="fb_product_title fb_order_cart_button" data-pid="<?php echo esc_attr( $product->get_id() ); ?>" data-toggle="fbPopupModal" data-target="fb_popup_modal"><?php echo esc_html( $product->get_name() ); ?></h4>
            <?php
            $desc = get_option('foodbook_options');
            if( !empty( $desc['show-item-short-desc'] ) ) {
              echo '<p>'.esc_html( $product->get_short_description() ).'</p>';
            }
            ?>
            <!-- End Title -->
            <!-- Star Rating -->
            <div class="fb_star_rating">
              <?php
              foodbook_rating_reviews( esc_html( $product->get_average_rating() ) );
              ?>                    
            </div>
            <!-- End Star Rating -->
            <!-- Price -->
            <p class="fb_product_price">
              <?php
              echo $product->get_price_html();
              ?>
            </p>
            <!-- End Price -->
          </div>
          <!-- End Product Content -->
        </div>
        <!-- Single Product -->
    </div>

    <?php

  }
  /**
   * [product_layout_grid description]
   * @return [type] [description]
   */
  public function product_layout_list( $product, $options, $column, $imgUrl ) {
    ?>

    <div class="fb_col_lg">
        <!-- Single Product -->
        <div class="fb_product_list fb_single_product_item">
          <div class="fb_row">
            <!-- Product Thumb -->
            <div class="fb_col_lg_4">
              <div class="fb_product_top">
                <!-- Product Thumb -->
                <div class="fb_product_thumb">
                  <img src="<?php echo esc_url( $imgUrl ); ?>" alt="<?php echo esc_attr( $product->get_name() ); ?>" />
                </div>
                <!-- End Product Thumb -->
                <!-- OnSale -->
                <?php 
                if( !empty( $product->get_regular_price() ) && !empty( $product->get_sale_price() )  ) {
                  echo '<span class="fb_badge">'.esc_html__( 'On sale', 'foodbook' ).'</span>';
                }
                ?>
                <!-- End OnSale -->
              </div>
            </div>
            <!-- End Product Thumb -->
            <!-- Product Content -->
            <div class="fb_col_lg_8">
              <div class="fb_product_content">
                <!-- Title -->
                <h4 class="fb_product_title fb_order_cart_button" data-pid="<?php echo esc_attr( $product->get_id() ); ?>" data-toggle="fbPopupModal" data-target="fb_popup_modal"><?php echo esc_html( $product->get_name() ); ?></h4>
                <!-- End Title -->
                <div class="fb_product_desc">
                  <p class="fb-read-more"><?php echo wp_kses_post( $product->get_description() ); ?></p>
                </div>
                <!-- Star Rating -->
                <div class="fb_star_rating">
                  <?php
                  foodbook_rating_reviews( esc_html( $product->get_average_rating() ) );
                  ?>                    
                </div>
                <!-- End Star Rating -->
                <!-- Price -->
                <p class="fb_product_price">
                  <?php
                   echo $product->get_price_html();
                  ?>
                </p>
                <!-- End Price -->
                <a class="fb_order_button fb_order_cart_button" href="#" data-pid="<?php echo esc_attr( $product->get_id() ); ?>" data-toggle="fbPopupModal" data-target="fb_popup_modal">
                    <?php
                    $btnIcon      = isset( $options['order-btn-icon'] ) ? $options['order-btn-icon'] : '';
                    $btnHoverIcon = isset( $options['order-btn-hover-icon'] ) ? $options['order-btn-hover-icon'] : '';
                    
                    // Button Icon
                    if( !empty( $btnIcon ) ) {
                      echo '<img src="'.esc_url( $btnIcon ).'" class="fb_svg" alt="'.esc_attr__( 'cart icon', 'foodbook' ).'" />';
                    } else {
                      $icon = FOODBOOK_DIR_URL.'assets/img/icon/cart-btn.svg';
                      echo '<img src="'.esc_url( $icon ).'" class="fb_svg" alt="'.esc_attr__( 'cart icon', 'foodbook' ).'" />';
                    }
                    //
                    if( !empty( $btnHoverIcon ) ) {
                      echo '<img src="'.esc_url( $btnHoverIcon ).'" class="fb_svg order-hover-icon" alt="'.esc_attr__( 'cart hover icon', 'foodbook' ).'" />';
                    }
                    
                    // Order Button text 
                    if( !empty( $options['order-btn-text'] ) ) {
                      echo esc_html( $options['order-btn-text'] );
                    } else {
                      esc_html_e( 'Order Now', 'foodbook' );
                    }
                    ?>
                  </a>
              </div>
            </div>
            <!-- End Product Content -->
          </div>
        </div>
        <!-- Single Product -->
    </div>

    <?php
  }

  /**
   * [product_search_grid_layout description]
   * @return [type] [description]
   */
  public function product_search_grid_layout( $result, $product, $price, $price_sale, $display_price ) {
    $productId = $result->ID;
    ?>
    <div class="fb_col_lg_4 fb_col_sm_6 fb_text_center">
      <!-- Single Product -->
      <div class="fb_single_product_item">
        <!-- Product Thumb -->
        <div class="fb_product_top">
          <!-- Product Thumb -->
          <div class="fb_product_thumb">
            <img src="<?php echo esc_url( get_the_post_thumbnail_url( $productId, 'full' ) ); ?>" alt="<?php echo esc_attr( $result->post_title ); ?>" />
          </div>
          <!-- End Product Thumb -->
          <!-- Overlay -->
          <div class="fb_overlay_content">
            <a class="fb_order_button fb_order_cart_button" href="#" data-pid="<?php echo esc_attr( $productId ); ?>" data-toggle="fbPopupModal" data-target="fb_popup_modal">
              <img src="<?php echo esc_url( FOODBOOK_DIR_URL.'assets/img/icon/cart-btn.svg' ); ?>" class="fb_svg" />
              <?php esc_html_e( 'order now', 'foodbook' ); ?>
            </a>
          </div>
          <!-- End Overlay -->
          <!-- OnSale -->
          <?php 
          if( !empty( $price[0] ) && !empty( $price_sale[0] )  ) {
            echo '<span class="fb_badge">'.esc_html__( 'On sale', 'foodbook' ).'</span>';
          }
          ?>
          <!-- End OnSale -->
        </div>
        <!-- End Product Thumb -->
        <!-- Product Content -->
        <div class="fb_product_content">
          <!-- Title -->
          <h4 class="fb_product_title fb_order_cart_button" data-pid="<?php echo esc_attr( $productId ); ?>" data-toggle="fbPopupModal" data-target="fb_popup_modal"><?php echo esc_html( $result->post_title ); ?></h4>
          <!-- End Title -->
          <!-- Star Rating -->
          <div class="fb_star_rating">
            <?php
            foodbook_rating_reviews( esc_html( $result->average_rating ) );
            ?>                    
          </div>
          <!-- End Star Rating -->
          <!-- Price -->
          <p class="fb_product_price">
            <?php
            echo $product->get_price_html();
            ?>
          </p>
          <!-- End Price -->
        </div>
        <!-- End Product Content -->
      </div>
      <!-- Single Product -->
    </div>
    <?php
  }

  /**
   * [product_search_list_layout description]
   * @return [type] [description]
   */
  public function product_search_list_layout( $result, $product, $price, $price_sale, $display_price ) {
    $productId = $result->ID;
  ?>
    <div class="fb_col_lg product-search-result-list">
      <!-- Single Product -->
      <div class="fb_single_product_item">
        <div class="fb_row">
          <!-- Product Thumb -->
          <div class="fb_col_lg_4">
            <div class="fb_product_top">
              <!-- Product Thumb -->
              <div class="fb_product_thumb">
                <img src="<?php echo esc_url( get_the_post_thumbnail_url( $productId, 'full' ) ); ?>" alt="<?php echo esc_attr( $result->post_title ); ?>" />
              </div>
              <!-- End Product Thumb -->
              <!-- OnSale -->
              <?php 
              if( !empty( $price[0] ) && !empty( $price_sale[0] )  ) {
                echo '<span class="fb_badge">'.esc_html__( 'On sale', 'foodbook' ).'</span>';
              }
              ?>
              <!-- End OnSale -->
            </div>
          </div>
          <!-- End Product Thumb -->
          <!-- Product Content -->
          <div class="fb_col_lg_8">
            <div class="fb_product_content">
              <!-- Title -->
              <h4 class="fb_product_title fb_order_cart_button" data-pid="<?php echo esc_attr( $productId ); ?>" data-toggle="fbPopupModal" data-target="fb_popup_modal"><?php echo esc_html( $result->post_title ); ?></h4>
              <!-- End Title -->
              <div class="fb_product_desc">
                  <p class="fb-read-more"><?php echo wp_kses_post( $product->get_description() ); ?></p>
              </div>
              <!-- Star Rating -->
              <div class="fb_star_rating">
                <?php
                foodbook_rating_reviews( esc_html( $result->average_rating ) );
                ?>                    
              </div>
              <!-- End Star Rating -->
              <!-- Price -->
              <p class="fb_product_price">
                <?php
                echo $product->get_price_html();
                ?>
              </p>
              <a class="fb_order_button fb_order_cart_button" href="#" data-pid="<?php echo esc_attr( $productId ); ?>" data-toggle="fbPopupModal" data-target="fb_popup_modal">
                  <img src="<?php echo esc_url( FOODBOOK_DIR_URL.'assets/img/icon/cart-btn.svg' ); ?>" class="fb_svg" />
                  <?php esc_html_e( 'order now', 'foodbook' ); ?>
              </a>
              <!-- End Price -->
            </div>
          </div>
          <!-- End Product Content -->
        </div>
      </div>
      <!-- Single Product -->
    </div>
  <?php
  }


}
