<?php 
namespace FoodBook;
/**
 *
 * @package     Foodbook
 * @author      ThemeLooks
 * @copyright   2020 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

class Hooks {

  function __construct() {

    $options = get_option('foodbook_options');

    // Foodbook shop page shortcode register hook
    add_shortcode( 'foodbook_products', [ __CLASS__, 'foodbook_shortcode' ] );

    // Foodbook shop page shortcode register hook
    add_shortcode( 'fb_only_product', [ __CLASS__, 'foodbook_cat_branch_product_shortcode' ] );

    // Foodbook delivery ability checker shortcode register hook
    add_shortcode( 'foodbook_delivery_ability_checker', [ __CLASS__, 'foodbook_delivery_ability_checker_shortcode' ] );

    // Foodbook shop page Template include filter hook
    add_filter( 'template_include', [ __CLASS__, 'foodbook_page_template'], 99 );

    // register_taxonomy for specialoffer post types.
    add_action( 'init', [ __CLASS__, 'foodbook_specialoffer_taxonomy'], 0 );
    // add_ons register taxonomy for product post types.
    if( !empty( $options['product-extra-add-ons-from'] ) && $options['product-extra-add-ons-from'] == 'global_term' ) {

    add_action( 'init', [ __CLASS__ ,'product_add_ons_taxonomy' ] );
    add_action( 'addons_add_form_fields', [ __CLASS__, 'add_ons_taxonomy_meta_fields' ] );
    add_action( 'addons_edit_form_fields', [ __CLASS__, 'edit_ons_taxonomy_meta_fields' ], 10, 2 );

    add_action( 'created_addons', [ __CLASS__, 'add_ons_save_taxonomy_meta_fields' ] );
    add_action( 'edited_addons', [ __CLASS__, 'add_ons_save_taxonomy_meta_fields' ] );

    add_action("addons_edit_form", [ __CLASS__, "add_add_ons_taxonomy_css" ] );
    add_action("addons_add_form", [ __CLASS__, "add_add_ons_taxonomy_css" ] );

    }

    // Add Body class on foodbook woocommerce page action hook
    add_filter( 'body_class', [ __CLASS__, 'add_body_class'] );

    // Js template hook in footer action hook
    add_action( 'wp_footer', [ __CLASS__, 'fb_js_template'] );

    // Login redirect filter hook
    add_filter( 'login_redirect', [ __CLASS__, 'foodbook_login_redirect' ], 10, 3 );

    // Login failed redirect
    add_action( 'wp_login_failed', [ __CLASS__, 'foodbook_login_failed_redirect' ] );

    // Add custom userr roles
    add_filter( 'init', [ __CLASS__, 'foodbook_add_roles' ] );

    //
    add_action( 'admin_init', [$this, 'foodbook_no_admin_access'], 100 );

    //
    add_action( 'after_setup_theme', [ $this, 'disable_admin_bar' ] );

    // Location modal
    add_action( 'wp_footer', [ __CLASS__, 'location_modal'] );

    // Mini Cart
    add_action( 'wp_footer', [ __CLASS__, 'foodbook_mini_cart'] );

    // unset checkout fields
    add_filter( 'woocommerce_checkout_fields' , [ __CLASS__, 'unset_checkout_fields'] );

  }

  /**
   * Foodbook shop page shortcode register
   *
   * 
   */
  public static function foodbook_shortcode( $atts ) {

    $attr = shortcode_atts( array(
      'col'     => '3',
      'layout'  => 'grid',
      'sidebar' => 'yes',
      'search'  => 'yes',
      'cat'     => '',
      'branch_id'       => '',
      'padding_top'     => '0px',
      'padding_bottom'  => '0px',
      'shortcode'       => true
    ), $atts );

    global $foodbookAttr;

    $foodbookAttr = $attr;

    ob_start();
    include FOODBOOK_DIR_PATH.'view/template-part-woo-items.php';
    return ob_get_clean();
   
  }

  /**
   * Foodbook shop page shortcode register
   *
   * 
   */
  public static function foodbook_cat_branch_product_shortcode( $atts ) {

    $attr = shortcode_atts( array(
      'col'     => '3',
      'limit'   => '-1',
      'layout'  => 'grid',
      'cat'     => '',
      'branch_id'       => '',
      'padding_top'     => '0px',
      'padding_bottom'  => '0px',
      'shortcode'       => true
    ), $atts );

    global $foodbookAttr;

    $foodbookAttr = $attr;

    ob_start();
    include FOODBOOK_DIR_PATH.'view/template-part-woo-shortcode-items.php';
    return ob_get_clean();
   
  }

  /**
   * foodbook_delivery_ability_checker_shortcode 
   * @param  string $atts
   * @return html form
   */
  public static function foodbook_delivery_ability_checker_shortcode( $atts ) {

    $attr = shortcode_atts( array(
      'button_text'     => esc_html__( 'Search', 'foodbook' ),
    ), $atts );

    wp_enqueue_script('googleapis-place');
    wp_enqueue_script('location');

    ob_start();
    \Foodbook\Inc\Ability_Checker_Form::form_for_shortcode( esc_html( $attr['button_text'] ) );
    return ob_get_clean();

  }

  /**
   * Foodbook shop page Template include
   *
   * 
   */   
  public static function foodbook_page_template( $template ) {
   
    $options = get_option('foodbook_options');

    $shop_page            = !empty( $options['shop-page'] ) ? $options['shop-page'] : 'foodbook';
    $branch_manager_page  = !empty( $options['branch-manager'] ) ? $options['branch-manager'] : 'branch-manager';
    $kitchen_manager_page = !empty( $options['kitchen-manager'] ) ? $options['kitchen-manager'] : 'kitchen-manager';
    $delivery_page        = !empty( $options['delivery'] ) ? $options['delivery'] : 'delivery';
    $admin_page           = !empty( $options['admin'] ) ? $options['admin'] : 'admin';


    // Woo Items
    if ( is_page( $shop_page )  ) {

        $new_template = FOODBOOK_DIR_PATH.'view/template-woo-items.php';

        if ( '' != $new_template ) {
            return $new_template ;
        }
    }
    
    // Manager Admin 
    if ( is_page( $admin_page )  ) {

        $new_template = FOODBOOK_DIR_PATH.'frontend-admin/templates/template-admin.php';

        if ( '' != $new_template ) {
            return $new_template ;
        }
    }
    // Branch Manager 
    if ( is_page( $branch_manager_page )  ) {

        $new_template = FOODBOOK_DIR_PATH.'frontend-admin/templates/template-branch-management.php';

        if ( '' != $new_template ) {
            return $new_template ;
        }
    }
    // kitchen Admin 
    if ( is_page( $kitchen_manager_page )  ) {

        $new_template = FOODBOOK_DIR_PATH.'frontend-admin/templates/template-kitchen-management.php';

        if ( '' != $new_template ) {
            return $new_template ;
        }
    }

    // Delivery Admin 
    if ( is_page( $delivery_page )  ) {

        $new_template = FOODBOOK_DIR_PATH.'frontend-admin/templates/template-delivery-management.php';

        if ( '' != $new_template ) {
            return $new_template ;
        }
    }

    return $template;

  }

  /**
   * Register.
   *
   * @see register_taxonomy for specialoffer post types.
   * 
   */
  public static function product_add_ons_taxonomy() {

    $labels = array(
     'name'              => __( 'Add-ons', 'foodbook' ),
     'singular_name'     => __( 'Add-ons', 'foodbook' ),
     'search_items'      => __( 'Search Add-ons', 'foodbook' ),
     'all_items'         => __( 'All Add-ons', 'foodbook' ),
     'parent_item'       => __( 'Parent Add-ons', 'foodbook' ),
     'parent_item_colon' => __( 'Parent Add-ons:', 'foodbook' ),
     'edit_item'         => __( 'Edit Add-on', 'foodbook' ),
     'update_item'       => __( 'Update Add-on', 'foodbook' ),
     'add_new_item'      => __( 'Add New Add-on', 'foodbook' ),
     'new_item_name'     => __( 'New Add On Name', 'foodbook' ),
     'menu_name'         => __( 'Add-ons', 'foodbook' ),
   );
   $args   = array(
     'hierarchical'      => true, // make it hierarchical (like categories)
     'labels'            => $labels,
     'show_ui'           => true,
     'show_admin_column' => true,
     'query_var'         => true,
     'rewrite'           => [ 'slug' => 'add-ons' ],
   );
   register_taxonomy( 'addons', [ 'product' ], $args );

  }

  public static function add_add_ons_taxonomy_css(){
    echo '<style>.term-parent-wrap,.term-description-wrap{display: none;}.term-repeater-wrap .group-title-wrapper-list-type-inner {display: flex;align-items: center;gap:15px;margin: 0;}.term-repeater-wrap .group-title-wrapper-list-type-inner .radio-group {margin: 0;}.term-repeater-wrap .foodbook-fields-group{ background: #ffffff; } .term-repeater-wrap .group-title-wrapper-list-type label, .term-repeater-wrap .group-title-wrapper label {margin: 0px !important;margin-bottom: 12px !important;display: block;font-size: 14px;font-weight: 600;}.term-repeater-wrap .field-repeater-wrapper{ margin-top: 30px;}</style>';

  }
  public static function add_ons_taxonomy_meta_fields( $taxonomy ) {
    $getText = \Foodbook\Inc\Text::getText();

   ?>
   <tr class="form-field">
    <th><label for="rudr_text"><?php esc_html_e( 'Extra Add-ons', 'foodbook' ); ?></label></th>
    <td>
      <div id="foodbook_custom_product_data" class="panel term-repeater-wrap woocommerce_options_panel" > 
        <div class = 'options_group'>
        <div class="foodbook-extra-featured">
          <div class="foodbook-extra-featured-inner">
            <div class="foodbook-fields-group">
              <div class="group-title-wrapper group-title-wrapper-list-type form-field">
                <label><?php echo esc_html( $getText['list_type'] ); ?></label>
                <div class="group-title-wrapper-list-type-inner">
                  <div class="radio-group">
                    <span><?php echo esc_html( $getText['checkbox'] ); ?></span>
                    <input type="radio" name="extra_featured[list_type]" value="checkbox" class="group-title featured-list-type"   />
                  </div>
                  <div class="radio-group">
                    <span><?php echo esc_html( $getText['radio'] ); ?></span>
                    <input type="radio" name="extra_featured[list_type]" value="radio" class="group-title featured-list-type"  />
                  </div>
                </div>
              </div>

              
              <p class="group-title-wrapper form-field">
                <label><?php echo esc_html( $getText['min_required_number'] ); ?></label>
                <input type="number" name="extra_featured[group_required_number]" value="" class="group-title" />
              </p>
              <p class="group-title-wrapper foodbook-required-number-max form-field">
                <label><?php echo esc_html( $getText['max_required_number'] ); ?></label>
                <input type="number" name="extra_featured[group_required_number_max]" value="" class="group-title" />
              </p>

              <div class="field-repeater-wrapper">
                <div class="field-repeater-inner">
               
                  <div data-child-count="0" class="field-repeater">
                    <input type="text" name="extra_featured[group_feature][0][title]" placeholder="<?php echo esc_html( $getText['frature_title'] ); ?>" value="" class="group-title" />
                    <input type="text" name="extra_featured[group_feature][0][price]" placeholder="<?php echo esc_html( $getText['price'] ); ?>" value="" class="group-title wc_input_price" />
                    <span class="remove-repeater-field fb-btn"><?php echo esc_html( $getText['remove'] ); ?></span>
                  </div>
                
                </div>
                <button class="add-addons-repeater-field fb-btn fb-btn-margin-top fb-btn-margin-top fb-btn-margin-bottom"><?php echo esc_html( $getText['add'] ); ?></button>
              </div>
            </div>
          </div>
          </div>
          </div>
        </div>
      </td>
      </tr>
   <?php 
  }

  public static function edit_ons_taxonomy_meta_fields( $term, $taxonomy ) {
    $getText = \Foodbook\Inc\Text::getText();
    $data = get_term_meta( $term->term_id, '_extra_featured', true );
    $decodedData = json_decode( $data, true );
   ?>
   
   <tr class="form-field">
    <th><label for="rudr_text"><?php esc_html_e( 'Extra Add-ons', 'foodbook' ); ?></label></th>
    <td>
      <div id="foodbook_custom_product_data" class="panel term-repeater-wrap woocommerce_options_panel" > 
        <div class = 'options_group'>
        <div class="foodbook-extra-featured">
          <div class="foodbook-extra-featured-inner">
            <?php
              $checkValue = $decodedData['list_type'] ?? '';
              $requiredNumber = $decodedData['group_required_number'] ?? '';
              $requiredNumberMax = $decodedData['group_required_number_max'] ?? '';
            ?>
            <div class="foodbook-fields-group" data-count="">

              <div class="group-title-wrapper group-title-wrapper-list-type form-field">
                <label><?php echo esc_html( $getText['list_type'] ); ?></label>
                <div class="group-title-wrapper-list-type-inner">
                  <div class="radio-group">
                    <span><?php echo esc_html( $getText['checkbox'] ); ?></span>
                    <input type="radio" name="extra_featured[list_type]" value="checkbox" class="group-title featured-list-type" <?php echo checked( $checkValue, 'checkbox' ); echo !empty( $checkValue ) ? '' : 'checked'; ?>  />
                  </div>
                  <div class="radio-group">
                    <span><?php echo esc_html( $getText['radio'] ); ?></span>
                    <input type="radio" name="extra_featured[list_type]" value="radio" class="group-title featured-list-type" <?php echo checked( $checkValue, 'radio' ); ?> />
                  </div>
                </div>
              </div>

              <p class="group-title-wrapper form-field">
                <label><?php echo esc_html( $getText['min_required_number'] ); ?></label>
                <input type="number" name="extra_featured[group_required_number]" value="<?php echo esc_html( $requiredNumber ); ?>" class="group-title" />
              </p>
              <p class="group-title-wrapper foodbook-required-number-max form-field">
                <label><?php echo esc_html( $getText['max_required_number'] ); ?></label>
                <input type="number" name="extra_featured[group_required_number_max]" value="<?php echo esc_html( $requiredNumberMax ); ?>" class="group-title" />
              </p>
              <div class="field-repeater-wrapper">
                <div class="field-repeater-inner">
                <?php
                if( !empty( $decodedData['group_feature'] ) ):
                  foreach ( $decodedData['group_feature'] as $ckey => $value ):
                ?>
                  <div data-child-count="<?php echo esc_attr($ckey); ?>" class="field-repeater">
                    <input type="text" name="extra_featured[group_feature][<?php echo esc_attr( $ckey ); ?>][title]" placeholder="<?php echo esc_html( $getText['frature_title'] ); ?>" value="<?php echo esc_html( $value['title'] ); ?>" class="group-title" />
                    <input type="text" name="extra_featured[group_feature][<?php echo esc_attr( $ckey ); ?>][price]" placeholder="<?php echo esc_html( $getText['price'] ); ?>" value="<?php echo esc_html( $value['price'] ); ?>" class="group-title wc_input_price" />
                    <span class="remove-repeater-field fb-btn"><?php echo esc_html( $getText['remove'] ); ?></span>
                  </div>
                <?php 
                  endforeach;
                endif;
                ?>
                </div>
                <button class="add-addons-repeater-field fb-btn fb-btn-margin-top fb-btn-margin-top fb-btn-margin-bottom"><?php echo esc_html( $getText['add'] ); ?></button>
              </div>
            </div>
            
          </div>
        </div>
        </div>
      </div>
      <td>
    </tr>
   <?php 
  }

  public static function add_ons_save_taxonomy_meta_fields( $term_id ) {
    
    if( !empty( $_POST['extra_featured'] ) ) {

      $getTerm = get_term_by('id', absint( $term_id ), 'addons');

      $addons = $_POST['extra_featured'];
      $addons['group_title'] = sanitize_text_field( $getTerm->name );

      $featured = json_encode( $addons, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES );
      update_term_meta( $term_id, '_extra_featured', $featured );
    }

  }


  /**
   * Register.
   *
   * @see register_taxonomy for specialoffer post types.
   * 
   */
  public static function foodbook_specialoffer_taxonomy() {

      $args = array(
          'label'        => esc_html__( 'Special Offer', 'foodbook' ),
          'public'       => true,
          'rewrite'      => array( 'slug' => 'special-offer' ),
          'hierarchical' => true
      );

      register_taxonomy( 'specialoffer', 'product', $args );

  }

  /**
   *
   * Add Body class on foodbook woocommerce page
   * 
   */
  public static function add_body_class( $classes ) {

    // add checkout page body class
    if( is_checkout() ) {

      $classes = array_merge( $classes, array( 'foodbook-checkout' ) );

    }
    // add account page body class
    if( is_account_page() ) {
      $classes = array_merge( $classes, array( 'foodbook-checkout foodbook-account' ) );
    }

    return $classes;
  }

  /**
   *
   * Js template hook in footer
   * 
   * 
   */  
  public static function fb_js_template() {
    
    include FOODBOOK_DIR_PATH.'view/template-modal-wrapper.php';
    include FOODBOOK_DIR_PATH.'view/template-modal-steps.php';
    include FOODBOOK_DIR_PATH.'view/template-modal-product-content.php';
    include FOODBOOK_DIR_PATH.'view/template-modal-cart-content.php';
    include FOODBOOK_DIR_PATH.'view/template-modal-checkout.php';
    include FOODBOOK_DIR_PATH.'view/template-modal-loginreg.php';
    include FOODBOOK_DIR_PATH.'view/template-modal-reviews.php';
    include FOODBOOK_DIR_PATH.'view/template-modal-billing-summary.php';
    include FOODBOOK_DIR_PATH.'view/template-modal-alert.php';

    include FOODBOOK_DIR_PATH.'frontend-admin/js-templates/template-order-modal.php';

  }

/**
 * foodbook_login_redirect 
 * @param  [type] $redirect_to 
 * @param  [type] $request     
 * @param  [type] $user        
 * @return [type]              
 */
public static function foodbook_login_redirect( $redirect_to, $request, $user ) {

    $options = get_option('foodbook_options');

    $branch_manager_page  = !empty( $options['branch-manager'] ) ? $options['branch-manager'] : 'branch-manager';
    $kitchen_manager_page = !empty( $options['kitchen-manager'] ) ? $options['kitchen-manager'] : 'kitchen-manager';
    $delivery_page        = !empty( $options['delivery'] ) ? $options['delivery'] : 'delivery';

    //is there a user to check?
    if ( isset( $user->roles ) && is_array( $user->roles ) ) {
        //check for admins
        if ( in_array( 'administrator', $user->roles ) ) {
          // redirect them to the default place
          return $redirect_to;
        } elseif( in_array( 'branch_manager', $user->roles ) ) {
          return home_url( esc_html( $branch_manager_page ) );
        }elseif( in_array( 'kitchen_manager', $user->roles ) ){
          return home_url( esc_html( $kitchen_manager_page ) );
        }elseif( in_array( 'delivery_boy', $user->roles ) ) {
          return home_url( esc_html( $delivery_page ) );
        } else {
          return $redirect_to;
        }

    } else {
        return $redirect_to;
    }

}

/**
 * foodbook_login_failed_redirect
 * login failed redirect
 * @return 
 */
public static function foodbook_login_failed_redirect() {

  $options     = get_option('foodbook_options');
  $admin_page  = !empty( $options['admin'] ) ? $options['admin'] : 'admin';
  wp_redirect( site_url( esc_html( $admin_page ) ) );

}

/**
 * foodbook_add_roles
 * add custom role
 * @return 
 */
public static function foodbook_add_roles() {

  add_role( 'kitchen_manager', esc_html__( 'Kitchen Manager', 'foodbook' ), get_role( 'subscriber' )->capabilities );
  add_role( 'branch_manager', esc_html__( 'Branch Manager', 'foodbook' ), get_role( 'subscriber' )->capabilities );
  add_role( 'delivery_boy', esc_html__( 'Delivery Boy', 'foodbook' ), get_role( 'subscriber' )->capabilities );

}

/**
 * foodbook_no_admin_access
 * prevent wp admin access
 * @return 
 * 
 */
public function foodbook_no_admin_access() {

  $options = get_option('foodbook_options');

  $admin_page  = !empty( $options['admin'] ) ? $options['admin'] : 'admin';
  
  if ( ( current_user_can( 'kitchen_manager' ) || 
    current_user_can( 'branch_manager' ) || 
    current_user_can( 'delivery_boy' ) ) &&
    ! ( defined( 'DOING_AJAX' ) && DOING_AJAX )
  ) {

    wp_redirect( site_url( esc_html( $admin_page ) ) );
    exit;

  }

}

public function disable_admin_bar() {

   if ( current_user_can( 'kitchen_manager' ) || 
    current_user_can( 'branch_manager' ) || 
    current_user_can( 'delivery_boy' ) ) {

    // hide admin bar
    show_admin_bar(false);

   } else {

    // user can view admin bar
    show_admin_bar(true);

   }

}


/**
 * [location_modal description]
 * @return [type] [description]
 */
public static function location_modal() {

  $modalShow = get_option('foodbook_options');
  $popupActive = isset( $modalShow['location-popup-active'] ) ? $modalShow['location-popup-active'] : '';
  $availabilityCheckerActive = isset( $modalShow['availability-checker-active'] ) ? $modalShow['availability-checker-active'] : '';

  if( !$popupActive || !$availabilityCheckerActive ) {
    return;
  }

  $getPages = !empty( $modalShow['availability-checker-modal'] ) ? $modalShow['availability-checker-modal'] : 'foodbook';

  if( !is_page( $getPages ) ) {
    return;
  }

  ?>
  <script>
    jQuery('body').addClass('fbPopupModal-opened fb_popup_modal-opened');
  </script>
  <div class="fb__wrapper orderadmin_popup_modal fb_delivery_availability_checker" id="orderadmin_popup_modal">
    <div class="fb_popup_modal open" style="display: block">
      <div class="fb_modal_wrap fb_modal_location">
        <div class="fb_modal">
          <div class="fb_modal_inner">
          <?php
          // Close Modal
          if( !empty( $modalShow['modal-close-btn-show'] ) ):
          ?>
            <span class="fb_close_modal sad">
              <img src="<?php echo FOODBOOK_DIR_URL.'assets/img/icon/close.svg'; ?>" alt="<?php esc_attr_e( 'close', 'foodbook' ); ?>" />
            </span>
            <?php 
            endif;
            // Form
            \Foodbook\Inc\Ability_Checker_Form::form();
            ?>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php
}

/**
 * foodbook_mini_cart
 * @return html
 */
public static function foodbook_mini_cart() {
  global $foodbookAttr;
  
  if( !is_page( foodbook_getOptionData('shop-page') ) && !isset( $foodbookAttr['shortcode'] ) ) {
    return;
  }

  ?>
  <!-- Cart Button -->
  <span class="fb_cart_count_btn">
    <?php
    if( !is_admin() ):
    ?>
    <span class="fb_cart_count"><?php echo esc_html( WC()->cart->get_cart_contents_count() ); ?></span>
    <?php
    endif;
    ?>
    <span class="fb_cart_icon">
      <?php 
      if( !empty( $options['cart-btn-icon'] ) ) {
        echo '<img src="'.esc_url( $options['cart-btn-icon'] ).'" class="fb_svg" alt="'.esc_attr( 'cart count', 'foodbook' ).'" />';
      } else {
        $icon = FOODBOOK_DIR_URL.'assets/img/icon/cart-btn-icon.svg';
        echo '<img src="'.esc_url( $icon ).'" class="fb_svg" alt="'.esc_attr( 'cart count', 'foodbook' ).'" />';
      }
      ?>
    </span>
  </span>
  <!-- End Cart Button -->
  <?php
}


public static function unset_checkout_fields( $fields ) {

  $opt = get_option('foodbook_options');

  // Billing comments
  $billingFieldList = [
    'billing_first_name',
    'billing_last_name',
    'billing_company',
    'billing_address_1',
    'billing_address_2',
    'billing_city',
    'billing_postcode',
    'billing_country',
    'billing_state',
    'billing_phone',
    'billing_email',
  ];

  foreach( $billingFieldList as $list ) {

    if( !empty( $opt[$list] ) ) {
      unset( $fields['billing'][$list] );
    }

  }

  // order comments
  if( !empty( $opt['order_comments'] ) ) {
    unset($fields['order']['order_comments']);
  }
  // Shipping
  $shippingFieldList = [
    'shipping_first_name',
    'shipping_last_name',
    'shipping_company',
    'shipping_address_1',
    'shipping_address_2',
    'shipping_city',
    'shipping_postcode',
    'shipping_country',
    'shipping_state',
    'shipping_phone',
    'shipping_email',
  ];

  foreach( $shippingFieldList as $list ) {
    if( !empty( $opt[$list] ) ) {
      unset( $fields['shipping'][$list] );
    }
  }


  return $fields;


}


}

// Hooks class init
new Hooks();