<?php
namespace FoodBook;
/**
 *
 * @package     Foodbook
 * @author      ThemeLooks
 * @copyright   2020 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

use \Automattic\WooCommerce\Utilities\OrderUtil;

class Components_Ajax {

	function __construct() {


    add_action( 'wp_ajax_login_action', [$this, 'login'] );
    add_action( 'wp_ajax_nopriv_login_action', [$this, 'login'] );

    add_action( 'wp_ajax_registration_action', [$this, 'registration'] );
    add_action( 'wp_ajax_nopriv_registration_action', [$this, 'registration'] );

    add_action( 'wp_ajax_woo_search_product', [$this, 'search_product'] );
    add_action( 'wp_ajax_nopriv_woo_search_product', [$this, 'search_product'] );

    add_action( 'wp_ajax_invitation_mail_action', [$this, 'invitation_mail'] );
    add_action( 'wp_ajax_nopriv_invitation_mail_action', [$this, 'invitation_mail'] );

    add_action( 'wp_ajax_order_tracking_status_action', [$this, 'order_tracking_status'] );
    add_action( 'wp_ajax_nopriv_order_tracking_status_action', [$this, 'order_tracking_status'] ); 

    add_action( 'wp_ajax_notification_number_action', [$this, 'notification_number'] );
    add_action( 'wp_ajax_nopriv_notification_number_action', [$this, 'notification_number'] );

    add_action( 'wp_ajax_order_delivery_boy_assign_action', [$this, 'order_delivery_boy_assign'] );
    add_action( 'wp_ajax_nopriv_order_delivery_boy_assign_action', [$this, 'order_delivery_boy_assign'] );

    add_action( 'wp_ajax_order_filter_by_date_action', [$this, 'order_filter_by_date'] );
    add_action( 'wp_ajax_nopriv_order_filter_by_date_action', [$this, 'order_filter_by_date'] );

    add_action( 'wp_ajax_order_branch_transfer_action', [$this, 'order_branch_transfer'] );
    add_action( 'wp_ajax_nopriv_order_branch_transfer_action', [$this, 'order_branch_transfer'] );

    add_action( 'wp_ajax_order_statistic_action', [$this, 'order_statistic'] );
    add_action( 'wp_ajax_nopriv_order_statistic_action', [$this, 'order_statistic'] );

    add_action( 'wp_ajax_update_order_review_action', [$this, 'update_order_review'] );
    add_action( 'wp_ajax_nopriv_update_order_review_action', [$this, 'update_order_review'] );

    add_action( 'wp_ajax_new_order_push_notification_action', [$this, 'new_order_push_notification'] );
    add_action( 'wp_ajax_nopriv_new_order_push_notification_action', [$this, 'new_order_push_notification'] );

    add_action( 'wp_ajax_branch_manager_data_action', [$this, 'branch_manager_data'] );
    add_action( 'wp_ajax_nopriv_branch_manager_data_action', [$this, 'branch_manager_data'] );

    add_action( 'wp_ajax_order_data_action', [$this, 'order_data'] );
    add_action( 'wp_ajax_nopriv_order_data_action', [$this, 'order_data'] );

    add_action( 'wp_ajax_manager_date_filter_data_action', [$this, 'manager_date_filter_data'] );
    add_action( 'wp_ajax_nopriv_manager_date_filter_data_action', [$this, 'manager_date_filter_data'] );

    add_action( 'wp_ajax_preorder_date_filter_data_action', [$this, 'preorder_date_filter_data'] );
    add_action( 'wp_ajax_nopriv_preorder_date_filter_data_action', [$this, 'preorder_date_filter_data'] );

    add_action( 'wp_ajax_order_time_lists_action', [$this, 'order_time_lists'] );
    add_action( 'wp_ajax_nopriv_order_time_lists_action', [$this, 'order_time_lists'] );

    add_action( 'wp_ajax_client_location_action', [$this, 'client_location'] );
    add_action( 'wp_ajax_nopriv_client_location_action', [$this, 'client_location'] );

    add_action( 'wp_ajax_location_availability_check_action', [$this, 'location_availability_check'] );
    add_action( 'wp_ajax_nopriv_location_availability_check_action', [$this, 'location_availability_check'] );

    add_action( 'wp_ajax_get_branch_location_action', [$this, 'get_branch_location'] );
    add_action( 'wp_ajax_nopriv_get_branch_location_action', [$this, 'get_branch_location'] );

    add_action( 'wp_ajax_visitor_address_from_cookie_action', [$this, 'visitor_address_from_cookie'] );
    add_action( 'wp_ajax_nopriv_visitor_address_from_cookie_action', [$this, 'visitor_address_from_cookie'] );

    add_action( 'wp_ajax_get_branch_location_by_id_action', [__CLASS__, 'get_branch_location_by_id'] );
    add_action( 'wp_ajax_nopriv_get_branch_location_by_id_action', [__CLASS__, 'get_branch_location_by_id'] );

    add_action( 'wp_ajax_get_branch_table_number', [__CLASS__, 'get_branch_table_numbers'] );
    add_action( 'wp_ajax_nopriv_get_branch_table_number', [__CLASS__, 'get_branch_table_numbers'] );

    add_action( 'wp_ajax_holy_day_check_action', [__CLASS__, 'holy_day_check'] );
    add_action( 'wp_ajax_nopriv_holy_day_check_action', [__CLASS__, 'holy_day_check'] );

	}

  /**
   * [order_data description]
   * @return json object
   */
  public function order_data() {

    if( isset( $_POST['order_id'] ) ) {
      $obj = new Order_Details_Json( $_POST['order_id'] );
      echo $obj->getOrderData();
    }

    exit;

  }

  public function login() {

    // First check the nonce, if it fails the function will break
    $formData = isset( $_POST['data'] ) ? $_POST['data'] : '';
    $parms = [];
    parse_str( $formData, $parms );
    // Nonce is checked, get the POST data and sign user on
    $info = [];
    $info['user_login'] = $parms['uname'];
    $info['user_password'] = $parms['paw'];
    $info['remember'] = true;

    $user_signon = wp_signon( $info, false );

    if ( is_wp_error($user_signon) ){
        $s = array( 'loggedin' => false, 'message' => esc_html__('Wrong username or password.', 'foodbook' ) );
    } else {
        $s = array( 'loggedin' => true,  'message' => esc_html__('Login successful, redirecting...', 'foodbook' ) );
    }

    wp_send_json_success( $s );

  exit();

  }

  public function registration() {

    $formData = isset( $_POST['data'] ) ? $_POST['data'] : '';

    $parms = [];

    parse_str( $formData, $parms );

    $new_user_login = stripcslashes( $parms['username'] );
    $new_user_email = stripcslashes( $parms['useremail'] );
    $new_user_password = $parms['password'];

    $user_data = array(
        'user_login' => $new_user_login,
        'user_email' => $new_user_email,
        'user_pass' => $new_user_password,
        'role' => 'customer'
      );

      $user_id = wp_insert_user($user_data);
      //
      $status = [];

      if ( !is_wp_error( $user_id ) ) {

        wp_set_current_user( $user_id );
        wp_set_auth_cookie( $user_id );

        $status = [ 'loggedin' => true, 'user_id' => $user_id, 'message' => esc_html__('Wrong username or password.', 'foodbook' ) ];

      } else {

        if ( isset( $user_id->errors['empty_user_login'] ) ) {
            
            $status = [ 'loggedin' => false, 'message' => esc_html__('User Name and Email are mandatory', 'foodbook' ) ];

          } elseif (isset( $user_id->errors['existing_user_login'] ) ) {

            $status = [ 'loggedin' => false, 'message' => esc_html__('User name already exixts.', 'foodbook' ) ];

          } else {

            $status = [ 'loggedin' => false, 'message' => esc_html__('Error Occured please fill up the sign up form carefully.', 'foodbook' ) ];
           

          }

      }

      wp_send_json_success( $status );

    exit;

  }

  public function search_product() {
 
    global $wpdb, $woocommerce;
 
    if ( isset( $_POST['keyword'] ) && !empty( $_POST['keyword'] ) ) {
      
        $keyword = $_POST['keyword'];
        $getLayout = $_POST['layout'];
        
        // Check multibranch
        if( foodbook_is_multi_branch() ) {
        $branchId  = isset( $_POST['branch'] ) ? $_POST['branch'] : '';

        $querystr = "SELECT DISTINCT $wpdb->posts.*
        FROM $wpdb->posts, $wpdb->postmeta
        WHERE $wpdb->posts.ID = $wpdb->postmeta.post_id
        AND (
            ($wpdb->postmeta.meta_key = '_sku' AND $wpdb->postmeta.meta_value LIKE '%{$keyword}%')
            OR
            ($wpdb->posts.post_content LIKE '%{$keyword}%')
            OR
            ($wpdb->posts.post_title LIKE '%{$keyword}%')
        )
        AND ($wpdb->postmeta.meta_key = 'foodbookbranch_list' AND $wpdb->postmeta.meta_value LIKE '%{$branchId}%')
        AND $wpdb->posts.post_status = 'publish'
        AND $wpdb->posts.post_type = 'product'
        ORDER BY $wpdb->posts.post_date DESC";

        } else {

        $querystr = "SELECT DISTINCT $wpdb->posts.*
        FROM $wpdb->posts, $wpdb->postmeta
        WHERE $wpdb->posts.ID = $wpdb->postmeta.post_id
        AND (
            ($wpdb->postmeta.meta_key = '_sku' AND $wpdb->postmeta.meta_value LIKE '%{$keyword}%')
            OR
            ($wpdb->posts.post_content LIKE '%{$keyword}%')
            OR
            ($wpdb->posts.post_title LIKE '%{$keyword}%')
        )
        AND $wpdb->posts.post_status = 'publish'
        AND $wpdb->posts.post_type = 'product'
        ORDER BY $wpdb->posts.post_date DESC";

        }

        $query_results = $wpdb->get_results( $querystr );

        if ( !empty( $query_results ) ) {
 
            ob_start();
 
            $layout = new Product_Layout();

            foreach ( $query_results as $result ) {


                $display_price = get_post_meta( $result->ID, '_price' );
                $price      = get_post_meta( $result->ID, '_regular_price' );
                $price_sale = get_post_meta( $result->ID, '_sale_price' );
                $currency   = get_woocommerce_currency_symbol();
 
                $sku   = get_post_meta( $result->ID, '_sku' );
                $stock = get_post_meta( $result->ID, '_stock_status' );

                $product = get_product( $result->ID );
 
                $categories = wp_get_post_terms( $result->ID, 'product_cat' );

                if( $getLayout != 'grid' ) {
                  $layout->product_search_list_layout( $result, $product, $price, $price_sale, $display_price  );
                } else {
                  $layout->product_search_grid_layout( $result, $product, $price, $price_sale, $display_price  );
                }
        
        }

    } else {
        esc_html_e( 'Product not found.', 'foodbook' );
    }
    
     echo ob_get_clean();

    }
    die();
  }


/**
 * order_delivery_boy_assign
 *
 * 
 */

public function order_delivery_boy_assign() {

  if( isset( $_POST['boy_id'] ) && isset( $_POST['orderId'] ) ) {
    
    $options = get_option('foodbook_options');

    $boyId   = $_POST['boy_id'];
    $orderId = $_POST['orderId'];
    $order = wc_get_order( $orderId );

    $date = foodbook_current_date();

    $order->update_meta_data( '_order_delivery_boy', sanitize_text_field( $boyId ) );
    $order->update_meta_data( '_order_delivery_boy_assign_date', sanitize_text_field( foodbook_db_format_date_time( $date ) ) );
    $res = $order->save();

    // Order data
    $addNewOrders = [];
    $newOrder = sanitize_text_field( $orderId );
    $getOrders = get_user_meta( absint( $boyId ), '_delivery_boy_orders', true );

    if( !empty( $getOrders ) ) {
      $addNewOrders = $getOrders;
    }
    // Update Order
    if( ! in_array( $newOrder, $addNewOrders ) ) {
      array_push( $addNewOrders, $newOrder );
      update_user_meta( absint( $boyId ), '_delivery_boy_orders', $addNewOrders );

    }

    // Mail Send to delivery boy
    if( !empty( $options['active-order-assign-mail-notification'] ) ) {
      $mailNotifier = new \FoodBook\Inc\Delivery_Boy_Order_Assign_Mail();
      $mailNotifier->setBoyId($boyId)->setReceiverEmail()->setOrderId( $orderId )->mailFunc();
    }
    
    //
    if( !is_wp_error( $res ) ) {
       wp_send_json_success();
    } else {
      wp_send_json_error();
    }

  } else {
    wp_send_json_error();
  }


  exit;

}

/**
 * order tracking status change
 *
 * 
 */

public function order_tracking_status() {

  $options = get_option('foodbook_options');
  
  if( isset( $_POST['orderId'] ) && isset( $_POST['status'] )  ) {

    $order = wc_get_order( absint( $_POST['orderId'] ) );
    $time = current_time( "Y-m-d H:i:s" );

    // Order cancel status update in woocommerce 
    if( $_POST['status'] == 'OC' ) {
      // Status without the "wc-" prefix
      $order->update_status( 'wc-cancelled' );

    }

    // Order Delivery Complete status update in woocommerce 
    if( $_POST['status'] == 'DC' ) {
      // Status without the "wc-" prefix
      $order->update_status( 'wc-completed' );

    }

    //
    $order->update_meta_data( '_pre_order_status', sanitize_text_field( 'mf' ) );
    $order->update_meta_data( '_order_tracking_status', sanitize_text_field( $_POST[ 'status' ] ) );
    $order->update_meta_data( '_order_tracking_status_time', sanitize_text_field( $time ) );
    $order->save();

    // Mail notification
    if( !empty( $options['active-e-notification'] ) ) {
      $mailNotifier = new \FoodBook\Inc\Mail_Notifier();
      $mailNotifier->setOrderData( $order )->setReceiverEmail()->setStatus( esc_html( $_POST['status'] ) )->mailFunc();
    }

  }

  exit;

}

  /**
   *  Notification
   * 
   */
  
  public function notification_number() {

    $options = get_option('foodbook_options');
    $currentUser = get_current_user_id();
    // User data
    $user_meta = get_userdata( $currentUser );
    $user_roles = $user_meta->roles;

    $toDay = foodbook_current_date();

    // Get Selected date
    if( isset( $_POST['date'] ) && !empty( $_POST['date'] ) ) {
      $toDay = $_POST['date'];
    }
    // Get Selected branch id
    $branche_id = '';
    if( isset( $_POST['branche_id'] ) && !empty( $_POST['branche_id'] ) ) {
      $branche_id = $_POST['branche_id'];
    }

    // Check kitchen manager
    $is_kitchen = 0;
    if( $user_roles[0] == 'kitchen_manager' ) {
      $is_kitchen = 1;
    }

      $args = array(
        'limit'          => '-1',
        'date_created'   => esc_html( $toDay )
      );

      // branch type check
      if( foodbook_is_multi_branch() ) {

        // Get Branch order

        $meta_key = '';

        if( $user_roles[0] == 'branch_manager' ) {
          $meta_key = 'foodbookbranch_manager';
        }
        //
        
        if( $user_roles[0] == 'kitchen_manager' ) {
          $meta_key = 'foodbookkitchen_manager';

        }

          // Get branch
          $branchArgs = array (
              'post_type'        => 'branches',
              'post_status'      => 'publish',
              'meta_key'         => $meta_key,
              'meta_value'       => esc_html( $currentUser ),
              'meta_compare' => 'LIKE'
          );

          $getBranchesId = get_posts( $branchArgs );

          $getBranchesId = array_column( $getBranchesId, 'ID' );
          
          // Check Admin
          if( !current_user_can('administrator') ) {
            $branchesId = $getBranchesId[0];
          } else {
            $branchesId = $branche_id;
          } 

          
          if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
            // HPOS usage is enabled.
            
            $args['meta_query'][] = [
              'key'     => '_fb_pickup_branch',
              'value'   => esc_html( $branchesId ),
              'compare' => '='
            ];

          } else {
            // Traditional CPT-based orders are in use.
            $args['branch'] = esc_html( $branchesId );
          }
 

      }

      $orders = wc_get_orders( $args );

      ob_start();

      $statusText = foodbook_getStatusText();


      $new = $ac = $cc = $dc = $owd = 0;

      foreach( $orders as $order ) {

      $status = $order->get_meta('_order_tracking_status');

        if( $is_kitchen == 1  ) {

          if( !$options['kitchen-all-order'] ) {

            if( $status == 'STC' ) {
              $new = $new + 1;
            }

          } else {

            if( $status == 'OP' || $status == 'STC' ) {
              $new = $new + 1;
            }

          }

        } else {

          if( $status == 'OP' ) {
            $new = $new + 1;
          }

        }


        //
        if( $status == 'CC' ) {
          $cc = $cc + 1;
        }
        //
        if( $status == 'AC' ) {
          $ac = $ac + 1;
        }
        //
        if( $status == 'OWD' ) {
          $owd = $owd + 1;
        }
        //
        if( $status == 'DC' ) {
          $dc = $dc + 1;
        }


      } 

      echo '<div class="notifi-number-count">';
        echo '<span class="fb-noti-inner" data-filter="'.esc_attr( $statusText['op'] ).'">'.esc_html( $statusText['no'] ).'<span class="n-new">'.esc_html( $new ).'</span></span>';
        echo '<span class="fb-noti-inner" data-filter="'.esc_attr( $statusText['ac'] ).'">'.esc_html( $statusText['cp'] ).'<span class="n-cooking">'.esc_html( $ac ).'</span></span>';
        echo '<span class="fb-noti-inner" data-filter="'.esc_attr( $statusText['cc'] ).'">'.esc_html( $statusText['cc'] ).'<span class="n-completed">'.esc_html( $cc ).'</span></span>';
        echo '<span class="fb-noti-inner" data-filter="'.esc_attr( $statusText['owd'] ).'">'.esc_html( $statusText['otw'] ).'<span class="n-completed">'.esc_html( $owd ).'</span></span>';
        echo '<span class="fb-noti-inner" data-filter="'.esc_html( $statusText['dc'] ).'">'.esc_html( $statusText['dc'] ).'<span class="n-completed">'.esc_html( $dc ).'</span></span>';

      echo '</div>';

      echo ob_get_clean();

    exit;


  } 

	
  /**
   * 
   * @return [string] [description]
   */
  public function invitation_mail() {

    $getData = get_option( 'foodbook_options' );

    $headerMail = !empty( $getData['invitation-from-email'] ) ? $getData['invitation-from-email'] : get_option('admin_email');
    $subject = !empty( $getData['invitation-subject'] ) ? $getData['invitation-subject'] : "";
    $message = !empty( $getData['invitation-message'] ) ? $getData['invitation-message'] : "";
    // Mail header
    $headers  = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= 'From: <'.$headerMail.'>' . "\r\n";

    if( isset( $_POST['mail'] ) ) {

      $res = mail( sanitize_email( $_POST['mail'] ) , esc_html( $subject ), $message, $headers );

      if( $res ) {
        esc_html_e( 'Thanks for sending invitation', 'foodbook' );
      }else {
        esc_html_e( 'Invite failed, please try again.', 'foodbook' );
      }
      
    } else {
      esc_html_e( 'E-mail id not found.', 'foodbook' );
    }

    exit;

  }

/**
 * order_filter_by_date for wp admin foodfook manager
 * @return
 * 
 */

public function order_filter_by_date() {
      
        $toDay = foodbook_current_date();
        $Components      = new Components();
        $currency_symbol = get_woocommerce_currency_symbol();

        $date = isset( $_POST['date'] ) ? esc_html( $_POST['date'] ) : esc_html( $toDay );
        $preorder = isset( $_POST['preorder'] ) ? esc_html( $_POST['preorder'] ) : '';
        $deliveryDate = foodbook_date_format( $date, 'd-m-Y' );

        $is_multi_branch = false;

        // Order Args
        $orderargs = ['limit' => '-1'];
        // Branch meta query
        $branch = '';
        if( foodbook_is_multi_branch() ) {

          $is_multi_branch = true;

          // Branch meta query

          if( !empty( $_POST['branch'] ) ) {
            
            if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
              // HPOS usage is enabled.
              
              $orderargs['meta_query'][] = [
                'key'      => '_fb_pickup_branch',
                'value'    => esc_html( $_POST['branch'] ),
                'compare'  => '='
              ];

            } else {
              // Traditional CPT-based orders are in use.
              $orderargs['branch'] = esc_html( $_POST['branch'] );
            }

          }

        }

        // order status, delivery date, created date meta query
        if( isset( $_POST['queryType'] ) && 'preorder' == $_POST['queryType'] ) {

          // Add delivery date in order args
          if( !empty( $deliveryDate ) && !$preorder ) {

            if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
              // HPOS usage is enabled.
              
              $orderargs['meta_query'][] = [
                'key'     => '_delivery_date',
                'value'   => sanitize_text_field(  $deliveryDate ),
                'compare' => '='
              ];

            } else {
              // Traditional CPT-based orders are in use.
              $orderargs['delivery_date'] = sanitize_text_field(  $deliveryDate  );
            }

          }
          // Add pre order status in order args
          if( !empty( $preorder ) ) {

            if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
              // HPOS usage is enabled.
              
              $orderargs['meta_query'][] = [
                'key'     => '_pre_order_status',
                'value'   => sanitize_text_field( $preorder ),
                'compare' => '='
              ];

            } else {
              // Traditional CPT-based orders are in use.
              $orderargs['pre_order_status'] = sanitize_text_field( $preorder );
            }
            
          }

        } else {
            $orderargs['date_created'] = $date;
        }
    

        $orders = wc_get_orders( $orderargs );

      ob_start();
        
        if( !empty( $orders ) ) {
          ?>
          <table class="wp-list-table widefat responsive fixed foodbook-order-list dataTable">
          <?php 
          // Table header
          \FoodBook\Admin_Sub_Menu_Templates::data_table_header();
          ?>
          <tbody id="admin-branch-order-list">    
          <?php

          foreach( $orders as $order ) {
           
            $paymentMethod = $order->get_payment_method_title();
            $wcOrderStatus = $order->get_status();
            
            $orderId = $order->get_id();
            
            $status         = $order->get_meta( '_order_tracking_status' );
            $preOrder       = $order->get_meta( '_pre_order_status' );
            $pickup_time    = $order->get_meta( '_pickup_time' );

            $orderDate = $order->get_date_created()->format ('M-d-Y');
            $delivery_date  = $order->get_meta( '_delivery_date' );
            $delivery_display_date = !empty( $delivery_date ) ? foodbook_display_date( $delivery_date ) : $orderDate;

            $delivery_time  = $order->get_meta( '_pickup_time' );

            $delivery_time  = !empty( $delivery_time ) ? ' - '.$delivery_time : '';

            $delivery_type  = $order->get_meta( '_delivery_type' );

            if( $is_multi_branch ) {
              $branchID = $order->get_meta( '_fb_pickup_branch' );
              $branchName  = get_the_title( $branchID );
            }

            $time = $order->get_meta( '_order_tracking_status_time' );
            
            $orderDisplayDate = foodbook_display_date($orderDate);

            $orderTime = $order->get_date_created()->format ( foodbook_time_format() );

            $getTime = foodbook_time_elapsed_string( $time , true );


            $oc = $stc = $cc = $OWD = $DC = ''; 

            // 
            if( $status == 'OC' ) {
              $oc = 'status-active';
            }
            // 
            if( $status == 'STC' ) {
              $stc = 'status-active';
            }
            // 
            if( $status == 'CC' ) {
              $cc = 'status-active';
            }
            // 
            if( $status == 'OWD' ) {
              $OWD = 'status-active';
            }
            // 
            if( $status == 'DC' ) {
              $DC = 'status-active';
            }

            ?>
            <tr>
              <td><?php echo esc_html( '#'.$order->get_id() ); ?></td>
              <td><?php echo esc_html( $orderDisplayDate.' - '.$orderTime ); ?></td>
              <td>
                <?php 
                  $preOrderClass = '';
                  if( !empty( $preOrder ) && $preOrder == 'PO' ) {
                    $preOrderClass = 'pre-order';
                    echo esc_html( $delivery_display_date.$delivery_time ); 
                  } else {
                    echo esc_html( $orderDisplayDate.$delivery_time );
                  }
                ?>
              </td>
              <td><?php echo esc_html( $delivery_type ); do_action( 'foodbook_order_table_delivery_type_td', $orderId ); ?></td>
              <td>
                <?php 
                echo sprintf( esc_html__( "Method: %s", "foodbook" ), $paymentMethod );
                echo '<br>';
                echo sprintf( esc_html__( "Status: %s", "foodbook" ), $wcOrderStatus ); 
                ?>
              </td>
              <td>
                <span class="order-status <?php echo esc_attr( strtolower( $status ).'-status' ); ?>"><?php echo esc_html( foodbook_converted_tracking_status( $status )  ); ?></span>

                <?php 
                if( !empty( $preOrder ) && $preOrder == 'PO' ):
                ?>
                <span class="order-status <?php echo esc_html( $preOrderClass ); ?>"><?php echo esc_html( foodbook_converted_tracking_status( $preOrder )  ); ?></span>
                <?php 
                endif;
                ?>
                <br>
                <span class="time-status"><?php echo esc_html( $getTime ); ?></span>
              </td>
              <td>
                <span class="fb-view-order"><?php esc_html_e( 'View Details', 'foodbook' ); ?></span>
                <div class="fb_popup_modal">
                  <div class="fb_modal_wrap">
                    <div class="fb_modal">
                      <div class="fb_modal_inner">
                          <span class="fb_close_modal">
                            <img src="<?php echo FOODBOOK_DIR_URL.'assets/img/icon/close.svg'; ?>" alt="<?php echo esc_attr( 'close', 'foodbook' ); ?>" />
                          </span>
                          <div class="fb_modal_content">
                            <div class="fb_modal_title text-center">
                              <h3><?php esc_html_e( 'Order Details', 'foodbook' ); ?></h3>
                              <div class="print-btn-area">
                                <span class="fb_btn_fill fb-inv-back" style="float:left;display:none;padding: 4px 12px;"><?php esc_html_e( 'Back', 'foodbook' ); ?></span>
                                <span class="fb_btn_fill fb-inv-print" style="float:right;padding: 4px 12px;"><?php esc_html_e( 'Print Invoice', 'foodbook' ); ?></span>
                              </div>
                            </div>
                            <?php
                            // Invoice Template
                            $Components->invoice_template_wpadmin( $order );
                            ?>
                            <div class="fb_modal_content_inner content-inner-hide">
                              <h4 class="order-id"><?php esc_html_e( 'Order ID:', 'foodbook' ); ?> <?php echo esc_html( '#'.$order->get_id() ); ?></h4>
                              <?php 
                              if( $is_multi_branch ):
                              ?>
                              <h4 class="order-id"><?php echo sprintf( esc_html__( 'Branch Name: %s', 'foodbook' ), esc_html( $branchName )  ); ?></h4>
                              <?php 
                              endif;
                              ?>
                              <h4 class="order-id"><?php echo sprintf( esc_html__( 'Order Date: %s', 'foodbook' ), esc_html( $orderDisplayDate )  ); ?></h4>
                              <h4 class="order-id"><?php echo sprintf( esc_html__( 'Delivery Type: %s', 'foodbook' ), esc_html( $delivery_type )  ); ?></h4>
              							  <?php
              								//
              								do_action( 'foodbook_order_modal_header_after_delivery_type', $orderId );
              							  ?>
                              <h4 class="order-id"> <?php echo sprintf( esc_html__( 'Delivery/Pickup Date: %s', 'foodbook' ), esc_html( $delivery_display_date )  ); ?></h4>
                              <h4 class="order-id"> <?php echo sprintf( esc_html__( 'Delivery/Pickup Time: %s', 'foodbook' ), esc_html( $pickup_time )  ); ?></h4>
                              <h4 class="order-id"><?php echo sprintf( esc_html__( 'Payment Method: %s', 'foodbook' ), esc_html( $paymentMethod )  ); ?></h4>
                              <?php
                              // Billing shipping details
                              $Components->order_billing_shipping_details( $order );
                               
                              if( $status != 'OF' ):  
                              ?>
                              <div class="kitchen-change-tracking">
                                <h4 class="fb_text_center"><?php esc_html_e( 'Tracking Status Action', 'foodbook' ); ?></h4>
                                <div class="status-button-area">
                                  <?php
                                  $Components->status_button_html( $order->get_id(), $status );
                                  ?>
                                </div>
                                <div class="row">
                                  <div class="col-md-6">
                                    <?php
                                      // Delivery Boy assign component
                                      $Components = new Components();
                                      $Components->delivery_boy_assign_component( $order, esc_html( $branch ) );
                                    ?>
                                  </div>
                                  <div class="col-md-6">
                                    <?php
                                      //
                                      if( foodbook_is_multi_branch() ) {
                                        $Components->order_transfer_component( $order );
                                      }
                                    ?>
                                  </div>
                                </div>
                              </div>
                              <?php 
                              endif;
                              ?>
                              <div class="fb--modal-inner">
                                <table>
                                  <thead>
                                    <tr>
                                      <th><?php esc_html_e( 'Item Name', 'foodbook' ); ?></th>
                                      <th><?php esc_html_e( 'Quantity', 'foodbook' ); ?></th>
                                      <th><?php esc_html_e( 'Extra Item', 'foodbook' ); ?></th>
                                      <th><?php esc_html_e( 'Item Total Price', 'foodbook' ); ?></th>
                                    </tr>
                                  </thead>
                                  <tbody>
                                    <?php
                                    foreach ( $order->get_items() as $item_id => $item ) {
                                      ?>
                                      <tr>
                                        <td><?php echo esc_html( $item->get_name() ); ?></td>
                                        <td><?php echo esc_html( $item->get_quantity() ); ?></td>
                                        <td>
                                        <?php 
                                        wc_display_item_meta($item);
                                        ?>  
                                        </td>
                                        <td><?php echo esc_html( foodbook_price_number_formating( $item->get_total() ) ); ?></td>
                                      </tr>
                                      <?php
                                    }
                                    ?>
                                    <tr>
                                      <td><?php esc_html_e( 'Order Notes:', 'foodbook' ); ?></td>
                                      <td>
                                        <?php
                                        if( !empty( $order->get_customer_note() ) ) {
                                          echo esc_html( $order->get_customer_note() );
                                        }
                                        ?>
                                      </td>
                                      <td></td>
                                      <td></td>
                                    </tr>
                                  </tbody>
                                  <tfoot>
                                  <?php 
                                  if( !empty( $order->get_subtotal() ) ):
                                  ?>
                                  <tr>
                                    <th rowspan="1" colspan="1"></th>
                                    <th rowspan="1" colspan="1"></th>
                                    <th rowspan="1" colspan="1"><?php esc_html_e( 'Items Subtotal', 'foodbook' ); ?></th>
                                    <th rowspan="1" colspan="1"><?php echo foodbook_price_number_formating($order->get_subtotal()); ?></th>
                                  </tr>
                                  <?php
                                  endif;
                                  if( !empty( $order->get_discount_to_display() ) ):
                                  ?>
                                  <tr>
                                    <th rowspan="1" colspan="1"></th>
                                    <th rowspan="1" colspan="1"></th>
                                    <th rowspan="1" colspan="1"><?php esc_html_e( 'Coupon(s): ', 'foodbook' ); echo implode(',', $order->get_coupon_codes()); ?></th>
                                    <th rowspan="1" colspan="1"><?php echo '- '.$order->get_discount_to_display(); ?></th>
                                  </tr>
                                  <?php 
                                  endif;
                                  // Fees
                                  if( !empty( $order->get_total_fees() ) ):
                                    foreach( $order->get_items('fee') as $fee ) {
                                  ?>
                                  <tr>
                                    <th rowspan="1" colspan="1"></th>
                                    <th rowspan="1" colspan="1"></th>
                                    <th rowspan="1" colspan="1"><?php echo esc_html( $fee->get_name() ); ?></th>
                                    <th rowspan="1" colspan="1"><?php echo esc_html( foodbook_price_number_formating( $fee->get_total()  ) ); ?></th>
                                  </tr>
                                  <?php 
                                   } // Endforeach
                                  endif;

                                  // Tax Fee
                                  if( wc_tax_enabled() ) {
                                  foreach( $order->get_tax_totals() as $tax ) {
                                  ?>
                                  <tr>
                                    <th rowspan="1" colspan="1"></th>
                                    <th rowspan="1" colspan="1"></th>
                                    <th rowspan="1" colspan="1"><?php echo esc_html( $tax->label ); ?></th>
                                    <th rowspan="1" colspan="1"><?php echo $tax->formatted_amount; ?></th>
                                  </tr>
                                  <?php
                                  }// End tax foreach
                                  }// end if
                                  //
                                  if( !empty( $order->get_shipping_total() ) ):
                                  ?>
                                  <tr>
                                    <th rowspan="1" colspan="1"></th>
                                    <th rowspan="1" colspan="1"></th>
                                    <th rowspan="1" colspan="1"><?php esc_html_e( 'Shipping Fee', 'foodbook' ); ?></th>
                                    <th rowspan="1" colspan="1"><?php echo foodbook_price_number_formating( $order->get_shipping_total() ); ?></th>
                                  </tr>
                                  <?php 
                                  endif;
                                  ?>
                                  <tr>
                                    <th rowspan="1" colspan="1"></th>
                                    <th rowspan="1" colspan="1"></th>
                                    <th rowspan="1" colspan="1"><?php esc_html_e( 'Total', 'foodbook' ); ?></th>
                                    <th rowspan="1" colspan="1"><?php echo esc_html( foodbook_price_number_formating( $order->get_total() ) ); ?></th>
                                  </tr>
                                </tfoot>
                                </table>

                              </div>
                            </div>
                          </div>
                      </div>
                    </div>
                  </div>
                </div>
              </td>
            </tr>
            <?php
            
          }

          ?>
          </tbody>
          <?php 
          // Table footer
          \FoodBook\Admin_Sub_Menu_Templates::data_table_footer();
          ?>

        </table>
          <?php


        } else {
          echo '<h4 class="order-notfound">'.esc_html( 'Order Not found', 'foodbook' ).'</h4>';
        }

       echo ob_get_clean();

        exit;



}

/**
 * order_branch_transfer
 * @return [type] [description]
 */
public function order_branch_transfer () {

  $update = update_post_meta( absint( $_POST['orderId'] ), '_fb_pickup_branch', sanitize_text_field( $_POST['branch_id'] ) );
  
  if( !is_wp_error( $update ) ) {
    wp_send_json_success();
  } else {
    wp_send_json_error();
  }

  exit;
  
  
}

/**
 * order_statistic
 * @return array
 */
public function order_statistic() {



  $toDay = foodbook_current_date();

  if( isset( $_POST['date'] ) && !empty( $_POST['date'] ) ) {
    $toDay = $_POST['date'];
  }

 
  // branch type check
  if( foodbook_is_multi_branch() ) {

    // check admin
    if( !current_user_can('administrator') ) {
      // Get Branch order
      $currentUser = get_current_user_id();
      // User data
      $user_meta = get_userdata( $currentUser );
      $user_roles = $user_meta->roles;
      $meta_key = '';
      
      if( $user_roles[0] == 'branch_manager' ) {
        $meta_key = 'foodbookbranch_manager';
      }

      // Get branch
      $args = array (
        'post_type'        => 'branches',
        'post_status'      => 'publish',
        'meta_key'         => $meta_key,
        'meta_value'       => esc_html( $currentUser ),
        'meta_compare' => 'LIKE'
      );

      $getBranchesId = get_posts( $args );

      $getBranchesId = array_column( $getBranchesId, 'ID' );

      $getBranchesId = $getBranchesId[0];

    } else {
      $getBranchesId = isset( $_POST['branchId'] ) ? $_POST['branchId'] : '';
    }

    $args = array(
      'limit'          => '-1',
      'date_created'   => esc_html( $toDay ),
    );

    if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
      // HPOS usage is enabled.
      
      $args['meta_query'][] = [
        'key'     => '_rb_pickup_branch',
        'value'   => esc_html( $getBranchesId ),
        'compare' => '='
      ];

    } else {
      // Traditional CPT-based orders are in use.
      $args['branch'] = esc_html( $getBranchesId );
    }

    $orders = wc_get_orders( $args );

  } else {

    $args = array(
      'limit'          => '-1',
      'date_created'   => esc_html( $toDay )
    );

    $orders = wc_get_orders( $args );

  }

  $totalOrder = $totalCompletedOrder = $totalCancelOrder = [];

  foreach( $orders as $order ) {

    $getStatus = $order->get_meta( '_order_tracking_status' );

    $orderId    =  $order->get_id();
    $orderTotal =  $order->get_total();

    //
    $totalOrder[] = [
        'count' => 1,
        'value' => $order->get_total()
    ]; 


    if( $getStatus == 'OC' ) {
      
      $totalCancelOrder[] = [
        'count' => 1,
        'value' => $order->get_total()

      ];

    } else if( $getStatus == 'DC' ) {

      $totalCompletedOrder[] = [
        'count' => 1,
        'value' => $order->get_total()

      ];

    }

  }

  //

  $getTotalCancelOrder = [
    "total_count" => count( $totalCancelOrder ),
    "total_value" => foodbook_price_number_formating( array_sum( array_column( $totalCancelOrder, 'value' ) ) ) ? foodbook_price_number_formating( array_sum( array_column( $totalCancelOrder, 'value' ) ) ) : 0
  ];

  $getTotalCompletedOrder = [
    "total_count" => count( $totalCompletedOrder ), 
    "total_value" => foodbook_price_number_formating( array_sum( array_column( $totalCompletedOrder, 'value' ) ) ) ? foodbook_price_number_formating( array_sum( array_column( $totalCompletedOrder, 'value' ) ) ) : 0
  ];

  $getTotalOrder = [
    "total_count" => count( $totalOrder ),
    "total_value" => foodbook_price_number_formating( array_sum( array_column( $totalOrder, 'value' ) ) ) ? foodbook_price_number_formating( array_sum( array_column( $totalOrder, 'value' ) ) ) : 0
  ];

  
  $getData = [

    "total_order" => $getTotalOrder,
    "completed_order" => $getTotalCompletedOrder,
    "cancel_order" => $getTotalCancelOrder
    
  ];
  

  wp_send_json_success( $getData );


  exit;

}

/**
 * update_order_review
 * @return
 * 
 */
public function update_order_review() {

  $values = array();
  parse_str( $_POST['post_data'], $values );
  $cart = $values['cart'];

  WC()->cart->calculate_shipping();
  WC()->cart->calculate_totals();

  wp_die();
}

public function new_order_push_notification() {

      $options = get_option('foodbook_options');

      $toDay = foodbook_current_date();
      
      // Get User role
      $currentUser = get_current_user_id();
      // User data
      $user_meta = get_userdata( $currentUser );
      $user_roles = $user_meta->roles;


      // Check Is kitchen
      $is_kitchen = 0;
      if( $user_roles[0] == 'kitchen_manager' ) {
        $is_kitchen = 1;
      }

      $args = array(
        'limit'          => '-1',
        'date_created'   => esc_html( $toDay )
      );

      // branch type check
      
      if( foodbook_is_multi_branch() ) {

        $branche_id = $_POST['branche_id'] ?? '';
        
        // Get Branch order

        $meta_key = '';

        if( $user_roles[0] == 'branch_manager' ) {
          $meta_key = 'foodbookbranch_manager';
        }
        //
        if( $user_roles[0] == 'kitchen_manager' ) {
          $meta_key = 'foodbookkitchen_manager';
        }

          // Get branch
          $branchArgs = array (
              'post_type'        => 'branches',
              'post_status'      => 'publish',
              'meta_key'         => $meta_key,
              'meta_value'       => esc_html( $currentUser ),
              'meta_compare' => 'LIKE'
          );

          $getBranchesId = get_posts( $branchArgs );

          $getBranchesId = array_column( $getBranchesId, 'ID' );
          
          // Check Admin
          if( !current_user_can('administrator') ) {
            $branchesId = $getBranchesId[0];
          } else {
            $branchesId = $branche_id;
          } 

          if( $branchesId ) {

            if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
              // HPOS usage is enabled.
              
              $args['meta_query'][] = [
                'key'     => '_fb_pickup_branch',
                'value'   => esc_html( $branchesId ),
                'compare' => '='
              ];

            } else {
              // Traditional CPT-based orders are in use.
              $args['branch'] = esc_html( $branchesId );
            }

          }

      }
      
      $orders = wc_get_orders( $args );

      // Status Code 
      
      $new = 0;

      foreach( $orders as $order ) {

      $status = $order->get_meta( '_order_tracking_status' );
      
        if( $is_kitchen == 1 ) {

          if( !empty( $options['kitchen-all-order'] ) ) {

            if( $status == 'STC' ) {
              $new = $new + 1;
            }

          } else {

            if( $status == 'OP' || $status == 'STC' ) {
              $new = $new + 1;
            }

          }


        } else {

          if( $status == 'OP' ) {
            $new = $new + 1;
          }

        }

       
      } 

      echo $new;      


    exit;

}

public function branch_manager_data() {

  $date = isset( $_POST['date'] ) ? $_POST['date'] : '';

  if( isset( $_POST['managertype'] ) && $_POST['managertype'] == 'branch-manager' ) {
    $obj = new \FoodBook\Admin_Sub_Menu_Templates();
    $obj->branch_order_manage( $date );

  } elseif (isset( $_POST['managertype'] ) && $_POST['managertype'] == 'kitchen-manager') {
    $obj = new \FoodBook\Admin_Sub_Menu_Templates();
    $obj->kitchen_template( $date );
  } else {
    $obj = new \FoodBook\Admin_Sub_Menu_Templates();
    $obj->delivery_order_manage( $date );
  }

  exit;
}

/**
 * [manager_date_filter_data description]
 * @return [type] [description]
 */
public function manager_date_filter_data() {

  $date = isset( $_POST['date'] ) ? $_POST['date'] : '';

  if( isset( $_POST['managertype'] ) && $_POST['managertype'] == 'branch-manager' ) {
    $obj = new \FoodBook\Admin_Sub_Menu_Templates();
    $obj->branch_order_manage( $date );

  } elseif (isset( $_POST['managertype'] ) && $_POST['managertype'] == 'kitchen-manager') {
    $obj = new \FoodBook\Admin_Sub_Menu_Templates();
    $obj->kitchen_template( $date );
  } else {
    $obj = new \FoodBook\Admin_Sub_Menu_Templates();
    $obj->delivery_order_manage( $date );
  }

  exit;

}

/**
 * [preorder_date_filter_data description]
 * @return [type] [description]
 */
public function preorder_date_filter_data() {

  //Pre order date filter
  $date     = isset( $_POST['date'] ) ? foodbook_date_format( $_POST['date'], 'd-m-Y' ) : '';
  $preorder = isset( $_POST['preorder'] ) ? $_POST['preorder'] : '';

  $obj = new \FoodBook\Admin_Sub_Menu_Templates();
  $obj->pre_order_date_filter( $date, $preorder );
   
  exit;
}

/**
 * [order_time_lists description]
 * @return [type] [description]
 */
public function order_time_lists() {

  $date = isset( $_POST['date'] ) ? $_POST['date'] : '';
  $branchid = isset( $_POST['branchid'] ) ? $_POST['branchid'] : '';
  $timeList = \FoodBook\Date_Time_Map::getTimes( $date, $branchid );
  foodbook_time_solt_options_html( $timeList );
  die();
}

/**
 * [client_location description]
 * @return [type] [description]
 */
public function client_location() {

  $lat  = isset( $_POST['lat'] ) ? $_POST['lat'] : '';
  $long = isset( $_POST['long'] ) ? $_POST['long'] : ''; 

  if( $lat && $long ) {
    echo \FoodBook\Inc\Location::longLatToAddress( $lat, $long );
    exit;
  }

}

/**
 * [location_availability_check description]
 * @return 
 */
public function location_availability_check() {

  $getText = \Foodbook\Inc\Text::getText();
  $options = \get_option('foodbook_options');
  $multideliveryfees = \get_option('foodbook_multideliveryfees_option');

  // Location type check
  
  if( foodbook_is_location_type_address() ) {
    
    //
    if( foodbook_is_multi_branch() ) {
      $DistanceRestrict = get_post_meta( $_POST['branchId'], 'foodbookbranch_distance_restrict', true );
    } else {
      $DistanceRestrict = $options['distance-restrict'];
    }

    $branchLocation  = isset( $_POST['branchLocation'] ) ? $_POST['branchLocation'] : '';
    $visitorLocation = isset( $_POST['visitorLocation'] ) ? $_POST['visitorLocation'] : '';

    $getLocationDistance = \Foodbook\Inc\Location_Distance::longLatToAddress( esc_html( $branchLocation ), esc_html( $visitorLocation ) );

    //
    if( !empty( $getLocationDistance ) ) {

      $getLocationDistance = explode( ' ' , $getLocationDistance);
      $locationDistance = str_replace(',', '', $getLocationDistance[0] );

      //
      if( in_array( 'm' , $getLocationDistance ) ) {

        if( !empty( $locationDistance ) ) {

          // Restrict distance kilometer to meter
          $restrictDistanceKmTom = $DistanceRestrict * 1000;

          // Check visitor area in Restrict distance
          if( $locationDistance <= $restrictDistanceKmTom  ) {

            $status = true;

          } else {
            $status = false;
          }
          
        }

      } else {

        // Check visitor area in Restrict distance
        if( $locationDistance <= $DistanceRestrict  ) {
          $status = true;
        } else {
          $status = false;
        }

      }

    } else {
      $status = false;
    }

  } else {

    $zipCode = isset( $_POST['zipcode'] ) ? $_POST['zipcode'] : '';
    
    if( foodbook_is_multi_branch() ) {

      if( !empty( $multideliveryfees ) && $multideliveryfees == 'yes' ) {

        $getZipCodes = get_post_meta( $_POST['branchId'], 'foodbookbranch_zipcode_with_fee', true );
        $zipCodes = array_column( $getZipCodes, 'code');

      } else {
        $zipCodes = get_post_meta( $_POST['branchId'], 'foodbookbranch_zipcode', true );
      }

    } else {
      
      if( !empty( $multideliveryfees ) && $multideliveryfees == 'yes' ) {

        $getZipCodes = !empty( $options['zip-delivery-fee'] ) ? $options['zip-delivery-fee'] : '';

        $zipCodes = array_column( $getZipCodes, 'code');

      } else {
        $zipCodes = !empty( $options['delivery_zip'] ) ? $options['delivery_zip'] : '';
      }
      
    }

    //
    if( in_array( $zipCode , $zipCodes ) ) {
      $status = true;
    } else {
      $status = false;
    }

  }

  $cookieTime = time() + DAY_IN_SECONDS;
  // Check status
  if( $status ) {
    
    // Set ookie for visior location
    setcookie( 'foodbook_visitor_location', $visitorLocation, $cookieTime, COOKIEPATH, COOKIE_DOMAIN );
    setcookie( 'd_availability_status', 'yes', $cookieTime, COOKIEPATH, COOKIE_DOMAIN );
    // Set location distance
    setcookie( 'fb_location_distance', esc_html( $locationDistance ), $cookieTime, COOKIEPATH, COOKIE_DOMAIN );
    // If Multibranch
    if( foodbook_is_multi_branch() ) {
      setcookie( 'fb_branch_id', esc_html( $_POST['branchId'] ), $cookieTime, COOKIEPATH, COOKIE_DOMAIN );
    }
    // ZipCode Set in cookie
    if( !empty( $zipCode ) ) {
      setcookie( 'fb_selected_zipcode', esc_html( $zipCode ), $cookieTime, COOKIEPATH, COOKIE_DOMAIN );
    }

    echo json_encode( [ 'status' => 'success', 'msg' => esc_html( $getText['delivery_available_success'] ) ] );

  } else {
    setcookie( 'd_availability_status', 'no', $cookieTime, COOKIEPATH, COOKIE_DOMAIN );
    echo json_encode( [ 'status' => 'error', 'msg' => esc_html( $getText['delivery_available_error'] ) ] );
  }

  exit;
}

/**
 * [get_branch_location description]
 * @return [type] [description]
 */
public static function get_branch_location() {
  $getBranch = isset( $_POST['branchId'] ) ? $_POST['branchId'] : '';
  $branchLocation   = get_post_meta( $getBranch, 'foodbookbranch_location', true );
  //$distanceRestrict = get_post_meta( $getBranch, 'foodbookbranch_distance', true );
  echo $branchLocation;
  exit;

}

/**
 * [visitor_address_from_cookie description]
 * @return [type] [description]
 */
public static function visitor_address_from_cookie() {

  if( isset( $_COOKIE['foodbook_visitor_location'] ) ) {
    echo $_COOKIE['foodbook_visitor_location'];
  }

  exit;

}
/**
 * [get_branch_location_by_id description]
 * @return [type] [description]
 */
public static function get_branch_location_by_id() {

  if( ! isset( $_POST['branchId'] ) ) return;
  
  $locationType = get_option('foodbook_options');
  $multideliveryfees = get_option('foodbook_multideliveryfees_option');
  $location = '';

  if( !empty( $locationType['location_type'] ) && $locationType['location_type'] == 'address' ) {

    $address = get_post_meta( esc_html( $_POST['branchId'] ), 'foodbookbranch_location', true );
    $location = json_encode( [ 'type' => 'address','address' => $address ] );

  } else {

    if( !empty( $multideliveryfees ) && $multideliveryfees == 'yes' ) {

      $zipCodes = get_post_meta( esc_html( $_POST['branchId'] ), 'foodbookbranch_zipcode_with_fee', true );
      $zipCodes = array_column($zipCodes, 'code');

    } else {
      $zipCodes = get_post_meta( esc_html( $_POST['branchId'] ), 'foodbookbranch_zipcode', true );
    }

    $location = json_encode( [ 'type' => 'zip','zipcode' => $zipCodes ] );

  }

  echo $location;
  
  exit;
}
/**
 * [get_branch_table_numbers description]
 * @return [type] [description]
 */
public static function get_branch_table_numbers() {

  if( foodbook_is_multi_branch() && isset( $_POST['branchId'] ) ) {  
    $tabls = get_post_meta( esc_html( $_POST['branchId'] ), 'foodbookbranch_restaurant_table_number', true );
  }else {
    $opt = get_option('foodbook_options');
    $tabls = !empty( $opt['restaurant-table-number'] ) ? $opt['restaurant-table-number'] : '';
  }

  echo json_encode( $tabls );

  exit;
}

/**
 * [holy_day_check description]
 * @return [type] [description]
 */
public static function holy_day_check() {

  $date = $_POST['date'] ? $_POST['date'] : '';
  $branch_id = $_POST['branch_id'] ? $_POST['branch_id'] : '';

  echo  Date_Time_Map::is_holy_day( $date, $branch_id );
  die();
}

}

// Components_Ajax Class init
new Components_Ajax();
