<?php 
namespace FoodBook\Inc;
/**
 *
 * @package     Foodbook
 * @author      ThemeLooks
 * @copyright   2020 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

class Ability_Checker_Form {


  /**
   * [availabilityStatus description]
   * @return [type] [description]
   */
  public static function availabilityStatus() {

      $getText = Text::getText();
      $availabilityStatus = '';

      if( isset( $_COOKIE['d_availability_status'] ) ) {
        if( $_COOKIE['d_availability_status'] == 'yes' ) {
          $availabilityStatus = [ 'class' => 'status-success', 'msg' => esc_html( $getText['delivery_available_success'] ) ];
        } else if( $_COOKIE['d_availability_status'] == 'no' ) {
          $availabilityStatus = [ 'class' => 'status-error', 'msg' => esc_html( $getText['delivery_available_error'] ) ];
        }

      }

      return $availabilityStatus;

  }
  /**
   * [checkoutStatus description]
   * @return [type] [description]
   */
  public static function checkoutStatus() {
    echo'<div class="d_availability_status">';
      $status = self::availabilityStatus();
      if( !empty( $status ) ) {
        echo '<p class="fb-checkout-status-inner '.esc_attr( $status['class'] ).'">'.esc_html( $status['msg'] ).'</p>';        
      }
    echo'</div>';
  }
  /**
   * [getBranch description]
   * @return [type] [description]
   */
  public static function getBranch() {
    ?>
    <p><?php esc_html_e( 'Select Branch', 'foodbook' ); ?></p>
    <?php
    self::branchInput();
  }

  public static function branchInput() {
    ?>
    <select class="fb_input_style get_product_by_branch" name="fb_pickup_branch">
      <?php
      echo foodbook_branch_list_html( esc_html__( 'Select Branch', 'foodbook' ), '' );
      ?>
    </select>
    <?php
  }

  /**
   * [form description]
   * @return [type] [description]
   */
  public static function form() {

    $getText = Text::getText();

    $is_active_location = foodbook_getOptionData('popup-location-active');
    $deliveryType = foodbook_getOptionData('delivery-options');
    ?>
    <!-- End Close Modal -->
    <div class="fb_modal_content fb-ability-checker-form-wrapper">
      <h4><?php echo esc_html( $getText['dac_title'] ); ?></h4>
      <?php
      if( !is_checkout() ) {
        self::delivery_types();
      }
      // branch 
      if( foodbook_is_active_multi_branch() && !is_checkout() ) {
        self::getBranch();
      }
      // 
      if( $is_active_location && $deliveryType != 'pickup' ) {

        if( foodbook_is_location_type_address() ) {
          self::addressInput();
        } else {
          self::zipcodeInput();
        }
        
      }
      //
      do_action('foodbook_modal_ability_checker_form_result_before');
      ?>
      <div id="infowindow-content" style="display: none">
        <img src="" width="16" height="16" id="place-icon" />
        <span id="place-name" class="title"></span><br />
        <span id="place-address"></span>
      </div>
      <div class="fb-availability-check-result" style="display: none;"></div>
      <?php
      if( $is_active_location ) {
        if( foodbook_is_location_type_address() ) {
          self::button();
        }
      }
      ?>
    </div>
    <?php
  }

  /**
   * [form_for_shortcode description]
   * @return html
   */
  public static function form_for_shortcode( $text ) {
        
    echo '<div class="ability-checker-shortcode-form fb-ability-checker-form-wrapper">';
      $borderLeft = 'single-branch-input';

      if( foodbook_is_active_multi_branch() ) {
        $borderLeft = 'border-left-0';
        echo '<div class="fb-select-box-wrapper">';
        self::branchInput();
        echo '<input type="hidden" name="branch_address" />';
        echo '</div>';
      }
      echo '<div class="visitor-location-input-wrapper '.esc_attr( $borderLeft ).'">';
      if( !foodbook_is_active_multi_branch() ) {
        $location = \get_option('foodbook_options');
      echo '<input type="hidden" class="fb_input_style" name="branch_address" readonly value="'.esc_html( $location['branch-location'] ).'" />';
      }
      self::visitorLocationInput();
      echo '<div class="fb-locate-me-and-button-wrapper">';
        echo '<div class="fb-locate-me-wrapper">';
          self::locateMeIcon();
        echo '</div>';
        self::button( $text );
        echo '</div>';
      echo '</div>';
      
    echo '</div>';
    echo '<div class="fb-availability-check-result" style="display: none;"></div>';
  }

  /**
   * [zipcodeInput description]
   * @return [type] [description]
   */
  public static function zipcodeInput() {
    $zipCodes = foodbook_get_zipcodes();
    
    ?>
    <div class="zip-code-list hide-availability-checker">
      <?php
      if( !empty( $zipCodes ) ):
      ?>
      <p><?php esc_html_e( 'Select Your Location Zip Code', 'foodbook' ); ?></p>
      <div class="zip-codes">
        <?php 
        foreach( $zipCodes as $zip ):
        ?>
          <label for="zipcode<?php echo esc_attr( $zip ); ?>">
            <input id="zipcode<?php echo esc_attr( $zip ); ?>" class="fb-availability-check" type="radio" value="<?php echo esc_attr( $zip ); ?>" name="zipcode">
            <span><?php echo esc_html( $zip ); ?></span>
          </label>
        <?php
        endforeach; 
        ?>
      </div>
      <?php 
      endif;
      ?>
    </div>
    <?php
  }

  /**
   * [addressInput description]
   * @return [type] [description]
   */
  public static function addressInput() {
    $getText = Text::getText();
      if( foodbook_is_active_multi_branch() && !is_checkout() ):
        echo '<div class="hide-availability-checker"><input type="hidden" name="branch_address" /></div>';
      else: 
      $location = \get_option('foodbook_options');
      $branchLocation = !empty( $location['branch-location'] ) ? $location['branch-location'] : '';
      echo '<div class="restaurant-location-area hide-availability-checker"><p>'.esc_html( $getText['rl_title'] ).'</p>';
      echo '<input type="text" class="fb_input_style" name="branch_address" readonly value="'.esc_html( $branchLocation ).'" /></div>';
      endif;
      ?>
      <div class="pac-card hide-availability-checker" id="pac-card">
        <div class="location-input-before">
          <span><?php esc_html_e( 'Search your location', 'foodbook' ); ?> </span>
          <?php 
          self::locateMeIcon();
          ?>
        </div>
        <div id="pac-container">
          <?php self::visitorLocationInput(); ?>
        </div>
      </div>
      <?php
  }

  public static function visitorLocationInput() {
    ?>
    <input id="pac-input" name="visitor_location" class="fb_input_style pac-input" required type="text" placeholder="<?php esc_html_e( 'Enter a location', 'foodbook' ); ?>" />
    <?php
  }

  public static function locateMeIcon() {
    echo '<div class="locate-me-icon-wrapper"><span>'.esc_html__( 'Locate Me', 'foodbook' ).'</span><img class="fb-locate-me" src="'. FOODBOOK_DIR_URL.'assets/img/located_me_icon.png" /></div>';
  }

  /**
   * [button description]
   * @return [type] [description]
   */
  public static function button( $text = '' ) {
    $getText = Text::getText();
    $text = $text ? $text : $getText['availability_check'];
    ?>
    <div class="fb-availability-check-buton hide-availability-checker">
        <button class="fb-availability-check fb_btn_fill" ><?php echo esc_html( $text ); ?></button>
    </div>
    <?php
  }
  
  public static function delivery_types() {
    do_action( 'foodbook_delivery_types' );
  }

}
