<?php
/**
 *
 * @package     FoodBook
 * @author      ThemeLooks
 * @copyright   2020 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 */

get_header();

?>

<div class="fb__wrapper">
	<div class="fb_container">
        <div class="fb_row">
            <div class="fb_col_12">
				<div class="fb_card">
			      <div class="fb_multiform">
			        <h2> <?php esc_html_e( 'Sign In', 'foodbook' ); ?> </h2>
			        <!-- Single Form -->
			        <div class="fb_single_form fb_login_form show">
			         	<form action="<?php echo site_url( '/wp-login.php' ); ?>" method="post" class="form_log_in">
			            <div class="fb_row">
			              <div class="fb_col_md_6">
			                <div class="fb_input_group">
			                  <input
			                    type="text"
			                    id="fb_user_email"
			                    class="fb_input_style"
			                    name="log"
			                    required
			                  />
			                  <label
			                    for="fb_user_email"
			                    class="fb_input_label"
			                    ><?php esc_html_e( 'username/email', 'foodbook' ); ?><span>*</span></label
			                  >
			                </div>
			              </div>
			              <div class="fb_col_md_6">
			                <div class="fb_input_group">
			                  <input
			                    type="password"
			                    id="fb_user_password"
			                    name="pwd"
			                    class="fb_input_style"
			                    required
			                  />
			                  <label
			                    class="fb_input_label"
			                    for="fb_user_password"
			                    ><?php esc_html_e( 'Password', 'foodbook' ); ?> <span>*</span></label
			                  >
			                </div>
			              </div>
			              <div class="fb_col_12">
			              	<?php wp_nonce_field( 'foodbook-login-nonce', 'security' ); ?>
			                <input type="submit" class="fb_btn_fill" value="<?php esc_html_e( 'Login', 'foodbook' ); ?>" />
			              </div>
			            </div>
			        	</form>
			        </div>
			        <!-- End Single Form -->
			      </div>
			    </div>

            </div>
        </div>
	</div>
</div>
<?php


get_footer();