<?php
namespace FoodBook;

/**
 * Foodbook admin
 *
 * @package     Foodbook
 * @author      ThemeLooks
 * @copyright   2020 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

use \Automattic\WooCommerce\Utilities\OrderUtil;
if( !class_exists( 'Admin_Sub_Menu_Templates' ) ) {

	class Admin_Sub_Menu_Templates {
		// Get current date using wp_date
		private static function getDisplayCurrentDate() {
			return foodbook_current_date( true );
		}
		private static function getCurrentDate() {
			return foodbook_current_date();
		}
		//
		public function kitchen_template( $date  = '' ) {

			$options = get_option('foodbook_options');
			// Init Components class
			$Components = new Components();
		    // Get current date
		    $currentDate = self::getCurrentDate();
		    $displayCurrentDate = self::getDisplayCurrentDate();
		    $date = !empty( $date ) ? esc_html( $date ) : esc_html( $currentDate );

			// order query args
		    $orderArgs = array(
				'limit' 		=> '-1',
				'date_created'	=> sanitize_text_field( $date ),
		    );

		    //
		    if( empty( $options['kitchen-all-order'] ) ) {

				if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
					// HPOS usage is enabled.
					$orderArgs['meta_query'][] = array(
						'key'      => '_order_tracking_status',
						'value'    => 'OP',
						'compare' 	=> '!=',
					);

				} else {
					// Traditional CPT-based orders are in use.
					$orderArgs['meta_key']         = '_order_tracking_status';
					$orderArgs['meta_value']       = 'OP';
					$orderArgs['meta_compare'] 	   = '!=';
				}

		    }

		    // Get User Id
			$currentUser = get_current_user_id();
		    //
			if( foodbook_is_multi_branch() ) {
				
				// Get branch
				$args = array (
				  'post_type'        => 'branches',
				  'post_status'      => 'publish',
				  'meta_key'         => 'foodbookkitchen_manager',
				  'meta_value'       => esc_html( $currentUser ),
				  'meta_compare' => 'LIKE'
				);

				$getBranches = get_posts( $args );
				$getBranchesId	 = array_column( $getBranches, 'ID' );
				$getBranchesId	 = !empty( $getBranchesId[0] ) ? $getBranchesId[0] : '';
				$getBranchesName = array_column( $getBranches, 'post_title' );
				$getBranchesName = !empty( $getBranchesName[0] ) ? $getBranchesName[0] : '';
				// Set branch id in order args
				
				if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
					// HPOS usage is enabled.
					$orderArgs['meta_query'][] = array(
						'key'      => '_fb_pickup_branch',
						'value'    => $getBranchesId,
						'compare' 	=> '=',
					);
				} else {
					// Traditional CPT-based orders are in use.
					$orderArgs['branch'] = $getBranchesId;
				}

			}


			$orders = wc_get_orders( $orderArgs );

			?>
			<div class="kitchen-order">
				<div class="fb_row">
					<div class="fb_col_12">
						<?php 
						$date = !empty( $date ) ? $date : $displayCurrentDate;
						if( foodbook_is_multi_branch() ):
						?>
						<h4 class="bf-order-title fb_text_center fb_mb_20"><?php echo sprintf( esc_html__( 'Welcome To %s Branch Kitchen' ), esc_html( $getBranchesName ) ); ?> </h4>
						<?php 
						endif;
						?>
						<h4 class="bf-order-title fb_text_center fb_mb_50"><?php esc_html_e( 'Order List :', 'foodbook' ); ?> <?php echo esc_html( $date ); ?></h4>
					</div>
				</div>
				<div class="fb_row">
					<div class="fb_col_12">
						<div class="fb-order-notification"></div>
					</div>
				</div>
			</div>
			<table class="wp-list-table widefat fixed responsive foodbook-order-data-table foodbook-order-list">
				<?php
				// Table header 
				self::data_table_header();
				// Table body
				self::data_table_body( 'kitchen-order-list', $orders );
				// Table footer
				self::data_table_footer();
				?>
			</table>
			<?php
		}
		//
		public function branch_order_manage( $date = '' ) {

			$Components = new Components();

			// Get current date
			$currentDate = self::getCurrentDate();
		    $displayCurrentDate = self::getDisplayCurrentDate();
		    $date = isset( $date ) && !empty( $date ) ? esc_html( $date ) : esc_html( $currentDate );

			// Order query args
			$orderArgs = array(
				'limit' => '-1',
				'date_created' => sanitize_text_field( $date )
			);

			// Get User ID
			$currentUser = get_current_user_id();

	      	// Check branch type
	      	if( foodbook_is_multi_branch() ) {

				$args = array (
				  'post_type'        => 'branches',
				  'post_status'      => 'publish',
				  'meta_key'         => 'foodbookbranch_manager',
				  'meta_value'       => esc_html( $currentUser ),
				  'meta_compare' => 'LIKE'
				);

				$getBranches = get_posts( $args );

				$getBranchesId	 = array_column( $getBranches, 'ID' );
				$getBranchesId	 = !empty( $getBranchesId[0] ) ? $getBranchesId[0] : '';
				$getBranchesName = array_column( $getBranches, 'post_title' );
				$getBranchesName = !empty( $getBranchesName[0] ) ? $getBranchesName[0] : '';
				// Set branch id in order args
				
				if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
					// HPOS usage is enabled.
					$orderArgs['meta_query'][] = array(
						'key'      => '_fb_pickup_branch',
						'value'    => $getBranchesId,
						'compare' 	=> '=',
					);
				} else {
					// Traditional CPT-based orders are in use.
					$orderArgs['branch'] = $getBranchesId;
				}

	      	}

	        $orders = wc_get_orders( $orderArgs );

			?>
			<div class="fb_row">
				<div class="fb_col_12">
					<?php 
					$date = !empty( $date ) ? $date : $displayCurrentDate;
					//
					if( foodbook_is_multi_branch() ):
					?>
					<h4 class="bf-order-title fb_text_center fb_mb_20"><?php echo sprintf( esc_html__( 'Welcome To %s Branch' ), esc_html( $getBranchesName ) ); ?> </h4>
					<?php
					endif;
					?>
					<h5 class="bf-order-title fb_text_center fb_mb_50"><?php esc_html_e( 'Date:', 'foodbook' ); ?> <?php echo esc_html( $date ); ?></h5>
				</div>
			</div>
			
			<div class="branch-order">
				<div class="statistics-area">
					<div class="fb_row">
						<div class="fb_col_lg_4 fb_col_sm_6">
							<div class="fb_card fb_text_center fb_mb_30">
								<div class="fb_card_title fb_mb_0">
									<h3 class="fz-30 total_order-total_count fb_mb_15" ></h3>
									<h5><?php esc_html_e( 'Total Order', 'foodbook' ); ?></h5>	
								</div>
							</div>
						</div>
						<div class="fb_col_lg_4 fb_col_sm_6">
							<div class="fb_card fb_text_center fb_mb_30">
								<div class="fb_card_title fb_mb_0">
									<h3 class="fz-30 completed_order-total_count fb_mb_15"></h3>
									<h5><?php esc_html_e( 'Total Completed Order', 'foodbook' ); ?></h5>
								</div>
							</div>
						</div>
						<div class="fb_col_lg_4 fb_col_sm_6">
							<div class="fb_card fb_text_center fb_mb_30">
								<div class="fb_card_title fb_mb_0">
									<h3 class="fz-30 cancel_order-total_count fb_mb_15"></h3>
									<h5><?php esc_html_e( 'Total Cancel Order', 'foodbook' ); ?></h5>
								</div>
							</div>
						</div>
						<div class="fb_col_lg_4 fb_col_sm_6">
							<div class="fb_card fb_text_center fb_mb_30">
								<div class="fb_card_title fb_mb_0">
									<h3 class="fz-30 fb_mb_15"><span class="total_order-total_value"></span></h3>
									<h5><?php esc_html_e( 'Total Value', 'foodbook' ); ?></h5>
								</div>
							</div>
						</div>
						<div class="fb_col_lg_4 fb_col_sm_6">
							<div class="fb_card fb_text_center fb_mb_30">
								<div class="fb_card_title fb_mb_0">
									<h3 class="fz-30 fb_mb_15"><span class="completed_order-total_value"></span></h3>
									<h5><?php esc_html_e( 'Total Completed Order Value', 'foodbook' ); ?></h5>
								</div>
							</div>
						</div>
						<div class="fb_col_lg_4 fb_col_sm_6">
							<div class="fb_card fb_text_center fb_mb_30">
								<div class="fb_card_title fb_mb_0">
									<h3 class="fz-30 fb_mb_15"><span class="cancel_order-total_value"></span></h3>
									<h5><?php esc_html_e( 'Total Cancel Order Value', 'foodbook' ); ?></h5>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="fb_row">
					<div class="fb_col_12">
						<div class="fb-order-notification"></div>
					</div>
				</div>
			</div>
			<table class="wp-list-table widefat responsive foodbook-order-data-table fixed foodbook-order-list">
				<?php
				// Table header 
				self::data_table_header();
				// Table body
				self::data_table_body( 'branch-order-list', $orders );
				// Table footer
				self::data_table_footer();
				?>
			</table>
			<?php
		}
		//
		public function delivery_order_manage( $date = '' ) {
		
			// Get current date
			$currentDate = self::getCurrentDate();
		    $displayCurrentDate = self::getDisplayCurrentDate();
		    $currentUser = get_current_user_id();
			$date = !empty( $date ) ? foodbook_db_format_date_time( $date ) : foodbook_db_format_date_time( $currentDate );

		     // Get Orders
	        $args = array(
	        	'limit' => '-1'
	        );

	        if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
					// HPOS usage is enabled.
					$args['meta_query'] = array(
			            'relation' => 'AND',
			            array(
			                'key'        => '_order_delivery_boy_assign_date',
			                'value'      => sanitize_text_field( $date ),
			                'compare' => '='
			            ),
			            array(
			                'key'        => '_order_delivery_boy',
			                'value'      => esc_html( $currentUser ),
			                'compare' 	 => '='
			            ),
			        );
				} else {
					// Traditional CPT-based orders are in use.
					$args['meta_key']        = '_order_delivery_boy_assign_date';
	                $args['meta_value']      = sanitize_text_field( $date );
	                $args['meta_compare'] = '=';
		        	$args['delivery_boy']  = esc_html( $currentUser );
				}

		        $orders = wc_get_orders( $args );

			?>
			<div class="kitchen-order">
				<div class="fb_row">
					<div class="fb_col_12">
						<?php 
						$date = !empty( $date ) ? $date : $displayCurrentDate ;
						?>
						<h4 class="bf-order-title fb_text_center fb_mb_50"><?php esc_html_e( 'Order List :', 'foodbook' ); ?> <?php echo esc_html( $date ); ?></h4>
					</div>
				</div>
			</div>
			<table class="wp-list-table widefat responsive foodbook-order-data-table fixed foodbook-order-list">
				<?php 
				// Table header 
				self::data_table_header();
				// Table body
				self::data_table_body( 'kitchen-order-list', $orders );
				// Table footer
				self::data_table_footer();
				?>
			</table>
			<?php
		}
		//
		public function pre_order_date_filter( $date = '', $preorder = '' ) {

		    $wooArgs = ['limit' => '-1' ];

		    // Check branch type
		    if( foodbook_is_multi_branch() ) {

		    	if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
					// HPOS usage is enabled.
					$wooArgs['meta_query'][] = [
		    			'key' => '_fb_pickup_branch',
		    			'value' => sanitize_text_field( foodbook_get_current_branch_id_by_manager() ), // Branch id
		    			'compare' => '=',
		    		];
				} else {
					// Traditional CPT-based orders are in use.
					$wooArgs['branch'] = sanitize_text_field( foodbook_get_current_branch_id_by_manager() ); // Branch id;
				}

		    }

		    //
		    if( !empty( $date ) && !$preorder ) {

		    	if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
					// HPOS usage is enabled.
					$wooArgs['meta_query'][] = [
		    			'key' => '_delivery_date',
		    			'value' => sanitize_text_field( foodbook_db_format_date_time( $date ) ),
		    			'compare' => '=',   		
		    		];
				} else {
					// Traditional CPT-based orders are in use.
					$wooArgs['delivery_date'] = sanitize_text_field( foodbook_db_format_date_time( $date ) ); // Branch id;
				}
	        }
	        //
	        if( !empty( $preorder ) ) {
	        	
		    	if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
					// HPOS usage is enabled.
					$wooArgs['meta_query'][] = [
		    			'key' => '_pre_order_status',
		    			'value' => sanitize_text_field( $preorder ),
		    			'compare' => '=',		
		    		];
				} else {
					// Traditional CPT-based orders are in use.
					$wooArgs['pre_order_status'] = sanitize_text_field( $preorder ); // Branch id;
				}

	        }

		    $orders = wc_get_orders( $wooArgs );

		      ?>
				<table class="wp-list-table widefat responsive foodbook-order-data-table fixed foodbook-order-list">
			        <thead>
			          <tr>
			            <th><?php esc_html_e( 'Order Id', 'foodbook' ); ?></th>
			            <th><?php esc_html_e( 'Order Date', 'foodbook' ); ?></th>
			            <th><?php esc_html_e( 'Delivery Date/Time', 'foodbook' ); ?></th>
			            <th><?php esc_html_e( 'Delivery Type', 'foodbook' ); ?></th>
			            <th><?php esc_html_e( 'Tracking Status', 'foodbook' ); ?></th>
			            <th><?php esc_html_e( 'View Order', 'foodbook' ); ?></th> 
			          </tr>
			        </thead>

			        <tbody>
			          <?php
			              if( !empty( $orders ) ) {

			                foreach( $orders as $order ) {

			                  $order_id = $order->get_id();
			                  $paymentMethod = $order->get_payment_method_title();

			                  $status = $order->get_meta('_order_tracking_status');
			                  $preOrder       = $order->get_meta('_pre_order_status');
			                  $delivery_type  = $order->get_meta('_delivery_type');
			                  $delivery_date  = $order->get_meta('_delivery_date');
			                  $delivery_time  = $order->get_meta('_pickup_time');

			                  $time = $order->get_meta('_order_tracking_status_time');

			                  $getTime = foodbook_time_elapsed_string( $time , true );
			                  $orderDate = $order->get_date_created()->format ('M-d-Y');

			                  ?>
			                  <tr>
			                    <td><?php echo esc_html( '#'.absint( $order_id ) ); ?></td>
			                    <td><?php echo esc_html( $orderDate ); ?></td>
			                    <td>
								    <?php 
					                  $preOrderClass = '';
					                  if( !empty( $preOrder ) && $preOrder == 'PO' ) {
					                    $preOrderClass = 'pre-order';
					                    echo esc_html( foodbook_date_format( $delivery_date, '' ) .' - '.$delivery_time ); 
					                  } else {
					                    echo esc_html( $orderDate );
					                  }
					                ?>	
			                    </td>
			                    <td><?php echo esc_html( $delivery_type ); ?></td>
			                    <td>
								    <span class="order-status"><?php echo esc_html( foodbook_converted_tracking_status( $status )  ); ?></span>
					                <?php 
					                if( !empty( $preOrder ) && $preOrder == 'PO' ):
					                ?>
					                <span class="order-status <?php echo esc_html( $preOrderClass ); ?>"><?php echo esc_html( foodbook_converted_tracking_status( $preOrder )  ); ?></span>
					                <?php 
					                endif;
					                ?>
			                    	<br>
			                    	<span class="time-status"><?php echo esc_html( $getTime ); ?></span>
			                    </td>
			                    <td>
			                    <button class="fb_btn_fill fill_sm fb-view-order" data-order-id="<?php echo esc_attr( $order_id ); ?>"><?php esc_html_e( 'View Details', 'foodbook' ); ?></button>
			                    </td>
			                  </tr>
			                  <?php
			                  
			                }

			              } else {
			              	echo '<td valign="top" colspan="7" class="dataTables_empty">'.esc_html__( 'No order found', 'foodbook' ).'</td>';
			              }
			              ?>

			        </tbody>
			        <tfoot>
			          <tr>            
			            <th><?php esc_html_e( 'Order Id', 'foodbook' ); ?></th>
			            <th><?php esc_html_e( 'Order Date', 'foodbook' ); ?></th>
			            <th><?php esc_html_e( 'Delivery Date/Time', 'foodbook' ); ?></th>
			            <th><?php esc_html_e( 'Delivery Type', 'foodbook' ); ?></th>
			            <th><?php esc_html_e( 'Tracking Status', 'foodbook' ); ?></th>
			            <th><?php esc_html_e( 'View Order', 'foodbook' ); ?></th> 
			          </tr>
			        </tfoot>

			    </table>
		      <?php

		}
		//
		public function admin_branches_manage() {
			// get current date
		    $displayCurrentDate = self::getDisplayCurrentDate();
			?>
			<div class="container-fluid">
				<div class="foodbook-wrapper">
					<div class="fb-tab-content">
						<div class="container-fluid">
							<div class="row">
								<div class="col-12">
									<?php do_action( 'foodbook_branche_mange_header_name' ); ?>									
									<h2 class="current-date-title"><?php esc_html_e( 'Date:', 'foodbook' ); ?> <span class="current-date"><?php echo esc_html( $displayCurrentDate ); ?></span></h2>
								</div>
								<div class="col-lg-6 col-12">
									<?php
										$Components = new Components();
										$Components->admin_filter_form_html();
									?>
								</div>
								<div class="col-lg-6 col-12">
									<?php
										$Components->preorder_filter_form_html();
									?>
								</div>
							</div>
							<div class="statistics-area">
								<div class="row">
									<div class="col-lg-4 col-sm-6 col-12">
										<div class="fb-single-Statistics">
											<h2 class="total_order-total_count" ></h2>
											<h4><?php esc_html_e( 'Total Order', 'foodbook' ); ?></h4>
										</div>
									</div>
									<div class="col-lg-4 col-sm-6 col-12">
										<div class="fb-single-Statistics">
											<h2 class="completed_order-total_count"></h2>
											<h4><?php esc_html_e( 'Total Completed Order', 'foodbook' ); ?></h4>
										</div>
									</div>
									<div class="col-lg-4 col-sm-6 col-12">
										<div class="fb-single-Statistics">
											<h2 class="cancel_order-total_count"></h2>
											<h4><?php esc_html_e( 'Total Cancel Order', 'foodbook' ); ?></h4>
										</div>
									</div>
									<div class="col-lg-4 col-sm-6 col-12">
										<div class="fb-single-Statistics">
											<h2><span class="total_order-total_value"></span></h2>
											<h4><?php esc_html_e( 'Total Value', 'foodbook' ); ?></h4>
										</div>
									</div>
									<div class="col-lg-4 col-sm-6 col-12">
										<div class="fb-single-Statistics">
											<h2><span class="completed_order-total_value"></span></h2>
											<h4><?php esc_html_e( 'Total Completed Order Value', 'foodbook' ); ?></h4>
										</div>
									</div>
									<div class="col-lg-4 col-sm-6 col-12">
										<div class="fb-single-Statistics">
											<h2><span class="cancel_order-total_value"></span></h2>
											<h4><?php esc_html_e( 'Total Cancel Order Value', 'foodbook' ); ?></h4>
										</div>
									</div>
								</div>
							</div>
							<div class="container-fluid">
								<div class="row">
									<div class="col-12">
										<div class="order-tbl">
											<div class="branch-order">
												<div class="row">
													<div class="col-12">
														<div class="fb-order-notification"></div>
													</div>
												</div>
											</div>
											<div id="dtable"></div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			
			<?php
		}

		/**
		 * data_table_header  data table header markup
		 * @return html
		 */
		public static function data_table_header() {
			?>
			<thead>
				<tr>
					<th><?php esc_html_e( 'Order Id', 'foodbook' ); ?></th>
					<th><?php esc_html_e( 'Order Date', 'foodbook' ); ?></th>
					<th><?php esc_html_e( 'Delivery Date/Time', 'foodbook' ); ?></th>
					<th><?php esc_html_e( 'Delivery Type', 'foodbook' ); ?></th>
					<th><?php esc_html_e( 'Payment Method/Status', 'foodbook' ); ?></th>
					<th><?php esc_html_e( 'Tracking Status', 'foodbook' ); ?></th>
					<th><?php esc_html_e( 'View Order', 'foodbook' ); ?></th>	
				</tr>
			</thead>
			<?php
		}
		/**
		 * data_table_footer data table footer markup
		 * @return html
		 */
		public static function data_table_footer() {
			?>
			<tfoot>
				<tr>						
					<th><?php esc_html_e( 'Order Id', 'foodbook' ); ?></th>
					<th><?php esc_html_e( 'Order Date', 'foodbook' ); ?></th>
					<th><?php esc_html_e( 'Delivery Date/Time', 'foodbook' ); ?></th>
					<th><?php esc_html_e( 'Delivery Type', 'foodbook' ); ?></th>
					<th><?php esc_html_e( 'Payment Method/Status', 'foodbook' ); ?></th>
					<th><?php esc_html_e( 'Tracking Status', 'foodbook' ); ?></th>
					<th><?php esc_html_e( 'View Order', 'foodbook' ); ?></th>	
				</tr>
			</tfoot>
			<?php
		}
		/**
		 * data_table_body data table body
		 * @param  [type] $orders [description]
		 * @return html
		 */
		public static function data_table_body( $tableId, $orders ) {
			?>
			<tbody id="<?php echo esc_attr( $tableId ); ?>">
				<?php
		        if( !empty( $orders ) ) {

		          foreach( $orders as $order ) {

		          	$order_id = $order->get_id();
		          	$paymentMethod = $order->get_payment_method_title();
		          	$wcOrderStatus = $order->get_status();

			        $status     = $order->get_meta('_order_tracking_status');
	                $preOrder     = $order->get_meta('_pre_order_status');
	                $delivery_type  = $order->get_meta('_delivery_type');
	                $delivery_date  = $order->get_meta('_delivery_date');
	                $deliveryDisplaydate = foodbook_display_date( $delivery_date );
	                $delivery_time  = $order->get_meta('_pickup_time');
	                $orderDate    = $order->get_date_created()->format ('M-d-Y');
	                $orderDisplayDate = foodbook_display_date( $orderDate );
	                $orderTime    = $order->get_date_created()->format ( foodbook_time_format() );
	                $time    = $order->get_meta('_order_tracking_status_time');
	                $getTime = foodbook_time_elapsed_string( $time , true );

		            ?>
		            <tr>
		              <td><?php echo esc_html( '#'.absint( $order_id ) ); ?></td>
		              <td><?php echo esc_html( $orderDisplayDate.' '.$orderTime ); ?></td>
		              <td>
		              	<?php 
		              	$preOrderClass = '';
		              	if( !empty( $preOrder ) && $preOrder == 'PO' ) {
		              		$preOrderClass = 'pre-order';
		              		echo esc_html( $deliveryDisplaydate.' - '.$delivery_time ); 
		              	} else {
		              		echo esc_html( $orderDisplayDate .' - '.$delivery_time );
		              	}
		              	?>
		              </td>
		              <td><?php echo esc_html( $delivery_type ); do_action( 'foodbook_order_table_delivery_type_td', $order_id ); ?></td>
		              <td>
		              	<?php 
		                echo sprintf( esc_html__( "Method: %s", "foodbook" ), $paymentMethod );
		                echo '<br>';
		                echo sprintf( esc_html__( "Status: %s", "foodbook" ), $wcOrderStatus ); 
		                ?>
		              </td>
		              <td>
		              	<span class="order-status <?php echo esc_attr( strtolower( $status ).'-status' ); ?>"><?php echo esc_html( foodbook_converted_tracking_status( $status )  ); ?></span>
		              	<?php 
		                if( !empty( $preOrder ) && $preOrder == 'PO' ):
		                ?>
		              	<span class="order-status <?php echo esc_html( $preOrderClass ); ?>"><?php echo esc_html( foodbook_converted_tracking_status( $preOrder )  ); ?></span>
		              	<?php 
		              	endif;
		              	?>
		              	<br>
		              	<span class="time-status"><?php echo esc_html( $getTime ); ?></span>
		              </td>
		              <td>
						<button class="fb_btn_fill fill_sm fb-view-order" data-order-id="<?php echo esc_attr( $order_id ); ?>"><?php esc_html_e( 'View Details', 'foodbook' ); ?></button>
		              </td>
		            </tr>
		            <?php
		            
		          }

		        }
		      	?>
			</tbody>
			<?php
		}


	}

}
