<script type="text/html" id="tmpl-fb_order_modal" >
	<div class="fb__wrapper orderadmin_popup_modal" id="orderadmin_popup_modal">
		<div class="fb_popup_modal open">
			<div class="fb_modal_wrap">
				<div class="fb_modal">
					<div class="fb_modal_inner">
						<!-- Close Modal -->
						<span class="fb_close_modal">
							<img src="<?php echo FOODBOOK_DIR_URL.'assets/img/icon/close.svg'; ?>" alt="<?php echo esc_attr( 'close', 'foodbook' ); ?>" />
						</span>
						<!-- End Close Modal -->
						<div class="fb_modal_content">
							<div class="fb_modal_title fb_text_center">
								<h3><?php esc_html_e( 'Order Details', 'foodbook' ); ?></h3>
								<div class="print-btn-area">
									<span class="fb_btn_fill fb-inv-back" style="float:left;display:none;padding: 4px 12px;"><?php esc_html_e( 'Back', 'foodbook' ); ?></span>
									<span class="fb_btn_fill fb-inv-print" style="float:right;padding: 4px 12px;"><?php esc_html_e( 'Print Invoice', 'foodbook' ); ?></span>
								</div>
							</div>
							<?php
							$invoiceType = foodbook_getOptionData( 'invoice_type' );
							// Invoice Template												
							$Components = new \FoodBook\Components();
							if( $invoiceType != 'thermal' ) {
								$Components->invoice_js_template();
							} else {
								$Components->thermal_printer_invoice_template();
							}
							?>

							<div class="fb_modal_content_inner content-inner-hide">
								<div class="modal-order-top-info">
									<h4 class="order-id"><?php esc_html_e( 'Order ID: #', 'foodbook' ); ?>{{data.order_id}} </h4>
									<h4 class="order-id"><?php echo sprintf( esc_html__( 'Order Date: %s', 'foodbook' ), "{{data.created_date}}"  ); ?></h4>
									<h4 class="order-id"><?php echo sprintf( esc_html__( 'Delivery Type: %s', 'foodbook' ), "{{data.delivery_type}}"  ); ?></h4>
									<# if(data.inrestaurant_table_number) { #>
										<h4 class="order-id"><?php echo sprintf( esc_html__( 'Table Number: %s', 'foodbook' ), "{{data.inrestaurant_table_number}}"  ); ?></h4>
									<# } #>
									<h4 class="order-id"><?php echo sprintf( esc_html__( 'Delivery/Pickup Date : %s', 'foodbook' ), "{{data.delivery_date}}"  ); ?></h4>
									<h4 class="order-id"><?php echo sprintf( esc_html__( 'Delivery/Pickup Time: %s', 'foodbook' ), "{{data.pickup_time}}"  ); ?></h4>
									<h4 class="order-id"><?php echo sprintf( esc_html__( 'Payment Method: %s', 'foodbook' ), "{{data.payment_method}}"  ); ?></h4>
								</div>
								
								<div class="fb-address-wrapper">
								    <div class="row">
										<div class="col-md-6">
											<div class="fb-billing-address">

												<h4><?php esc_html_e( 'Billing Information', 'foodbook' ); ?></h4>
												<# if( data.order_address.billing_name ){ #>
												<?php echo '<p>'.sprintf( esc_html__( 'Name: %s', 'foodbook' ), "{{data.order_address.billing_name}}" ).'</p>'; ?>
												<# } if( data.order_address.billing_name ){ #>
												<?php echo '<p>'.sprintf(  esc_html__( 'Phone: ', 'foodbook' ).'<a href="tel:%1$s">%1$s</a>', "{{data.order_address.billing_phone}}" ).'</p>'; ?>
												<# } #>
												<?php echo '<p>'.esc_html__( 'Address: ', 'foodbook' ).'{{data.order_address.billing_address}}</p>'; ?>
											</div>
										</div>

								    	<# if( data.order_address.shipping_address ) { #>
										<div class="col-md-6">
											<div class="fb-shipping-address">
												<h4><?php esc_html_e( 'Shipping Information', 'foodbook' ); ?></h4>
												<?php
												echo '<p>'.sprintf( esc_html__( 'Name: %s', 'foodbook' ), "{{data.order_address.shipping_name}}" ).'</p>';
								          		echo '<p>'.esc_html__( 'Address: ', 'foodbook' ).'{{data.order_address.shipping_address}}</p>';
								        
												?>
											</div>
										</div>
								    	<#}#>
								    </div>
								    <?php 
								    if( !empty( foodbook_getOptionData('delivery-directions-map') ) ):
								    ?>
								    <# if( !data.status_button.is_kitchen_manager && !data.status_button.is_branch_manager  ){ #>
								    <div class="row">
								    	<div class="fb_col_12">
								    		<div class="fb-shipping-address">
								    			<# var address =  data.order_address.shipping_address_1 ? data.order_address.shipping_address_1 : data.order_address.billing_address_1;
								    			var branchAddress = data.shop_address;
								    			#>
								    			<iframe src="https://www.google.com/maps/embed/v1/directions?origin={{branchAddress}}&destination={{address}}&key=<?php echo foodbook_getOptionData('google-api-key'); ?>&mode=<?php echo esc_attr( foodbook_getOptionData('delivery-transport-mode', 'driving') ); ?>" width="100%" height="350" allowfullscreen></iframe>
								    		</div>
								    	</div>
								    </div>
								    <#}#>
								    <?php
									endif;
								    ?>
								</div>
								<#
								if( data.status_button.order_status != 'OF' ){
								#>
								<div class="kitchen-change-tracking">
									<?php 
									$statusText = foodbook_getStatusText();
									?>
									<h4 class="fb_text_center"><?php esc_html_e( 'Tracking Status Action', 'foodbook' ); ?></h4>
									<div class="status-button-area">
										<!-- Don't show if user  delivery boy -->
										<# var getStatusData = data.status_button;  if( getStatusData.is_not_delivery_boy ) { #>
										<span data-orderid="{{data.order_id}}" data-tracking-status="OC" class="order-cancel {{getStatusData.status_class.oc}}"><?php echo esc_html( $statusText['oc'] ); ?></span>
										<!-- Don't show if user not branch manager -->
										<# if( getStatusData.is_branch_manager ){ #>
										<span data-orderid="{{data.order_id}}" data-tracking-status="STC"  class="status-btn send-to-cooking {{getStatusData.status_class.stc}}"><?php echo esc_html( $statusText['stc'] ); ?></span>
										<#
										}
										<!-- Don't show if user not kitchen manager -->
										if( getStatusData.is_kitchen_manager ){
										#>
										<span data-orderid="{{data.order_id}}" data-tracking-status="AC" class="cooking-accept status-btn {{getStatusData.status_class.ac}}"><?php echo esc_html( $statusText['ac'] ); ?></span>
										<# } #>
										<span data-orderid="{{data.order_id}}" data-tracking-status="CC" class="cooking-complete status-btn {{getStatusData.status_class.cc}}"><?php echo esc_html( $statusText['cc'] ); ?></span>
										<!--  end check Delivery boy user -->
										<# }#>
										<span data-orderid="{{data.order_id}}" data-tracking-status="OWD" class="status-btn {{getStatusData.status_class.owd}}"><?php echo esc_html( $statusText['otw'] ); ?></span>
										<span data-orderid="{{data.order_id}}" data-tracking-status="DC" class="cooking-accept status-btn {{getStatusData.status_class.dc}}"><?php echo esc_html( $statusText['dc'] ); ?></span>

									</div>
									<# if( getStatusData.is_not_delivery_boy ) { #>
									<div class="fb_row">
										<div class="fb_col_lg_6">
											<div class="delivery-boy fb_input_wrapper">
										        
										        <select class="fb_input_style" id="delivery_boy" name="delivery_boy">
										        	<#
										        	_.each( data.delivery_boies.boies, function( item, i ) {

										        	selected = ( i == data.delivery_boies.asigned_boy ) ? 'selected' : '';
										        	#>
										        	<option value="{{i}}" {{selected}} >{{item}}</option>
										        	<#}  )#>
										          
										        </select>
										        <button class="fb_btn_fill" id="delivery_assign" data-orderid="{{data.order_id}}" > <?php esc_html_e( 'Assign', 'foodbook' ); ?> </button>
										    </div>
										</div>

										<div class="fb_col_lg_6">
											<# if(data.is_multi_branch) { #>
											<div class="order-transfer fb_input_wrapper">
										        <select class="fb_input_style" id="branch_list" name="branch_id">
										          <option value=""><?php esc_html_e( 'Select Branch', 'foodbook' ); ?></option>
										          	<#
										        	_.each( data.branch_list.branches, function( item, i ) {

										        	selected = ( i == data.branch_list.asigned_branch ) ? 'selected' : '';
										        	#>
										        	<option value="{{i}}" {{selected}} >{{item}}</option>
										        	<#}  )#>
										        </select>
										        <button class="fb_btn_fill" id="order_transfer" data-orderid="{{data.order_id}}" > <?php esc_html_e( 'Transfer', 'foodbook' ); ?> </button>
										    </div>
										    <#}#>
										</div>
									</div>
									<#}#>
								</div>
								<#
								} <!-- OF Status Check End -->
								#>
								<div class="fb_order_table">
									<table>
										<thead>
											<tr>
											<th><?php esc_html_e( 'Item Name', 'foodbook' ); ?></th>
											<th><?php esc_html_e( 'Quantity', 'foodbook' ); ?></th>
											<th><?php esc_html_e( 'Extra Item', 'foodbook' ); ?></th>
											<th><?php esc_html_e( 'Item Total Price', 'foodbook' ); ?></th>
											</tr>
										</thead>
										<tbody>
										<# _.each( data.order_items, function( item ) { #>
											<tr>
												<td>{{item.item_name}}</td>
												<td>{{item.item_qty}}</td>
												<td>
													{{{item.item_meta_data}}}													 
												</td>
												<td>{{{item.item_total_price}}}</td>
											</tr>
											<# } ) #>
											<tr>
												<td><?php esc_html_e( 'Order Notes:', 'foodbook' ); ?></td>
												<td>{{data.customer_note}}</td>
												<td></td>
												<td></td>
											</tr>
										</tbody>
										<tfoot>
											<# if( data.item_total ) { #>
											<tr>
												<th rowspan="1" colspan="1"></th>
												<th rowspan="1" colspan="1"></th>
												<th rowspan="1" colspan="1"><?php esc_html_e( 'Items Subtotal', 'foodbook' ); ?></th>
												<th rowspan="1" colspan="1">{{{data.item_total}}}</th>
											</tr>
											<# } #>
												
											<# if( data.discount_display ) { #>
											<tr>
												<th rowspan="1" colspan="1"></th>
												<th rowspan="1" colspan="1"></th>
												<th rowspan="1" colspan="1"><?php esc_html_e( 'Coupon(s):', 'foodbook' ); ?>  {{{data.used_coupons}}}</th>
												<th rowspan="1" colspan="1">- {{{data.discount_display}}}</th>
											</tr>
											<# } #>
											<# if( data.order_total_fees ) {
									        	_.each( data.get_fees, function( item ) {
									         #>
											<tr>
												<th rowspan="1" colspan="1"></th>
												<th rowspan="1" colspan="1"></th>
												<th rowspan="1" colspan="1">{{{item.name}}}</th>
												<th rowspan="1" colspan="1">{{{item.amount}}}</th>
											</tr>
											<# })} #>

											<# 
											if( data.get_tax_totals ){
											_.each( data.get_tax_totals , function( item ) {
											#>
											<tr>
												<th rowspan="1" colspan="1"></th>
												<th rowspan="1" colspan="1"></th>
												<th rowspan="1" colspan="1">{{{item.label}}}</th>
												<th rowspan="1" colspan="1">{{{item.formatted_amount}}}</th>
											</tr>
											<#})}#>

											<# if( data.order_shipping_total ) { #>
											<tr>
												<th rowspan="1" colspan="1"></th>
												<th rowspan="1" colspan="1"></th>
												<th rowspan="1" colspan="1"><?php esc_html_e( 'Shipping Fee', 'foodbook' ); ?></th>
												<th rowspan="1" colspan="1">{{{data.order_shipping_total}}}</th>
											</tr>
											<# } #>
											<tr>
												<th rowspan="1" colspan="1"></th>
												<th rowspan="1" colspan="1"></th>
												<th rowspan="1" colspan="1"><?php esc_html_e( 'Total', 'foodbook' ); ?></th>
												<th rowspan="1" colspan="1">{{{data.order_total}}}</th>
											</tr>
										</tfoot>
									</table>
								</div>
							</div>
						</div>
					</div>
				</div>
				
			</div>

		</div>
	</div>
</script>