<?php
/**
 * Plugin Name:       FoodBook
 * Plugin URI:        https://www.persianscript.ir
 * Description:       FoodBook is a Online Food Ordering system for WordPress. It is developed based on woocommerce. It is a standalone WordPress plugin which allows you to easily add Food Ordering System to your WordPress Website. Using FoodBook you can easily receive both PickUp and Delivery orders.
 * Version:           4.3.9
 * Author:            پرشین اسکریپت
 * Author URI:        https://www.persianscript.ir
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       foodbook
 * Domain Path:       /languages
 */

/**
 * Define all constant
 *
 */
update_option( "foodbook_plugin_lic_Key", "lic_Key" );

// Version constant
if( !defined( 'FOODBOOK_VERSION' ) ) {
	define( 'FOODBOOK_VERSION', '4.3.9' );
}

// Plugin dir path constant
if( !defined( 'FOODBOOK_DIR_PATH' ) ) {
	define( 'FOODBOOK_DIR_PATH', trailingslashit( plugin_dir_path( __FILE__ ) ) );
}
// Plugin dir url constant
if( !defined( 'FOODBOOK_DIR_URL' ) ) {
	define( 'FOODBOOK_DIR_URL', trailingslashit( plugin_dir_url( __FILE__ ) ) );
}
// Plugin dir admin assets url constant
if( !defined( 'FOODBOOK_DIR_ADMIN_ASSETS_URL' ) ) {
	define( 'FOODBOOK_DIR_ADMIN_ASSETS_URL', trailingslashit( FOODBOOK_DIR_URL . 'admin/assets' ) );
}
// Admin dir path
if( !defined( 'FOODBOOK_DIR_ADMIN' ) ) {
	define( 'FOODBOOK_DIR_ADMIN', trailingslashit( FOODBOOK_DIR_PATH.'admin' ) );
}
// Inc dir path
if( !defined( 'FOODBOOK_DIR_INC' ) ) {
	define( 'FOODBOOK_DIR_INC', trailingslashit( FOODBOOK_DIR_PATH.'inc' ) );
}

require_once "foodbookBase.php";

final class FoodBook {

	private static $instance = null;
	
	public $plugin_file 	=__FILE__;
	public $showMessage 	= false;
	public $slug 			= "foodbook_plugin_license";
	public $responseObj;
	public $licenseMessage;
	
	function __construct() {
		add_action( 'init', [ $this, 'foodbook_load_textdomain' ] );
		add_action( 'admin_notices',[ $this, 'foodbook_plugin_activated_notices' ] );
		register_uninstall_hook( __FILE__, [ __CLASS__, 'foodbook_plugin_deactivate' ] );
		register_activation_hook( __FILE__, [ $this, 'foodbook_plugin_activate' ] );
		register_activation_hook( __FILE__, [ $this, 'foodbook_admin_notice_activation_hook' ] );
		
		// For License
		add_action( 'admin_print_styles', [ $this, 'SetAdminStyle' ] );
		$licenseKey = get_option( "foodbook_plugin_lic_Key", "" );
		$liceEmail  = get_option( "foodbook_plugin_lic_email", "" );
		
		foodbookBase::addOnDelete( function(){
		   delete_option( "foodbook_plugin_lic_Key" );
		});
		
		if( foodbookBase::CheckWPPlugin( $licenseKey, $liceEmail, $this->licenseMessage, $this->responseObj, __FILE__ ) ){
			add_action( 'admin_menu', [ $this, 'ActiveAdminMenu' ], 99999 );
			add_action( 'admin_post_foodbook_plugin_el_deactivate_license', [ $this, 'action_deactivate_license' ] );
			add_action( 'plugins_loaded', [ $this, 'foodbook_is_woocommerce_activated'] );
			delete_transient( 'foodbook_plugin-admin-notice' );
		}else{
			if( !empty( $licenseKey ) && !empty( $this->licenseMessage ) ){
			   $this->showMessage = true;
			}
			update_option( "foodbook_plugin_lic_Key", "" ) || add_option( "foodbook_plugin_lic_Key", "" );
			add_action( 'admin_post_foodbook_plugin_el_activate_license', [ $this, 'action_activate_license' ] );
			add_action( 'admin_menu', [ $this, 'InactiveMenu' ] );
		}
	}
	
	// Initial Notice
	public function foodbook_admin_notice_activation_hook(){
        set_transient( 'foodbook_plugin-admin-notice', 'yes', 0 );
    }
	
	public function foodbook_plugin_activated_notices() {
        if( get_transient( 'foodbook_plugin-admin-notice' ) ){
            printf('<div class="notice notice-warning is-dismissible"><h3>Warning!</h3><p><strong>'.esc_html__('Please activate your license to get full access to the Plugin, updates, premium support, etc.','foodbook').'</strong></p><p><a class="button button-primary" href="'.admin_url('/admin.php?page=foodbook_plugin_license').'">'.esc_html__('Active License','foodbook').'</a></p></div>');
        }
    }
	
	public static function getInstance() {
		
		if( is_null( self::$instance ) ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	/**
	 * Load plugin textdomain.
	 */
	public function foodbook_load_textdomain() {
	    load_plugin_textdomain( 'foodbook', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' ); 
	}

	/**
	 * Check WooCommerce is activated or not
	 * 
	 */
	public function foodbook_is_woocommerce_activated() {

		if ( class_exists( 'woocommerce' ) ) {
			require_once( FOODBOOK_DIR_PATH.'foodbook-init.php' );
		} else {
			add_action( 'admin_notices', [ $this, 'foodbook_activation_admin_notice' ] );
		}

	}

	/**
	 * foodbook_activation_admin_notice description
	 * 
	 * If wooocommerce plugin not active 
	 * show the admin notification to active woocommerce plugin 
	 * 
	 * @return 
	 */
	public function foodbook_activation_admin_notice() {
	    $url = "https://wordpress.org/plugins/woocommerce/";
	    ?>
	    <div class="notice notice-error is-dismissible">
	        <h4><?php echo sprintf( esc_html__( 'FoodBook requires the WooCommerce plugin to be installed and active. You can download %s woocommerce %s here. Thanks.', 'foodbook' ), '<a href="'.esc_url( $url ).'" target="_blank">','</a>' ); ?></h4>
	    </div>
	    <?php
	}

	/**
	 * foodbook_default_pages_list 
	 * @return array
	 */
	public function foodbook_default_pages_list() {

	  return [
	    "foodbook"        => "FoodBook",
	    "branch-manager"  => "Branch Manager",
	    "kitchen-manager" => "Kitchen Manager",
	    "delivery"        => "Delivery",
	    "delivery-options" => "all",
	    "admin"           => "Admin"
	  ];

	}

	/**
	 * foodbook_insert_page 
	 * Add plugin default page
	 * @return 
	 * 
	 */
	public function foodbook_insert_page() {

	  $getPages = $this->foodbook_default_pages_list();

	  foreach( $getPages as $page_title ) {

		  // Create page object
		  $page = array(
		    'post_type'     => 'page',
		    'post_title'    => wp_strip_all_tags( $page_title ),
		    'post_status'   => 'publish'
		  );
		   
		  // Insert the post into the database
		  wp_insert_post( $page );
	  
	  }

	}

	/**
	 * foodbook_delete_page description
	 * @return 
	 */
	public function foodbook_delete_page() {

	    // Pages
	   $getPages = $this->foodbook_default_pages_list();
	    
	    //
	    foreach( $getPages as $key => $page ){
	      $page_data  = get_page_by_path( $key );
	      
	      wp_delete_post( $page_data->ID );
	    }

	}

	/**
	 * foodbook_plugin_activate
	 * @return 
	 */
	public function foodbook_plugin_activate() {

		// Insert default pages
		$this->foodbook_insert_page();

		// Default options set
		$defaultOption = array(

			"product-limit" 	=> 6,
			"search-section" 	=> 'yes',
			"show-cart-button" 	=> 'yes',
			"shop-page" 		=> 'foodbook',
			"branch-manager" 	=> 'branch-manager',
			"kitchen-manager" 	=> 'kitchen-manager',
			"checkout-delivery-option" => 'yes',
			"popup-location-active"	   => 'yes',
			"modal-close-btn-show"	   => 'yes',
			"delivery-options" 	 => 'all',
			"pickup-time-switch" => 'yes',
			"delivery" 			 => 'delivery',
			"admin" 			 => 'admin'
		);

		update_option( 'foodbook_options', $defaultOption );

	}
	
	/**
	 * foodbook_plugin_deactivate 
	 * @return 
	 */
	public static function foodbook_plugin_deactivate() {
		// Delete default pages
		$this->foodbook_delete_page();
		//
		delete_option('foodbook_options');
	}
	
	// Admin Style Css
	public function SetAdminStyle() {
		wp_register_style( "foodbook_pluginLic", plugins_url( "assets/css/license-style.css", $this->plugin_file ), 10 );
		wp_enqueue_style( "foodbook_pluginLic" );
	}
	
	// Menu For Activate The License
	public function ActiveAdminMenu(){
		add_menu_page (  "Foodbook Licensing", "Foodbook Licensing", "activate_plugins", $this->slug, [ $this, "Activated" ], plugins_url( 'foodbook/assets/img/favicon.png' ) );
	}
	
	public function InactiveMenu() {
		add_menu_page( "Foodbook Licensing", "Foodbook Licensing", 'activate_plugins', $this->slug,  [ $this, "LicenseForm" ], plugins_url( 'foodbook/assets/img/favicon.png' ) );
	}
	
	// Action For Activate The License
	public function action_activate_license(){
        check_admin_referer( 'el-license' );
        $licenseKey   = ! empty( $_POST['el_license_key'] ) ? $_POST['el_license_key'] : "";
        $licenseEmail = ! empty( $_POST['el_license_email']) ? $_POST['el_license_email'] : "";
        update_option( "foodbook_plugin_lic_Key", $licenseKey ) || add_option( "foodbook_plugin_lic_Key", $licenseKey );
        update_option( "foodbook_plugin_lic_email", $licenseEmail ) || add_option( "foodbook_plugin_lic_email", $licenseEmail );
        update_option( '_site_transient_update_plugins', '' );
        wp_safe_redirect( admin_url( 'admin.php?page='.$this->slug ) );
    }
	
	// Action When Deactivate The License
	public function action_deactivate_license() {
		check_admin_referer( 'el-license' );
		if( foodbookBase::RemoveLicenseKey(__FILE__, $message ) ){
			update_option( "foodbook_plugin_lic_Key", "" ) || add_option( "foodbook_plugin_lic_Key", "" );
			deactivate_plugins( '/foodbook/foodbook.php' );
			wp_safe_redirect( admin_url( 'plugins.php' ) );
		} else {
			wp_safe_redirect( admin_url( 'admin.php?page='.$this->slug ) );
		}
	}
	
	// Interface After Activate The License
	public function Activated(){
        ?>
        <form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
            <input type="hidden" name="action" value="foodbook_plugin_el_deactivate_license"/>
            <div class="el-license-container">
                <h3 class="el-license-title"><i class="dashicons-before dashicons-star-filled"></i> <?php _e( "Foodbook License Info", $this->slug );?> </h3>
                <hr>
                <ul class="el-license-info">
	                <li>
	                    <div>
	                        <span class="el-license-info-title"><?php _e( "Status", "foodbook" );?></span>

	                        <?php if ( $this->responseObj->is_valid ) : ?>
	                            <span class="el-license-valid"><?php _e( "Valid", "foodbook" );?></span>
	                        <?php else : ?>
	                            <span class="el-license-valid"><?php _e( "Invalid", "foodbook" );?></span>
	                        <?php endif; ?>
	                    </div>
	                </li>
	                <li>
	                    <div>
	                        <span class="el-license-info-title"><?php _e( "License Type", "foodbook" );?></span>
	                        <?php echo $this->responseObj->license_title; ?>
	                    </div>
	                </li>
	                <li>
	                   <div>
	                       <span class="el-license-info-title"><?php _e( "License Expired on", "foodbook" );?></span>
	                        <?php 
						   		echo $this->responseObj->expire_date;
	                       		if( !empty( $this->responseObj->expire_renew_link ) ){
	                        ?>
	                           <a target="_blank" class="el-blue-btn" href="<?php echo $this->responseObj->expire_renew_link; ?>"><?php echo esc_html__( 'Renew', 'foodbook' );?></a>
	                        <?php
	                       		}
	                        ?>
	                   </div>
	                </li>
	                <li>
	                   <div>
	                       <span class="el-license-info-title"><?php _e( "Support Expired on", "foodbook" );?></span>
	                        <?php
	                            echo $this->responseObj->support_end;
	                        	if(!empty($this->responseObj->support_renew_link)){
	                        ?>
	                            <a target="_blank" class="el-blue-btn" href="<?php echo $this->responseObj->support_renew_link; ?>"><?php echo esc_html__( 'Renew', 'foodbook' );?></a>
	                        <?php
	                        	}
	                        ?>
	                   </div>
	                </li>
	                <li>
	                    <div>
	                        <span class="el-license-info-title"><?php _e( "Your License Key", "foodbook" );?></span>
	                        <span class="el-license-key"><?php echo esc_attr( substr( $this->responseObj->license_key,0,9 )."XXXXXXXX-XXXXXXXX".substr( $this->responseObj->license_key,-9 ) ); ?></span>
	                    </div>
	                </li>
                </ul>
                <div class="el-license-active-btn">
                    <?php wp_nonce_field( 'el-license' ); ?>
                    <?php submit_button( 'Deactivate' ); ?>
                </div>
            </div>
        </form>
    <?php
    }
	
	// License Form
	function LicenseForm() {
    ?>
    <form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
        <input type="hidden" name="action" value="foodbook_plugin_el_activate_license"/>
        <div class="el-license-container">
            <h3 class="el-license-title"><i class="dashicons-before dashicons-star-filled"></i> <?php _e("Foodbook Licensing","foodbook");?></h3>
            <hr>
            <?php
            	if( !empty( $this->showMessage ) && !empty( $this->licenseMessage ) ){
            ?>
                <div class="notice notice-error is-dismissible">
                    <p><?php echo _e( $this->licenseMessage, "foodbook" ); ?></p>
                </div>
            <?php
            	}
            ?>
            <p><?php _e("Enter your license key here, to activate the product, and get full feature updates and premium support.", "foodbook" );?></p>
            <div class="license-wrapper">
                <div class="single-license-wrapper">
                    <h3><?php _e( "Regular License", "foodbook" );?></h3>
                    <ol>
                        <li><?php echo esc_html__('Login To Your ',"foodbook").'<a href="'.esc_url( 'https://account.envato.com/' ).'">'.esc_html__('Envato Account','foodbook').'</a>'; ?></li>
                        <li><?php echo esc_html__('Download your License certificate & purchase code (text) from here ','foodbook').'<a target="_blank" href="'.esc_url( 'https://themeforest.net/downloads' ).'">'.esc_html__( 'themeforest.net/downloads', 'foodbook' ).'</a>'; ?>
                        <?php echo esc_html__('(Check out the ',"foodbook").'<a target="_blank" href="'.esc_url( 'http://prntscr.com/gja0gk' ).'">'.esc_html__( 'Screenshot', 'foodbook' ).'</a>'; ?></li>
                        <li><?php _e( "Get Your License Key", "foodbook" );?></li>
                    </ol>
                </div>
                <div class="membership-license-wrapper">
                    <h3><?php _e( "Extended License", "foodbook" );?></h3>
                    <ol>
                        <li><?php echo esc_html__( 'Login To Your ', "foodbook" ).'<a href="'.esc_url( 'https://account.envato.com/' ).'">'.esc_html__( 'Envato Account', 'foodbook' ).'</a>'; ?></li>
                        <li><?php echo esc_html__( 'Download your License certificate & purchase code (text) from here ','foodbook').'<a target="_blank" href="'.esc_url( 'https://themeforest.net/downloads' ).'">'.esc_html__( 'themeforest.net/downloads', 'foodbook' ).'</a>'; ?>
                        <?php echo esc_html__( '(Check out the ', "foodbook" ).'<a target="_blank" href="'.esc_url( 'http://prntscr.com/gja0gk' ).'">'.esc_html__( 'Screenshot', 'foodbook' ).'</a>'; ?></li>
                        <li><?php _e( "Get Your License Key", "foodbook" );?></li>
                    </ol>
                </div>
            </div>
            <hr/>
            <div class="el-license-field">
                <label for="el_license_key"><?php _e( "License code", "foodbook" );?></label>
                <input type="text" class="regular-text code" name="el_license_key" size="50" placeholder="<?php echo esc_attr__( 'xxxxxxxx-xxxxxxxx-xxxxxxxx-xxxxxxxx', 'foodbook' );?>" required="required">
            </div>
            <div class="el-license-field">
                <label for="el_license_key"><?php _e( "Email Address", "foodbook" );?></label>
                <?php
                    $purchaseEmail = get_option( "foodbook_plugin_lic_email", get_bloginfo( 'admin_email' ) );
                ?>
                <input type="text" class="regular-text code" name="el_license_email" size="50" value="<?php echo $purchaseEmail; ?>" placeholder="" required="required">
                <div><small><?php _e( "We will send update news of this product by this email address, don't worry, we hate spam", "foodbook" );?></small></div>
            </div>
            <div class="el-license-active-btn">
                <?php wp_nonce_field( 'el-license' ); ?>
                <?php submit_button( 'Activate' ); ?>
            </div>
        </div>
    </form>
        <?php
    }
	
}

// Init FoodBook class
FoodBook::getInstance();
