<?php
namespace FoodBook\Admin;
 /**
  * 
  * @package    FoodBook 
  * @since      3.0.0
  * @version    3.0.0
  * @author     ThemeLooks
  * @Websites:  http://themelooks.com/
  *
  */


class Textedit_Settings_Tab extends Settings_Fields_Base {

  public function get_option_name() {
    return 'foodbook_options'; // set option name it will be same or different name
  }

   public function tab_setting_fields() {

        $this->start_fields_section([
            'title'   => esc_html__( 'Text Edit', 'foodbook' ),
            'icon'    => 'fa fa-edit',
            'id'      => 'textedit'
        ]);

        $this->text(
          [
            'title'       => esc_html__( 'Start Order Button Text', 'foodbook' ),
            'placeholder' => 'Start Order',
            'name'        => 'start-order-btn-text',
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'Order Now Button Text', 'foodbook' ),
            'placeholder' => 'Order Now',
            'name'        => 'order-btn-text',
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'Buy More Button Text', 'foodbook' ),
            'placeholder' => 'Buy More',
            'name'        => 'buy-more-btn-text',
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'Availability Check Button Text', 'foodbook' ),
            'placeholder' => 'Availability Check',
            'name'        => 'availability-check-btn-text',
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'Restaurant Location Text', 'foodbook' ),
            'placeholder' => 'Restaurant Location',
            'name'        => 'rest-locat-text',
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'Delivery Availability Checker Text', 'foodbook' ),
            'placeholder' => 'Delivery Availability Checker',
            'name'        => 'delivery-availability-checker-text',
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'All items Text', 'foodbook' ),
            'placeholder' => 'All items',
            'name'        => 'all-items-text',
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'Categories Text', 'foodbook' ),
            'placeholder' => 'Categories',
            'name'        => 'categories-text',
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'Special Offer Text', 'foodbook' ),
            'placeholder' => 'Special Offer',
            'name'        => 'special-offer-text',
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'Special Instructions? Text ( Product Modal )', 'foodbook' ),
            'placeholder' => 'Special Instructions?',
            'name'        => 'special-instructions-text',
          ]
        );


        $this->end_fields_section(); // End fields section
   }
}

new Textedit_Settings_Tab();