<?php
namespace FoodBook\Admin;
 /**
  * 
  * @package    FoodBook 
  * @since      3.0.0
  * @version    3.0.0
  * @author     ThemeLooks
  * @Websites:  http://themelooks.com/
  *
  */


class StatusText_Settings_Tab extends Settings_Fields_Base {

  public function get_option_name() {
    return 'foodbook_options'; // set option name it will be same or different name
  }

   public function tab_setting_fields() {

        $this->start_fields_section([
            'title'   => esc_html__( 'Status Text Settings', 'foodbook' ),
            'icon'    => 'fa fa-pen',
            'id'      => 'statustext'
        ]);
        $this->text(
          [
            'title' => esc_html__( 'Order Cancel Text', 'foodbook' ),
            'name'  => 'order-cancel-text',
            'placeholder' => esc_html__( 'Order Cancel', 'foodbook' )
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Order Failed Text', 'foodbook' ),
            'name'  => 'order-failed-text',
            'placeholder' => esc_html__( 'Order Failed', 'foodbook' )
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'New Order Text', 'foodbook' ),
            'name'  => 'new-order-text',
            'placeholder' => esc_html__( 'New Order', 'foodbook' )
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Send To Cooking Text', 'foodbook' ),
            'name'  => 'send-to-cooking-text',
            'placeholder' => esc_html__( 'Send To Cooking', 'foodbook' )
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Cooking Processing Text', 'foodbook' ),
            'name'  => 'cooking-processing-text',
            'placeholder' => esc_html__( 'Cooking Processing', 'foodbook' )
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Cooking Completed Text', 'foodbook' ),
            'name'  => 'cooking-completed-text',
            'placeholder' => esc_html__( 'Cooking Completed', 'foodbook' )
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Waiting For Kitchen Accept Text', 'foodbook' ),
            'name'  => 'waiting-for-kitchen-accept-text',
            'placeholder' => esc_html__( 'Waiting For Kitchen Accept', 'foodbook' )
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'On The Way Text', 'foodbook' ),
            'name'  => 'on-the-way-text',
            'placeholder' => esc_html__( 'On The Way', 'foodbook' )
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Ready To Delivery Text', 'foodbook' ),
            'name'  => 'ready-to-delivery-text',
            'placeholder' => esc_html__( 'Ready To Delivery', 'foodbook' )
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Delivery Completed Text', 'foodbook' ),
            'name'  => 'delivery-completed-text',
            'placeholder' => esc_html__( 'Delivery Completed', 'foodbook' )
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Order Placed Text', 'foodbook' ),
            'name'  => 'order-placed-text',
            'placeholder' => esc_html__( 'Order Placed', 'foodbook' )
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Accepted Cooking Text', 'foodbook' ),
            'name'  => 'accepted-cooking-text',
            'placeholder' => esc_html__( 'Accepted Cooking', 'foodbook' )
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Processing Text', 'foodbook' ),
            'name'  => 'processing-text',
            'placeholder' => esc_html__( 'Processing', 'foodbook' )
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'On The Way To Delivery Text', 'foodbook' ),
            'name'  => 'way-to-delivery-text',
            'placeholder' => esc_html__( 'On The Way To Delivery', 'foodbook' )
          ]
        );
        
        $this->end_fields_section(); // End fields section
   }
}

new StatusText_Settings_Tab();