<?php
namespace FoodBook\Admin;
 /**
  * 
  * @package    FoodBook 
  * @since      3.0.0
  * @version    3.0.0
  * @author     ThemeLooks
  * @Websites:  http://themelooks.com/
  *
  */

class Shortcodelist_Settings_Tab extends Settings_Fields_Base {

  public function get_option_name() {
    return 'foodbook_options'; // set option name it will be same or different name
  }

   public function tab_setting_fields() {

        $this->start_fields_section([
            'title'   => esc_html__( 'Shortcode List', 'foodbook' ),
            'icon'    => 'fa fa-code',
            'id'      => 'shortcodelist'
        ]);
        ?>
        <h3><?php esc_html_e( 'Shortcode List', 'foodbook' ); ?></h3>
              <div class="shortcode-item-list">
                <h4><?php esc_html_e( 'Product Page Shortcode:', 'foodbook' ); ?></h4>

                <code>[foodbook_products]</code>
                <code>[foodbook_products col="4" cat="accessories" layout="grid" sidebar="yes" search="yes" padding_top="120px" padding_bottom="120px"]</code>
                <h5><?php esc_html_e( 'Attrubute List', 'foodbook' ); ?></h5>
                <ul>
                  <li><pre><?php esc_html_e( 'cat - cat="category name"', 'foodbook' ); ?> </pre></li>
                  <li><pre><?php esc_html_e( 'col - col="column" like ( 2, 3, 4 )', 'foodbook' ); ?> </pre></li>
                  <li><pre><?php esc_html_e( 'layout - layout="layout" like grid or list', 'foodbook' ); ?> </pre></li>
                  <li><pre><?php esc_html_e( 'sidebar - sidebar="yes" like yes or no', 'foodbook' ); ?> </pre></li>
                  <li><pre><?php esc_html_e( 'search - search="yes" like yes or no', 'foodbook' ); ?> </pre></li>
                  <li><pre><?php esc_html_e( 'Wrapper Padding Top - padding_top="120px" ', 'foodbook' ); ?> </pre></li>
                  <li><pre><?php esc_html_e( 'Wrapper Padding Bottom - padding_bottom="120px" ', 'foodbook' ); ?> </pre></li>
                </ul>
              </div>
              <div class="shortcode-item-list">
                <h4><?php esc_html_e( 'Delivery ability checker form:', 'foodbook' ); ?></h4>
                <code>[foodbook_delivery_ability_checker]</code>
                <code>[foodbook_delivery_ability_checker button_text="search"]</code>
                <h5><?php esc_html_e( 'Attrubute List', 'foodbook' ); ?></h5>
                <ul>
                  <li><pre><?php esc_html_e( 'button_text - button_text="search"', 'foodbook' ); ?> </pre></li>
                </ul>
              </div>

              <div class="foodbook-shortcode-generator-wrapper">
                  <h2><?php esc_html_e( 'Shortcode Generator', 'foodbook' ); ?></h2>
                  <div class="foodbook-shortcode-generator-inner">
                      <select id="shortcodeType">
                          <option value=""><?php esc_html_e( 'Shortcode For ?', 'foodbook' ); ?></option>
                          <option value="foodbook_products"><?php esc_html_e( 'Products with page component', 'foodbook' ); ?></option>
                          <option value="fb_only_product"><?php esc_html_e( 'Products without page component', 'foodbook' ); ?></option>
                          <option value="foodbook_delivery_ability_checker"><?php esc_html_e( 'Delivery ability checker form', 'foodbook' ); ?></option>
                      </select>
                      <p class="shortcode-note"><?php esc_html_e( 'You could not use this shortcode multiple time in same page.', 'foodbook' ); ?></p>
                      <select id="column" class="single-field shortcode-attr-single-field produt-attr-field">
                          <option value=""><?php esc_html_e( 'Select Column', 'foodbook' ); ?></option>
                          <option value="12"><?php esc_html_e( '1 Column', 'foodbook' ); ?></option>
                          <option value="6"><?php esc_html_e( '2 Column', 'foodbook' ); ?></option>
                          <option value="4"><?php esc_html_e( '3 Column', 'foodbook' ); ?></option>
                          <option value="3"><?php esc_html_e( '4 Column', 'foodbook' ); ?></option>
                      </select>
                      <select id="layout" class="single-field shortcode-attr-single-field produt-attr-field">
                          <option value=""><?php esc_html_e( 'Select layout type', 'foodbook' ); ?></option>
                          <option value="grid"><?php esc_html_e( 'Grid', 'foodbook' ); ?></option>
                          <option value="list"><?php esc_html_e( 'List', 'foodbook' ); ?></option>
                      </select>
                      <input type="number" id="limit" class="single-field shortcode-attr-single-field produt-attr-field" placeholder="<?php esc_html_e( 'Limit', 'foodbook' ); ?>" />
                      <select id="sidebar" class="single-field shortcode-attr-single-field produt-attr-field">
                          <option value=""><?php esc_html_e( 'Show sidebar?', 'foodbook' ); ?></option>
                          <option value="yes"><?php esc_html_e( 'Yes', 'foodbook' ); ?></option>
                          <option value="no"><?php esc_html_e( 'No', 'foodbook' ); ?></option>
                      </select>
                      <select id="search" class="single-field shortcode-attr-single-field produt-attr-field">
                          <option value=""><?php esc_html_e( 'Product quick search bar?', 'foodbook' ); ?></option>
                          <option value="yes"><?php esc_html_e( 'Yes', 'foodbook' ); ?></option>
                          <option value="no"><?php esc_html_e( 'No', 'foodbook' ); ?></option>
                      </select>
                      <select id="categories" class="single-field shortcode-attr-single-field produt-attr-field" multiple>
                          <option value=""><?php esc_html_e( 'Select Categoty', 'foodbook' ); ?></option>
                          <?php 
                          $getTerms = foodbook_get_terms('product_cat');
                          if( !empty( $getTerms ) ) {
                            foreach ( $getTerms as $key => $value) {

                              echo '<option value="'.esc_html( $value->slug ).'">'.esc_html( $value->name ).'</option>';
                            }
                          }
                          ?>
                      </select>
                      <?php
                      do_action('foodbook_shortcode_branch_list');
                      ?>
                      <input type="number" id="padding_top" class="single-field shortcode-attr-single-field produt-attr-field" placeholder="<?php esc_html_e( 'Padding Top', 'foodbook' ); ?>" />

                      <input type="number" id="padding_bottom" class="single-field shortcode-attr-single-field produt-attr-field" placeholder="<?php esc_html_e( 'Padding Bottom', 'foodbook' ); ?>" />

                      <input type="text" id="search_text" class="single-field shortcode-attr-single-field ability-checker-attr-field" placeholder="<?php esc_html_e( 'Search....', 'foodbook' ); ?>" />

                      <div class="button-area">
                        <span id="scodegenerate" class="button button-primary"><?php esc_html_e( 'Generate', 'foodbook' ); ?></span>
                        <span id="scode-copy" class="button button-primary"><?php esc_html_e( 'Copy', 'foodbook' ); ?></span>
                      </div>

                  </div>
                  <div class="scode-show"></div>
              </div>
              
        <?php
        $this->end_fields_section(); // End fields section
   }
}

new Shortcodelist_Settings_Tab();