<?php
namespace FoodBook\Admin;
 /**
  * 
  * @package    FoodBook 
  * @since      3.0.0
  * @version    3.0.0
  * @author     ThemeLooks
  * @Websites:  http://themelooks.com/
  *
  */


class Page_Settings_Tab extends Settings_Fields_Base {

  public function get_option_name() {
    return 'foodbook_options'; // set option name it will be same or different name
  }

   public function tab_setting_fields() {

        $this->start_fields_section([
            'title'   => esc_html__( 'Page Settings', 'foodbook' ),
            'icon'    => 'fa fa-cog',
            'id'      => 'pagesettings'
        ]);
        $this->selectbox(
          [
          'title' => esc_html__( 'Select Foodbook Shop Page', 'foodbook' ),
          'name'  => 'shop-page',
          'options'   => foodbook_get_pages()
          ]
        );
        $this->selectbox(
          [
          'title' => esc_html__( 'Select Branch Manager Page', 'foodbook' ),
          'name'  => 'branch-manager',
          'options'   => foodbook_get_pages()
          ]
        );
        $this->selectbox(
          [
          'title' => esc_html__( 'Select Kitchen Manager Page', 'foodbook' ),
          'name'  => 'kitchen-manager',
          'options'   => foodbook_get_pages()
          ]
        );
        $this->selectbox(
          [
          'title' => esc_html__( 'Select Delivery Page', 'foodbook' ),
          'name'  => 'delivery',
          'options'   => foodbook_get_pages()
          ]
        );
        $this->selectbox(
          [
          'title' => esc_html__( 'Select Admin Page', 'foodbook' ),
          'name'  => 'admin',
          'options'   => foodbook_get_pages()
          ]
        );
        


        $this->end_fields_section(); // End fields section
   }
}

new Page_Settings_Tab();