<?php
namespace FoodBook\Admin;
 /**
  * 
  * @package    FoodBook 
  * @since      3.0.0
  * @version    3.0.0
  * @author     ThemeLooks
  * @Websites:  http://themelooks.com/
  *
  */


class OrderReceived_Settings_Tab extends Settings_Fields_Base {

  public function get_option_name() {
    return 'foodbook_options'; // set option name it will be same or different name
  }

   public function tab_setting_fields() {

        $this->start_fields_section([
            'title'   => esc_html__( 'Order Received Pgae Settings', 'foodbook' ),
            'icon'    => 'fa fa-pager',
            'id'      => 'orderReceived'
        ]);
        
        $this->media(
          [
            'title' => esc_html__( 'Page Top Image', 'foodbook' ),
            'name'  => 'received-page-img',
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Page Title', 'foodbook' ),
            'name'  => 'received-page-title',
          ]
        );
        $this->textarea(
          [
            'title' => esc_html__( 'Page Description', 'foodbook' ),
            'name'  => 'received-description'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Active Invitation Option', 'foodbook' ),
            'name'  => 'active-invitation'
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Invitation Header ( From ) Email', 'foodbook' ),
            'name'  => 'invitation-from-email',
          ]
        );
        $this->textarea(
          [
            'title' => esc_html__( 'Invitation Message Subject', 'foodbook' ),
            'name'  => 'invitation-subject'
          ]
        );
        $this->textarea(
          [
            'title' => esc_html__( 'Invitation Message', 'foodbook' ),
            'name'  => 'invitation-message'
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Twitter Share Link', 'foodbook' ),
            'name'  => 'twitter-share-link',
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Facebook Share Link', 'foodbook' ),
            'name'  => 'facebook-share-link',
          ]
        );


        $this->end_fields_section(); // End fields section
   }
}

new OrderReceived_Settings_Tab();