<?php
namespace FoodBook\Admin;
 /**
  * 
  * @package    FoodBook 
  * @since      3.0.0
  * @version    3.0.0
  * @author     ThemeLooks
  * @Websites:  http://themelooks.com/
  *
  */


class Location_Settings_Tab extends Settings_Fields_Base {

  public function get_option_name() {
    return 'foodbook_options'; // set option name it will be same or different name
  }

   public function tab_setting_fields() {

        $this->start_fields_section([
            'title'   => esc_html__( 'Location Settings', 'foodbook' ),
            'icon'    => 'fa fa-map',
            'id'      => 'locationSettings'
        ]);

        $this->checkbox(
          [
            'title' => esc_html__( 'Delivery Availability Checker Active', 'foodbook' ),
            'name'  => 'availability-checker-active'
          ]
        );
        $this->selectbox(
          [
            'title' => esc_html__( 'Delivery Availability Checker Active', 'foodbook' ),
            'name'  => 'location_type',
            'options'   => [
              'address' => esc_html__( 'Address', 'foodbook' ),
              'zip'     => esc_html__( 'Zip Code', 'foodbook' )
            ]
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Set Google API Key', 'foodbook' ),
            'name'  => 'google-api-key',
            'wrapperclass' => 'fb-address-conditional-field',
            'description' => '<a href="http://console.cloud.google.com/" target="_blank">'.esc_html__( 'Create google API ', 'foodbook' ).'</a>',
          ]
        );
        // Check multibranch
        if( !foodbook_is_multi_branch() ) {

          if( !get_option('foodbook_multideliveryfees_option') ) {
            $this->zipcode([
              'title' => esc_html__( 'Add Single Branch Shop Zip Code', 'foodbook' ),
              'name'  => 'delivery_zip',
              'add_btn_text' => esc_html__( 'Add Zip Code', 'foodbook' ),
              'wrap_class' => 'fb-zip-conditional-field'
            ]);
          }
          $this->locationSearch([
            'title' => esc_html__( 'Set Single Branch Shop Location', 'foodbook' ),
            'name'  => 'branch-location',
          ]);
          $this->number(
            [
              'title' => esc_html__( 'Set Distance Restrict (KM)', 'foodbook' ),
              'name'  => 'distance-restrict',
              'class' => 'fb-address-conditional-field'
            ]
          );

          // Get zipcode with fee field from multideliveryfee plugin
          do_action('foodbook_multideliveryfee_field_delivery_settings', $this );
        }

        $this->checkbox(
          [
            'title' => esc_html__( 'Location Modal Popup Active', 'foodbook' ),
            'name'  => 'location-popup-active'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Modal Location Checker Active', 'foodbook' ),
            'name'  => 'popup-location-active'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Modal Close Button Show', 'foodbook' ),
            'name'  => 'modal-close-btn-show'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Checkout Page Delivery Location Checker Active', 'foodbook' ),
            'name'  => 'checkout-location-active'
          ]
        );
        
        $this->multiple_select(
          [
            'title' => esc_html__( 'Set Delivery Availability Checker Modal Show Page', 'foodbook' ),
            'name'  => 'availability-checker-modal',
            'options'   => foodbook_get_pages()
          ]
        );

        $this->end_fields_section(); // End fields section
   }
}

new Location_Settings_Tab();