<?php
namespace FoodBook\Admin;
 /**
  * 
  * @package    FoodBook 
  * @since      3.0.0
  * @version    3.0.0
  * @author     ThemeLooks
  * @Websites:  http://themelooks.com/
  *
  */


class Kitchen_Settings_Tab extends Settings_Fields_Base {

  public function get_option_name() {
    return 'foodbook_options'; // set option name it will be same or different name
  }

   public function tab_setting_fields() {

        $this->start_fields_section([
            'title'   => esc_html__( 'Kitchen Options', 'foodbook' ),
            'icon'    => 'fa fa-tools',
            'id'      => 'kitchenopt'
        ]);
        
        if( foodbook_is_active_multi_branch() ){
          $this->checkbox([
            'title' => esc_html__( 'Branch Transfer Option', 'foodbook' ),
            'name'  => 'kitchen-branch-transfer'
          ]);
        }
        $this->checkbox([
          'title' => esc_html__( 'Deliver Boy Assign Option', 'foodbook' ),
          'name'  => 'kitchen-boy-assign'
        ]);
        $this->checkbox([
          'title' => esc_html__( 'All Order Show In Kitchen', 'foodbook' ),
          'name'  => 'kitchen-all-order'
        ]);

        $this->end_fields_section(); // End fields section
   }
}

new Kitchen_Settings_Tab();