<?php
namespace FoodBook\Admin;
 /**
  * 
  * @package    FoodBook 
  * @since      3.0.0
  * @version    3.0.0
  * @author     ThemeLooks
  * @Websites:  http://themelooks.com/
  *
  */


class Invoice_Settings_Tab extends Settings_Fields_Base {

  public function get_option_name() {
    return 'foodbook_options'; // set option name it will be same or different name
  }

   public function tab_setting_fields() {

        $this->start_fields_section([
            'title'   => esc_html__( 'Invoice Settings', 'foodbook' ),
            'icon'    => 'fas fa-file-invoice',
            'id'      => 'invoicesettings'
        ]);

        $this->selectbox(
          [
          'title' => esc_html__( 'Invoice Type', 'foodbook' ),
          'name'  => 'invoice_type',
          'options'   => [
            'normal' => esc_html__('Normal Printer', 'foodbook'),
            'thermal' => esc_html__('Thermal/Receipt Printer', 'foodbook'),
          ]
          ]
        );
        $this->media(
          [
            'title' => esc_html__( 'Logo Upload', 'foodbook' ),
            'name'  => 'invoice_logo',
          ]
        );
        $this->text(
          [
          'title' => esc_html__( 'Invoice header restaurant name', 'foodbook' ),
          'name'  => 'header_restaurant_name',
          ]
        );
        $this->text(
          [
          'title' => esc_html__( 'Invoice header restaurant Address', 'foodbook' ),
          'name'  => 'header_restaurant_address',
          ]
        );
        $this->text(
          [
          'title' => esc_html__( 'Invoice Footer Text', 'foodbook' ),
          'name'  => 'invoice_footer_text',
          ]
        );
        $this->number(
          [
          'title' => esc_html__( 'Thermal Invoice Width', 'foodbook' ),
          'name'  => 'thermal_invoice_width',
          'placeholder' => '270',
          'description' => esc_html__( 'Default width 270px based on 2inc thermal paper.', 'foodbook' )
          ]
        );


        $this->end_fields_section(); // End fields section
   }
}

new Invoice_Settings_Tab();