<?php
namespace FoodBook\Admin;
 /**
  * 
  * @package    FoodBook 
  * @since      3.0.0
  * @version    3.0.0
  * @author     ThemeLooks
  * @Websites:  http://themelooks.com/
  *
  */


class General_Settings_Tab extends Settings_Fields_Base {

  public function get_option_name() {
    return 'foodbook_options'; // set option name it will be same or different name
  }

   public function tab_setting_fields() {

        $this->start_fields_section([

            'title'   => esc_html__( 'General Settings', 'foodbook' ),
            'icon'    => 'fa fa-home',
            'class'   => 'active',
            'id'      => 'general',
            'display' => 'block'

        ]);

        $this->checkbox(
          [
            'title' => esc_html__( 'Search Section Show', 'foodbook' ),
            'name'  => 'search-section'
          ]
        );
        $this->selectbox(
          [
            'title' => esc_html__( 'Product Extra Add-ons From', 'foodbook' ),
            'name'  => 'product-extra-add-ons-from',
            'options'   => [
              'individual_product' => esc_html__( 'On Individual Product', 'foodbook' ), 
              'global_term'  => esc_html__( 'Global', 'foodbook' ),
            ]
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Add To Cart Button Show', 'foodbook' ),
            'name'  => 'show-cart-button'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Show Product Short Description In Products', 'foodbook' ),
            'name'  => 'show-item-short-desc'
          ]
        );
        $this->number(
          [
            'title' => esc_html__( 'Product Per Page', 'foodbook' ),
            'name'  => 'product-limit'
          ]
        );
        $this->selectbox(
          [
            'title' => esc_html__( 'Product Order By', 'foodbook' ),
            'name'  => 'product-order-by',
            'options'   => [
              'title menu_order' => esc_html__( 'Title Menu Order', 'foodbook' ), 
              'name'             => esc_html__( 'Name', 'foodbook' ),
              'ID'               => esc_html__( 'ID', 'foodbook' ),
              'type'             => esc_html__( 'Type', 'foodbook' ),
              'rand'             => esc_html__( 'Rand', 'foodbook' ),
              'date'             => esc_html__( 'Date', 'foodbook' ),
              'modified'         => esc_html__( 'Modified', 'foodbook' )
            ]
          ]
        );
        $this->selectbox(
          [
            'title' => esc_html__( 'Product Order (Shorting)', 'foodbook' ),
            'name'  => 'product-order',
            'options'   => [
              'DESC' => esc_html__( 'DESC', 'foodbook' ), 
              'ASC'  => esc_html__( 'ASC', 'foodbook' )
            ]
          ]
        );
        $this->selectbox(
          [
            'title' => esc_html__( 'Product Layout', 'foodbook' ),
            'name'  => 'product-layout',
            'options'   => [ 'grid' => esc_html__( 'Grid Column', 'foodbook' ), 'list' => esc_html__( 'List Column', 'foodbook' ) ]
          ]
        );
        $this->selectbox(
          [
            'title' => esc_html__( 'Product Column', 'foodbook' ),
            'name'  => 'product-column',
            'options'   => [ 
              '6' => esc_html__( '2 Column', 'foodbook' ), 
              '4' => esc_html__( '3 Column', 'foodbook' ), 
              '3' => esc_html__( '4 Column', 'foodbook' ) 
            ]
          ]
        );
        $this->number(
          [
            'title' => esc_html__( 'Manager Page Order Notification Delay Time ( default 6 second )', 'foodbook' ),
            'name'  => 'page-autoreload',
            'placeholder' => esc_attr__( '6', 'foodbook' )
          ]
        );
        $this->number(
          [
            'title' => esc_html__( 'Set List View Product Description Characters', 'foodbook' ),
            'name'  => 'desc-characters'
          ]
        );
        
        $this->media(
          [
            'title'       => esc_html__( 'Order Button Icon', 'foodbook' ),
            'name'        => 'order-btn-icon',
          ]
        );
        $this->media(
          [
            'title'       => esc_html__( 'Order Button Hover Icon', 'foodbook' ),
            'name'        => 'order-btn-hover-icon',
          ]
        );
        $this->media(
          [
            'title'       => esc_html__( 'Cart Button Icon', 'foodbook' ),
            'name'        => 'cart-btn-icon',
          ]
        );
        if( foodbook_is_active_multi_branch() ) {
          $this->selectbox(
            [
              'title' => esc_html__( 'Branch Type', 'foodbook' ),
              'name'  => 'brunch-type',
              'options'   => [ 
                'single' => esc_html__( 'Single Branch', 'foodbook' ), 
                'multi' => esc_html__( 'Multi Branch', 'foodbook' ) 
              ]
            ]
          );
        }
        $this->checkbox(
          [
            'title' => esc_html__( 'Notification Audio Loop', 'foodbook' ),
            'name'  => 'audio-loop'
          ]
        );
        $this->media(
          [
            'title'       => esc_html__( 'Upload Notification Audio MP3', 'foodbook' ),
            'name'        => 'notification-audio',
          ]
        );
        $this->end_fields_section(); // End fields section
   }
}

new General_Settings_Tab();