<?php
namespace FoodBook\Admin;
 /**
  * 
  * @package    FoodBook 
  * @since      3.0.0
  * @version    3.0.0
  * @author     ThemeLooks
  * @Websites:  http://themelooks.com/
  *
  */


class Email_Settings_Tab extends Settings_Fields_Base {

  public function get_option_name() {
    return 'foodbook_options'; // set option name it will be same or different name
  }

   public function tab_setting_fields() {

        $this->start_fields_section([
            'title'   => esc_html__( 'Email Settings', 'foodbook' ),
            'icon'    => 'fa fa-envelope',
            'id'      => 'emailsettings'
        ]);

        $this->checkbox(
          [
            'title' => esc_html__( 'Active Email Notification', 'foodbook' ),
            'name'  => 'active-e-notification'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Active Delivery Boy Assign Email Notification', 'foodbook' ),
            'name'  => 'active-order-assign-mail-notification'
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'Subject Text', 'foodbook' ),
            'name'        => 'subject-text',
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'Order Cancel Notification Text', 'foodbook' ),
            'name'        => 'on-cancel-text',
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'Send To Cooking Notification Text', 'foodbook' ),
            'name'        => 'on-stc-text',
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'Accept Cooking Notification Text', 'foodbook' ),
            'name'        => 'on-ac-text',
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'Cooking Complete Notification Text', 'foodbook' ),
            'name'        => 'on-cc-text',
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'On The Way Notification Text', 'foodbook' ),
            'name'        => 'on-owd-text',
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'Delivery Complete Notification Text', 'foodbook' ),
            'name'        => 'on-dc-text',
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'Email Template Header Text', 'foodbook' ),
            'name'        => 'et-header-text',
          ]
        );
        $this->text(
          [
            'title'       => esc_html__( 'Email Template Footer Text', 'foodbook' ),
            'name'        => 'et-footer-text',
          ]
        );
        $this->colorpicker(
          [
            'title'       => esc_html__( 'Email Template Header Background Color', 'foodbook' ),
            'name'        => 'et-bg-color',
          ]
        );

        $this->end_fields_section(); // End fields section
   }
}

new Email_Settings_Tab();