<?php
namespace FoodBook\Admin;
 /**
  * 
  * @package    FoodBook 
  * @since      3.0.0
  * @version    3.0.0
  * @author     ThemeLooks
  * @Websites:  http://themelooks.com/
  *
  */


class Delivertimebranch_Settings_Tab extends Settings_Fields_Base {

  public function get_option_name() {
    return 'foodbook_options'; // set option name it will be same or different name
  }

   public function tab_setting_fields() {

        $this->start_fields_section([
            'title'   => esc_html__( 'Delivery Settings', 'foodbook' ),
            'icon'    => 'fa fa-truck',
            'id'      => 'delivertimebranch'
        ]);

        $this->checkbox(
          [
            'title' => esc_html__( 'Checkout Page Delivery Option Show/Hide', 'foodbook' ),
            'name'  => 'checkout-delivery-option'
          ]
        );
        $this->selectbox(
          [
            'title'     => esc_html__( 'Set Delivery Options', 'foodbook' ),
            'name'      => 'delivery-options',
            'options'   => [
              'all'   => esc_html__( 'Delivery/Pickup Both', 'foodbook' ),
              'delivery' => esc_html__( 'Only Delivery', 'foodbook' ),
              'pickup'   => esc_html__( 'Only Pickup', 'foodbook' )
            ]
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Set Delivery Fee', 'foodbook' ),
            'name'  => 'delivery-fee'
          ]
        );
        $this->selectbox(
          [
            'title'     => esc_html__( 'Delivery Fee Tax Status', 'foodbook' ),
            'name'      => 'delivery_fee_tax_status',
            'options'   => [
              'none' => esc_html__( 'None', 'foodbook' ),
              'taxable'   => esc_html__( 'Taxable', 'foodbook' )
            ]
          ]
        );
        $this->number(
          [
            'title' => esc_html__( 'Minimum order amount', 'foodbook' ),
            'name'  => 'minimum-order-amount'
          ]
        );
        $this->number(
          [
            'title' => esc_html__( 'Free shipping require minimum order amount', 'foodbook' ),
            'name'  => 'free-shipping-amount'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Deliver/Pickup Time and Date Show/Hide', 'foodbook' ),
            'name'  => 'pickup-time-switch'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Off current date order', 'foodbook' ),
            'name'  => 'off-current-order'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Pre order active', 'foodbook' ),
            'name'  => 'pre-order-active'
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Deliver/Pickup Time Option Note', 'foodbook' ),
            'name'  => 'delivery-time-note'
          ]
        );
        // Check multibranch
        if( !foodbook_is_multi_branch() ) {
          $this->day_based_time(
            [
              'title' => esc_html__( 'Delivery Time and Day ', 'foodbook' ),
              'class' => 'delivery-time-day',
              'name'  => 'delivery-time-day'
            ]
          );
        }
        $this->selectbox(
          [
            'title'     => esc_html__( 'Delivery Time Format', 'foodbook' ),
            'name'      => 'delivery-time-format',
            'options'   => [
              '12'    => esc_html__( '12 Hour', 'foodbook' ), 
              '24'    => esc_html__( '24 Hour', 'foodbook' )
            ]
          ]
        );
        $this->selectbox(
          [
            'title'     => esc_html__( 'Delivery Time Slot', 'foodbook' ),
            'name'      => 'delivery-time-slot',
            'options'   => [
              '2,30'    => esc_html__( '30min', 'foodbook' ), 
              '1,60'    => esc_html__( '60min', 'foodbook' ),
              '2,120'   => esc_html__( '120min', 'foodbook' ),
              '3,180'   => esc_html__( '180min', 'foodbook' )
            ]
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Add ASAP Option In Time Slot', 'foodbook' ),
            'name'  => 'active-asap-timeslot'
          ]
        );
        $this->number(
          [
            'title' => esc_html__( 'Order Limit On Time Slot', 'foodbook' ),
            'name'  => 'order-limit-time-slot'
          ]
        );
        $this->number(
          [
            'title' => esc_html__( 'Pre Order Days Limit', 'foodbook' ),
            'name'  => 'date-days-limit'
          ]
        );
        $this->timezone_select(
          [
            'title'     => esc_html__( 'Set Time Zone', 'foodbook' ),
            'name'      => 'time-zone'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Order Delivery Directions Map Active', 'foodbook' ),
            'name'  => 'delivery-directions-map'
          ]
        );
        $this->selectbox(
          [
            'title'     => esc_html__( 'Delivery Directions Map Transport Mode', 'foodbook' ),
            'name'      => 'delivery-transport-mode',
            'options'   => [
              'driving'    => esc_html__( 'Driving', 'foodbook' ), 
              'walking'    => esc_html__( 'Walking', 'foodbook' ),
              'bicycling'  => esc_html__( 'Bicycling', 'foodbook' )
            ]
          ]
        );
        $this->text(
          [
            'title' => esc_html__( 'Closing Time Info Text', 'foodbook' ),
            'name'  => 'closing-time-msg'
          ]
        );

        $this->end_fields_section(); // End fields section
   }
}

new Delivertimebranch_Settings_Tab();