<?php
namespace FoodBook\Admin;
 /**
  * 
  * @package    FoodBook 
  * @since      3.0.0
  * @version    3.0.0
  * @author     ThemeLooks
  * @Websites:  http://themelooks.com/
  *
  */


class Checkout_Fields extends Settings_Fields_Base {

  public function get_option_name() {
    return 'foodbook_options'; // set option name it will be same or different name
  }

   public function tab_setting_fields() {

        $this->start_fields_section([
            'title'   => esc_html__( 'Checkout Fields Settings', 'foodbook' ),
            'icon'    => 'fa fa-edit',
            'id'      => 'checkoutfields'
        ]);
        
        // Billing details Fields
        $this->heading(
          [
          'title' => esc_html__( 'Billing Fields Controls', 'foodbook' ),
          'name'  => 'billing_opt_heading'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Billing First Name', 'foodbook' ),
            'name'  => 'billing_first_name'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Billing Last Name', 'foodbook' ),
            'name'  => 'billing_last_name'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Billing Company Name', 'foodbook' ),
            'name'  => 'billing_company'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Billing Country / Region', 'foodbook' ),
            'name'  => 'billing_country'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Billing Street Address', 'foodbook' ),
            'name'  => 'billing_address_1'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Billing Street Address 2', 'foodbook' ),
            'name'  => 'billing_address_2'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Billing Town / City', 'foodbook' ),
            'name'  => 'billing_city'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Billing District', 'foodbook' ),
            'name'  => 'billing_state'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Billing Postcode / ZIP', 'foodbook' ),
            'name'  => 'billing_postcode'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Billing Phone Number', 'foodbook' ),
            'name'  => 'billing_phone'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Billing Email', 'foodbook' ),
            'name'  => 'billing_email'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Order Notes', 'foodbook' ),
            'name'  => 'order_comments'
          ]
        );

        // Shipping details Fields
        $this->heading(
          [
          'title' => esc_html__( 'Shipping Fields Controls', 'foodbook' ),
          'name'  => 'shipping_opt_heading'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Shipping First Name', 'foodbook' ),
            'name'  => 'shipping_first_name'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Shipping Last Name', 'foodbook' ),
            'name'  => 'shipping_last_name'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Shipping Company Name', 'foodbook' ),
            'name'  => 'shipping_company'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Shipping Country / Region', 'foodbook' ),
            'name'  => 'shipping_country'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Shipping Street Address', 'foodbook' ),
            'name'  => 'shipping_address_1'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Shipping Street Address 2', 'foodbook' ),
            'name'  => 'shipping_address_2'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Shipping Town / City', 'foodbook' ),
            'name'  => 'shipping_city'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Shipping District', 'foodbook' ),
            'name'  => 'shipping_state'
          ]
        );
        $this->checkbox(
          [
            'title' => esc_html__( 'Hide Shipping Postcode / ZIP', 'foodbook' ),
            'name'  => 'shipping_postcode'
          ]
        );
        

        $this->end_fields_section(); // End fields section
   }
}

new Checkout_Fields();