<?php 
namespace FoodBook\Admin\Field;
 /**
  * 
  * @package    FoodBook 
  * @since      3.0.0
  * @version    3.0.0
  * @author     ThemeLooks
  * @Websites:  http://themelooks.com/
  *
  */

trait Number {

	protected static $args;

	public function number( $args ) {

		$default = [
			'title' => '',
			'name'	=> '',
			'description'	=> '',
			'class'			=> '',
			'placeholder'	=> '',
			'default'		=> '',
			'condition'		=> ''
		];

		self::$args = wp_parse_args( $args, $default );

		self::number_markup();
		
	}

	protected static function number_markup() {

		$optionName = self::$optionName;
	    $args = self::$args;
	    $getData = self::$getOptionData;
	    $fieldName  = $args['name'];
	    $value = !empty( $getData[$fieldName] ) ? $getData[$fieldName] : $args['default'];
	    $placeholder = !empty( $args['placeholder'] ) ? $args['placeholder'] : '';

	    $conditionData = '';
	    if( !empty( $args['condition'] ) ) {
	      $conditionData = json_encode( $args['condition'] );
	    }
		?>
		<div class="foodbook-admin-field <?php echo esc_attr( $args['class'] ); ?>" data-condition="<?php echo esc_html($conditionData); ?>">
			<h4><?php echo esc_html( $args['title'] ); ?></h4>
			<div class="fb-field-group">
				<div>
				<input type="number" name="<?php echo esc_attr( $optionName ).'['.$fieldName.']'; ?>" placeholder="<?php echo esc_attr( $placeholder );  ?>" value="<?php echo esc_attr( $value ); ?>" />
				<?php
				if( !empty( $args['description'] ) ) {
					echo '<p>'.esc_html( $args['description'] ).'</p>';
				}
				?>
				</div>
			</div>
		</div>
		<?php
	}
}
