<?php 
namespace FoodBook\Admin\Field;
 /**
  * 
  * @package    FoodBook 
  * @since      3.0.0
  * @version    3.0.0
  * @author     ThemeLooks
  * @Websites:  http://themelooks.com/
  *
  */
trait Heading {

	protected static $args;

	public function heading( $args ) {

		$default = [
			'title' => '',
			'name'	=> '',
			'description'	=> '',
			'placeholder'	=> '',
			'wrapperclass'	=> '',
			'class'			=> '',
			'condition'		=> ''
		];

		self::$args = wp_parse_args( $args, $default );
		self::heading_markup();
	}

	protected static function heading_markup() {

	    $args = self::$args;

	    $conditionData = '';
	    if( !empty( $args['condition'] ) ) {
	      $conditionData = json_encode( $args['condition'] );
	    }
		?>
		<div class="foodbook-admin-field <?php echo esc_attr( $args['wrapperclass'] ); ?>" data-condition="<?php echo esc_html($conditionData); ?>">
			<h4 style="font-size: 20px;color: #FB9426;"><?php echo esc_html( $args['title'] ); ?></h4>
		</div>
		<?php
	}
}
