<?php
namespace FoodBook\Admin;
 /**
  * 
  * @package    FoodBook 
  * @since      3.0.0
  * @version    3.0.0
  * @author     ThemeLooks
  * @Websites:  http://themelooks.com/
  *
  */
 
abstract class Settings_Fields_Base {

  public static  $optionName;

  public static $getOptionData;

  use \FoodBook\Admin\Field\Checkbox;
  use \FoodBook\Admin\Field\Colorpicker;
  use \FoodBook\Admin\Field\MediaUpload;
  use \FoodBook\Admin\Field\Timepicker;
  use \FoodBook\Admin\Field\Textarea;
  use \FoodBook\Admin\Field\Text;
  use \FoodBook\Admin\Field\Selectbox;
  use \FoodBook\Admin\Field\Number;
  use \FoodBook\Admin\Field\TimezoneSelect;
  use \FoodBook\Admin\Field\Zipcode;
  use \FoodBook\Admin\Field\LocationSearch;
  use \FoodBook\Admin\Field\MultipleSelect;
  use \FoodBook\Admin\Field\Day_Based_Time;
  use \FoodBook\Admin\Field\kmFeeRepeater;
  use \FoodBook\Admin\Field\ZipcodeMultiInput;
  use \FoodBook\Admin\Field\Heading;
  
  public function __construct() {

    self::$optionName = $this->get_option_name();
    self::$getOptionData = get_option(self::$optionName);

    $this->tab_setting_fields();

  }

  public function get_option_name() {}
  public function tab_setting_fields() {}

  public function start_fields_section( $args ) {

    $default = [
      'title'     => esc_html__( 'Title goes here', 'foodbook' ),
      'class'     => '',
      'icon'      => '',
      'id'        => '',
      'display'   => 'none',
    ];

    $args = wp_parse_args( $args, $default );

    ?>
    <div id="<?php echo esc_attr( $args['id'] ); ?>" data-tab="<?php echo esc_attr( $args['id'] ); ?>" class="<?php echo esc_attr( $args['class'] ); ?>" style="display: <?php echo esc_attr( $args['display'] ); ?>;">
      <div class="container">
        <div class="dashboard-content-wrap">
    <?php
    //
    if( !empty( $args['title'] ) ) {
      $icon = !empty( $args['icon'] ) ? '<i class="'.esc_attr( $args['icon'] ).'"></i>' : '';
      echo '<h2 class="tab-content-section-title">'.$icon.esc_html( $args['title'] ).'</h2>';
    }

  }

  public function end_fields_section() {
    echo '</div></div></div>';
  }

}