<?php
namespace FoodBook;

/**
 * foodbook admin class
 *
 * @package     Foodbook
 * @author      ThemeLooks
 * @copyright   2020 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

if( !class_exists('Admin_Menu') ) {
	class Admin_Menu {

		private static $getPermission;
		private static $instance = null;

		function __construct() {
			self::$getPermission = foodbookgetG();
			add_action( 'admin_menu', array( __CLASS__, 'admin_menu_page' ) );
			add_action( 'admin_init', array( __CLASS__, 'page_settings_init' ) );
		}

		public static function getInstance() {
			if( is_null( self::$instance ) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		public static function admin_menu_page() {

			if( !self::$getPermission ) {
				return;
			}

			// add top level menu page
			add_menu_page(
				esc_html__( 'Foodbook Settings', 'foodbook' ),
				esc_html__( 'Foodbook', 'foodbook' ),
				'manage_options',
				'foodbook',
				array( __CLASS__, 'admin_view' )
			);
			add_submenu_page( 'foodbook', esc_html__( 'Foodbook Settings', 'foodbook' ), esc_html__( 'Settings', 'foodbook' ),'manage_options', 'foodbook');
			do_action('foodbook_admin_menu');
			add_submenu_page(
		        'foodbook',
		        esc_html__( 'Order Manage', 'foodbook' ), //page title
		        esc_html__( 'Orders', 'foodbook' ), //menu title
		        'manage_options', //capability,
		        'foodbook-branch-order',//menu slug
		        array( __CLASS__, 'branch_order_submenu_page' ) //callback function
		    );
		}

		public static function admin_view() {
			$Admin_Templates = new Admin_Templates_Map();
			$Admin_Templates->admin_page_init();
		}
		public static function page_settings_init() {
			register_setting(
	            'foodbook_settings_option_group', // Option group
	            'foodbook_options' // Option name
	        );  
		}

		public static function branch_order_submenu_page() {
			// 
			$obj = new Admin_Sub_Menu_Templates();
			$obj->admin_branches_manage();
		}

	}

	Admin_Menu::getInstance();
}