<?php
////////////////////////////////////
// DYNAMICALLY CREATE THE CSS //////
////////////////////////////////////
include_once(FP_DIR . '/functions.php');


// base style for shortcode div
echo '
mark.fp_sc_mark {
	display: inline !important;
	margin: 0 !important;
	padding: 0 !important; 	
}
';


///////////////////////////////////////////////////
/////// CSS RULES /////////////////////////////////
///////////////////////////////////////////////////

$rules = get_option('fp'.FP_BID.'_rules', array());
if($rules) {
	foreach($rules as $rule) {	
		
		///////////////////////////////
		// retrocompatibility
		if(isset($rule['shadow_x'])) {
			$shadow_color = (!fp_rgb2hex($rule['shadow_color'])) ? '#555555' : fp_rgb2hex($rule['shadow_color']); 
			
			$rule['shadow'] = array(
				$rule['shadow_x'],
				$rule['shadow_y'],
				$rule['shadow_r'],
				90,
				$shadow_color,
			);	
			
			if(isset($rule['subj'])) {
				$rule['element_subj'] = $rule['subj'];
			}
			
			$rule['force_rule'] = 1;
		}
		////////////////////////////////////////
		
		$rule = wp_parse_args($rule, fp_default_vals());
		$force = (!empty($rule['force_rule'])) ? ' !important' : '';


		// font name 
		switch($rule['font_type']) {
			case 'fontface' 	: $font_name = '"'. fp_urlToName($rule['font_name']) .'"'; break;
			case 'ad_typekit' 	: $font_name = fp_typekit_css_name($rule['font_name']); break;	
			default 			: $font_name = '"'. $rule['font_name'] .'"'; break;
		}
	
	  echo '
	  '.$rule['element_subj'].' {';
			
		// font-family - FONTFACE, WEBFONTS AND STANDARD CSS FONT only
		if($rule['font_type'] != 'inherited' && $rule['font_type'] != 'cufon') {		
			echo '
			font-family: '.$font_name.$force.';';
		}
	
		// font size
		if(!empty($rule['font_size'])) {
			echo '
			font-size: '.$rule['font_size'].$rule['font_size_type'].$force.';';	
		}
		
		// line height
		if(!empty($rule['line_height'])) {
			echo '
			line-height: '.$rule['line_height'].$rule['line_height_type'].$force.';';	
		}
		
		// font-weight
		if($rule['font_weight'] != 'inherit') {
			echo '
			font-weight: '.$rule['font_weight'].$force.';';	
		}
		
		// font-style
		if($rule['font_style'] != 'inherit') {
			echo '
			font-style: '.$rule['font_style'].$force.';';	
		}
		
		// text-decoration
		if($rule['text_decoration'] != 'inherit') {
			echo '
			text-decoration: '.$rule['text_decoration'].$force.';';	
		}
		
		// text-decoration
		if($rule['text_transform'] != 'inherit') {
			echo '
			text-transform: '.$rule['text_transform'].$force.';';	
		}
		
		// color
		if($rule['text_color'] != 'none') {
			echo '
			color: '.$rule['text_color'].$force.';';	
		}
		
		// highlight
		if($rule['highlight'] != 'none') {
			echo '
			background: '.$rule['highlight'].$force.';
			border-color: '.$rule['highlight'].$force.';
			border-style: solid'.$force.';
			border-width: 3px 8px'.$force.'';
		}
		
		// unselectable
		if(!empty($rule['unselectable'])) {
			echo '
			-webkit-user-select: none'.$force.';
			-moz-user-select: none'.$force.';
			-ms-user-select: none'.$force.';
			user-select: none'.$force.';';	
		}
		

		// text shadow and/or stroke
		if(!empty($rule['shadow'][0]) || !empty($rule['shadow'][1]) || !empty($rule['shadow'][2]) || !empty($rule['text_stroke_w'])) {
			$shadow = '';
			
			if(!empty($rule['text_stroke_w'])) {
				$data = array($rule['text_stroke_w'], $rule['text_stroke_col']);
				$shadow = '-'.$data[0].'px -'.$data[0].'px 0 '.$data[1].',  '.$data[0].'px -'.$data[0].'px 0 '.$data[1].', -'.$data[0].'px '.$data[0].'px 0 '.$data[1].', '.$data[0].'px '.$data[0].'px 0 '.$data[1];	
			}
			
			if(!empty($rule['shadow'][0]) || !empty($rule['shadow'][1]) || !empty($rule['shadow'][2])) {
				if(!empty($shadow)) {$shadow .= ', ';}
				$shadow .= $rule['shadow'][0].'px '.$rule['shadow'][1].'px '.$rule['shadow'][2].'px '.fp_hex2rgb($rule['shadow'][4], $rule['shadow'][3]);	
			}

			echo '
			text-shadow: '.$shadow.$force.';';		
		}
	
	  echo '}';					
	}
}



/////////////////////////////////////
/// FONTFACE GLOBAL CLASSES /////////
/////////////////////////////////////

$enabled_list = get_option('fp'.FP_BID.'_font_enabled', array());

if(is_array($enabled_list)) {
	foreach($enabled_list as $enabled) {
		
		// enabled fontface declaration
		echo fp_fontface_css_creator($enabled);
		
		// global class style
		echo '
		.fp_ff_'.$enabled.', .fp_ff_'.$enabled.' * {
			font-family: "'.fp_urlToName($enabled).'";
		}';	
	}
}


/////////////////////////////////////
/// WEB FONTS GLOBAL CLASSES ////////
/////////////////////////////////////

$enabled_list = get_option('fp'.FP_BID.'_webfonts_enabled', array());

if(is_array($enabled_list)) {
	foreach($enabled_list as $enabled) {
		$enabled_id = fp_stringToUrl($enabled);
		
		// global class style
		echo '
		.fp_wf_'.$enabled_id.', .fp_wf_'.$enabled_id.' * {
			font-family: "'.$enabled.'";
		}';	
	} 
}


/////////////////////////////////////
/// ADOBE TYPEKIT GLOBAL CLASSES ////
/////////////////////////////////////

$kits_list = (array)unserialize(get_option('fp_adobe_typekits', ''));
$enabled_kits = get_option('fp'.FP_BID.'_ad_typekits_enabled', array());

if($kits_list && $enabled_kits) {
	foreach($kits_list as $id => $data) {
		if(!in_array($id, $enabled_kits)) {continue;}
		
		foreach($data as $slug => $subdata) {
			// global class style
			echo '
			.fp_at_'. fp_stringToUrl($slug) .', .fp_at_'. fp_stringToUrl($slug) .' * {
				font-family: '.fp_typekit_css_name($slug) .';
			}';	
		}
	}
}



/////////////////////////////////////
/////// CUSTOM CSS //////////////////
/////////////////////////////////////

echo get_option('fp_custom_css', '');

