<?php

/**
 * XT Woo Floating Cart
 *
 * @package     XT_Woo_Floating_Cart
 * @author      XplodedThemes
 * @copyright   2018 XplodedThemes
 * @license     GPL-2.0+
 *
 * @wordpress-plugin
 * Plugin Name: XT Woo Floating Cart Pro
 * Plugin URI:  https://xplodedthemes.com/products/woo-floating-cart/
 * Description: An Interactive Floating Cart for WooCommerce that slides in when the user decides to buy an item. Fully customizable right from WordPress Customizer with Live Preview. Products, quantities and prices are updated instantly via Ajax.
 * Version:     1.2.3
 * Author:      پرشین اسکریپت
 * Author URI:  https://www.persianscript.ir
 * Text Domain: woo-floating-cart
 * Domain Path: /languages
 * License:     GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 *
 * @fs_premium_only /includes/freemius-migration
 */
// If this file is called directly, abort.
if ( !defined( 'WPINC' ) ) {
    die;
}
global  $xt_woofc_plugin ;
$market = '##XT_MARKET##';
$market = ( strpos( $market, 'XT_MARKET' ) !== false ? 'freemius' : $market );
$xt_woofc_plugin = (object) array(
    'version'       => '1.2.3',
    'name'          => 'XT Woo Floating Cart',
    'menu_name'     => 'Woo Floating Cart',
    'icon'          => 'dashicons-cart',
    'slug'          => 'xt-woo-floating-cart',
    'premium_slug'  => 'xt-woo-floating-cart',
    'freemium_slug' => 'woo-floating-cart-lite',
    'freemius_id'   => '2907',
    'market'        => $market,
    'file'          => __FILE__,
);

if ( function_exists( 'xt_woofc_fs' ) ) {
    xt_woofc_fs()->set_basename( true, __FILE__ );
    return;
} else {
    // Create a helper function for easy SDK access.
    
    if ( $xt_woofc_plugin->market !== 'freemius' ) {
        function xt_woofc_fs()
        {
            global  $xt_woofc_license, $xt_woofc_plugin ;
            
            if ( !isset( $xt_woofc_license ) ) {
                // Include License Checker
                require_once plugin_dir_path( __FILE__ ) . 'includes/license/start.php';
                $xt_woofc_license = xt_woofc_license_init( __FILE__, $xt_woofc_plugin->premium_slug, $xt_woofc_plugin->market );
            }
            
            return $xt_woofc_license;
        }
        
        xt_woofc_fs();
        // Signal that the License SDK was initiated.
        do_action( 'xt_woofc_license_loaded' );
    } else {
        function xt_woofc_fs()
        {
            global  $xt_woofc_fs, $xt_woofc_plugin ;
            
            if ( !isset( $xt_woofc_fs ) ) {
                // Activate multisite network integration.
                if ( !defined( 'WP_FS__PRODUCT_' . $xt_woofc_plugin->freemius_id . '_MULTISITE' ) ) {
                    define( 'WP_FS__PRODUCT_' . $xt_woofc_plugin->freemius_id . '_MULTISITE', true );
                }
                // Include Freemius SDK.
                require_once plugin_dir_path( __FILE__ ) . 'includes/freemius/start.php';
                $xt_woofc_fs = fs_dynamic_init( array(
                    'id'              => $xt_woofc_plugin->freemius_id,
                    'slug'            => $xt_woofc_plugin->freemium_slug,
                    'premium_slug'    => $xt_woofc_plugin->premium_slug,
                    'type'            => 'plugin',
                    'public_key'      => 'pk_befd5797ccb0ea582377dfd79ce5b',
                    'is_premium'      => true,
                    'premium_suffix'  => 'Pro',
                    'has_addons'      => false,
                    'has_paid_plans'  => true,
                    'has_affiliation' => 'all',
                    'trial'           => array(
                    'days'               => 14,
                    'is_require_payment' => true,
                ),
                    'menu'            => array(
                    'slug'    => $xt_woofc_plugin->slug,
                    'contact' => false,
                    'support' => false,
                ),
                    'is_live'         => true,
                ) );
            }
            
            return $xt_woofc_fs;
        }
        
        // Init Freemius.
        xt_woofc_fs();
        // Signal that SDK was initiated.
        do_action( 'xt_woofc_fs_loaded' );
        // Enqueue Custom Freemius SDK assets
        function xt_woofc_fs_assets()
        {
            global  $xt_woofc_plugin ;
            wp_enqueue_style(
                'xt-freemius-sdk',
                'https://s3.amazonaws.com/xt-freemius/sdk.css',
                array(),
                $xt_woofc_plugin->version,
                'all'
            );
            wp_enqueue_script(
                'xt-freemius-sdk',
                'https://s3.amazonaws.com/xt-freemius/sdk.min.js',
                array(),
                $xt_woofc_plugin->version,
                true
            );
        }
        
        add_action( 'admin_footer', 'xt_woofc_fs_assets' );
        if ( xt_woofc_fs()->is_premium() ) {
            // EDD to Freemius Migration
            require_once plugin_dir_path( __FILE__ ) . 'includes/freemius-migration/edd.php';
        }
    }
    
    // Load plugin if no other instances are loaded
    
    if ( !class_exists( 'XT_Woo_Floating_Cart' ) ) {
        /**
         * The code that runs during plugin activation.
         * This action is documented in includes/class-activator.php
         */
        function xt_woo_floating_cart_activate()
        {
            require_once plugin_dir_path( __FILE__ ) . 'includes/class-activator.php';
            XT_Woo_Floating_Cart_Activator::activate();
        }
        
        register_activation_hook( __FILE__, 'xt_woo_floating_cart_activate' );
        /**
         * The code that runs during plugin deactivation.
         * This action is documented in includes/class-deactivator.php
         */
        function xt_woo_floating_cart_deactivate()
        {
            require_once plugin_dir_path( __FILE__ ) . 'includes/class-deactivator.php';
            XT_Woo_Floating_Cart_Deactivator::deactivate();
        }
        
        register_deactivation_hook( __FILE__, 'xt_woo_floating_cart_deactivate' );
        /**
         * The code that runs after plugin uninstall.
         * This action is documented in includes/class-uninstall.php
         */
        function xt_woo_floating_cart_uninstall()
        {
            require_once plugin_dir_path( __FILE__ ) . 'includes/class-uninstaller.php';
            XT_Woo_Floating_Cart_Uninstaller::uninstall();
        }
        
        xt_woofc_fs()->add_action( 'after_uninstall', 'xt_woo_floating_cart_uninstall' );
        /**
         * Global functions used to access multiple class public methods.
         */
        require plugin_dir_path( __FILE__ ) . 'includes/global-functions.php';
        /**
         * The core plugin class that is used to define internationalization,
         * admin-specific hooks, and public-facing site hooks.
         */
        require plugin_dir_path( __FILE__ ) . 'includes/class-core.php';
        /**
         * Begins execution of the plugin.
         *
         * Since everything within the plugin is registered via hooks,
         * then kicking off the plugin from this point in the file does
         * not affect the page life cycle.
         *
         * @since    1.0.0
         */
        function xt_woo_floating_cart()
        {
            global  $xt_woofc_plugin ;
            return XT_Woo_Floating_Cart::instance( $xt_woofc_plugin );
        }
        
        xt_woo_floating_cart();
    }

}
