(function($, window) {

	// jQuery on an empty object, we are going to use this as our Queue
	var xt_woofcAjaxQueue = $({});
	
	$.xt_woofcAjaxQueue = function( ajaxOpts ) {
	    var jqXHR,
	        dfd = $.Deferred(),
	        promise = dfd.promise();
	
	    // run the actual query
	    function doRequest( next ) {
	        jqXHR = $.ajax( ajaxOpts );
	        jqXHR.done( dfd.resolve )
	            .fail( dfd.reject )
	            .then( next, next );
	    }
	
	    // queue our ajax request
	    xt_woofcAjaxQueue.queue( doRequest );
	
	    // add the abort method
	    promise.abort = function( statusText ) {
	
	        // proxy abort to the jqXHR if it is active
	        if ( jqXHR ) {
	            return jqXHR.abort( statusText );
	        }
	
	        // if there wasn't already a jqXHR we need to remove from queue
	        var queue = xt_woofcAjaxQueue.queue(),
	            index = $.inArray( doRequest, queue );
	
	        if ( index > -1 ) {
	            queue.splice( index, 1 );
	        }
	
	        // and then reject the deferred
	        dfd.rejectWith( ajaxOpts.context || ajaxOpts, [ promise, statusText, "" ] );
	        return promise;
	    };
	
	    return promise;
	};
	
	window.xt_woofcAjaxQueue = xt_woofcAjaxQueue;
	
})(jQuery, window);