<?php

if(self::$parent->fs()->can_use_premium_code__premium_only()) {

    Kirki::add_field( self::$config_id, array(
        'settings' => self::field_id('cart_checkout_button_bg_color'),
        'section'  => self::section_id('footer'),
        'label'    => esc_html__( 'Cart Checkout Button Bg Color', 'woo-floating-cart' ),
        'type'     => 'color-alpha',
        'priority' => 10,
        'default'  => '#2c97de',
        'transport'=>'auto',
        'output' => array(
            array(
                'element'  => '.xt_woofc-inner a.xt_woofc-checkout',
                'property' => 'background',
            )
        )
    ));
    Kirki::add_field( self::$config_id, array(
        'settings' => self::field_id('cart_checkout_button_bg_hover_color'),
        'section'  => self::section_id('footer'),
        'label'    => esc_html__( 'Cart Checkout Button Bg Hover Color', 'woo-floating-cart' ),
        'type'     => 'color-alpha',
        'priority' => 10,
        'default'  => '#2c97de',
        'transport'=>'auto',
        'output' => array(
            array(
                'element'  => array('.xt_woofc-no-touchevents .xt_woofc-inner a.xt_woofc-checkout:hover', '.xt_woofc-touchevents .xt_woofc-inner a.xt_woofc-checkout:focus'),
                'property' => 'background',
            )
        )
    ));

    Kirki::add_field( self::$config_id, array(
        'settings' => self::field_id('cart_checkout_button_text_color'),
        'section'  => self::section_id('footer'),
        'label'    => esc_html__( 'Cart Checkout Button Text Color', 'woo-floating-cart' ),
        'type'     => 'color-alpha',
        'priority' => 10,
        'default'  => '#ffffff',
        'transport'=>'auto',
        'output' => array(
            array(
                'element'  => '.xt_woofc-cart-open .xt_woofc-inner a.xt_woofc-checkout',
                'property' => 'color',
            )
        )
    ));
    Kirki::add_field( self::$config_id, array(
        'settings' => self::field_id('cart_checkout_button_text_hover_color'),
        'section'  => self::section_id('footer'),
        'label'    => esc_html__( 'Cart Checkout Button Text Hover Color', 'woo-floating-cart' ),
        'type'     => 'color-alpha',
        'priority' => 10,
        'default'  => '#ffffff',
        'transport'=>'auto',
        'output' => array(
            array(
                'element'  => array('.xt_woofc-no-touchevents .xt_woofc-cart-open .xt_woofc-inner a.xt_woofc-checkout:hover', '.xt_woofc-touchevents .xt_woofc-cart-open .xt_woofc-inner a.xt_woofc-checkout:focus'),
                'property' => 'color',
            )
        )
    ));

    Kirki::add_field( self::$config_id, array(
        'settings'    => self::field_id('cart_checkout_link'),
        'section'     => self::section_id('footer'),
        'label'       => esc_html__( 'Cart Checkout Action', 'woo-floating-cart' ),
        'type'        => 'radio-buttonset',
        'choices'     => array(
            'checkout'	  => esc_attr__( 'Go to Checkout Page', 'woo-floating-cart' ),
            'cart'  => esc_attr__( 'Go to Cart Page', 'woo-floating-cart' )
        ),
        'default'     => 'checkout',
        'priority'    => 10
    ));

}else{

    Kirki::add_field(self::$config_id, array(
        'settings' => self::field_id('footer_features'),
        'section'     => self::section_id('footer'),
        'type'  => 'xt-premium',
        'default' => array(
            'type' => 'image',
            'value' => self::$parent->plugin_url(). 'includes/customizer/assets/images/footer.png',
            'link' => self::$parent->fs()->get_upgrade_url()
        )
    ));
}