<?php
/**
 * @package         FirePlugins Framework
 * @version         1.1.141
 * 
 * @author          FirePlugins <info@fireplugins.com>
 * @link            https://www.fireplugins.com
 * @copyright       Copyright © 2025 FirePlugins All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

if (!defined('ABSPATH'))
{
	exit; // Exit if accessed directly.
}
$label = $this->data->get('label', '');
$feature_label = $this->data->get('feature_label', '');
if ($feature_label)
{
	$label = $feature_label;
}
$upgrade_plan = $this->data->get('upgrade_plan', '');
$button_text = sprintf(fpframework()->_('FPF_UNLOCK_X_FEATURE'), $upgrade_plan ? $upgrade_plan : fpframework()->_('FPF_PRO'));
?>
<a
	href="#"
	data-fpf-modal-item="<?php echo esc_attr(fpframework()->_($label)); ?>"
	data-current-plan="<?php echo FBOX_LICENSE_PLAN === 'free' ? fpframework()->_('FPF_LITE') : ucfirst(FBOX_LICENSE_PLAN); ?>"
	class="fpf-button upgrade fpf-modal-opener"
	data-fpf-modal="<?php echo $this->data->get('modal', ''); ?>"
	<?php echo $upgrade_plan ? 'data-upgrade-plan="' . esc_attr($upgrade_plan) . '"' : ''; ?>>
	<svg class="fpf-upgrade-icon lock-closed" xmlns="http://www.w3.org/2000/svg" height="18px" viewBox="0 -960 960 960" width="18px" fill="#e8eaed"><path d="M263.72-96Q234-96 213-117.15T192-168v-384q0-29.7 21.15-50.85Q234.3-624 264-624h24v-96q0-79.68 56.23-135.84 56.22-56.16 136-56.16Q560-912 616-855.84q56 56.16 56 135.84v96h24q29.7 0 50.85 21.15Q768-581.7 768-552v384q0 29.7-21.16 50.85Q725.68-96 695.96-96H263.72Zm.28-72h432v-384H264v384Zm216.21-120Q510-288 531-309.21t21-51Q552-390 530.79-411t-51-21Q450-432 429-410.79t-21 51Q408-330 429.21-309t51 21ZM360-624h240v-96q0-50-35-85t-85-35q-50 0-85 35t-35 85v96Zm-96 456v-384 384Z"/></svg>
	<svg class="fpf-upgrade-icon lock-open" xmlns="http://www.w3.org/2000/svg" height="18px" viewBox="0 -960 960 960" width="18px" fill="#e8eaed"><path d="M264-624h336v-96q0-50-35-85t-85-35q-50 0-85 35t-35 85h-72q0-80 56.23-136 56.22-56 136-56Q560-912 616-855.84q56 56.16 56 135.84v96h24q29.7 0 50.85 21.15Q768-581.7 768-552v384q0 29.7-21.16 50.85Q725.68-96 695.96-96H263.72Q234-96 213-117.15T192-168v-384q0-29.7 21.15-50.85Q234.3-624 264-624Zm0 456h432v-384H264v384Zm216.21-120Q510-288 531-309.21t21-51Q552-390 530.79-411t-51-21Q450-432 429-410.79t-21 51Q408-330 429.21-309t51 21ZM264-168v-384 384Z"/></svg>
	<span class="text"><?php echo esc_html($button_text); ?></span>
</a>