<?php
/**
 * @package         FirePlugins Framework
 * @version         1.1.141
 * 
 * @author          FirePlugins <info@fireplugins.com>
 * @link            https://www.fireplugins.com
 * @copyright       Copyright © 2025 FirePlugins All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

namespace FPFramework\Helpers;

if (!defined('ABSPATH'))
{
	exit; // Exit if accessed directly.
}

class Currencies
{
    public static function getList()
    {
        return [
            'AED' => 'United Arab Emirates Dirham',
            'AFN' => 'Afghan Afghani',
            'ALL' => 'Albanian Lek',
            'AMD' => 'Armenian Dram',
            'ANG' => 'Netherlands Antillean Guilder',
            'AOA' => 'Angolan Kwanza',
            'ARS' => 'Argentine Peso',
            'AUD' => 'Australian Dollar',
            'AWG' => 'Aruban Florin',
            'AZN' => 'Azerbaijani Manat',
            'BAM' => 'Bosnia-Herzegovina Convertible Mark',
            'BBD' => 'Barbadian Dollar',
            'BDT' => 'Bangladeshi Taka',
            'BGN' => 'Bulgarian Lev',
            'BHD' => 'Bahraini Dinar',
            'BIF' => 'Burundian Franc',
            'BMD' => 'Bermudan Dollar',
            'BND' => 'Brunei Dollar',
            'BOB' => 'Bolivian Boliviano',
            'BRL' => 'Brazilian Real',
            'BSD' => 'Bahamian Dollar',
            'BTC' => 'Bitcoin',
            'BTN' => 'Bhutanese Ngultrum',
            'BWP' => 'Botswanan Pula',
            'BYN' => 'Belarusian Ruble',
            'BYR' => 'Belarusian Ruble (pre-2016)',
            'BZD' => 'Belize Dollar',
            'CAD' => 'Canadian Dollar',
            'CDF' => 'Congolese Franc',
            'CHF' => 'Swiss Franc',
            'CLF' => 'Chilean Unit of Account (UF)',
            'CLP' => 'Chilean Peso',
            'CNY' => 'Chinese Yuan',
            'COP' => 'Colombian Peso',
            'CRC' => 'Costa Rican Colón',
            'CUC' => 'Cuban Convertible Peso',
            'CUP' => 'Cuban Peso',
            'CVE' => 'Cape Verdean Escudo',
            'CZK' => 'Czech Republic Koruna',
            'DJF' => 'Djiboutian Franc',
            'DKK' => 'Danish Krone',
            'DOP' => 'Dominican Peso',
            'DZD' => 'Algerian Dinar',
            'EEK' => 'Estonian Kroon',
            'EGP' => 'Egyptian Pound',
            'ERN' => 'Eritrean Nakfa',
            'ETB' => 'Ethiopian Birr',
            'EUR' => 'Euro',
            'FJD' => 'Fijian Dollar',
            'FKP' => 'Falkland Islands Pound',
            'GBP' => 'British Pound Sterling',
            'GEL' => 'Georgian Lari',
            'GGP' => 'Guernsey Pound',
            'GHS' => 'Ghanaian Cedi',
            'GIP' => 'Gibraltar Pound',
            'GMD' => 'Gambian Dalasi',
            'GNF' => 'Guinean Franc',
            'GTQ' => 'Guatemalan Quetzal',
            'GYD' => 'Guyanaese Dollar',
            'HKD' => 'Hong Kong Dollar',
            'HNL' => 'Honduran Lempira',
            'HRK' => 'Croatian Kuna',
            'HTG' => 'Haitian Gourde',
            'HUF' => 'Hungarian Forint',
            'IDR' => 'Indonesian Rupiah',
            'ILS' => 'Israeli New Sheqel',
            'IMP' => 'Manx pound',
            'INR' => 'Indian Rupee',
            'IQD' => 'Iraqi Dinar',
            'IRR' => 'Iranian Rial',
            'ISK' => 'Icelandic Króna',
            'JEP' => 'Jersey Pound',
            'JMD' => 'Jamaican Dollar',
            'JOD' => 'Jordanian Dinar',
            'JPY' => 'Japanese Yen',
            'KES' => 'Kenyan Shilling',
            'KGS' => 'Kyrgystani Som',
            'KHR' => 'Cambodian Riel',
            'KMF' => 'Comorian Franc',
            'KPW' => 'North Korean Won',
            'KRW' => 'South Korean Won',
            'KWD' => 'Kuwaiti Dinar',
            'KYD' => 'Cayman Islands Dollar',
            'KZT' => 'Kazakhstani Tenge',
            'LAK' => 'Laotian Kip',
            'LBP' => 'Lebanese Pound',
            'LKR' => 'Sri Lankan Rupee',
            'LRD' => 'Liberian Dollar',
            'LSL' => 'Lesotho Loti',
            'LTL' => 'Lithuanian Litas',
            'LVL' => 'Latvian Lats',
            'LYD' => 'Libyan Dinar',
            'MAD' => 'Moroccan Dirham',
            'MDL' => 'Moldovan Leu',
            'MGA' => 'Malagasy Ariary',
            'MKD' => 'Macedonian Denar',
            'MMK' => 'Myanma Kyat',
            'MNT' => 'Mongolian Tugrik',
            'MOP' => 'Macanese Pataca',
            'MRO' => 'Mauritanian Ouguiya',
            'MTL' => 'Maltese Lira',
            'MUR' => 'Mauritian Rupee',
            'MVR' => 'Maldivian Rufiyaa',
            'MWK' => 'Malawian Kwacha',
            'MXN' => 'Mexican Peso',
            'MYR' => 'Malaysian Ringgit',
            'MZN' => 'Mozambican Metical',
            'NAD' => 'Namibian Dollar',
            'NGN' => 'Nigerian Naira',
            'NIO' => 'Nicaraguan Córdoba',
            'NOK' => 'Norwegian Krone',
            'NPR' => 'Nepalese Rupee',
            'NZD' => 'New Zealand Dollar',
            'OMR' => 'Omani Rial',
            'PAB' => 'Panamanian Balboa',
            'PEN' => 'Peruvian Nuevo Sol',
            'PGK' => 'Papua New Guinean Kina',
            'PHP' => 'Philippine Peso',
            'PKR' => 'Pakistani Rupee',
            'PLN' => 'Polish Zloty',
            'PYG' => 'Paraguayan Guarani',
            'QAR' => 'Qatari Rial',
            'RON' => 'Romanian Leu',
            'RSD' => 'Serbian Dinar',
            'RUB' => 'Russian Ruble',
            'RWF' => 'Rwandan Franc',
            'SAR' => 'Saudi Riyal',
            'SBD' => 'Solomon Islands Dollar',
            'SCR' => 'Seychellois Rupee',
            'SDG' => 'Sudanese Pound',
            'SEK' => 'Swedish Krona',
            'SGD' => 'Singapore Dollar',
            'SHP' => 'Saint Helena Pound',
            'SLL' => 'Sierra Leonean Leone',
            'SOS' => 'Somali Shilling',
            'SRD' => 'Surinamese Dollar',
            'STD' => 'São Tomé and Príncipe Dobra',
            'SVC' => 'Salvadoran Colón',
            'SYP' => 'Syrian Pound',
            'SZL' => 'Swazi Lilangeni',
            'THB' => 'Thai Baht',
            'TJS' => 'Tajikistani Somoni',
            'TMT' => 'Turkmenistani Manat',
            'TND' => 'Tunisian Dinar',
            'TOP' => 'Tongan Pa?anga',
            'TRY' => 'Turkish Lira',
            'TTD' => 'Trinidad and Tobago Dollar',
            'TWD' => 'New Taiwan Dollar',
            'TZS' => 'Tanzanian Shilling',
            'UAH' => 'Ukrainian Hryvnia',
            'UGX' => 'Ugandan Shilling',
            'USD' => 'United States Dollar',
            'UYU' => 'Uruguayan Peso',
            'UZS' => 'Uzbekistan Som',
            'VEF' => 'Venezuelan Bolívar Fuerte',
            'VND' => 'Vietnamese Dong',
            'VUV' => 'Vanuatu Vatu',
            'WST' => 'Samoan Tala',
            'XAF' => 'CFA Franc BEAC',
            'XAG' => 'Silver Ounce',
            'XAU' => 'Gold Ounce',
            'XCD' => 'East Caribbean Dollar',
            'XDR' => 'Special Drawing Rights',
            'XOF' => 'CFA Franc BCEAO',
            'XPD' => 'Palladium Ounce',
            'XPF' => 'CFP Franc',
            'XPT' => 'Platinum Ounce',
            'YER' => 'Yemeni Rial',
            'ZAR' => 'South African Rand',
            'ZMK' => 'Zambian Kwacha (pre-2013)',
            'ZMW' => 'Zambian Kwacha',
            'ZWL' => 'Zimbabwean Dollar',
        ];
    }

    /**
     * Get currency symbols
     * 
     * @return array
     */
    public static function getSymbols()
    {
        return [
            'AED' => 'د.إ',
            'AFN' => '؋',
            'ALL' => 'L',
            'AMD' => '֏',
            'ANG' => 'ƒ',
            'AOA' => 'Kz',
            'ARS' => '$',
            'AUD' => '$',
            'AWG' => 'ƒ',
            'AZN' => '₼',
            'BAM' => 'KM',
            'BBD' => '$',
            'BDT' => '৳',
            'BGN' => 'лв',
            'BHD' => '.د.ب',
            'BIF' => 'FBu',
            'BMD' => '$',
            'BND' => '$',
            'BOB' => '$b',
            'BOV' => 'BOV',
            'BRL' => 'R$',
            'BSD' => '$',
            'BTC' => '₿',
            'BTN' => 'Nu.',
            'BWP' => 'P',
            'BYN' => 'Br',
            'BYR' => 'Br',
            'BZD' => 'BZ$',
            'CAD' => '$',
            'CDF' => 'FC',
            'CHE' => 'CHE',
            'CHF' => 'CHF',
            'CHW' => 'CHW',
            'CLF' => 'CLF',
            'CLP' => '$',
            'CNH' => '¥',
            'CNY' => '¥',
            'COP' => '$',
            'COU' => 'COU',
            'CRC' => '₡',
            'CUC' => '$',
            'CUP' => '₱',
            'CVE' => '$',
            'CZK' => 'Kč',
            'DJF' => 'Fdj',
            'DKK' => 'kr',
            'DOP' => 'RD$',
            'DZD' => 'دج',
            'EEK' => 'kr',
            'EGP' => '£',
            'ERN' => 'Nfk',
            'ETB' => 'Br',
            'ETH' => 'Ξ',
            'EUR' => '€',
            'FJD' => '$',
            'FKP' => '£',
            'GBP' => '£',
            'GEL' => '₾',
            'GGP' => '£',
            'GHC' => '₵',
            'GHS' => 'GH₵',
            'GIP' => '£',
            'GMD' => 'D',
            'GNF' => 'FG',
            'GTQ' => 'Q',
            'GYD' => '$',
            'HKD' => '$',
            'HNL' => 'L',
            'HRK' => 'kn',
            'HTG' => 'G',
            'HUF' => 'Ft',
            'IDR' => 'Rp',
            'ILS' => '₪',
            'IMP' => '£',
            'INR' => '₹',
            'IQD' => 'د.ع',
            'IRR' => '﷼',
            'ISK' => 'kr',
            'JEP' => '£',
            'JMD' => 'J$',
            'JOD' => 'JD',
            'JPY' => '¥',
            'KES' => 'KSh',
            'KGS' => 'лв',
            'KHR' => '៛',
            'KMF' => 'CF',
            'KPW' => '₩',
            'KRW' => '₩',
            'KWD' => 'KD',
            'KYD' => '$',
            'KZT' => '₸',
            'LAK' => '₭',
            'LBP' => '£',
            'LKR' => '₨',
            'LRD' => '$',
            'LSL' => 'M',
            'LTC' => 'Ł',
            'LTL' => 'Lt',
            'LVL' => 'Ls',
            'LYD' => 'LD',
            'MAD' => 'MAD',
            'MDL' => 'lei',
            'MGA' => 'Ar',
            'MKD' => 'ден',
            'MMK' => 'K',
            'MNT' => '₮',
            'MOP' => 'MOP$',
            'MRO' => 'UM',
            'MRU' => 'UM',
            'MUR' => '₨',
            'MVR' => 'Rf',
            'MWK' => 'MK',
            'MXN' => '$',
            'MXV' => 'MXV',
            'MYR' => 'RM',
            'MZN' => 'MT',
            'NAD' => '$',
            'NGN' => '₦',
            'NIO' => 'C$',
            'NOK' => 'kr',
            'NPR' => '₨',
            'NZD' => '$',
            'OMR' => '﷼',
            'PAB' => 'B/.',
            'PEN' => 'S/',
            'PGK' => 'K',
            'PHP' => '₱',
            'PKR' => '₨',
            'PLN' => 'zł',
            'PYG' => 'Gs',
            'QAR' => '﷼',
            'RMB' => '￥',
            'RON' => 'lei',
            'RSD' => 'Дин.',
            'RUB' => '₽',
            'RWF' => 'R₣',
            'SAR' => '﷼',
            'SBD' => '$',
            'SCR' => '₨',
            'SDG' => 'ج.س.',
            'SEK' => 'kr',
            'SGD' => 'S$',
            'SHP' => '£',
            'SLL' => 'Le',
            'SOS' => 'S',
            'SRD' => '$',
            'SSP' => '£',
            'STD' => 'Db',
            'STN' => 'Db',
            'SVC' => '$',
            'SYP' => '£',
            'SZL' => 'E',
            'THB' => '฿',
            'TJS' => 'SM',
            'TMT' => 'T',
            'TND' => 'د.ت',
            'TOP' => 'T$',
            'TRL' => '₤',
            'TRY' => '₺',
            'TTD' => 'TT$',
            'TVD' => '$',
            'TWD' => 'NT$',
            'TZS' => 'TSh',
            'UAH' => '₴',
            'UGX' => 'USh',
            'USD' => '$',
            'UYI' => 'UYI',
            'UYU' => '$U',
            'UYW' => 'UYW',
            'UZS' => 'лв',
            'VEF' => 'Bs',
            'VES' => 'Bs.S',
            'VND' => '₫',
            'VUV' => 'VT',
            'WST' => 'WS$',
            'XAF' => 'FCFA',
            'XBT' => 'Ƀ',
            'XCD' => '$',
            'XOF' => 'CFA',
            'XPF' => '₣',
            'XSU' => 'Sucre',
            'XUA' => 'XUA',
            'YER' => '﷼',
            'ZAR' => 'R',
            'ZMW' => 'ZK',
            'ZWD' => 'Z$',
            'ZWL' => '$'
        ];
    }

    /**
     * Get currencies with both name and symbol
     * 
     * @return array
     */
    public static function getListWithSymbols()
    {
        $names = self::getList();
        $symbols = self::getSymbols();
        $result = [];

        foreach ($names as $code => $name)
        {
            $result[$code] = [
                'name' => $name,
                'symbol' => isset($symbols[$code]) ? $symbols[$code] : $code
            ];
        }

        return $result;
    }

    /**
     * Get currency symbol by currency code
     * 
     * @param string $currencyCode The 3-letter currency code (e.g., 'USD', 'EUR')
     * @param string $fallback The fallback value if currency code is not found (default: currency code itself)
     * @return string The currency symbol
     */
    public static function getSymbol($currencyCode, $fallback = null)
    {
        $symbols = self::getSymbols();
        $currencyCode = strtoupper(trim($currencyCode));
        
        if (isset($symbols[$currencyCode]))
            {
            return $symbols[$currencyCode];
        }
        
        // Use provided fallback or default to the currency code itself
        return $fallback !== null ? $fallback : $currencyCode;
    }
}