<?php
/**
 * @package         FireBox
 * @version         3.1.1 Pro
 * 
 * @author          FirePlugins <info@fireplugins.com>
 * @link            https://www.fireplugins.com
 * @copyright       Copyright © 2025 FirePlugins All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

namespace FireBox\Core\Analytics\QueryBuilders\Conversions;

if (!defined('ABSPATH'))
{
	exit; // Exit if accessed directly.
}

class MonthlyStrategy extends BaseConversionsQueryStrategy
{
	public function getSelect(): string
	{
		return $this->metric->getTimezoneDateSQL('DATE_FORMAT', 'bld.date', '\'%b %Y\'') . ' as label, COUNT(bld.id) as total';
	}

	public function getWhere(): string
	{
		return 'AND bld.event = \'conversion\'';
	}

	public function getGroupBy(): string
	{
		return 'GROUP BY ' . $this->metric->getTimezoneDateSQL('YEAR', 'bld.date') . ', ' . $this->metric->getTimezoneDateSQL('MONTH', 'bld.date');
	}

	public function getOrderBy(): string
	{
		$orderby = 'bld.date DESC';
		$options = $this->metric->getOptions();
		
		if (isset($options['orderby']))
		{
			$orderby = $options['orderby'];
		}

		return 'ORDER BY ' . $orderby;
	}

	public function getHaving(): string
	{
		return '';
	}
}
