<?php

function fifu_bbp_get_topic_author_avatar($author_avatar, $topic_id, $size) {
    if (fifu_is_on('fifu_bbpress_avatar') && fifu_main_image_url($topic_id, true)) {
        $author_avatar = fifu_replace_attribute($author_avatar, 'src', fifu_main_image_url($topic_id, true));
        $author_avatar = fifu_replace_attribute($author_avatar, 'srcset', '');
    }
    return $author_avatar;
}

add_filter('bbp_get_topic_author_avatar', 'fifu_bbp_get_topic_author_avatar', 10, 3);

function fifu_bbp_theme_before_topic_title() {
    if (fifu_is_off('fifu_bbpress_title'))
        return;

    fifu_bbp_display();
}

add_action('bbp_theme_before_topic_title', 'fifu_bbp_theme_before_topic_title');

function fifu_bbp_theme_before_forum_title() {
    if (fifu_is_off('fifu_bbpress_title'))
        return;

    fifu_bbp_display();
}

function fifu_bbp_display() {
    global $post;
    $url = fifu_main_image_url($post->ID, true);
    if (!$url)
        return;

    $img_tag = '<img src="' . $url . '" style="height:72px;width:96px;object-fit:cover" class="fifu-bbpress-img">';

    if (fifu_is_video_thumb($url)) {
        $video_url = get_post_meta($post->ID, 'fifu_video_url', true);
        $icon = '<span style="position:absolute;bottom:0px;left:0;text-decoration:none;background-color:black;color:white;" class="dashicons dashicons-external"></span>';
        echo '<a href="' . $video_url . '" target="_blank"><div class="alignleft" style="float:left;position:relative;padding-right:5px">' . $icon . $img_tag . '</div></a>';
        return;
    } else {
        echo '<div class="alignleft" style="float:left;position:relative;padding-right:5px">' . $img_tag . '</div>';
        return;
    }
}

add_action('bbp_theme_before_forum_title', 'fifu_bbp_theme_before_forum_title');

function fifu_bbp_extra_fields() {
    if (fifu_is_off('fifu_bbpress_fields'))
        return;

    $fifu = fifu_get_strings_meta_box_php();

    $image_url = get_post_meta(bbp_get_topic_id(), 'fifu_image_url', true);
    echo '<span class="dashicons dashicons-camera" style="font-size:17px"></span><label for="fifu_input_url">' . $fifu['title']['post']['image']() . '</label><br>';
    echo "<input type='text' name='fifu_input_url' value='" . $image_url . "' placeholder='" . $fifu['common']['image']() . "'><br>";

    $video_url = get_post_meta(bbp_get_topic_id(), 'fifu_video_url', true);
    echo '<span class="dashicons dashicons-video-alt3" style="font-size:17px"></span><label for="fifu_video_input_url">' . $fifu['title']['post']['video']() . '</label><br>';
    echo "<input type='text' name='fifu_video_input_url' value='" . $video_url . "' placeholder='" . $fifu['common']['video']() . "'>";
}

add_action('bbp_theme_before_topic_form_content', 'fifu_bbp_extra_fields');

