function fifu_convert($url) {
    if (fifu_from_google_drive($url))
        return fifu_google_drive_url($url);

    if (fifu_has_special_char($url))
        return fifu_escape_special_char($url);

    return $url;
}

function fifu_convert_video($url) {
    if (fifu_from_youtube_shorts($url))
        return fifu_youtube_url($url);

    return $url;
}

//Google Drive

function fifu_from_google_drive($url) {
    return $url.includes('drive.google.com');
}

function fifu_google_drive_id($url) {
    return $url.match(/[-\w]{25,}/);
}

function fifu_google_drive_url($url) {
    return 'https://drive.google.com/uc?id=' + fifu_google_drive_id($url);
}

//YouTube Shorts

function fifu_from_youtube_shorts($url) {
    return $url.match('youtube.com/shorts/');
}

function fifu_youtube_url($url) {
    return $url.replace('shorts/', 'watch?v=');
}

//Special char

function fifu_has_special_char($url) {
    return $url.includes("'");
}

function fifu_escape_special_char($url) {
    return $url.replace("'", "%27");
}
