jQuery(document).ready(function () {
    fifu_open_quick_lightbox();
});

function fifu_open_quick_lightbox() {
    jQuery("div.fifu-quick").on('click', function (evt) {
        evt.stopImmediatePropagation();
        post_id = jQuery(this).attr('post-id');
        video_url = jQuery(this).attr('video-url');
        image_url = jQuery(this).attr('image-url');
        video_src = jQuery(this).attr('video-src');
        is_ctgr = jQuery(this).attr('is-ctgr');
        url = image_url;
        url = (url == 'about:invalid' ? '' : url);
        if (video_url) {
            media = `<iframe id="fifu-quick-preview" src="${video_src}" post-id="${post_id}" style="min-height:200px; max-height:600px; width:100%;" allowfullscreen frameborder="0"></iframe>`;
            url = '';
        } else
            media = `<img id="fifu-quick-preview" src="${url}" post-id="${post_id}" style="max-height:600px; width:100%;">`;
        box = `
            <table>
                <tr>
                    <td id="fifu-left-column" style="min-width:170px; background-color:#f6f7f7">${media}</td>
                    <td style="vertical-align:top; padding: 10px; background-color:#f6f7f7">
                        <div>
                            <div style="padding-bottom:5px">
                                <span class="dashicons dashicons-camera" style="font-size:20px;cursor:auto;" title="${fifuColumnVars.tipImage}"></span>
                                <b>${fifuColumnVars.labelImage}</b>
                            </div>
                            <input id="fifu-quick-input-url" type="text" placeholder="${fifuColumnVars.urlImage}" value="${url}"/>
                            <br><br>

                            <div style="padding-bottom:5px">
                                <span class="dashicons dashicons-video-alt3" style="font-size:20px;cursor:auto;" title="${fifuColumnVars.tipVideo}"></span>
                                <b>${fifuColumnVars.labelVideo}</b>
                            </div>
                            <input id="fifu-quick-video-input-url" type="text" placeholder="${fifuColumnVars.urlVideo}" value="${video_url}"/>
                            <br><br>

                            <div style="padding-bottom:5px">
                                <span class="dashicons dashicons-search" style="font-size:20px;cursor:auto" title="${fifuColumnVars.tipSearch}"></span>
                                <b>${fifuColumnVars.labelSearch}</b>
                            </div>
                            <div>
                                <input id="fifu-quick-search-input-keywords" type="text" placeholder="${fifuColumnVars.keywords}" value="" style="width:170px"/>
                                <button id="fifu-search-button" class="fifu-quick-button" type="button" style="width:50px;border-radius:5px;height:30px;position:absolute;background-color:#3c434a"><span class="dashicons dashicons-search" style="font-size:16px;cursor:auto"></span></button>
                            </div>
                            <br><br>
                        </div>
                        <div style="width:100%">
                            <button id="fifu-clean-button" class="fifu-quick-button" type="button" style="background-color: #e7e7e7; color: black;">Clean</button>
                            <button id="fifu-save-button" post-id="${post_id}" is-ctgr="${is_ctgr}" class="fifu-quick-button" type="button">Save</button>
                        </div>
                    </td>
                </tr>
            </table>                           
        `;
        fifu_include_input_hidden(post_id);
        jQuery.fancybox.open(box, {
            afterClose: function () {
                jQuery('input[id^=fifu-quick-video-input]').remove();
            },
        }
        );
        jQuery('#fifu-left-column').css('display', url || video_url ? 'table-cell' : 'none');
        if (video_url)
            jQuery('#fifu-quick-video-input-url').select();
        else
            jQuery('#fifu-quick-input-url').select();
        fifu_change_image_event();
        fifu_save_event();
        fifu_keypress_event();
        fifu_search_event();
    });
}

function fifu_change_image_event() {
    // image
    jQuery('#fifu-quick-input-url').on('input', function () {
        url = jQuery('#fifu-quick-input-url').val();
        post_id = jQuery('#fifu-save-button').attr('post-id');
        jQuery('#fifu-left-column').css('display', url ? 'table-cell' : 'none');
        jQuery('#fifu-quick-preview').remove();
        jQuery('#fifu-quick-video-input-url').val('');

        jQuery('#fifu-left-column').append(`<img id="fifu-quick-preview" src="${url}" post-id="${post_id}" style="max-height:600px; width:100%;">`);
    });
    // video
    jQuery('#fifu-quick-video-input-url').on('input', function () {
        url = jQuery('#fifu-quick-video-input-url').val();
        post_id = jQuery('#fifu-save-button').attr('post-id');
        jQuery('#fifu-left-column').css('display', url ? 'table-cell' : 'none');
        jQuery('#fifu-quick-preview').remove();
        jQuery('#fifu-quick-input-url').val('');

        src = srcVideo(url);
        imgColumn = jQuery('.fifu-quick[post-id="' + post_id + '"]');
        imgColumn.attr('video-url', url);
        imgColumn.attr('video-src', src);
        src = src ? src : '#';

        if (url) {
            video_thumb_url = fifu_video_image_thumbnail(url, fifuColumnVars);
            fifu_quick_video_get_image(video_thumb_url);
        }

        jQuery('#fifu-left-column').append(`<iframe id="fifu-quick-preview" src="${src}" post-id="${post_id}" style="min-height:200px; max-height:600px; width:100%;" allowfullscreen frameborder="0"></iframe>`);
    });
    // clean
    jQuery('#fifu-clean-button').on('click', function () {
        jQuery('#fifu-left-column').css('display', 'none');
        jQuery('#fifu-quick-preview').remove();
        jQuery('#fifu-quick-input-url').val('');
        jQuery('#fifu-quick-video-input-url').val('');
    });
}

function fifu_save_event() {
    jQuery('#fifu-save-button').on('click', function () {
        post_id = jQuery(this).attr('post-id');
        is_ctgr = jQuery(this).attr('is-ctgr');

        image_url = jQuery("#fifu-quick-input-url")[0].value;
        video_url = jQuery("#fifu-quick-video-input-url")[0].value;

        img = jQuery("img[post-id=" + post_id + "]")[0];
        iframe = jQuery("iframe[post-id=" + post_id + "]")[0];

        width = height = video_thumb_url = null;

        if (image_url) {
            width = img.naturalWidth;
            height = img.naturalHeight;
        } else if (video_url) {
            width = jQuery("#fifu-quick-video-input-image-width")[0].value;
            height = jQuery("#fifu-quick-video-input-image-height")[0].value;
            video_thumb_url = jQuery("#fifu-quick-video-input-image-src")[0].value;
        }

        jQuery.ajax({
            method: "POST",
            url: fifuColumnVars.restUrl + 'fifu-premium/v2/quick_edit_save_api/',
            data: {
                "post_id": post_id,
                "is_ctgr": is_ctgr,
                "width": width,
                "height": height,
                "image_url": image_url,
                "video_url": video_url,
                "video_thumb_url": video_thumb_url,
            },
            async: false,
            beforeSend: function (xhr) {
                xhr.setRequestHeader("X-WP-Nonce", fifuColumnVars.nonce);
            },
            success: function (data) {
                json = JSON.parse(data);
                url = json['thumb_url'];
                thumb = jQuery('div.fifu-quick[post-id=' + post_id + ']')[0];
                jQuery(thumb).attr('image-url', url);
                jQuery(thumb).css('background-image', 'url("' + url + '")');
                url ? jQuery(thumb).css('border', 'none') : jQuery(thumb).css('color', '#ca4a1f').css('border', '2px').css('border-style', 'dashed');
            },
            complete: function (data) {
                jQuery.fancybox.close();
            },
            timeout: 10
        });
    });
}

function fifu_keypress_event() {
    jQuery('div.fancybox-container.fancybox-is-open').keyup(function (e) {
        switch (e.which) {
            case 9:
                // tab (keyword)
                if (jQuery('#fifu-quick-search-input-keywords').val())
                    jQuery('#fifu-search-button').click();
                break;
            case 13:
                jQuery(this).blur();
                // enter (keyword)
                if (jQuery('#fifu-quick-search-input-keywords').val()) {
                    jQuery('#fifu-search-button').focus().click();
                    break;
                }
                // enter (save)
                jQuery('#fifu-save-button').focus().click();
                break;
            case 27:
                // esc
                jQuery.fancybox.close();
                break;
            default:
                break;
        }
    });
}

function fifu_search_event() {
    jQuery('#fifu-search-button').on('click', function () {
        keywords = jQuery('#fifu-quick-search-input-keywords').val();
        fifu_start_unsplash_lightbox(keywords, fifuColumnVars.unsplash_size);
    });
}

function fifu_quick_video_get_image(url) {
    var image = new Image();
    jQuery(image).attr('onload', 'fifu_quick_video_store_sizes(this);');
    jQuery(image).attr('src', url);
}

function fifu_quick_video_store_sizes($) {
    jQuery("#fifu-quick-video-input-image-width").val($.naturalWidth);
    jQuery("#fifu-quick-video-input-image-height").val($.naturalHeight);
    if ($.naturalWidth == 120 && $.naturalHeight == 90)
        jQuery("#fifu-quick-video-input-image-src").val($.src.replace('maxresdefault', 'mqdefault'));
    else
        jQuery("#fifu-quick-video-input-image-src").val($.src);
}

function fifu_include_input_hidden(post_id) {
    hidden_input = `
        <input 
            post-id="${post_id}"
            type="hidden" 
            id="fifu-quick-video-input-image-width" 
            name="fifu-quick-video-input-image-width" 
            value="" >

        <input
            post-id="${post_id}"
            type="hidden" 
            id="fifu-quick-video-input-image-height" 
            name="fifu-quick-video-input-image-height" 
            value="" >

        <input 
            post-id="${post_id}"
            type="hidden" 
            id="fifu-quick-video-input-image-src" 
            name="fifu-quick-video-input-image-src" 
            value="" >
    `;
    jQuery("div.fifu-quick").after(hidden_input);
}
