<?php

class FifuDdg {

    function __construct() {
        $this->site = 'https://duckduckgo.com/';
        $this->headers = array(
            'authority' => 'duckduckgo.com',
            'accept' => 'application/json, text/javascript, */*; q=0.01',
            'sec-fetch-dest' => 'empty',
            'x-requested-with' => 'XMLHttpRequest',
            'user-agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36',
            'sec-fetch-site' => 'same-origin',
            'sec-fetch-mode' => 'cors',
            'referer' => 'https://duckduckgo.com/',
            'accept-language' => 'en-US,en;q=0.9'
        );
    }

    function get_image_url($keywords, $width, $height, $blocklist, $source) {
        $keywords = $source ? "{$keywords} site:{$source}" : $keywords;

        error_log('fifu-ddg: ' . $keywords);
        $token = $this->get_token($keywords);
        if (!$token) {
            error_log('fifu-ddg: no token');
            sleep(30);
            return;
        }

        $params = array(
            'headers' => $this->headers,
            'l' => 'us-en',
            'o' => 'json',
            'q' => $keywords,
            'vqd' => $token,
            'f' => ',,,',
            'p' => '1',
            'v7exp' => 'a',
        );
        $js_url = $this->site . 'i.js';

        while (true) {
            while (true) {
                try {
                    $res = wp_safe_remote_get($js_url . '?' . http_build_query($params));
                    if (is_wp_error($res)) {
                        sleep(30);
                        continue;
                    }
                    $data = json_decode($res['body']);
                    break;
                } catch (Exception $e) {
                    error_log('fifu-ddg: ' . $e . ':' . $res);
                    sleep(30);
                    continue;
                }
            }

            if (!isset($data->results)) {
                error_log('fifu-ddg: not found');
                sleep(30);
                return null;
            }

            foreach ($data->results as $res) {
                // validate width
                if ($width && $res->width < $width)
                    continue;

                // validate height
                if ($height && $res->height < $height)
                    continue;

                // validate blocklist
                if ($blocklist) {
                    $skip = false;
                    foreach ($blocklist as $block) {
                        if (strpos($res->image, trim($block)) !== false) {
                            $skip = true;
                            break;
                        }
                    }
                    if ($skip)
                        continue;
                }
                error_log('fifu-ddg: ' . $res->image);
                return array('url' => $res->image, 'width' => $res->width, 'height' => $res->height);
            }

            if (!isset($data->next))
                return null;

            $js_url = $this->site . $data->next;
        }
    }

    function get_token($keywords) {
        $params = array('q' => $keywords);
        $args = array('timeout' => 30, 'sslverify' => false);
        $res = wp_safe_remote_get($this->site . '?' . http_build_query($params), $args);
        $data = json_encode($res);
        preg_match('/vqd=([\d-]+)\&/', $data, $matches);
        return $matches ? $matches[1] : null;
    }

}

function fifu_ddg_search($post_title, $width, $height, $blocklist, $post_id, $source) {
    $ddg = new FifuDdg();
    return $ddg->get_image_url($post_title, $width, $height, $blocklist, $source);
}

