"use strict";
var FatSbBookingOneServiceProvider_FE = {
    services: [],
    services_extra: [],
    services_work_day: [],
    employees_schedule: [],
    employees_day_off: [],
    services_employee: [],
    employee_break_time: [],
    e_service: {},
    e_id: 0,
    s_id: 0,
    b_date: 0,
    hasSetActiveDate: false
};
(function ($) {
    FatSbBookingOneServiceProvider_FE.init = function () {
        FatSbBookingOneServiceProvider_FE.initField();
        FatSbBookingOneServiceProvider_FE.loadServiceDictionary();
        FatSbMain_FE.registerEventProcess($('.fat-booking-container.one-service-provider'));
    };

    FatSbBookingOneServiceProvider_FE.initField = function () {
        $('.fat-booking-container.one-service-provider').each(function () {
            var container = $(this);
            //select box
            $('.ui.dropdown', container).each(function () {
                var self = $(this);
                self.suidropdown({
                    clearable: self.hasClass('clearable')
                });
            });

            $('.ui.steps .step', container).on('click', function () {
                var self = $(this),
                    container = self.closest('.fat-booking-container'),
                    step = self.attr('data-step');
                if (!self.hasClass('active') && !self.hasClass('disabled')) {
                    $('.ui.steps .step.active', container).removeClass('active');
                    self.addClass('active');
                    $('.step-tab-content .step-tab.active', container).fadeOut(function () {
                        $(this).removeClass('active');
                        $('.step-tab-content .step-tab[data-step="' + step + '"]', container).fadeIn(function () {
                            $(this).addClass('active');
                        })
                    })
                }
            });

            //air datetime
            var date_format = FatSbBookingOneServiceProvider_FE.getDateFormat(),
                elmBookingDate = $('.air-date-picker', container),
                locale = elmBookingDate.attr('data-locale');
            locale = locale.split('_').length > 1 ? locale.split('_')[0] : locale;
            var option = {
                language: locale,
                minDate: new Date(),
                autoClose: true,
                dateFormat: date_format
            };
            elmBookingDate.datepicker(option);
        });
    };

    FatSbBookingOneServiceProvider_FE.loadServiceDictionary = function () {
        var container = $('.fat-booking-container.one-service-provider'),
            tabContent = $('.step-tab-content', container),
            s_id = typeof (container.attr('data-service'))!='undefined' ? container.attr('data-service') : '',
            e_id = typeof (container.attr('data-provider'))!='undefined' ? container.attr('data-provider') : '';

        FatSbMain_FE.showLoading(tabContent);
        $.ajax({
            url: FatSbMain_FE.data.ajax_url,
            type: 'GET',
            data: ({
                action: 'fat_sb_get_one_service_provider_dictionary',
                s_field: FatSbMain_FE.data.ajax_s_field,
                s_id: s_id,
                e_id: e_id
            }),
            success: function (response) {
                response = $.parseJSON(response);
                if(typeof response=='undefined' || response == null){
                    FatSbBookingOneServiceProvider_FE.showNotFoundData();
                }
                FatSbBookingOneServiceProvider_FE.services = _.first(response.services);
                FatSbBookingOneServiceProvider_FE.services_extra = response.services_extra;

                if(typeof FatSbBookingOneServiceProvider_FE.services=='undefined' || FatSbBookingOneServiceProvider_FE.services.length==0){
                    FatSbBookingOneServiceProvider_FE.showNotFoundData();
                    return;
                }

                if(typeof container.attr('data-service') && container.attr('data-service')!='' && container.attr('data-service')!='0' ){
                    FatSbBookingOneServiceProvider_FE.s_id = parseInt(container.attr('data-service'));
                }else{
                    FatSbBookingOneServiceProvider_FE.s_id = FatSbBookingOneServiceProvider_FE.services.s_id;
                }

                if(typeof container.attr('data-provider') && container.attr('data-provider')!='' && container.attr('data-provider')!='0' ){
                    FatSbBookingOneServiceProvider_FE.e_id = parseInt(container.attr('data-provider'));
                }else{
                    FatSbBookingOneServiceProvider_FE.services_employee = _.where(response.services_employee,{s_id: FatSbBookingOneServiceProvider_FE.s_id}) ;
                    FatSbBookingOneServiceProvider_FE.services_employee = _.sortBy(FatSbBookingOneServiceProvider_FE.services_employee, function(se){
                        return se.e_id;
                    });
                    FatSbBookingOneServiceProvider_FE.e_id = FatSbBookingOneServiceProvider_FE.services_employee[0].e_id;
                }

                FatSbBookingOneServiceProvider_FE.services_work_day = _.where(response.services_work_day,{s_id: FatSbBookingOneServiceProvider_FE.s_id}) ;
                FatSbBookingOneServiceProvider_FE.employees_schedule = _.where(response.employees_schedule,{e_id: FatSbBookingOneServiceProvider_FE.e_id});
                FatSbBookingOneServiceProvider_FE.employees_day_off = _.where(response.employees_day_off,{e_id: FatSbBookingOneServiceProvider_FE.e_id});
                FatSbBookingOneServiceProvider_FE.employee_break_time = _.where(response.employee_break_time,{e_id: FatSbBookingOneServiceProvider_FE.e_id});

                //FatSbBookingOneServiceProvider_FE.initField();
                FatSbBookingOneServiceProvider_FE.initSlot();
                FatSbMain_FE.closeLoading(tabContent);
            },
            error: function () {

            }
        })
    };

    FatSbBookingOneServiceProvider_FE.initSlot = function(container){
        var date_wrap = $('.fat-sb-booking-date-wrap', container),
            time_wrap = $('.fat-sb-booking-time-wrap', container);

        try {
            $.ajax({
                url: FatSbMain_FE.data.ajax_url,
                type: 'GET',
                data: ({
                    action: 'fat_sb_get_booking_slot_fe',
                    s_id: FatSbBookingOneServiceProvider_FE.s_id,
                    e_id: FatSbBookingOneServiceProvider_FE.e_id,
                    loc_id: 1,
                    s_field: FatSbMain_FE.data.ajax_s_field
                }),
                success: function (response) {
                    response = $.parseJSON(response);

                    $('.fat-sb-booking-time-wrap .item:not(.disabled)', container).addClass('disabled');

                    if (response.result > 0 && typeof response.employee != 'undefined' && response.employee != null) {
                        var bookings = typeof response.bookings != 'undefined' && response.bookings != 'null' ? response.bookings : [],
                            e_day_off = typeof response.employee.e_day_off != 'undefined' && response.employee.e_day_off != 'null' ? response.employee.e_day_off : [],
                            e_break_times = typeof response.employee.e_break_times != 'undefined' && response.employee.e_break_times != 'null' ? response.employee.e_break_times : [],
                            e_schedules = typeof response.employee.e_schedules != 'undefined' && response.employee.e_schedules != 'null' ? response.employee.e_schedules : [],
                            e_services = typeof response.employee.e_services != 'undefined' && response.employee.e_services != 'null' ? response.employee.e_services : {},
                            dof_start = '',
                            dof_end = '';

                        FatSbBookingOneServiceProvider_FE.e_service = _.findWhere(e_services, {s_id: FatSbBookingOneServiceProvider_FE.s_id});

                        // init customer number dropdown
                        if (typeof FatSbBookingOneServiceProvider_FE.e_service != 'undefined' && FatSbBookingOneServiceProvider_FE.e_service != null && !isNaN(FatSbBookingOneServiceProvider_FE.e_service.s_min_cap) && !isNaN(FatSbBookingOneServiceProvider_FE.e_service.s_max_cap)) {
                            var min_cap = parseInt(FatSbBookingOneServiceProvider_FE.e_service.s_min_cap),
                                max_cap = parseInt(FatSbBookingOneServiceProvider_FE.e_service.s_max_cap),
                                elm_customer_number = $('.fat-sb-number-of-person-wrap .menu', container);
                            $('.fat-sb-number-of-person-wrap .text', container).html(min_cap);
                            $('#number_of_person', container).val(min_cap);
                            $('.item', elm_customer_number).remove();
                            for (var $n_index = min_cap; $n_index <= max_cap; $n_index++) {
                                elm_customer_number.append('<div class="item" data-value="' + $n_index + '">' + $n_index + '</div>');
                            }
                            $('.fat-sb-number-of-person-wrap', container).suidropdown('refresh').suidropdown('set selected', min_cap);
                        }


                        var $default_date = '',
                            $service_work_day = _.where(FatSbBookingOneServiceProvider_FE.services_work_day,{s_id: FatSbBookingOneServiceProvider_FE.s_id});

                        if($service_work_day.length > 0){
                            var from_date = '';
                            for(var $swd_index = 0; $swd_index < $service_work_day.length; $swd_index ++){
                                from_date = moment($service_work_day[$swd_index].from_date + ' 00:00:00');
                                from_date = new Date(from_date.year(), from_date.month(), from_date.date(), 0, 0, 0);
                                if($default_date=='' || $default_date > from_date){
                                    $default_date = from_date;
                                }
                            }
                        }else{
                            $default_date = new Date();
                        }

                        var today = new Date(),
                            delay_time = new Date();
                        if(typeof FatSbMain_FE.data.delay_time !='undefined' && parseInt(FatSbMain_FE.data.delay_time) > 0){
                            delay_time = new Date(today.getFullYear(),today.getMonth(),today.getDate()+ parseInt(FatSbMain_FE.data.delay_time));
                        }
                        delay_time = new Date(delay_time.getFullYear(),delay_time.getMonth(),delay_time.getDate(), 0, 0, 0);

                        $('.air-date-picker', date_wrap).datepicker({
                            firstDay: 1,
                            onRenderCell: function (date, cellType) {
                                if (cellType == 'day') {

                                    //check delay time booking
                                    if(date < delay_time){
                                        return {
                                            classes: 'fat-slot-not-free',
                                            disabled: true
                                        }
                                    }

                                    //check service working day
                                    var $service_work_day = FatSbBookingOneServiceProvider_FE.services_work_day;

                                    if($service_work_day.length > 0){
                                        var from_date = '',
                                            to_date = '',
                                            cell_status = {
                                                classes: 'fat-slot-not-free',
                                                disabled: true
                                            };
                                        for(var $swd_index = 0; $swd_index < $service_work_day.length; $swd_index ++){
                                            from_date = moment($service_work_day[$swd_index].from_date);
                                            to_date =  moment($service_work_day[$swd_index].to_date);

                                            from_date = new Date(from_date.year(), from_date.month(), from_date.date(), 0, 0, 0);
                                            to_date = new Date(to_date.year(), to_date.month(), to_date.date(), 23, 59, 59);

                                            if (date >= from_date && date <= to_date) {
                                                cell_status = {
                                                    classes: 'fat-slot-free',
                                                    disabled: false
                                                }
                                            }
                                        }
                                        return cell_status;
                                    }

                                    var $es_day = FatSbBookingOneServiceProvider_FE.getESDay(date),
                                        cell_result = '',
                                        dof_start = '',
                                        dof_end = '',
                                        e_day_off = FatSbBookingOneServiceProvider_FE.employees_day_off,
                                        e_schedules = FatSbBookingOneServiceProvider_FE.employees_schedule;

                                    for (var $dof_index = 0; $dof_index < e_day_off.length; $dof_index++) {
                                        if (e_day_off[$dof_index].dof_start != '' && e_day_off[$dof_index].dof_end != '') {
                                            dof_start = moment(e_day_off[$dof_index].dof_start);
                                            dof_end =  moment(e_day_off[$dof_index].dof_end);

                                            dof_start = new Date(dof_start.year(), dof_start.month(), dof_start.date(), 0, 0, 0);
                                            dof_end = new Date(dof_end.year(), dof_end.month(), dof_end.date(), 23, 59, 59);

                                            if (date >= dof_start && date <= dof_end) {
                                                return {
                                                    classes: 'fat-slot-not-free',
                                                    disabled: true
                                                }
                                            }
                                        }
                                    }

                                    for (var $es_index = 0; $es_index < e_schedules.length; $es_index++) {
                                        if ($es_day == e_schedules[$es_index].es_day) {
                                            if (e_schedules[$es_index].es_enable == "1" ) {
                                                return {
                                                    classes: 'fat-slot-free',
                                                    disabled: false
                                                }
                                            } else {
                                                return {
                                                    classes: 'fat-slot-not-free',
                                                    disabled: true
                                                }
                                            }
                                        }
                                    }
                                }
                            },
                            onSelect: function (formattedDate, date, inst) {
                                time_wrap.suidropdown('restore defaults');
                                $('.fat-empty-time-slot',container).remove();

                                if (typeof date == 'undefined' || date == '') {
                                    var selected_date = new Date($('.air-date-picker', date_wrap).attr('data-date') + ' 00:00:00');
                                    $('.air-date-picker', date_wrap).data('datepicker').selectDate(selected_date);
                                    return;
                                }

                                var month = date.getMonth() + 1,
                                    day = date.getDate(),
                                    selected_date_value = '',
                                    now = new Date(FatSbMain_FE.data.now),
                                    now_minute = now.getHours()*60 + now.getMinutes();

                                month = parseInt(month);
                                day = parseInt(day);
                                month = month < 10 ? ('0' + month) : month;
                                day = day < 10 ? ('0' + day) : day;

                                setTimeout(function(){
                                    var elm_default_date = $('.datepicker--cell[data-date="' + date.getDate() + '"][data-month="'+ date.getMonth() +'"][data-year="' + date.getFullYear() + '"]');
                                    if( !FatSbBookingOneServiceProvider_FE.hasSetActiveDate && (elm_default_date.hasClass('fat-slot-not-free') || elm_default_date.hasClass('-disabled-') )){
                                        FatSbBookingOneServiceProvider_FE.setActiveDate(date, date_wrap, 1);
                                    }
                                },500);

                                selected_date_value = date.getFullYear() + '-' + month + '-' + day;
                                $('#b_date', container).attr('data-date', selected_date_value);

                                $('.fat-sb-booking-time-wrap .item:not(.disabled)', container).addClass('disabled');
                                if (typeof date == 'undefined' || date == '' || $('#employee', container).val() == '') {
                                    return;
                                }

                                //check service working day
                                var $service_work_day = FatSbBookingOneServiceProvider_FE.services_work_day;
                                if($service_work_day.length > 0){
                                    var from_date = '',
                                        to_date = '',
                                        result = 'no_slot';
                                    for(var $swd_index = 0; $swd_index < $service_work_day.length; $swd_index ++){
                                        from_date = moment($service_work_day[$swd_index].from_date);
                                        to_date =  moment($service_work_day[$swd_index].to_date);

                                        from_date = new Date(from_date.year(), from_date.month(), from_date.date(), 0, 0, 0);
                                        to_date = new Date(to_date.year(), to_date.month(), to_date.date(), 23, 59, 59);
                                        if (date >= from_date && date <= to_date) {
                                            result = 'has_slot';

                                        }
                                    }
                                    if(result=='no_slot'){
                                        $('.fat-sb-booking-time-wrap', container).append('<div class="fat-empty-time-slot">' + FatSbMain_FE.data.empty_time_slot + '</div>');
                                        return;
                                    }
                                }

                                var $es_day = FatSbBookingOneServiceProvider_FE.getESDay(date),
                                    time = 0,
                                    self = '',
                                    work_hours = [],
                                    current_service_id = FatSbBookingOneServiceProvider_FE.s_id,
                                    service = FatSbBookingOneServiceProvider_FE.services,
                                    duration = !isNaN(service.s_duration) ? parseInt(service.s_duration) : 0,
                                    break_times = _.where(e_break_times, {es_day: String($es_day)});


                                //check work hour
                                $('.fat-sb-booking-time-wrap .item', container).each(function () {
                                    self = $(this),
                                        time = $(this).attr('data-value');
                                    time = parseInt(time);

                                    for (var $es_index = 0; $es_index < e_schedules.length; $es_index++) {
                                        if (e_schedules[$es_index].es_day == $es_day) {
                                            work_hours = e_schedules[$es_index].work_hours;
                                            if(typeof work_hours !='undefined'){
                                                for (var $wk_index = 0; $wk_index < work_hours.length; $wk_index++) {
                                                    if (work_hours[$wk_index].s_id.indexOf(FatSbBookingOneServiceProvider_FE.s_id) >= 0 &&
                                                        parseInt(work_hours[$wk_index].es_work_hour_start) <= time && (time + duration ) <= parseInt(work_hours[$wk_index].es_work_hour_end)) {
                                                        self.removeClass('disabled');
                                                    }
                                                }
                                            }
                                            if (typeof break_times != 'undefined') {
                                                for (var $b_index = 0; $b_index < break_times.length; $b_index++) {
                                                    if (time >= parseInt(break_times[$b_index].es_break_time_start) && time < parseInt(break_times[$b_index].es_break_time_end)) {
                                                        self.addClass('disabled');
                                                    }
                                                }
                                            }
                                        }
                                    }

                                    //disable time slot that has passed in the current day
                                    if(FatSbMain_FE.equalDay(now, date) && time < now_minute){
                                        self.addClass('disabled');
                                    }

                                    //default max cap
                                    self.attr('data-max-cap-available', FatSbBookingOneServiceProvider_FE.e_service.s_max_cap);
                                });

                                //check base on booking
                                var booking_in_day = _.where(bookings, {b_date: selected_date_value}),
                                    booking_service_in_day = _.where(bookings, {b_date: selected_date_value, b_service_id: FatSbBookingOneServiceProvider_FE.s_id.toString()});

                                if (typeof booking_in_day != 'undefined') {
                                    var b_time = 0,
                                        b_service_duration = 0,
                                        b_service_break_time = 0,
                                        b_service_id = 0,
                                        time = 0,
                                        self,
                                        min_cap =  parseInt(FatSbBookingOneServiceProvider_FE.e_service.s_min_cap),
                                        max_cap =  parseInt(FatSbBookingOneServiceProvider_FE.e_service.s_max_cap),
                                        total_customer = 0,
                                        booking_service_in_time;

                                    for (var $b_index = 0; $b_index < booking_in_day.length; $b_index++) {
                                        b_time = parseInt(booking_in_day[$b_index].b_time);
                                        b_service_duration = parseInt(booking_in_day[$b_index].b_service_duration);
                                        b_service_break_time = parseInt(service.s_break_time);// parseInt(booking_in_day[$b_index].b_service_break_time);
                                        b_service_id = parseInt(booking_in_day[$b_index].b_service_id);

                                        $('.fat-sb-booking-time-wrap .item:not(.disabled)', container).each(function () {
                                            self = $(this);
                                            time = parseInt(self.attr('data-value'));
                                            total_customer = 0;

                                            if(current_service_id == b_service_id && b_time == time){
                                                booking_service_in_time =  _.where(booking_service_in_day, {b_time: time.toString()});
                                                for(var $bs_index=0; $bs_index < booking_service_in_time.length; $bs_index++ ){
                                                    total_customer += parseInt(booking_service_in_time[$bs_index].b_customer_number);
                                                }
                                                if(total_customer >= max_cap || min_cap > (max_cap - total_customer)){
                                                    self.addClass('disabled');
                                                }

                                            }else{
                                                console.log('b_time:' + b_time + ' time:' + time + ' b_end_time:' + (b_time + b_service_duration + b_service_break_time));
                                                if (b_time <= time && time < (b_time + b_service_duration + b_service_break_time)) {
                                                    self.addClass('disabled');
                                                }
                                                if (time <= b_time && b_time < (time + b_service_duration + b_service_break_time)) {
                                                    self.addClass('disabled');
                                                }
                                            }
                                            self.attr('data-max-cap-available', (max_cap - total_customer));

                                        });
                                    }
                                }

                                if ($('.fat-sb-booking-time-wrap .item:not(.disabled)', container).length == 0) {
                                    $('.ui.step-tab.active', container).append('<div class="fat-empty-time-slot">' + FatSbMain_FE.data.empty_time_slot + '</div>');
                                }
                                inst.hide();
                            }
                        });

                        FatSbBookingOneServiceProvider_FE.setActiveDate($default_date, date_wrap);
                    }

                    FatSbBookingOneServiceProvider_FE.b_date = $default_date;
                    $('.ui.step-tab.active', container).css('opacity',1);
                    $(container).addClass('has-init');
                },
                error: function () {
                    date_wrap.removeClass('fat-loading');
                    time_wrap.removeClass('fat-loading');
                    $('.ui.button.loading', date_wrap).remove();
                    $('.ui.button.loading', time_wrap).remove();
                }
            });
        } catch (e) {
            console.log(e);
        } finally {
            $('.fat-loading-container', container).remove();
        }
    };

    FatSbBookingOneServiceProvider_FE.getDateFormat = function () {
        var date_format = FatSbMain_FE.data.date_format;
        date_format = date_format.replace('M', 'M');
        date_format = date_format.replace('F', 'MM');
        date_format = date_format.replace('m', 'mm');
        date_format = date_format.replace('n', 'mm');

        date_format = date_format.replace('d', 'dd');
        date_format = date_format.replace('j', 'dd');
        date_format = date_format.replace('s', 'dd');

        date_format = date_format.replace('Y', 'yyyy');
        date_format = date_format.replace('年','/');
        date_format = date_format.replace('月','/');
        date_format = date_format.replace('日','');
        return date_format;
    };

    FatSbBookingOneServiceProvider_FE.initStripeCardInput = function () {
        if ($('form#stripe-payment-form').length == 0) {
            return;
        }

        var pk = $('form#stripe-payment-form').attr('data-pk');
        if(typeof pk=='undefined' || pk==''){
            return;
        }

        var stripe = Stripe(pk),
            elements = stripe.elements();

        var style = {
            base: {
                color: '#32325d',
                lineHeight: '18px',
                fontSmoothing: 'antialiased',
                fontSize: '16px',
                '::placeholder': {
                    color: '#aab7c4'
                }
            },
            invalid: {
                color: 'red',
                iconColor: 'red'
            }
        };

        // Create an instance of the card Element.
        var card = elements.create('card', {style: style});

        // Add an instance of the card Element into the `card-element` <div>.
        card.mount('#card-element');

        // Handle real-time validation errors from the card Element.
        card.addEventListener('change', function (event) {
            var displayError = document.getElementById('card-errors');
            if (event.error) {
                displayError.textContent = event.error.message;
            } else {
                displayError.textContent = '';
            }
        });

        // Handle form submission.
        var form = document.getElementById('stripe-payment-form');
        form.addEventListener('submit', function (event) {
            event.preventDefault();

            var self = $('button.fat-bt-payment', '.fat-booking-container'),
                container = self.closest('.ui.step-tab-content');

            FatSbMain_FE.addLoading(container, self);
            stripe.createToken(card).then(function (result) {

                var self = $('button.fat-bt-payment', '.fat-booking-container'),
                    container = self.closest('.ui.step-tab-content');

                if (result.error) {
                    // Inform the user if there was an error.
                    var errorElement = document.getElementById('card-errors');
                    errorElement.textContent = result.error.message;
                    FatSbMain_FE.removeLoading(container, self);
                } else {
                    // Send the token to your server.
                    var self = $('button.fat-bt-payment', '.fat-booking-container'),
                        container = self.closest('.fat-booking-container'),
                        service_id = $('.fat-sb-services-dic', container).suidropdown('get value'),
                        services_extra = $('.fat-sb-services-extra-dic', container).suidropdown('get value'),
                        employee_id = $('.fat-sb-employee-dic', container).suidropdown('get value'),
                        loc_id = $('.fat-sb-location-dic', container).suidropdown('get value'),
                        date = $('.fat-sb-booking-date-wrap #b_date', container).attr('data-date'),
                        time = $('.fat-sb-booking-time-wrap', container).suidropdown('get value'),
                        number_of_person = $('.fat-sb-number-of-person-wrap', container).suidropdown('get value'),
                        coupon = $('#coupon', container).val(),
                        payment_method = $('.fat-sb-payment-method-wrap', container).suidropdown('get value'),
                        c_first_name = $('#c_first_name', container).val(),
                        c_last_name = $('#c_last_name', container).val(),
                        c_email = $('#c_email', container).val(),
                        c_phone = $('#c_phone', container).val(),
                        note = $('#note', container).text();
                    $.ajax({
                        url: FatSbMain_FE.data.ajax_url,
                        type: 'POST',
                        data: ({
                            action: 'fat_sb_save_booking_fe',
                            s_field: FatSbMain_FE.data.ajax_s_field,
                            token: result.token.id,
                            data: {
                                b_service_id: service_id,
                                b_services_extra: services_extra,
                                b_loc_id: loc_id,
                                b_employee_id: employee_id,
                                b_date: date,
                                b_time: time,
                                b_customer_number: number_of_person,
                                b_coupon_code: coupon,
                                b_gateway_type: payment_method,
                                c_first_name: c_first_name,
                                c_last_name: c_last_name,
                                c_email: c_email,
                                c_phone: c_phone,
                                b_description: note
                            }
                        }),
                        success: function (data) {
                            data = $.parseJSON(data);

                            if (data.code > 0) {

                                $.ajax({
                                    url: FatSbMain_FE.data.ajax_url,
                                    type: 'POST',
                                    data: ({
                                        action: 'fat_sb_send_booking_fe_mail',
                                        s_field: FatSbMain_FE.data.ajax_s_field,
                                        b_id: data.code,
                                    })
                                });

                                FatSbMain_FE.removeLoading(container, self);
                                $('.ui.steps .step[data-step="completed"]', container).removeClass('disabled');
                                $('.ui.steps .step[data-step="completed"]', container).trigger('click');
                                $('.fat-bt-add-icalendar', container).attr('data-id',data.code);
                            } else {
                                FatSbMain_FE.removeLoading(container, self);
                                var errorElement = document.getElementById('card-errors');
                                errorElement.textContent = data.message;
                            }
                        },
                        error: function () {
                            FatSbMain_FE.removeLoading(container, self);
                            var errorElement = document.getElementById('card-errors');
                            errorElement.textContent = FatSbMain_FE.data.error_message;
                        }
                    });
                }
            });
        });

        var paymentType = $('.fat-sb-payment-method-wrap').suidropdown('get value');
        if (paymentType === 'stripe') {
            $('.fat-sb-order-stripe').show();
        } else {
            $('.fat-sb-order-stripe').hide();
        }
        $('.fat-sb-payment-method-wrap').on('change', function () {
            if ($(this).suidropdown('get value') === 'stripe') {
                $('.fat-sb-order-stripe').show();
            } else {
                $('.fat-sb-order-stripe').hide();
            }
        });
    };

    FatSbBookingOneServiceProvider_FE.getESDay = function (date) {
        switch (date.getDay()) {
            case 0: {
                return 8;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
                break;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
        }
        return 0;
    };

    FatSbBookingOneServiceProvider_FE.initPayment = function (container) {
        var location = $('.fat-sb-location-dic', container).suidropdown('get text'),
            service = $('.fat-sb-services-dic', container).suidropdown('get text'),
            service_id = FatSbBookingOneServiceProvider_FE.s_id,
            employee = '',
            date = $('.fat-sb-booking-date-wrap #b_date', container).attr('data-date'),
            date_label = $('.fat-sb-booking-date-wrap #b_date', container).val(),
            time = $('.fat-sb-booking-time-wrap', container).suidropdown('get value'),
            time_label = $('.fat-sb-booking-time-wrap', container).suidropdown('get text'),
            number_of_person = $('.fat-sb-number-of-person-wrap', container).suidropdown('get value'),
            price = typeof FatSbBookingOneServiceProvider_FE.e_service.s_price != 'undefined' ? parseFloat(FatSbBookingOneServiceProvider_FE.e_service.s_price) : 0,
            price_label = '',
            discount = $('#coupon', container).val() != '' ? $('.fat-sb-order-discount .fat-item-value', container).attr('data-value') : 0,
            total = 0,
            duration = 0,
            end_time = 0,
            service_info = FatSbBookingOneServiceProvider_FE.services,
            time_end_label = '',
            tax_percent = 0,
            tax = 0,
            extra_price = 0,
            extra_tax = 0;

        if (typeof service_info.s_duration != 'undefined' && service_info.s_duration != null) {
            duration = service_info.s_duration;
            end_time = parseInt(service_info.s_duration) + parseInt(time);

            var minute = Math.floor(end_time/60),
                second = end_time%60;
            time_end_label =  minute + ':' + second;
            tax_percent = parseFloat(service_info.s_tax);
        }

        var service_extra,
            cb_se_id = 0;
        $('.fat-sb-order-extra-service .fat-sb-service-extra-item',container).each(function(){
            if($(this).is(':checked')){
                cb_se_id = $(this).val();
                service_extra = _.find(FatSbBookingOneServiceProvider_FE.services_extra,{se_id: cb_se_id});
                extra_price += parseFloat(service_extra.se_price);
                extra_tax += (number_of_person * parseFloat(service_extra.se_price) * parseFloat(service_extra.se_tax) ) / 100;
            }
        });

        discount = typeof discount != 'undefined' && discount != '' && !isNaN(discount) ? parseFloat(discount) : 0;

        var $price_base_quantity = FatSbMain_FE.calculatePrice(number_of_person, price, FatSbBookingOneServiceProvider_FE.s_id);

        tax = $price_base_quantity * tax_percent / 100;
        tax = tax + extra_tax;
        total = $price_base_quantity + (extra_price * number_of_person)  + tax - discount;

        price_label = FatSbMain_FE.getPriceLabel(number_of_person, price, $price_base_quantity,  FatSbBookingOneServiceProvider_FE.s_id);

        $('.fat-sb-order-service .fat-item-value', container).text(service);
        $('.fat-sb-order-employee .fat-item-value', container).text(employee);
        $('.fat-sb-order-date .fat-item-value', container).html(date_label);
        $('.fat-sb-order-time .fat-item-value', container).html(time_label + ' - ' + time_end_label);
        $('.fat-sb-order-location .fat-item-value', container).text(location);
        $('.fat-sb-order-price .fat-item-value', container).html(price_label);
        $('.fat-sb-order-time-end .fat-item-value', container).text(time_end_label);


        if (tax > 0) {
            $('.fat-sb-order-tax', container).removeClass('fat-sb-hidden');
            $('.fat-sb-order-tax .fat-item-value', container).text(FatSbMain_FE.data.symbol_prefix + tax.format(FatSbMain_FE.data.number_of_decimals, 3, ',') + FatSbMain_FE.data.symbol_suffix);
        } else {
            $('.fat-sb-order-tax', container).addClass('fat-sb-hidden');
        }

        $('.fat-sb-order-discount .fat-item-value', container).attr('data-value', discount);
        $('.fat-sb-order-discount .fat-item-value', container).text(FatSbMain_FE.data.symbol_prefix + discount.format(FatSbMain_FE.data.number_of_decimals, 3, ',') + FatSbMain_FE.data.symbol_suffix);

        $('.fat-sb-order-total .fat-item-value', container).attr('data-value', total);
        $('.fat-sb-order-total .fat-item-value', container).text(FatSbMain_FE.data.symbol_prefix + total.format(FatSbMain_FE.data.number_of_decimals, 3, ',') + FatSbMain_FE.data.symbol_suffix);


    };

    FatSbBookingOneServiceProvider_FE.nextOnClick = function (self) {
        var container = self.closest('.fat-booking-container'),
            step_container = self.closest('.ui.step-tab'),
            form = $('.ui.form', step_container),
            step = self.attr('data-next-step');
        if (FatSbMain_FE.validateForm(form)) {

            $('.ui.step-tab.active', container).fadeOut(function(){
                $(this).removeClass('active');
                $('.ui.step-tab[data-step="' + step + '"]', container).fadeIn(function(){
                    $(this).removeClass('fat-sb-hidden').addClass('active');
                })
            });

            if (step == 'customer') {
                //init customer number dropdown
                var b_time = $('#b_time',container).val(),
                    min_cap = parseInt(FatSbBookingOneServiceProvider_FE.e_service.s_min_cap),
                    max_cap = parseInt( $('.fat-sb-booking-time-wrap .menu .item[data-value="' + b_time +'"]', container).attr('data-max-cap-available') ),
                    elm_customer_number = $('.fat-sb-number-of-person-wrap .menu', container);
                $('.fat-sb-number-of-person-wrap .text', container).html(min_cap);
                $('#number_of_person', container).val(min_cap);
                $('.item', elm_customer_number).remove();
                for (var $n_index = min_cap; $n_index <= max_cap; $n_index++) {
                    elm_customer_number.append('<div class="item" data-value="' + $n_index + '">' + $n_index + '</div>');
                }
                $('.fat-sb-number-of-person-wrap', container).suidropdown('refresh').suidropdown('set selected', min_cap);

                //init list service extra
                var $service = FatSbBookingOneServiceProvider_FE.services,
                    elm_extra = $('.fat-order-wrap .fat-sb-order-extra-service',container);
                elm_extra.addClass('fat-sb-hidden');
                $('span.fat-item-value ul li',elm_extra).remove();

                if(typeof $service.s_extra_ids !='undefined' && $service.s_extra_ids!=''){
                    var $s_extra_ids = $service.s_extra_ids.split(','),
                        $service_extra = _.filter(FatSbBookingOneServiceProvider_FE.services_extra,function(item){
                            return $s_extra_ids.indexOf(item.se_id) > -1 ? true : false;
                        });

                    if($service_extra!=null && $service_extra.length > 0){
                        elm_extra.removeClass('fat-sb-hidden');
                        for(var $i=0; $i < $service_extra.length; $i++){
                            $('ul',elm_extra).append('<li><input type="checkbox" data-onChange="FatSbBookingOneServiceProvider_FE.onChangeExtraService" value="' + $service_extra[$i].se_id +'" class="fat-sb-service-extra-item">'
                                + $service_extra[$i].se_name
                                + '<span  class="fat-se-price"> (' + FatSbMain_FE.data.symbol_prefix + parseFloat($service_extra[$i].se_price).format(FatSbMain_FE.data.number_of_decimals, 3, ',') + FatSbMain_FE.data.symbol_suffix + ')</span> '
                                + '</li>');
                        }
                        FatSbMain_FE.registerOnChange($('.fat-sb-order-extra-service'));
                    }
                }

                FatSbBookingOneServiceProvider_FE.initPayment(container);
            }
        }
    };

    FatSbBookingOneServiceProvider_FE.onChangeExtraService = function(self){
        var container = self.closest('.fat-sb-step-layout.one-service-provider');
        FatSbBookingOneServiceProvider_FE.initPayment(container);
    };

    FatSbBookingOneServiceProvider_FE.resetValidateField = function (self) {
        if (self.val() != '') {
            self.closest('.field').removeClass('field-error');
        }
    };

    FatSbBookingOneServiceProvider_FE.submitBooking = function (self) {
        var container = self.closest('.fat-booking-container'),
            step_container = self.closest('.ui.step-tab'),
            form = $('.ui.form', step_container),
            step = self.attr('data-next-step');
        if (FatSbMain_FE.validateForm(form)) {
            var service_id = FatSbBookingOneServiceProvider_FE.s_id,
                services_extra = '',
                employee_id = FatSbBookingOneServiceProvider_FE.e_id,
                loc_id = 1,
                date = $('.fat-sb-booking-date-wrap #b_date', container).attr('data-date'),
                time = $('.fat-sb-booking-time-wrap', container).suidropdown('get value'),
                number_of_person = $('.fat-sb-number-of-person-wrap', container).suidropdown('get value'),
                coupon = $('#coupon', container).val(),
                payment_method = $('.fat-sb-payment-method-wrap', container).suidropdown('get value'),
                c_first_name = $('#c_first_name', container).val(),
                c_last_name = $('#c_last_name', container).val(),
                c_email = $('#c_email', container).val(),
                c_phone = $('#c_phone', container).val(),
                note = $('#note', container).val(),
                form_builder = {};

            if(typeof payment_method=='undefined' || payment_method=='' || payment_method == null){
                $('.fat-sb-error-message',container).html(FatSbMain_FE.data.empty_payment_method).removeClass('fat-sb-hidden');
                return;
            }

            $('.fat-sb-order-extra-service .fat-sb-service-extra-item',container).each(function(){
                if($(this).is(':checked')){
                    if(services_extra==''){
                        services_extra += $(this).val();
                    }else{
                        services_extra += ',' + $(this).val();
                    }
                }
            });

            $('.fat-sb-field-builder',form).each(function(){
                var field = $(this),
                    field_id = field.attr('name');
                if(field.hasClass('fat-sb-checkbox-group') && $('input[type="checkbox"]', field).is(':checked')){
                    form_builder[field_id] = [];
                    $('input[type="checkbox"]:checked',field).each(function(){
                        form_builder[field_id].push($(this).val());
                    });
                }
                if(field.hasClass('fat-sb-radio-group') && $('input[type="radio"]', field).is(':checked')){
                    form_builder[field_id] = $('input[type="radio"]:checked',field).val();
                }

                if(field.hasClass('fat-sb-date-field')){
                    form_builder[field_id] = field.attr('data-date');
                }

                if(!field.hasClass('fat-sb-date-field') && !field.hasClass('fat-sb-radio-group') && !field.hasClass('fat-sb-checkbox-group')){
                    form_builder[field_id] = field.val();
                }
            });

            if(payment_method=='stripe'){
                $('button', 'form#stripe-payment-form').trigger('click');
            }else{
                FatSbMain_FE.addLoading(container, self);
                try {
                    $.ajax({
                        url: FatSbMain_FE.data.ajax_url,
                        type: 'POST',
                        data: ({
                            action: 'fat_sb_save_booking_fe',
                            s_field: FatSbMain_FE.data.ajax_s_field,
                            form_builder: form_builder,
                            data: {
                                b_service_id: service_id,
                                b_services_extra: services_extra,
                                b_loc_id: loc_id,
                                b_employee_id: employee_id,
                                b_date: date,
                                b_time: time,
                                b_customer_number: number_of_person,
                                b_coupon_code: coupon,
                                b_gateway_type: payment_method,
                                c_first_name: c_first_name,
                                c_last_name: c_last_name,
                                c_email: c_email,
                                c_phone: c_phone,
                                b_description: note
                            }
                        }),
                        success: function (response) {
                            response = $.parseJSON(response);

                            if (response.result > 0) {
                                if (payment_method == 'onsite' || payment_method == 'price-package' || (payment_method == 'paypal' && typeof response.pp_url == 'undefined')) {

                                    $('.ui.step-tab.active', container).fadeOut(function(){
                                        $(this).removeClass('active');
                                        $('.ui.step-tab[data-step="completed"]', container).fadeIn(function(){
                                            $(this).removeClass('fat-sb-hidden').addClass('active');
                                        })
                                    });

                                    $('.fat-bt-add-icalendar', container).attr('data-id',response.result);
                                    $('.fat-bt-add-google-calendar', container).attr('data-id',response.result);
                                    FatSbMain_FE.removeLoading(container, self);

                                    $.ajax({
                                        url: FatSbMain_FE.data.ajax_url,
                                        type: 'POST',
                                        data: ({
                                            action: 'fat_sb_send_booking_fe_mail',
                                            s_field: FatSbMain_FE.data.ajax_s_field,
                                            b_id: response.result,
                                        })
                                    });
                                }

                                if(payment_method=='myPOS'){
                                    var form = $(response.form);
                                    form.hide();
                                    $('body').append(form);
                                    $('form#ipcForm').submit();
                                    return;
                                }

                                if (payment_method == 'paypal' && typeof response.pp_url != 'undefined' && response.pp_url != '') {
                                    window.location.href = response.pp_url;
                                }
                            }else{
                                self.removeClass('loading');
                                FatSbMain_FE.removeLoading(container, self);
                                $('.fat-sb-error-message',container).html(response.message).removeClass('fat-sb-hidden');
                            }
                        },
                        error: function (response) {
                            FatSbMain_FE.removeLoading(container, self);
                        }
                    });
                } catch (err) {
                    FatSbMain_FE.removeLoading(container, self);
                }
            }
        }
    };

    FatSbBookingOneServiceProvider_FE.setActiveDate = function($default_date, date_wrap, is_return_set_active){
        var default_day = $default_date.getDate(),
            default_month = $default_date.getMonth(),
            default_year = $default_date.getFullYear(),
            elm_default_date = $('.datepicker--cell[data-date="' + default_day + '"][data-month="'+ default_month +'"][data-year="' + default_year + '"]');

        if(elm_default_date.hasClass('fat-slot-not-free')){
            elm_default_date = $('.datepicker--cell:not(.fat-slot-not-free):not(.-disabled-)');
            if(elm_default_date.length > 0){
                default_day = elm_default_date.attr('data-date');
                default_month = elm_default_date.attr('data-month');
                default_year = elm_default_date.attr('data-year');
                $default_date = new Date(default_year, default_month, default_day);
            }
        }
        elm_default_date = $('.datepicker--cell[data-date="' + default_day + '"][data-month="'+ default_month +'"][data-year="' + default_year + '"]');
        $('.air-date-picker', date_wrap).data('datepicker').selectDate($default_date);
        if(typeof is_return_set_active!='undefined' && is_return_set_active==1){
            FatSbBookingOneServiceProvider_FE.hasSetActiveDate = true;
        }
    };

    FatSbBookingOneServiceProvider_FE.numberOnChange = function(self){
        var container = $(self).closest('.one-service-provider');
        FatSbBookingOneServiceProvider_FE.initPayment(container);
    };

    $(document).ready(function () {
        FatSbBookingOneServiceProvider_FE.init();
    })
})(jQuery);