<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/8/2018
 * Time: 2:56 PM
 */

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

if (!class_exists('FAT_Event_Utils')) {
    class FAT_Event_Utils
    {
        function __construct()
        {

        }

        public function get_event_taxonomy($taxonomy, $args = array())
        {
            $default = array(
                'taxonomy' => $taxonomy,
                'hide_empty' => false
            );

            $terms = get_terms(array_merge($default, $args));
            $result = array();
            foreach ($terms as $term) {
                $result[$term->term_id] = $term->name;
            }
            return $result;
        }

        public function fat_dropdown_taxonomy($args)
        {
            $terms = get_terms(array(
                'taxonomy' => $args['taxonomy'],
                'hide_empty' => false
            ));
            ?>
            <select name="<?php echo esc_attr($args['name']); ?>" name="<?php echo esc_attr($args['name']); ?>"
                    class="postform">
                <option value="0" <?php echo (isset($args['selected']) && ($args['selected'] == '' || $args['selected'] == 0)) ? 'selected' : ''; ?>>
                    <?php echo esc_html($args['show_option_all']); ?>
                </option>
                <?php
                foreach ($terms as $term) { ?>
                    <option value="<?php echo esc_attr($term->term_id); ?>" <?php echo (isset($args['selected']) && $args['selected'] == $term->term_id) ? 'selected' : ''; ?>>
                        <?php echo esc_html($term->name); ?>
                    </option>
                    <?php
                }
                ?>
            </select>
            <?php
        }

        public function fat_dropdown_post_meta($args)
        {
            ?>
            <select name="<?php echo esc_attr($args['name']); ?>" name="<?php echo esc_attr($args['name']); ?>"
                    class="postform <?php echo(isset($args['class']) ? $args['class'] : ''); ?>">
                <option value="0" <?php echo (isset($args['selected']) && ($args['selected'] == '' || $args['selected'] == 0)) ? 'selected' : ''; ?>>
                    <?php echo esc_html($args['show_option_all']); ?>
                </option>
                <?php
                foreach ($args['data'] as $key => $val) { ?>
                    <option value="<?php echo esc_attr($key); ?>" <?php echo (isset($args['selected']) && $args['selected'] == $key) ? 'selected' : ''; ?>>
                        <?php echo esc_html($val); ?>
                    </option>
                    <?php
                }
                ?>
            </select>
            <?php
        }

        public static function enqueue_custom_css()
        {
            global $fat_event_custom_css;
            if (isset($fat_event_custom_css) && is_array($fat_event_custom_css)) {
                $output_custom_css = $css_path = '';
                ob_start();
                foreach ($fat_event_custom_css as $custom_css) {
                    $css_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/assets/css/frontend/custom-css.php';
                    if (file_exists($css_path)) {
                        include $css_path;
                    }
                }
                $output_custom_css .= ob_get_contents();
                ob_end_clean();
                echo sprintf('%s', $output_custom_css);
            }
        }

        public static function get_timezone_string()
        {
            // if site timezone string exists, return it
            if ($timezone = get_option('timezone_string'))
                return $timezone;

            // get UTC offset, if it isn't set then return UTC
            if (0 === ($utc_offset = get_option('gmt_offset', 0)))
                return 'UTC';

            // adjust UTC offset from hours to seconds
            $utc_offset *= 3600;

            // attempt to guess the timezone string from the UTC offset
            if ($timezone = timezone_name_from_abbr('', $utc_offset, 0)) {
                return $timezone;
            }

            // last try, guess timezone string manually
            $is_dst = date('I');

            foreach (timezone_abbreviations_list() as $abbr) {
                foreach ($abbr as $city) {
                    if ($city['dst'] == $is_dst && $city['offset'] == $utc_offset)
                        return $city['timezone_id'];
                }
            }

            // fallback to UTC
            return 'UTC';

        }

        public static function get_events($shortcode_config, &$total_found)
        {
            if (isset($shortcode_config['only_for_logged'][0]) && $shortcode_config['only_for_logged'][0] == 'yes') {
                if (!is_user_logged_in()) {
                    return array();
                }
            }
            $start_date = isset($shortcode_config['start_date']) && $shortcode_config['start_date'] ? $shortcode_config['start_date'] : '';
            $shortcode_end_date = isset($shortcode_config['end_date']) && $shortcode_config['end_date'] ? $shortcode_config['end_date'] : '';

            if (isset($shortcode_config['filter_date']) && $shortcode_config['filter_date'] != '') {
                $start_date = $shortcode_config['filter_date'] . ' 00:00';
                //$shortcode_end_date = $shortcode_config['filter_date'].' 23:59';
            }

            $shortcode_end_date = $shortcode_end_date ? new DateTime($shortcode_end_date) : '';
            $date_format = isset($shortcode_config['date_format']) && $shortcode_config['date_format'] ? $shortcode_config['date_format'] : get_option('date_format');
            $limit = isset($shortcode_config['limit']) && $shortcode_config['limit'] ? $shortcode_config['limit'] : '';
            $pagination = isset($shortcode_config['pagination']) && $shortcode_config['pagination'] ? $shortcode_config['pagination'] : 'none';
            $item_per_page = isset($shortcode_config['item_per_page']) && $shortcode_config['item_per_page'] ? $shortcode_config['item_per_page'] : 12;
            $current_page = isset($shortcode_config['current_page']) && $shortcode_config['current_page'] ? $shortcode_config['current_page'] : 1;
            $sc_open_detail = isset($shortcode_config['open_detail_type']) && $shortcode_config['open_detail_type'] ? $shortcode_config['open_detail_type'] : 'single_window';
            $name = isset($shortcode_config['name']) && $shortcode_config['name'] ? $shortcode_config['name'] : '';
            $tag = isset($shortcode_config['tag']) && $shortcode_config['tag'] ? $shortcode_config['tag'] : '';
            $data_from = isset($shortcode_config['data_from']) && $shortcode_config['data_from'] ? $shortcode_config['data_from'] : 'category';
            $event_ids = isset($shortcode_config['event_ids']) && $shortcode_config['event_ids'] ? $shortcode_config['event_ids'] : '';
            $categories = isset($shortcode_config['categories']) && $shortcode_config['categories'] ? $shortcode_config['categories'] : '';
            $locations = isset($shortcode_config['locations']) && $shortcode_config['locations'] ? $shortcode_config['locations'] : '';
            $organizers = isset($shortcode_config['organizers']) && $shortcode_config['organizers'] ? $shortcode_config['organizers'] : '';
            $include_expired_event = isset($shortcode_config['include_expired_event'][0]) && $shortcode_config['include_expired_event'][0] === '1';
            $layout = isset($shortcode_config['layout']) ? $shortcode_config['layout'] : '';
            $args = array(
                'post_type' => FAT_EVENT_POST_TYPE,
                'post_status' => 'publish',
                'nopaging' => true,
                'post_per_page' => -1,
            );

            if (isset($shortcode_config['order_by']) && $shortcode_config['order_by'] != 'start_date') {
                $args['order'] = isset($shortcode_config['order']) && $shortcode_config['order'] ? $shortcode_config['order'] : 'ASC';
                $args['orderby'] = isset($shortcode_config['order_by']) && $shortcode_config['order_by'] ? $shortcode_config['order_by'] : 'ID';
            }
            $args['tax_query'] = array('relation' => 'AND');

            if ($name !== '') {
                $args['post_title_like'] = $name;
            }

            if ($tag !== '') {
                $tags = get_terms(array(
                    'taxonomy' => FAT_EVENT_TAG_TAXONOMY,
                    'name__like' => $tag
                ));
                $ids = array();
                foreach ($tags as $t) {
                    $ids[] = $t->term_id;
                }
                $args['tax_query'][] = array(
                    'taxonomy' => FAT_EVENT_TAG_TAXONOMY,
                    'field' => 'id',
                    'terms' => $ids
                );
            }

            if ($data_from != 'category' && is_array($event_ids) && count($event_ids) > 0) {
                $args['post__in'] = $event_ids;
            } else {
                $post_in = [];
                global $wpdb;
                if ($categories !== '' && is_array($categories)) {
                    $sql = "SELECT object_id 
                            FROM {$wpdb->prefix}term_relationships AS TR
                            INNER JOIN {$wpdb->prefix}term_taxonomy AS TT
                            ON TR.term_taxonomy_id = TT.term_taxonomy_id
                            WHERE TT.taxonomy=%s AND TT.term_id IN (". implode(',',$categories). ")";
                    $sql = $wpdb->prepare($sql, FAT_EVENT_CATEGORY_TAXONOMY);
                    error_log($sql);
                    $terms = $wpdb->get_results($sql);
                    if(is_array($terms)){
                        foreach($terms as $term){
                            $post_in[] = $term->object_id;
                        }
                    }

                }
                if ($locations !== '' && is_array($locations)) {
                    $sql = "SELECT object_id 
                            FROM {$wpdb->prefix}term_relationships AS TR
                            INNER JOIN {$wpdb->prefix}term_taxonomy AS TT
                            ON TR.term_taxonomy_id = TT.term_taxonomy_id
                            WHERE TT.taxonomy=%s AND TT.term_id IN (". implode(',', $locations). ")";
                    $sql = $wpdb->prepare($sql, FAT_EVENT_LOCATION_TAXONOMY);
                    $terms = $wpdb->get_results($sql);
                    if(is_array($terms)){
                        foreach($terms as $term){
                            $post_in[] = $term->object_id;
                        }
                    }
                }
                if ($organizers !== '' && is_array($organizers)) {
                    $sql = "SELECT object_id 
                            FROM {$wpdb->prefix}term_relationships AS TR
                            INNER JOIN {$wpdb->prefix}term_taxonomy AS TT
                            ON TR.term_taxonomy_id = TT.term_taxonomy_id
                            WHERE TT.taxonomy=%s AND TT.term_id IN (".implode(',',$organizers). ")";
                    $sql = $wpdb->prepare($sql, FAT_EVENT_ORGANIZER_TAXONOMY);
                    $terms = $wpdb->get_results($sql);
                    if(is_array($terms)){
                        foreach($terms as $term){
                            $post_in[] = $term->object_id;
                        }
                    }
                }
                $args['post__in'] = $post_in;
            }


            $posts = new WP_Query($args);

            $events = array();
            $opt_date_format = FAT_EVENT_DATETIME_FORMAT;
            $event_start_date = $event_end_date = $repeat = $custom_days = $now = '';
            $post_id = $event_repeat = $repeat_interval = $date_diff = 0;
            $event_detail = array();

            $index = 1;
            $hours_start = $minutes_start = 0;
            $link_detail = '';

            $repeat_number = 1;

            $now = current_time('mysql', 0);
            $now = DateTime::createFromFormat('Y-m-d H:i:s', $now);
            if($start_date){
                $now = DateTime::createFromFormat('U',  strtotime($start_date));
            }
            $count_repeat_number = 0;
            while ($posts->have_posts()) : $posts->the_post();
                $post_id = get_the_ID();
                $event_detail = get_post_meta($post_id, 'fat-mb-event-detail', true);
                $opt_date_format = get_post_meta($post_id, 'opt_date_format', true);

                $event_start_date = isset($event_detail['start_date']) ? $event_detail['start_date'] : '';
                $event_start_date = $event_start_date ? DateTime::createFromFormat($opt_date_format . ' H:i', $event_start_date) : '';
                $event_end_date =  isset($event_detail['end_date']) ? $event_detail['end_date'] : '';
                $event_end_date =  $event_end_date ? DateTime::createFromFormat($opt_date_format . ' H:i', $event_end_date) : '';
                $event_repeat = isset($event_detail['event_repeating'][0]) && $event_detail['event_repeating'][0] == '1' ? true : false;
                $repeat = $event_repeat && isset($event_detail['repeat']) ? $event_detail['repeat'] : '';
                $repeat_interval = isset($event_detail['daily_interval']) && $event_detail['daily_interval'] ? $event_detail['daily_interval'] : 1;
                $repeat_number = isset($event_detail['repeat_event_display']) && $event_detail['repeat_event_display'] ? $event_detail['repeat_event_display'] : $repeat_number;
                $count_repeat_number = 0;
                $start_date_string = '';

                $repeat_custom_event = [];
                $sc_repeat_event = isset($shortcode_config['repeat_event']) && $shortcode_config['repeat_event'] ? $shortcode_config['repeat_event'] : 0;
                $repeat_number = $sc_repeat_event ? $sc_repeat_event : $repeat_number;
                if (($event_end_date instanceof DateTime) && ($event_start_date instanceof DateTime)) {
                    $date_diff = $event_end_date->diff($event_start_date)->days;
                    //convert link to detail
                    if (isset($event_detail['link_detail_type'])) {
                        if ($event_detail['link_detail_type'] === 'post' && $event_detail['link_detail_post']) {
                            $event_detail['link_detail'] = get_permalink($event_detail['link_detail_post']);
                        }
                        if ($event_detail['link_detail_type'] === 'page' && $event_detail['link_detail_page']) {
                            $event_detail['link_detail'] = get_permalink($event_detail['link_detail_page']);
                        }
                    }
                    if ($repeat === 'custom') {
                        $is_violate_day_off = FAT_Event_Utils::is_violate_day_off($event_start_date, $event_end_date, $post_id);
                        if (!in_array($post_id,$repeat_custom_event) && $is_violate_day_off['violate']=='0' && ($include_expired_event || $now <= $event_start_date || ($now >= $event_start_date && $now <= $event_end_date) )) {
                            if ($shortcode_end_date == '' || $event_end_date <= $shortcode_end_date) {
                                $events[] = array(
                                    'id' => $post_id,
                                    'title' => get_the_title(),
                                    'start_date' => $event_start_date,
                                    'end_date' => $event_end_date,
                                    'location' => $event_detail['location'],
                                    'main_organizer' => $event_detail['main_organizer'],
                                    'media_type' => $event_detail['media_type'],
                                    'link_video' => $event_detail['link_video'],
                                    'link_detail' => $event_detail['link_detail'] ? $event_detail['link_detail'] : get_permalink($post_id),
                                    'link_open_type' => $event_detail['link_open_type'],
                                    'open_detail_type' => $sc_open_detail,
                                    'hide_event_time' => isset($event_detail['hide_event_time'][0]) ? $event_detail['hide_event_time'][0] : '',
                                    'hide_event_end_time' => isset($event_detail['hide_event_end_time'][0]) ? $event_detail['hide_event_end_time'][0] : '',
                                    'fees' => isset($event_detail['fees']) && $event_detail['fees'] ? $event_detail['fees'] : 0,
                                    'date_format' => $date_format,
                                    'all_day_event' => isset($event_detail['all_day_event'][0]) && $event_detail['all_day_event'][0] === '1',
                                    'seats' => isset($event_detail['seats']) && $event_detail['seats'] ? $event_detail['seats'] : 0,
                                    'fees_type' => isset($event_detail['fees_type']) && $event_detail['fees_type'] ? $event_detail['fees_type'] : 'fixed',
                                    'fees_package' => isset($event_detail['fees_package']) && $event_detail['fees_package'] ? $event_detail['fees_package'] : '',
                                    'ticket_class' => isset($event_detail['ticket_class']) ? $event_detail['ticket_class'] : ''
                                );
                                /*if ($limit !== '' && $limit <= $index) {
                                    break;
                                }*/
                                if($repeat_number==1){
                                    $repeat_custom_event[] = $post_id;
                                }
                                $index++;
                            }
                        }

                        $custom_days = $event_detail['custom_days'];
                        $hours_start = $event_start_date->format('H');
                        $minutes_start = $event_start_date->format('i');

                        if (count($custom_days) > 0) {
                            for ($i = 0; $i < count($custom_days['repeat_on_date']); $i++) {
                                $repeat_on_date = $custom_days['repeat_on_date'][$i];
                                if ($repeat_on_date) {
                                    $repeat_on_date_convert = DateTime::createFromFormat($opt_date_format, $repeat_on_date);
                                    if (!($repeat_on_date_convert instanceof DateTime)) {
                                        $repeat_on_date = DateTime::createFromFormat($opt_date_format . ' H:i', $repeat_on_date);
                                        if (!($repeat_on_date instanceof DateTime)) {
                                            break;
                                        }
                                    } else {
                                        $repeat_on_date = $repeat_on_date_convert;
                                        $repeat_on_date->setTime(0, 0, 0);
                                    }
                                    if (isset($custom_days['repeat_to_date'][$i]) && $custom_days['repeat_to_date'][$i]) {
                                        //custom day difference time
                                        $repeat_to_date = DateTime::createFromFormat($opt_date_format . ' H:i', $custom_days['repeat_to_date'][$i]);
                                        if ($repeat_on_date >= $now || $repeat_to_date > $now || $include_expired_event) {
                                            $event_start_date = $repeat_on_date;
                                            $event_end_date = $repeat_to_date;

                                            $is_violate_day_off = FAT_Event_Utils::is_violate_day_off($event_start_date, $event_end_date, $post_id);
                                            if (!in_array($post_id, $repeat_custom_event) && $is_violate_day_off['violate']==0 && ($shortcode_end_date == '' || $event_end_date <= $shortcode_end_date)) {
                                                if ($event_detail['link_detail']) {
                                                    $link_detail = $event_detail['link_detail'];
                                                } else {
                                                    $link_detail = get_permalink($post_id);
                                                    $link_detail = add_query_arg(array('sd' => $event_start_date->format('U'), 'ed' => $event_end_date->format('U')), $link_detail);
                                                }
                                                $events[] = array(
                                                    'id' => $post_id,
                                                    'title' => get_the_title(),
                                                    'start_date' => $event_start_date,
                                                    'end_date' => $event_end_date,
                                                    'location' => $event_detail['location'],
                                                    'main_organizer' => $event_detail['main_organizer'],
                                                    'media_type' => $event_detail['media_type'],
                                                    'link_video' => $event_detail['link_video'],
                                                    'link_detail' => $link_detail,
                                                    'link_open_type' => $event_detail['link_open_type'],
                                                    'open_detail_type' => $sc_open_detail,
                                                    'all_day_event' => isset($event_detail['all_day_event'][0]) ? $event_detail['all_day_event'][0] : '',
                                                    'hide_event_time' => isset($event_detail['hide_event_time'][0]) ? $event_detail['hide_event_time'][0] : '',
                                                    'hide_event_end_time' => isset($event_detail['hide_event_end_time'][0]) ? $event_detail['hide_event_end_time'][0] : '',
                                                    'fees' => isset($event_detail['fees']) && $event_detail['fees'] ? $event_detail['fees'] : 0,
                                                    'seats' => isset($event_detail['seats']) && $event_detail['seats'] ? $event_detail['seats'] : 0,
                                                    'date_format' => $date_format,
                                                    'fees_type' => isset($event_detail['fees_type']) && $event_detail['fees_type'] ? $event_detail['fees_type'] : 'fixed',
                                                    'fees_package' => isset($event_detail['fees_package']) && $event_detail['fees_package'] ? $event_detail['fees_package'] : '',
                                                    'ticket_class' => isset($event_detail['ticket_class']) ? $event_detail['ticket_class'] : ''
                                                );
                                                if($repeat_number==1){
                                                    $repeat_custom_event[] = $post_id;
                                                }

                                                $index++;
                                            }
                                        }
                                    } else {
                                        // custom day have same time
                                        if ($repeat_on_date >= $now || $include_expired_event) {
                                            $date_diff = $event_start_date->diff($event_end_date);
                                            $event_start_date = $repeat_on_date->setTime($hours_start, $minutes_start, 0);

                                            $event_end_date = (clone $event_start_date);
                                            $event_end_date = $event_end_date->modify('+' . $date_diff->y . ' year');
                                            $event_end_date = $event_end_date->modify('+' . $date_diff->m . ' month');
                                            $event_end_date = $event_end_date->modify('+' . $date_diff->d . ' day');
                                            $event_end_date = $event_end_date->modify('+' . $date_diff->h . ' hours');
                                            $event_end_date = $event_end_date->modify('+' . $date_diff->i . ' minutes');

                                            $is_violate_day_off = FAT_Event_Utils::is_violate_day_off($event_start_date, $event_end_date, $post_id);
                                            if(!in_array($post_id,$repeat_custom_event) && $is_violate_day_off['violate']==0){
                                                if ($event_detail['link_detail']) {
                                                    $link_detail = $event_detail['link_detail'];
                                                } else {
                                                    $link_detail = get_permalink($post_id);
                                                    $link_detail = add_query_arg(array('sd' => $event_start_date->format('U'), 'ed' => $event_end_date->format('U')), $link_detail);
                                                }
                                                $events[] = array(
                                                    'id' => $post_id,
                                                    'title' => get_the_title(),
                                                    'start_date' => $event_start_date,
                                                    'end_date' => $event_end_date,
                                                    'location' => $event_detail['location'],
                                                    'main_organizer' => $event_detail['main_organizer'],
                                                    'media_type' => $event_detail['media_type'],
                                                    'link_video' => $event_detail['link_video'],
                                                    'link_detail' => $link_detail,
                                                    'link_open_type' => $event_detail['link_open_type'],
                                                    'open_detail_type' => $sc_open_detail,
                                                    'all_day_event' => isset($event_detail['all_day_event'][0]) ? $event_detail['all_day_event'][0] : '',
                                                    'hide_event_time' => isset($event_detail['hide_event_time'][0]) ? $event_detail['hide_event_time'][0] : '',
                                                    'hide_event_end_time' => isset($event_detail['hide_event_end_time'][0]) ? $event_detail['hide_event_end_time'][0] : '',
                                                    'fees' => isset($event_detail['fees']) && $event_detail['fees'] ? $event_detail['fees'] : 0,
                                                    'seats' => isset($event_detail['seats']) && $event_detail['seats'] ? $event_detail['seats'] : 0,
                                                    'date_format' => $date_format,
                                                    'fees_type' => isset($event_detail['fees_type']) && $event_detail['fees_type'] ? $event_detail['fees_type'] : 'fixed',
                                                    'fees_package' => isset($event_detail['fees_package']) && $event_detail['fees_package'] ? $event_detail['fees_package'] : '',
                                                    'ticket_class' => isset($event_detail['ticket_class']) ? $event_detail['ticket_class'] : ''
                                                );
                                                $index++;
                                                if($repeat_number==1){
                                                    $repeat_custom_event[] = $post_id;
                                                }
                                            }

                                        }
                                    }
                                }
                            }
                        }
                    }

                    //$repeat_interval++;
                    $count_repeat_number = 0;
                    if ($repeat !== 'daily' && $repeat !== 'weekly' && $repeat !== 'monthly' && $repeat !== 'yearly' && $repeat !== 'custom') {
                        if ($include_expired_event || $now <= $event_start_date || ($now >= $event_start_date && $now <= $event_end_date)) {
                            if ($shortcode_end_date == '' || $event_end_date <= $shortcode_end_date) {
                                $events[] = array(
                                    'id' => $post_id,
                                    'title' => get_the_title(),
                                    'start_date' => $event_start_date,
                                    'end_date' => $event_end_date,
                                    'location' => $event_detail['location'],
                                    'main_organizer' => $event_detail['main_organizer'],
                                    'media_type' => $event_detail['media_type'],
                                    'link_video' => $event_detail['link_video'],
                                    'link_detail' => $event_detail['link_detail'] ? $event_detail['link_detail'] : (get_permalink($post_id) . '?sd=' . $event_start_date->format('U') . '&ed=' . $event_end_date->format('U')),
                                    'link_open_type' => $event_detail['link_open_type'],
                                    'open_detail_type' => $sc_open_detail,
                                    'hide_event_time' => isset($event_detail['hide_event_time'][0]) ? $event_detail['hide_event_time'][0] : '',
                                    'hide_event_end_time' => isset($event_detail['hide_event_end_time'][0]) ? $event_detail['hide_event_end_time'][0] : '',
                                    'fees' => isset($event_detail['fees']) && $event_detail['fees'] ? $event_detail['fees'] : 0,
                                    'date_format' => $date_format,
                                    'all_day_event' => isset($event_detail['all_day_event'][0]) && $event_detail['all_day_event'][0] === '1',
                                    'seats' => isset($event_detail['seats']) && $event_detail['seats'] ? $event_detail['seats'] : 0,
                                    'fees_type' => isset($event_detail['fees_type']) && $event_detail['fees_type'] ? $event_detail['fees_type'] : 'fixed',
                                    'fees_package' => isset($event_detail['fees_package']) && $event_detail['fees_package'] ? $event_detail['fees_package'] : '',
                                    'ticket_class' => isset($event_detail['ticket_class']) ? $event_detail['ticket_class'] : ''
                                );
                                $index++;
                            }
                        }
                    }

                    if ($repeat === 'daily') {
                        do {
                            $is_violate_day_off = FAT_Event_Utils::is_violate_day_off($event_start_date, $event_end_date, $post_id);
                            if ($is_violate_day_off['violate']== 0 && ( $include_expired_event || $now < $event_start_date || $now < $event_end_date)) {
                                if ($shortcode_end_date == '' || $event_end_date <= $shortcode_end_date) {
                                    $events[] = array(
                                        'id' => $post_id,
                                        'title' => get_the_title(),
                                        'start_date' => $event_start_date,
                                        'end_date' => $event_end_date,
                                        'location' => $event_detail['location'],
                                        'main_organizer' => $event_detail['main_organizer'],
                                        'media_type' => $event_detail['media_type'],
                                        'link_video' => $event_detail['link_video'],
                                        'link_detail' => $event_detail['link_detail'] ? $event_detail['link_detail'] : (get_permalink($post_id) . '?sd=' . $event_start_date->format('U') . '&ed=' . $event_end_date->format('U')),
                                        'link_open_type' => $event_detail['link_open_type'],
                                        'open_detail_type' => $sc_open_detail,
                                        'hide_event_time' => isset($event_detail['hide_event_time'][0]) ? $event_detail['hide_event_time'][0] : '',
                                        'hide_event_end_time' => isset($event_detail['hide_event_end_time'][0]) ? $event_detail['hide_event_end_time'][0] : '',
                                        'fees' => isset($event_detail['fees']) && $event_detail['fees'] ? $event_detail['fees'] : 0,
                                        'date_format' => $date_format,
                                        'all_day_event' => isset($event_detail['all_day_event'][0]) && $event_detail['all_day_event'][0] === '1',
                                        'seats' => isset($event_detail['seats']) && $event_detail['seats'] ? $event_detail['seats'] : 0,
                                        'fees_type' => isset($event_detail['fees_type']) && $event_detail['fees_type'] ? $event_detail['fees_type'] : 'fixed',
                                        'fees_package' => isset($event_detail['fees_package']) && $event_detail['fees_package'] ? $event_detail['fees_package'] : '',
                                        'ticket_class' => isset($event_detail['ticket_class']) ? $event_detail['ticket_class'] : ''
                                    );
                                    $index++;
                                }
                                if ($now < $event_start_date || $now < $event_end_date) {
                                    $count_repeat_number++;
                                }
                            }
                            $start_date_string = $event_end_date->format('d/m/Y ') . $event_start_date->format('H:i');
                            $event_start_date = DateTime::createFromFormat('d/m/Y H:i', $start_date_string);
                            $event_end_date = (clone $event_end_date);
                            $event_start_date = $event_start_date->modify('+' . $repeat_interval . ' day');
                            $event_end_date = $event_end_date->modify('+' . ($repeat_interval + $date_diff) . ' day');

                        } while ($event_end_date < $now || $count_repeat_number < $repeat_number);
                    }

                    if ($repeat === 'weekly') {
                        do {
                            $is_violate_day_off = FAT_Event_Utils::is_violate_day_off($event_start_date, $event_end_date, $post_id);
                            if ($is_violate_day_off['violate']==0 && ($include_expired_event || $now < $event_start_date || $now < $event_end_date) ){
                                if ($shortcode_end_date == '' || $event_end_date <= $shortcode_end_date) {
                                    $events[] = array(
                                        'id' => $post_id,
                                        'title' => get_the_title(),
                                        'start_date' => $event_start_date,
                                        'end_date' => $event_end_date,
                                        'location' => $event_detail['location'],
                                        'main_organizer' => $event_detail['main_organizer'],
                                        'media_type' => $event_detail['media_type'],
                                        'link_video' => $event_detail['link_video'],
                                        'link_detail' => $event_detail['link_detail'] ? $event_detail['link_detail'] : (get_permalink($post_id) . '?sd=' . $event_start_date->format('U') . '&ed=' . $event_end_date->format('U')),
                                        'link_open_type' => $event_detail['link_open_type'],
                                        'open_detail_type' => $sc_open_detail,
                                        'hide_event_time' => isset($event_detail['hide_event_time'][0]) ? $event_detail['hide_event_time'][0] : '',
                                        'hide_event_end_time' => isset($event_detail['hide_event_end_time'][0]) ? $event_detail['hide_event_end_time'][0] : '',
                                        'fees' => isset($event_detail['fees']) && $event_detail['fees'] ? $event_detail['fees'] : 0,
                                        'date_format' => $date_format,
                                        'all_day_event' => isset($event_detail['all_day_event'][0]) && $event_detail['all_day_event'][0] === '1',
                                        'seats' => isset($event_detail['seats']) && $event_detail['seats'] ? $event_detail['seats'] : 0,
                                        'fees_type' => isset($event_detail['fees_type']) && $event_detail['fees_type'] ? $event_detail['fees_type'] : 'fixed',
                                        'fees_package' => isset($event_detail['fees_package']) && $event_detail['fees_package'] ? $event_detail['fees_package'] : '',
                                        'ticket_class' => isset($event_detail['ticket_class']) ? $event_detail['ticket_class'] : ''
                                    );
                                    $index++;
                                }
                                if ($now < $event_start_date || $now < $event_end_date) {
                                    $count_repeat_number++;
                                }

                            }
                            $start_date_string = $event_end_date->format('d/m/Y ') . $event_start_date->format('H:i');
                            $event_start_date = DateTime::createFromFormat('d/m/Y H:i', $start_date_string);
                            $event_end_date = (clone $event_end_date);
                            $event_start_date = $event_start_date->modify('+7 day');
                            $event_end_date = $event_end_date->modify('+7 day');

                        } while ($event_end_date < $now || $count_repeat_number < $repeat_number);
                    }

                    if ($repeat === 'monthly') {
                        do {
                            $is_violate_day_off = FAT_Event_Utils::is_violate_day_off($event_start_date, $event_end_date, $post_id);

                            if ($is_violate_day_off['violate']==0 && ( $include_expired_event || $now < $event_start_date || $now < $event_end_date) ) {
                                if ($shortcode_end_date == '' || $event_end_date <= $shortcode_end_date) {
                                    $events[] = array(
                                        'id' => $post_id,
                                        'title' => get_the_title(),
                                        'start_date' => $event_start_date,
                                        'end_date' => $event_end_date,
                                        'location' => $event_detail['location'],
                                        'main_organizer' => $event_detail['main_organizer'],
                                        'media_type' => $event_detail['media_type'],
                                        'link_video' => $event_detail['link_video'],
                                        'link_detail' => $event_detail['link_detail'] ? $event_detail['link_detail'] : (get_permalink($post_id) . '?sd=' . $event_start_date->format('U') . '&ed=' . $event_end_date->format('U')),
                                        'link_open_type' => $event_detail['link_open_type'],
                                        'open_detail_type' => $sc_open_detail,
                                        'hide_event_time' => isset($event_detail['hide_event_time'][0]) ? $event_detail['hide_event_time'][0] : '',
                                        'hide_event_end_time' => isset($event_detail['hide_event_end_time'][0]) ? $event_detail['hide_event_end_time'][0] : '',
                                        'fees' => isset($event_detail['fees']) && $event_detail['fees'] ? $event_detail['fees'] : 0,
                                        'date_format' => $date_format,
                                        'all_day_event' => isset($event_detail['all_day_event'][0]) && $event_detail['all_day_event'][0] === '1',
                                        'seats' => isset($event_detail['seats']) && $event_detail['seats'] ? $event_detail['seats'] : 0,
                                        'fees_type' => isset($event_detail['fees_type']) && $event_detail['fees_type'] ? $event_detail['fees_type'] : 'fixed',
                                        'fees_package' => isset($event_detail['fees_package']) && $event_detail['fees_package'] ? $event_detail['fees_package'] : '',
                                        'ticket_class' => isset($event_detail['ticket_class']) ? $event_detail['ticket_class'] : ''
                                    );
                                    /* if ($limit !== '' && $limit <= $index) {
                                         break;
                                     }*/
                                    $index++;
                                }
                                if ($now < $event_start_date || $now < $event_end_date) {
                                    $count_repeat_number++;
                                }
                            }
                            $start_date_string = $event_end_date->format('d/m/Y ') . $event_start_date->format('H:i');
                            $event_start_date = DateTime::createFromFormat('d/m/Y H:i', $start_date_string);
                            $event_end_date = (clone $event_end_date);
                            $event_start_date = $event_start_date->modify('+1 month');
                            $event_end_date = $event_end_date->modify('+1 month');

                        } while ($event_end_date < $now || $count_repeat_number < $repeat_number);
                    }

                    if ($repeat === 'yearly') {
                        do {
                            $is_violate_day_off = FAT_Event_Utils::is_violate_day_off($event_start_date, $event_end_date, $post_id);

                            if ($is_violate_day_off['violate']=='0' && ($include_expired_event || $now < $event_start_date || $now < $event_end_date)) {
                                if ($shortcode_end_date == '' || $event_end_date <= $shortcode_end_date) {
                                    $events[] = array(
                                        'id' => $post_id,
                                        'title' => get_the_title(),
                                        'start_date' => $event_start_date,
                                        'end_date' => $event_end_date,
                                        'location' => $event_detail['location'],
                                        'main_organizer' => $event_detail['main_organizer'],
                                        'media_type' => $event_detail['media_type'],
                                        'link_video' => $event_detail['link_video'],
                                        'link_detail' => $event_detail['link_detail'] ? $event_detail['link_detail'] : (get_permalink($post_id) . '?sd=' . $event_start_date->format('U') . '&ed=' . $event_end_date->format('U')),
                                        'link_open_type' => $event_detail['link_open_type'],
                                        'open_detail_type' => $sc_open_detail,
                                        'hide_event_time' => isset($event_detail['hide_event_time'][0]) ? $event_detail['hide_event_time'][0] : '',
                                        'hide_event_end_time' => isset($event_detail['hide_event_end_time'][0]) ? $event_detail['hide_event_end_time'][0] : '',
                                        'fees' => isset($event_detail['fees']) && $event_detail['fees'] ? $event_detail['fees'] : 0,
                                        'date_format' => $date_format,
                                        'all_day_event' => isset($event_detail['all_day_event'][0]) && $event_detail['all_day_event'][0] === '1',
                                        'seats' => isset($event_detail['seats']) && $event_detail['seats'] ? $event_detail['seats'] : 0,
                                        'fees_type' => isset($event_detail['fees_type']) && $event_detail['fees_type'] ? $event_detail['fees_type'] : 'fixed',
                                        'fees_package' => isset($event_detail['fees_package']) && $event_detail['fees_package'] ? $event_detail['fees_package'] : '',
                                        'ticket_class' => isset($event_detail['ticket_class']) ? $event_detail['ticket_class'] : ''
                                    );
                                    /*if ($limit !== '' && $limit <= $index) {
                                        break;
                                    }*/
                                    $index++;
                                }
                                if ($now < $event_start_date || $now < $event_end_date) {
                                    $count_repeat_number++;
                                }
                            }
                            $start_date_string = $event_end_date->format('d/m/Y ') . $event_start_date->format('H:i');
                            $event_start_date = DateTime::createFromFormat('d/m/Y H:i', $start_date_string);
                            $event_end_date = (clone $event_end_date);
                            $event_start_date = $event_start_date->modify('+1 year');
                            $event_end_date = $event_end_date->modify('+1 year');

                        } while ($event_end_date < $now || $count_repeat_number < $repeat_number);
                    }
                }

            endwhile;
            wp_reset_postdata();
            if (isset($shortcode_config['order_by']) && $shortcode_config['order_by'] === 'start_date') {
                if (!isset($shortcode_config['order']) || $shortcode_config['order'] !== 'DESC') {
                    usort($events, 'FAT_Event_Utils::sortByDate');
                } else {
                    usort($events, 'FAT_Event_Utils::sortByDateDESC');
                }
            }
            if ($limit) {
                $events = array_slice($events, 0, $limit);
            }

            if (isset($total_found)) {
                $total_found = count($events);
            }

            if ($limit) {
                $total_found = $limit > $total_found ? $total_found : $limit;
            }
            if ($pagination !== 'none' && $layout != 'map' && $layout != 'countdown' && $layout != 'table') {
                $events = array_slice($events, ($item_per_page * ($current_page - 1)), $item_per_page);
            }
            return $events;
        }

        public static function get_thumbnail_image($post_id, $width, $height)
        {
            $thumb_id = get_post_thumbnail_id($post_id);
            if (function_exists('fat_event_matthewruddy_image_resize_id')) {
                $resize = fat_event_matthewruddy_image_resize_id($thumb_id, $width, $height);
                return is_array($resize) && isset($resize['url']) ? $resize['url'] : wp_get_attachment_image_url($thumb_id, 'full');
            } else {
                return wp_get_attachment_image_url($thumb_id, 'full');
            }
        }

        public static function get_thumbnail_image_masonry($post_id, &$width, &$height)
        {
            $thumb_id = get_post_thumbnail_id($post_id);
            if (function_exists('fat_resize_constrain')) {
                $resize = fat_resize_constrain($thumb_id, $width, $height, false);
                return is_array($resize) && isset($resize['url']) ? $resize['url'] : wp_get_attachment_image_url($thumb_id, 'full');
            } else {
                return wp_get_attachment_image_url($thumb_id, 'full');
            }
        }

        public static function get_location_title($location_id, $split)
        {
            $location = get_term_by('id', $location_id, FAT_EVENT_LOCATION_TAXONOMY);
            if (isset($location->name)) {
                $location->name = '<span class="loc-name">'.$location->name. $split.'</span><span class="loc-address">'  . get_term_meta($location_id, 'fat-mb-location-detail', true)['address'].'</span>';
                return trim($location->name, $split);
            }
            return '';
        }

        public static function get_location_name($location_id)
        {
            $location = get_term_by('id', $location_id, FAT_EVENT_LOCATION_TAXONOMY);
            if (isset($location->name)) {
                return $location->name;
            }
            return '';
        }

        public static function get_organizer($organizer_id, $split)
        {
            $organizer = get_term_by('id', $organizer_id, FAT_EVENT_ORGANIZER_TAXONOMY);
            if (isset($organizer->name)) {
                return $organizer->name;
            }
            return '';
        }

        public static function get_location_organizer($event_id)
        {
            $event_detail = get_post_meta($event_id, 'fat-mb-event-detail', true);
            $multiple_location = isset($event_detail['multiple_location']) ? $event_detail['multiple_location'] : 'no';
            $organizer = array();
            $location = array();
            if ($multiple_location != 'yes') {
                $organizer[] = isset($event_detail['main_organizer']) ? $event_detail['main_organizer'] : '';
                $location[] = isset($event_detail['location']) ? $event_detail['location'] : '';
            } else {
                $hourly_schedule = isset($event_detail['schedule']) ? $event_detail['schedule'] : '';
                if (is_array($hourly_schedule) && is_countable($hourly_schedule['from']) && count($hourly_schedule['from']) > 0 && $hourly_schedule['from'][0]) {
                    for ($i = 0; $i < count($hourly_schedule['from']); $i++) {
                        $location[] = isset($hourly_schedule['location'][$i]) && $hourly_schedule['location'][$i]!='hide' ? $hourly_schedule['location'][$i] : '';
                        $organizer[] = isset($hourly_schedule['organizer'][$i]) && $hourly_schedule['location'][$i]!='hide' ? $hourly_schedule['organizer'][$i] : '';
                    }
                }
            }
            return array(
                'organizer' => implode(',', $organizer),
                'location' => implode(',', $location)
            );

        }

        public static function get_event_tags($event_id)
        {
            $tags = get_the_terms($event_id, FAT_EVENT_TAG_TAXONOMY);
            $result = '';
            if (isset($tags) && is_array($tags)) {
                foreach ($tags as $tag) {
                    $result .= $result == '' ? (' #' . $tag->name) : (', #' . $tag->name);
                }
            }
            return $result;
        }

        public static function sortByDate($a, $b)
        {
            if ($a['start_date'] == $b['start_date']) {
                return 0;
            }
            return ($a['start_date'] < $b['start_date']) ? -1 : 1;
        }

        public static function sortByDateDESC($a, $b)
        {
            if ($a['start_date'] == $b['start_date']) {
                return 0;
            }
            return ($a['start_date'] > $b['start_date']) ? -1 : 1;
        }

        public static function color_luminance($hex, $percent)
        {

            // validate hex string
            $hex = preg_replace('/[^0-9a-f]/i', '', $hex);
            $new_hex = '#';

            if (strlen($hex) < 6) {
                $hex = $hex[0] + $hex[0] + $hex[1] + $hex[1] + $hex[2] + $hex[2];
            }

            // convert to decimal and change luminosity
            for ($i = 0; $i < 3; $i++) {
                $dec = hexdec(substr($hex, $i * 2, 2));
                $dec = min(max(0, $dec + $dec * $percent), 255);
                $new_hex .= str_pad(dechex($dec), 2, 0, STR_PAD_LEFT);
            }

            return $new_hex;
        }

        public static function addProduct($event_id, $price)
        {
            $title = get_the_title($event_id);
            $post = array(
                'post_content' => '',
                'post_status' => "draft",
                'post_title' => $title,
                'post_parent' => '',
                'post_type' => "product",
            );
            $attach_id = has_post_thumbnail($event_id) ? get_post_thumbnail_id($event_id) : '';
            $post_id = wp_insert_post($post);

            if ($post_id instanceof WP_Error) {
                return -1;
            }

            if ($attach_id) {
                add_post_meta($post_id, '_thumbnail_id', $attach_id);
            }

            wp_set_object_terms($post_id, 'simple', 'product_type');
            update_post_meta($post_id, '_visibility', 'visible');
            update_post_meta($post_id, '_stock_status', 'instock');
            update_post_meta($post_id, '_downloadable', 'no');
            update_post_meta($post_id, '_regular_price', $price);
            update_post_meta($post_id, '_price', $price);
            update_post_meta($post_id, '_event_id', $event_id);
            update_post_meta($post_id, '_event_product_id', $event_id.'_'.$price);
            return $post_id;
        }

        public static function enqueue_google_font()
        {
            $fat_event_setting = get_option('fat_event_setting');
            if (isset($fat_event_setting['use_google_font'][0]) && $fat_event_setting['use_google_font'][0] === '1') {
                $fonts = array('event_title_font', 'location_font', 'date_time_font', 'description_font');
                $font_name = $link_font = $handler = $font_weight = '';
                $link_fonts = array();
                foreach ($fonts as $font) {
                    if (isset($fat_event_setting[$font]['font_family']) && $fat_event_setting[$font]['font_family'] !== '' && $fat_event_setting[$font]['font_family'] !== 'none') {
                        $font_name = $fat_event_setting[$font]['font_family'];
                        $handler = 'google_font_' . str_replace(' ', '_', $font_name);
                        $font_weight = '300,300i,400,400i,500,500i,600,600i,700,700i,800,800i';
                        if ('off' !== _x('on', 'Google font: on or off', 'cronus')) {
                            $font_name = str_replace('+', ' ', $font_name);
                            $link_font = add_query_arg('family', urlencode($font_name . ':' . $font_weight), "//fonts.googleapis.com/css");

                            wp_enqueue_style($handler, $link_font, array(), false);
                        }
                    }
                }
                ob_start();
                $custom_font_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/assets/css/frontend/custom-font.php';
                if (file_exists($custom_font_path)) {
                    include_once $custom_font_path;
                }
                $output_font_css = ob_get_contents();
                ob_end_clean();
                echo sprintf('%s', $output_font_css);
            }
        }

        public function get_coupon($coupon_code, $currency, $total_spend, $symbol_position, $event_id)
        {

            $fat_event_setting = get_option('fat_event_setting');
            if (isset($fat_event_setting['enable_coupon'][0]) && $fat_event_setting['enable_coupon'][0] != '1') {
                return array(
                    'code' => -1,
                    'message' => esc_html__('The coupon have been disabled', 'fat-event'),
                );
            }
            $args = array(
                'post_type' => FAT_EVENT_COUPON_POST_TYPE,
                'post_status' => 'publish',
                'nopaging' => true,
                'post_per_page' => -1
            );
            $coupons = get_posts($args);
            $coupon_id = 0;
            foreach ($coupons as $coupon) {
                if ($coupon->post_title === $coupon_code) {
                    $coupon_id = $coupon->ID;
                    break;
                }
            }
            if ($coupon_id > 0) {
                $coupon_detail = get_post_meta($coupon_id, 'fat-mb-event-coupon-detail', true);
                $expiry_date = get_post_meta($coupon_id, 'fat_event_expiry_date', true);

                if ($expiry_date) {
                    $expiry_date = DateTime::createFromFormat('U', $expiry_date);
                    $now = new DateTime();
                    if ($expiry_date < $now) {
                        return array(
                            'code' => -1,
                            'message' => esc_html__('The coupon code has expired', 'fat-event'),
                        );
                    }
                }

                $minimum_spend = isset($coupon_detail['minimum_spend']) && $coupon_detail['minimum_spend'] ? $coupon_detail['minimum_spend'] : 0;
                $maximum_spend = isset($coupon_detail['maximum_spend']) && $coupon_detail['maximum_spend'] ? $coupon_detail['maximum_spend'] : 0;

                if ($minimum_spend > 0 && $total_spend < $minimum_spend) {
                    return array(
                        'code' => -1,
                        'message' => esc_html__('The coupon code only apply for order what have total spend > ' . $minimum_spend . $currency, 'fat-event'),
                    );
                }

                if ($maximum_spend > 0 && $total_spend > $maximum_spend) {
                    return array(
                        'code' => -1,
                        'message' => esc_html__('The coupon code only apply for order what have total spend < ' . $maximum_spend . $currency, 'fat-event'),
                    );
                }
                $times_use = isset($coupon_detail['times_use']) && $coupon_detail['times_use'] ? $coupon_detail['times_use'] : 0;
                if ($times_use > 0) {
                    $used = get_post_meta($coupon_id, 'fat_event_coupon_used', true);
                    if (is_array($used) && isset($used[0][0])) {
                        update_post_meta($coupon_id, 'fat_event_coupon_used', $used[0][0]);
                    }
                    if ($used && $used >= $times_use) {
                        return array(
                            'code' => -1,
                            'message' => esc_html__('The coupon has exceeded the number of times used', 'fat-event'),
                        );
                    }
                }

                $apply_events = isset($coupon_detail['apply_events']) && $coupon_detail['apply_events'] ? $coupon_detail['apply_events'] : '';
                if ($apply_events && is_array($apply_events) && !in_array($event_id, $apply_events)) {
                    return array(
                        'code' => -1,
                        'message' => esc_html__('The coupon does not apply to this event', 'fat-event'),
                    );
                }

                $exclude_events = isset($coupon_detail['exclude_events']) && $coupon_detail['exclude_events'] ? $coupon_detail['exclude_events'] : '';
                if ($exclude_events && is_array($exclude_events) && in_array($event_id, $exclude_events)) {
                    return array(
                        'code' => -1,
                        'message' => esc_html__('The coupon does not apply to this event', 'fat-event'),
                    );
                }

                $discount_message = esc_html__('Discount: ', 'fat-event') . $coupon_detail['amount'];
                if ($coupon_detail['discount_type'] == 'percentage') {
                    $discount_message .= '%';
                } else {
                    $discount_message = $symbol_position == 'prefix' ? ($currency . $discount_message) : ($discount_message . $currency);
                }

                return array(
                    'code' => 1,
                    'coupon_id' => $coupon_id,
                    'discount_type' => $coupon_detail['discount_type'],
                    'amount' => $coupon_detail['amount'],
                    'discount_message' => $discount_message
                );
            } else {
                return array(
                    'code' => -1,
                    'message' => esc_html__('The coupon is not valid', 'fat-event'),
                );
            }
        }

        public static function send_email_reminder()
        {
            $fat_event_setting = get_option('fat_event_setting', array());
            $reminder_before = isset($fat_event_setting['email_reminder_before']) && $fat_event_setting['email_reminder_before'] ? $fat_event_setting['email_reminder_before'] : 1;
            global $wpdb;
            $start_ranger = current_time('mysql', 0);
            $start_ranger = DateTime::createFromFormat('Y-m-d H:i:s', $start_ranger);
            $to_ranger = (clone $start_ranger);
            $to_ranger = $to_ranger->modify('+ ' . $reminder_before . ' hour');
            $sql = "SELECT PM.post_id, PM.meta_value
                                        FROM {$wpdb->prefix}posts AS P
                                        LEFT JOIN {$wpdb->prefix}postmeta AS PM ON P.ID = PM.post_id
                                        WHERE PM.meta_key= %s AND PM.meta_value !='' AND P.post_type = %s AND P.post_status=%s
                                        AND CAST(PM.meta_value as datetime) BETWEEN %s AND %s";
            $sql = $wpdb->prepare($sql, 'start_date_string', FAT_EVENT_BOOKING_POST_TYPE, 'publish', $start_ranger->format('Y-m-d H:i:s'), $to_ranger->format('Y-m-d H:i:s'));
            $booking_info = $wpdb->get_results($sql);

            $booking_id = 0;
            $has_send_reminder = 0;
            foreach ($booking_info as $bi) {
                $booking_id = $bi->post_id;
                $has_send_reminder = get_post_meta($booking_id, 'has_send_reminder', true);
                if (!isset($has_send_reminder) || $has_send_reminder != '1') {
                    $start_date = get_post_meta($booking_id, 'start_date', true);
                    $end_date = get_post_meta($booking_id, 'end_date', true);
                    $confirm_attention = get_post_meta($booking_id, 'attention_code', true);
                    $event_id = get_post_meta($booking_id, 'event_id', true);
                    $event = get_post($event_id);
                    $booking_detail = get_post_meta($booking_id, 'fat-mb-event-booking-detail', true);

                    $firstName = $booking_detail['first_name'];
                    $lastName = $booking_detail['last_name'];
                    $phone = $booking_detail['phone'];
                    $email = $booking_detail['email'];
                    $coupon = $booking_detail['coupon'];
                    $address = $booking_detail['address'];
                    $fees = $booking_detail['price'];
                    $total_fees = $booking_detail['total_price'];
                    $department = $booking_detail['department'];
                    $company = $booking_detail['company'];
                    $discount = $booking_detail['discount'];
                    $quantity = $booking_detail['quantity'];
                    $country = $booking_detail['country'];
                    $note = $booking_detail['note'];
                    $gender = $booking_detail['gender'];
                    $ticket_name = $booking_detail['ticket_name'];

                    $currency = isset($fat_event_setting['currency']) ? $fat_event_setting['currency'] : 'USD';
                    $currency_symbol = isset($fat_event_setting['currency_symbol']) ? $fat_event_setting['currency_symbol'] : '$';
                    $currency_symbol = $currency_symbol ? $currency_symbol : $currency;

                    $date_format = get_option('date_format');
                    $date_format = strpos($date_format, 'H:i:s') === FALSE ? $date_format . ' H:i:s' : $date_format;
                    $date_format = str_replace(':s','', $date_format);

                    $event_detail = get_post_meta($event_id, 'fat-mb-event-detail', true);
                    $location_id = isset($event_detail['location']) && $event_detail['location'] ? $event_detail['location'] : 0;
                    $location = '';
                    $location_address = '';
                    if ($location_id) {
                        $location = get_term_by('id', $location_id, FAT_EVENT_LOCATION_TAXONOMY);
                        $location = $location->name;
                        $location_meta = get_term_meta($location_id, 'fat-mb-location-detail', true);
                        $location_address = isset($location_meta['address']) ? $location_meta['address'] : '';
                    }

                    $start_date = $start_date->format($date_format);
                    $end_date = $end_date->format($date_format);
                    $order_detail = '';
                    ob_start();
                    include_once untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/order/order-detail.php';
                    $order_detail = ob_get_contents();
                    ob_end_clean();

                    $email_subject = isset($fat_event_setting['email_reminder_subject']) ? $fat_event_setting['email_reminder_subject'] : '';
                    $email_content = isset($fat_event_setting['email_reminder_content']) ? $fat_event_setting['email_reminder_content'] : '';

                    // send email to client
                    $recipients = array(
                        $email => ($firstName . ' ' . $lastName)
                    );
                    FAT_Event_Utils::send_mail_notification($recipients, '', '', $email_subject, $email_content, $firstName, $lastName, $event, $start_date, $end_date, $location, $location_address, $booking_id,
                        $confirm_attention, $order_detail, $coupon, $discount, $phone, $company, $department,
                        $address, $country, $note, $quantity, $fees, $ticket_name);

                    update_post_meta($booking_id, 'has_send_reminder', 1);

                }

            }
        }

        public static function send_mail_notification($email, $cc, $bcc, $email_subject, $email_content, $firstName, $lastName, $event, $start_date, $end_date, $location, $location_address, $booking_id, $confirm_attention, $order_detail = '', $coupon_code = '', $discount = 0, $phone = '', $company = '', $department = '', $address = '', $country = '', $note = '', $quantity = '', $fees = 0, $total_price = '', $ticket_name='', $email_client = '')
        {
            $fat_event_setting = get_option('fat_event_setting');
            $currency = isset($fat_event_setting['currency_symbol']) && $fat_event_setting['currency_symbol'] ? $fat_event_setting['currency_symbol'] : '$';
            $prefix_symbol = isset($fat_event_setting['symbol_position']) && $fat_event_setting['symbol_position'] == 'prefix' ? $currency : '';
            $suffix_symbol = $prefix_symbol ? '' : $currency;
            $currency_symbol = $currency;
            $total_fees = $total_price;
            $link_confirm = home_url('/');
            $link_confirm = add_query_arg(array('source' => 'fat_event_confirm', 'booking_id' => $booking_id, 'code' => $confirm_attention), $link_confirm);
            error_log('link confirm:'.$link_confirm);

            //make subject
            $email_subject = str_replace('[first_name]', $firstName, $email_subject);
            $email_subject = str_replace('[last_name]', $lastName, $email_subject);
            $email_subject = str_replace('[event_name]', $event->post_title, $email_subject);
            $email_subject = str_replace('[location_address]', $location_address, $email_subject);
            $email_subject = str_replace('[location]', $location, $email_subject);

            //make body
            $email_content = preg_replace('/\n/', '<br/>', $email_content);
            $email_content = str_replace('[email]', $email_client, $email_content);
            $email_content = str_replace('[first_name]', $firstName, $email_content);
            $email_content = str_replace('[last_name]', $lastName, $email_content);
            $email_content = str_replace('[event_name]', $event->post_title, $email_content);
            $email_content = str_replace('[start_date]', $start_date, $email_content);
            $email_content = str_replace('[end_date]', $end_date, $email_content);
            $email_content = str_replace('[link_confirm]', $link_confirm, $email_content);

            $email_content = str_replace('[location]', $location, $email_content);
            $email_content = str_replace('[location_address]', $location_address, $email_content);

            $email_content = str_replace('[phone]', $phone, $email_content);
            $email_content = str_replace('[company]', $company, $email_content);
            $email_content = str_replace('[department]', $department, $email_content);
            $email_content = str_replace('[address]', $address, $email_content);
            $email_content = str_replace('[country]', $country, $email_content);
            $email_content = str_replace('[note]', $note, $email_content);
            $email_content = str_replace('[quantity]', $quantity, $email_content);
            $email_content = str_replace('[ticket_name]', $ticket_name, $email_content);
            $email_content = str_replace('[total_price]', ($prefix_symbol . $total_price . $suffix_symbol), $email_content);

            $email_address = '';
            foreach ($email as $em => $name) {
                $email_address = $email_address ? $email_address : $em;
            }

            if (isset($fat_event_setting['enable_qrcode']) && $fat_event_setting['enable_qrcode'] == '1') {
                if (!class_exists('QRcode') && !class_exists('qrstr')) {
                    include FAT_EVENT_DIR_PATH . 'libs/phpqrcode/qrlib.php';
                }
                $qrcode = esc_html__('Full name: ', 'fat-event') . $firstName . ' ' . $lastName . '. ';
                $qrcode .= esc_html__('Address: ', 'fat-event') . $address . '. ';
                $qrcode .= esc_html__('Phone: ', 'fat-event') . $phone . '. ';
                $qrcode .= esc_html__('Email: ', 'fat-event') . $email_address . '. ';
                $qrcode .= esc_html__('Company: ', 'fat-event') . $company . '. ';
                $qrcode .= esc_html__('Department: ', 'fat-event') . $department . '. ';
                $qrcode .= esc_html__('Event: ', 'fat-event') . $event->post_title . '. ';
                $qrcode .= esc_html__('Start Date: ', 'fat-event') . $start_date . '. ';
                $qrcode .= esc_html__('End Date: ', 'fat-event') . $end_date . '. ';
                $qrcode .= esc_html__('Quantity: ', 'fat-event') . $quantity . '. ';
                if ($total_price) {
                    $qrcode .= esc_html__('Total fees: ', 'fat-event') . ($prefix_symbol . $total_price . $suffix_symbol) . '. ';
                }

                $qrcode = apply_filters('fat_event_qrcode', $qrcode);

                $upload = wp_get_upload_dir();
                $upload_dir = $upload['basedir'];
                $upload_dir = $upload_dir . '/fat-qrcode';
                if (!is_dir($upload_dir)) {
                    mkdir($upload_dir, 0700);
                }
                $qrcode_file = '/' . $booking_id . '.png';
                if (!file_exists($upload_dir . $qrcode_file)) {
                    QRcode::png($qrcode, $upload_dir . $qrcode_file, QR_ECLEVEL_L, 3);
                }
                $email_content = str_replace('[qrcode]', '<div><img src="' . $upload['baseurl'] . '/fat-qrcode' . $qrcode_file . '" /></div>', $email_content);

            }

            if (isset($_REQUEST['data_form']) && $_REQUEST['data_form'] != '') {
                if (isset($data_form) && is_array($data_form)) {
                    $value = '';
                    foreach ($data_form as $k => $v) {
                        if (isset($v['name'])) {
                            $value = is_array($v['value']) ? implode(',', $v['value']) : $v['value'];
                            $email_content = str_replace('[' . $v['name'] . ']', $value, $email_content);
                        }
                    }
                }
            }

            $order_detail = '';
            ob_start();
            include_once untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/order/order-detail.php';
            $order_detail = ob_get_contents();
            ob_end_clean();
            if ($order_detail !== '') {
                $email_content = str_replace('[order_detail]', $order_detail, $email_content);
            }
            $email_content = stripslashes($email_content);

            if ($fat_event_setting['mailer'] === 'postSMTP') {
                $headers[] = 'MIME-Version: 1.0';
                $headers[] = 'Content-type: text/html; charset=utf-8';
                if ($cc) {
                    $headers[] = 'CC: ' . $cc;
                }
                if ($bcc) {
                    $headers[] = 'BCC: ' . $bcc;
                }
                wp_mail($email_address, $email_subject, $email_content, $headers);
            }

            if ($fat_event_setting['mailer'] === 'smtp') {
                if (!class_exists('PHPMailer\\PHPMailer\\Exception')) {
                    require FAT_EVENT_DIR_PATH . 'libs/PHPMailer/src/Exception.php';
                }
                if (!class_exists('PHPMailer\\PHPMailer\\PHPMailer')) {
                    require FAT_EVENT_DIR_PATH . 'libs/PHPMailer/src/PHPMailer.php';
                }
                if (!class_exists('PHPMailer\\PHPMailer\\SMTP')) {
                    require FAT_EVENT_DIR_PATH . 'libs/PHPMailer/src/SMTP.php';
                }

                if (class_exists('PHPMailer\\PHPMailer\\PHPMailer') && isset($fat_event_setting['smtp_host']) && $fat_event_setting['smtp_host'] !== ''
                    && isset($fat_event_setting['smtp_username']) && $fat_event_setting['smtp_username'] !== ''
                    && isset($fat_event_setting['smtp_password']) && $fat_event_setting['smtp_password'] !== ''
                ) {
                    $mail = new PHPMailer();
                    try {
                        $mail->SMTPDebug = 0;
                        $mail->isSMTP();
                        $mail->isHTML(true);
                        //$mail->ClearCustomHeaders();
                        $mail->CharSet = PHPMailer::CHARSET_UTF8;
                        $mail->Host = $fat_event_setting['smtp_host'];
                        $mail->SMTPAuth = true;
                        $mail->Username = $fat_event_setting['smtp_username'];
                        $mail->Password = $fat_event_setting['smtp_password'];
                        $mail->SMTPSecure = isset($fat_event_setting['encryption']) && $fat_event_setting['encryption'] ? $fat_event_setting['encryption'] : 'ssl';
                        $mail->Port = $fat_event_setting['smtp_port'];
                        if ($mail->SMTPSecure === 'ssl') {
                            $mail->SMTPOptions = array(
                                'ssl' => array(
                                    'verify_peer' => false,
                                    'verify_peer_name' => false,
                                    'allow_self_signed' => true
                                )
                            );
                        }

                        //Recipients
                        $mail->setFrom($fat_event_setting['smtp_username'], $fat_event_setting['from_name']);
                        foreach ($email as $em => $name) {
                            $mail->addAddress($em, $name);
                        }

                        if ($cc) {
                            $mail->addCC($fat_event_setting['cc_email']);
                        }
                        if ($bcc) {
                            $mail->addBCC($fat_event_setting['bcc_email']);
                        }

                        //Content
                        $mail->Subject = $email_subject;
                        $mail->Body = $email_content;


                        $mail->send();
                    } catch (Exception $err) {
                        error_log($mail->ErrorInfo);
                    }
                }
            }

            if ($fat_event_setting['mailer'] === 'default') {
                try {
                    $subject = $email_subject;
                    $message = $email_content;
                    $headers[] = 'MIME-Version: 1.0';
                    $headers[] = 'Content-type: text/html; charset=utf-8';
                    $headers[] = 'Content-Transfer-Encoding: 8bit';

                    $headers[] = 'From: ' . $fat_event_setting['from_name'] . ' <' . $fat_event_setting['from_email'] . '>';
                    if ($cc) {
                        $headers[] = 'CC: ' . $cc;
                    }
                    if ($bcc) {
                        $headers[] = 'BCC: ' . $bcc;
                    }

                    $email_address = array();
                    foreach ($email as $em => $name) {
                        $email_address[] = $em;
                    }
                    $email = implode(', ', $email_address);
                    $result = mail($email, $subject, $message, implode("\r\n", $headers));
                } catch (Exception $err) {
                    error_log(serialize($err));
                }
            }
        }

        public static function send_mail_callback($booking_id)
        {
            $has_send = get_post_meta($booking_id, 'has_send', true);
            if (!$has_send) {
                $fat_event_setting = get_option('fat_event_setting');
                $start_date = get_post_meta($booking_id, 'start_date', true);
                $end_date = get_post_meta($booking_id, 'end_date', true);
                $confirm_attention = get_post_meta($booking_id, 'attention_code', true);
                $event_id = get_post_meta($booking_id, 'event_id', true);
                $event = get_post($event_id);
                $booking_detail = get_post_meta($booking_id, 'fat-mb-event-booking-detail', true);

                $firstName = $booking_detail['first_name'];
                $lastName = $booking_detail['last_name'];
                $phone = $booking_detail['phone'];
                $email = $booking_detail['email'];
                $coupon = $booking_detail['coupon'];
                $address = isset($booking_detail['address']) ? $booking_detail['address'] : '';
                $fees = $booking_detail['price'];
                $total_fees = $booking_detail['total_price'];
                $department = isset( $booking_detail['department']) ? $booking_detail['department'] : '';
                $company = isset($booking_detail['company']) ? $booking_detail['company'] : '';
                $discount = $booking_detail['discount'];
                $quantity = $booking_detail['quantity'];
                $country = $booking_detail['country'];
                $note = isset($booking_detail['note']) ? $booking_detail['note'] : '';
                $gender = isset( $booking_detail['gender']) ? $booking_detail['gender'] : '';
                $ticket_name = isset( $booking_detail['ticket_name']) ? $booking_detail['ticket_name'] : '';

                $currency = isset($fat_event_setting['currency']) ? $fat_event_setting['currency'] : 'USD';
                $currency_symbol = isset($fat_event_setting['currency_symbol']) ? $fat_event_setting['currency_symbol'] : '$';
                $currency_symbol = $currency_symbol ? $currency_symbol : $currency;

                $date_format = get_option('date_format');
                $date_format = strpos($date_format, 'H:i:s') === FALSE ? $date_format . ' H:i:s' : $date_format;
                $date_format  = str_replace(':s','',$date_format);

                //send mail notification
                if (isset($fat_event_setting['enable_email_notification']) && $fat_event_setting['enable_email_notification'] == '1' && $start_date instanceof DateTime) {
                    $start_date = $start_date->format($date_format);
                    $end_date = $end_date->format($date_format);
                    $order_detail = '';

                    $event_detail = get_post_meta($event_id, 'fat-mb-event-detail', true);
                    $location_id = isset($event_detail['location']) && $event_detail['location'] ? $event_detail['location'] : 0;
                    $location = '';
                    $location_address = '';
                    if ($location_id) {
                        $location = get_term_by('id', $location_id, FAT_EVENT_LOCATION_TAXONOMY);
                        $location = isset($location->name) ? $location->name : '';
                        $location_meta = get_term_meta($location_id, 'fat-mb-location-detail', true);
                        $location_address = isset($location_meta['address']) ? $location_meta['address'] : '';
                    }

                    ob_start();
                    include_once untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/order/order-detail.php';
                    $order_detail = ob_get_contents();
                    ob_end_clean();
                    update_post_meta($booking_id, 'has_send', 1);

                    $email_subject = isset($fat_event_setting['email_subject']) ? $fat_event_setting['email_subject'] : '';
                    $email_content = isset($fat_event_setting['email_content']) ? $fat_event_setting['email_content'] : '';

                    // send email to client
                    $cc = isset($fat_event_setting['cc_email']) ? $fat_event_setting['cc_email'] : '';
                    $bcc = isset($fat_event_setting['bcc_email']) ? $fat_event_setting['bcc_email'] : '';
                    $recipients = array(
                        $email => $email//($firstName.' '. $lastName)
                    );
                    FAT_Event_Utils::send_mail_notification($recipients, $cc, $bcc, $email_subject, $email_content, $firstName, $lastName, $event, $start_date, $end_date, $location, $location_address, $booking_id,
                        $confirm_attention, $order_detail, $coupon, $discount, $phone, $company, $department,
                        $address, $country, $note, $quantity, $fees, $total_fees, $ticket_name, $email);

                    //send email to admin and organizer
                    $admin_email = isset($fat_event_setting['admin_email']) ? $fat_event_setting['admin_email'] : '';
                    $admin_name = isset($fat_event_setting['admin_name']) ? $fat_event_setting['admin_name'] : '';
                    $recipients = array(
                        $admin_email => $admin_name
                    );
                    $notifier_to_organizer = isset($fat_event_setting['notifier_to_organizer']) ? $fat_event_setting['notifier_to_organizer'] : '';
                    if ($notifier_to_organizer == '1') {
                        $event_detail = get_post_meta($event_id, 'fat-mb-event-detail', true);
                        $multiple_location = isset($event_detail['multiple_location']) ? $event_detail['multiple_location'] : 'no';
                        if ($multiple_location != 'yes') {
                            $organizer = isset($event_detail['main_organizer']) ? get_term_by('id', $event_detail['main_organizer'], FAT_EVENT_ORGANIZER_TAXONOMY) : '';
                            $organizer_detail = get_term_meta($event_detail['main_organizer'], 'fat-mb-organizer-detail', true);
                            if (isset($organizer_detail['email']) && $organizer_detail['email']) {
                                $recipients[$organizer_detail['email']] = isset($organizer->name) ? $organizer->name : '';
                            }
                        }
                    }

                    if ($admin_email != '') {
                        $email_subject = isset($fat_event_setting['admin_email_subject']) ? $fat_event_setting['admin_email_subject'] : '';
                        $email_content = isset($fat_event_setting['admin_email_content']) ? $fat_event_setting['admin_email_content'] : '';

                        FAT_Event_Utils::send_mail_notification($recipients, '', '', $email_subject, $email_content, $firstName, $lastName, $event, $start_date, $end_date, $location, $location_address, $booking_id,
                            $confirm_attention, $order_detail, $coupon, $discount, $phone, $company, $department,
                            $address, $country, $note, $quantity, $fees, $total_fees, $ticket_name, $email);
                    }
                }
            }
        }

        public static function send_mail_test($email){
            $fat_event_setting = get_option('fat_event_setting');
            $email_subject = 'This is email from FAT Event';
            $email_content =  'Id timeam vocibus qui, labitur dissentiunt efficiantur vix in, at vix vivendo omittam disputationi. Nec ex adhuc tation';

            if ($fat_event_setting['mailer'] === 'postSMTP') {
                $headers[] = 'MIME-Version: 1.0';
                $headers[] = 'Content-type: text/html; charset=utf-8';
                return wp_mail($email, $email_subject, $email_content, $headers);
            }

            if ($fat_event_setting['mailer'] === 'smtp') {
                if (!class_exists('PHPMailer\\PHPMailer\\Exception')) {
                    require FAT_EVENT_DIR_PATH . 'libs/PHPMailer/src/Exception.php';
                }
                if (!class_exists('PHPMailer\\PHPMailer\\PHPMailer')) {
                    require FAT_EVENT_DIR_PATH . 'libs/PHPMailer/src/PHPMailer.php';
                }
                if (!class_exists('PHPMailer\\PHPMailer\\SMTP')) {
                    require FAT_EVENT_DIR_PATH . 'libs/PHPMailer/src/SMTP.php';
                }

                if (class_exists('PHPMailer\\PHPMailer\\PHPMailer') && isset($fat_event_setting['smtp_host']) && $fat_event_setting['smtp_host'] !== ''
                    && isset($fat_event_setting['smtp_username']) && $fat_event_setting['smtp_username'] !== ''
                    && isset($fat_event_setting['smtp_password']) && $fat_event_setting['smtp_password'] !== ''
                ) {
                    $mail = new PHPMailer();
                    try {
                        $mail->SMTPDebug = 0;
                        $mail->isSMTP();
                        $mail->isHTML(true);
                        //$mail->ClearCustomHeaders();
                        $mail->CharSet = PHPMailer::CHARSET_UTF8;
                        $mail->Host = $fat_event_setting['smtp_host'];
                        $mail->SMTPAuth = true;
                        $mail->Username = $fat_event_setting['smtp_username'];
                        $mail->Password = $fat_event_setting['smtp_password'];
                        $mail->SMTPSecure = isset($fat_event_setting['encryption']) && $fat_event_setting['encryption'] ? $fat_event_setting['encryption'] : 'ssl';
                        $mail->Port = $fat_event_setting['smtp_port'];
                        if ($mail->SMTPSecure === 'ssl') {
                            $mail->SMTPOptions = array(
                                'ssl' => array(
                                    'verify_peer' => false,
                                    'verify_peer_name' => false,
                                    'allow_self_signed' => true
                                )
                            );
                        }

                        //Recipients
                        $mail->setFrom($fat_event_setting['smtp_username'], $fat_event_setting['from_name']);
                        $mail->addAddress($email, $email_address);
                        //Content
                        $mail->Subject = $email_subject;
                        $mail->Body = $email_content;


                        return $mail->send();
                    } catch (Exception $err) {
                        error_log($mail->ErrorInfo);
                    }
                }
            }

            if ($fat_event_setting['mailer'] === 'default') {
                try {
                    $subject = $email_subject;
                    $message = $email_content;
                    $headers[] = 'MIME-Version: 1.0';
                    $headers[] = 'Content-type: text/html; charset=utf-8';
                    $headers[] = 'Content-Transfer-Encoding: 8bit';

                    $headers[] = 'From: ' . $fat_event_setting['from_name'] . ' <' . $fat_event_setting['from_email'] . '>';
                    $email_address = array();
                    $email_address[] = $email;
                    $email = implode(', ', $email_address);
                    return mail($email, $subject, $message, implode("\r\n", $headers));
                } catch (Exception $err) {
                    error_log(serialize($err));
                }
            }
        }

        public static function diff_hours($below_date, $above_date)
        {
            $below_date = strtotime($below_date->format('Y-m-d H:i:s'));
            $above_date = strtotime($above_date->format('Y-m-d H:i:s'));
            return ($above_date - $below_date) / 3600;
        }

        public static function is_violate_day_off($start_date, $end_date, $event_id = 0)
        {
            $fat_event_setting = get_option('fat_event_setting');
            if (isset($fat_event_setting['day_off'])) {
                $day_off = $fat_event_setting['day_off'];
                $total = isset($day_off['repeat_on_date']) && is_array($day_off['repeat_on_date'])  ? count($day_off['repeat_on_date']) : 0;
                $on_date = $to_date = '';
                for ($i = 0; $i < $total; $i++) {
                    $on_date = DateTime::createFromFormat('Y/m/d H:i', $day_off['repeat_on_date'][$i]);
                    $to_date = DateTime::createFromFormat('Y/m/d H:i', $day_off['repeat_to_date'][$i]);
                    if (($on_date <= $start_date && $start_date <= $to_date) || ($on_date <= $end_date && $end_date <= $to_date)) {
                        return array(
                            'violate' => 1,
                            'message' => esc_html__('You can not booking in day off from ', 'fat-event') . $on_date->format('Y-m-d H:i') . esc_html__(' to ', 'fat-event') . $to_date->format('Y-m-d H:i')
                        );
                    }
                }
            }

            $day_off = get_post_meta($event_id,'fat-mb-event-detail', true);
            if(isset($day_off['day_off'])){
                $day_off = $day_off['day_off'];
                if(isset($day_off['dof']) && is_array($day_off['dof'])){
                    $start_date = $start_date->format('Y-m-d');
                    $end_date = $end_date->format('Y-m-d');
                    foreach($day_off['dof'] as $dof){
                        $dof = explode(';',$dof);
                        if(count($dof)>=2 && ( ( strtotime($dof[0]) <= strtotime($start_date) && strtotime($start_date) <= strtotime($dof[1])) ||
                                ( strtotime($dof[0]) <= strtotime($end_date) && strtotime($end_date) <= strtotime($dof[1]) ) ) ){
                            return array(
                                'violate' => 1,
                                'message' => esc_html__('Unfortunately this event is canceled', 'fat-event')
                            );
                        }
                    }
                }
            }

            return array(
                'violate' => 0,
            );
        }

        public static function is_violate_email_blacklist($email)
        {
            $fat_event_setting = get_option('fat_event_setting');
            if (isset($fat_event_setting['day_off'])) {
                $email_blacklist = isset($fat_event_setting['email_blacklist']) && $fat_event_setting['email_blacklist'] ? $fat_event_setting['email_blacklist'] : '';
                $email_blacklist = str_replace(' ','',$email_blacklist);
                $email_blacklist = strtolower($email_blacklist);
                $email = strtolower($email);
                $email_blacklist = $email_blacklist !='' ? explode(',',$email_blacklist) : '';

                if(is_array($email_blacklist) && in_array($email,$email_blacklist)){
                    return array(
                        'violate' => 1,
                        'message' => esc_html__('You cannot pre-book using this email. Email is blacklisted','fat-event')
                    );
                }
            }
            return array(
                'violate' => 0,
            );
        }

        public static function get_seat_available($event_id, $event_start_date, $event_end_date){
            $event_detail = get_post_meta($event_id, 'fat-mb-event-detail', true);
            $seats = isset($event_detail['seats'])  ? $event_detail['seats'] : 0;
            $num_of_book = 0;
            if ($event_start_date instanceof DateTime && $event_end_date instanceof DateTime) {
                $num_of_book_key = 'num_of_book_' . $event_start_date->format('U') . '_' . $event_end_date->format('U');
            } else {
                $num_of_book_key = 'num_of_book_';
            }
            $num_of_book = get_post_meta($event_id, $num_of_book_key, true);
            $num_of_book = $num_of_book && $num_of_book != NULL ? $num_of_book : 0;
            if($seats > $num_of_book){
                return $seats - $num_of_book;
            }else{
                return 0;
            }
        }

        public static function get_seat_color($event_id, $event_start_date, $event_end_date){
            $event_detail = get_post_meta($event_id, 'fat-mb-event-detail', true);
            $event_color = get_post_meta($event_id,'fat-mb-event-color', true);
            $seats = isset($event_detail['seats'])  ? $event_detail['seats'] : 0;
            $num_of_book = 0;
            if ($event_start_date instanceof DateTime && $event_end_date instanceof DateTime) {
                $num_of_book_key = 'num_of_book_' . $event_start_date->format('U') . '_' . $event_end_date->format('U');
            } else {
                $num_of_book_key = 'num_of_book_';
            }
            $num_of_book = get_post_meta($event_id, $num_of_book_key, true);
            $num_of_book = $num_of_book && $num_of_book != NULL ? $num_of_book : 0;
            if($seats > $num_of_book){
                $number_seat_warning = isset($event_color['number_seat_warning']) && $event_color['number_seat_warning'] ? $event_color['number_seat_warning'] : 3;
                $warning_color = isset($event_color['warning_color']) && $event_color['warning_color'] ? $event_color['warning_color'] : '#ede435';
                return (($seats - $num_of_book) >= $number_seat_warning) ? $event_color['color'] : $warning_color;
            }
            return isset($event_color['disable_color']) && $event_color['disable_color'] ? $event_color['disable_color'] : '#ef1d20';
        }

        public static function update_number_of_book($booking_id){
            if($booking_id){
                $booking = get_post_meta($booking_id,'fat-mb-event-booking-detail', true);
                $quantity = isset($booking['quantity']) ? $booking['quantity'] : 0;
                if($quantity){
                    try{
                        $event_id = get_post_meta($booking_id,'event_id', true);
                        $ticket_class_id = get_post_meta($booking_id,'ticket_class_id', true);
                        $start_date = get_post_meta($booking_id,'start_date_string', true);
                        $end_date = get_post_meta($booking_id,'end_date_string', true);
                        $start_date = DateTime::createFromFormat('Y-m-d H:i:s', $start_date)->format('U');
                        $end_date = DateTime::createFromFormat('Y-m-d H:i:s', $end_date)->format('U');

                        $num_of_book_key = 'num_of_book_' . $start_date. '_' . $end_date;
                        if($ticket_class_id!=''){
                            $num_of_book_key .= '_' . $ticket_class_id;
                        }
                        $num_book = get_post_meta($event_id, $num_of_book_key, true);
                        $num_book = isset($num_book) && $num_book ? $num_book : 0;
                        $num_book += $quantity;
                        update_post_meta($event_id, $num_of_book_key, $num_book);
                    }catch(Exception $err){
                        error_log(serialize($err->getMessage()));
                    }

                }
            }
        }

        public static function get_auto_fill_info(){
            $current_user = wp_get_current_user();
            if($current_user->exists()){
                global $wpdb;
                $email =  $current_user->user_email ;
                $sql = "SELECT PM.post_id FROM {$wpdb->prefix}postmeta AS PM
                        INNER JOIN {$wpdb->prefix}posts AS P
                        ON PM.post_id = P.ID
                        WHERE P.post_type=%s AND meta_key='email' AND meta_value=%s
                        ORDER BY PM.post_id DESC LIMIT 1";
                $sql = $wpdb->prepare($sql, FAT_EVENT_BOOKING_POST_TYPE, $email);
                $booking = $wpdb->get_results($sql);
                if(is_array($booking) && count($booking)>0){
                    $booking_detail  = get_post_meta($booking[0]->post_id, 'data_form', true);
                    if(is_array($booking_detail)){
                        $data = [];
                        $data['payment_type']  = get_post_meta($booking[0]->post_id, 'payment_type', true);
                        foreach($booking_detail as $key=>$value){
                            $data[$value['name']] = $value['value'];
                        }
                        return $data;
                    }else{
                        $booking_detail = get_post_meta($booking[0]->post_id,'fat-mb-event-booking-detail', true);
                        return $booking_detail;
                    }
                }
            }
            return array();

        }

        public static function get_ticket_type(){
            global $wpdb;

            $sql = "SELECT ID FROM {$wpdb->prefix}posts WHERE post_type=%s and post_status='publish'";
            $sql = $wpdb->prepare($sql,FAT_EVENT_POST_TYPE);
            $posts = $wpdb->get_results($sql);
            $ticket_type = [];
            $mb_event_detail = [];
            $ticket_name = '';
            foreach($posts as $post){
                $mb_event_detail = get_post_meta($post->ID,'fat-mb-event-detail', true);
                if(isset($mb_event_detail['fees_type']) && $mb_event_detail['fees_type']=='ticket_class' && isset($mb_event_detail['ticket_class']) && is_array($mb_event_detail['ticket_class'])){
                    for($i=0; $i< count($mb_event_detail['ticket_class']['class']); $i++){
                        $ticket_name = trim($mb_event_detail['ticket_class']['class'][$i]);
                        $ticket_name = strtolower($ticket_name);
                        $ticket_type[$ticket_name] = ucfirst($ticket_name);
                    }
                }
            }

            return $ticket_type;
        }
    }
}