<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 7/11/2018
 * Time: 2:38 PM
 */

use Mypos\IPC\Cart;
use Mypos\IPC\Config;
use Mypos\IPC\Customer;
use Mypos\IPC\Defines;
use Mypos\IPC\IPC_Exception;
use Mypos\IPC\Purchase;
use Mypos\IPC\Response;

if (!class_exists('FAT_Event_Payment')) {
    class FAT_Event_Payment
    {
        function __construct()
        {

        }

        /**
         * Get paypal access token
         * @param $url
         * @param $postArgs
         * @return mixed
         */
        private function get_paypal_access_token($url, $postArgs)
        {

            $fat_event_setting = get_option('fat_event_setting');
            $client_id = isset($fat_event_setting['paypal_client_id']) ? $fat_event_setting['paypal_client_id'] : '';
            $secret_key = isset($fat_event_setting['paypal_secret']) ? $fat_event_setting['paypal_secret'] : '';

            if ($client_id && $secret_key) {
                $curl = curl_init($url);
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($curl, CURLOPT_USERPWD, $client_id . ":" . $secret_key);
                curl_setopt($curl, CURLOPT_HEADER, false);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, $postArgs);
                $response = curl_exec($curl);

                if (empty($response)) {
                    curl_close($curl);
                    return array(
                        'code' => -1,
                        'message' => curl_error($curl)
                    );

                } else {
                    $info = curl_getinfo($curl);
                    curl_close($curl);
                    if ($info['http_code'] != 200 && $info['http_code'] != 201) {
                        return array(
                            'code' => -1,
                            'message' => $response
                        );
                    }
                }
                $response = json_decode($response);
                return array(
                    'code' => 1,
                    'access_token' => $response->access_token
                );
            } else {
                return array(
                    'code' => -1,
                    'message' => esc_html__('Please input Paypal Client ID and Secret', 'fat-event')
                );
            }
        }

        /**
         * Execute paypal request
         * @param $url
         * @param $jsonData
         * @param $access_token
         * @return array|mixed|object
         */
        private function execute_paypal_request($url, $jsonData, $access_token)
        {
            $curl = curl_init($url);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl, CURLOPT_HEADER, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                'Authorization: Bearer ' . $access_token,
                'Accept: application/json',
                'Content-Type: application/json'
            ));

            curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData);
            $response = curl_exec($curl);
            if (empty($response)) {
                curl_close($curl);
                die(curl_error($curl));
            } else {
                $info = curl_getinfo($curl);
                curl_close($curl);
                if ($info['http_code'] != 200 && $info['http_code'] != 201) {
                    echo "Received error: " . $info['http_code'] . "\n";
                    echo "Raw response:" . $response . "\n";
                    die();
                }
            }
            $jsonResponse = json_decode($response, TRUE);
            return $jsonResponse;
        }

        public function payment($booking_id, $event_id, $quantity, $price, $total_price, $currency, $event_title, $description, $current_url)
        {

            $fat_event_setting = get_option('fat_event_setting');
            $host = isset($fat_event_setting['payment_api']) && $fat_event_setting['payment_api'] == 'live' ? 'https://api.paypal.com' : 'https://api.sandbox.paypal.com';

            $url = $host . '/v1/oauth2/token';
            $postArgs = 'grant_type=client_credentials';
            $access_token = $this->get_paypal_access_token($url, $postArgs);
            if ($access_token['code'] != 1) {
                $message = esc_html__('Cannot get access token. Please check Paypal\'s clientID and secret', 'fat-sb-booking');
                if (isset($access_token['message'])) {
                    $message = json_decode($access_token['message']);
                    $message = isset($message->error_description) ? $message->error_description : $message;
                }
                return array(
                    'result' => $access_token['code'],
                    'message' => $message
                );
            }
            $url = $host . '/v1/payments/payment';
            $cancel_link = add_query_arg(array('source' => 'fat_event_booking', 'action' => 'paypal_cancel'), $current_url);
            $return_link = add_query_arg(array('source' => 'fat_event_booking', 'action' => 'payment_return'), $current_url);

            $payment = array(
                'intent' => 'sale',
                "redirect_urls" => array(
                    "return_url" => $return_link,
                    "cancel_url" => $cancel_link
                ),
                'payer' => array("payment_method" => "paypal"),
            );

            $payment['transactions'][0] = array(
                'amount' => array(
                    'total' => number_format($total_price,2),
                    'currency' => $currency,
                    'details' => array(
                        'subtotal' => number_format($total_price,2),
                        'tax' => '0.00',
                        'shipping' => '0.00'
                    )
                ),
                'description' => $description
            );

            $payment['transactions'][0]['item_list']['items'][] = array(
                'quantity' => $quantity,
                'name' => $event_title,
                'price' => number_format($price,2),
                'currency' => $currency,
                'sku' => $event_id,
            );

            $jsonEncode = json_encode($payment);
            $json_response = $this->execute_paypal_request($url, $jsonEncode, $access_token['access_token']);
            $payment_approval_url = '';
            $payment_execute_url = '';
            foreach ($json_response['links'] as $link) {
                if ($link['rel'] == 'approval_url') {
                    $payment_approval_url = $link['href'];
                }
                if ($link['rel'] == 'execute') {
                    $payment_execute_url = $link['href'];
                }
            }

            update_post_meta($booking_id, 'paypal_execute_url', $payment_execute_url);
            update_post_meta($booking_id, 'paypal_id', $json_response['id']);
            update_post_meta($booking_id, 'paypal_approval_url', $payment_approval_url);
            update_post_meta($booking_id, 'paypal_access_token', $access_token['access_token']);
            update_post_meta($booking_id, 'paypal_result', $json_response);
            return array(
                'result' => 1,
                'approval_url' => $payment_approval_url
            );
        }

        public function payment_update_status()
        {
            if (isset($_GET['source']) && $_GET['source'] === 'fat_event_booking' && isset($_GET['token']) && isset($_GET['PayerID']) && isset($_GET['paymentId'])) {
                $paypal_id = $_GET['paymentId'];
                $payer_ID = $_GET['PayerID'];

                // validate payment status
                $fat_event_setting = get_option('fat_event_setting');
                $host = isset($fat_event_setting['payment_api']) && $fat_event_setting['payment_api'] == 'live' ? 'https://api.paypal.com' : 'https://api.sandbox.paypal.com';
                $url = $host . '/v1/oauth2/token';
                $postArgs = 'grant_type=client_credentials';
                $access_token = $this->get_paypal_access_token($url, $postArgs);
                if ($access_token['code'] != 1) {
                    return;
                }

                $url = $host . '/v1/payments/payment/' . $paypal_id;
                $curl = curl_init($url);
                curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($curl, CURLOPT_HEADER, false);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                    'Authorization: Bearer ' . $access_token['access_token'],
                    'Content-Type: application/json'
                ));
                $response = curl_exec($curl);
                if (empty($response)) {
                    curl_close($curl);
                } else {
                    $info = curl_getinfo($curl);
                    curl_close($curl);
                    if ($info['http_code'] != 200 && $info['http_code'] != 201) {
                        echo "Received error: " . $info['http_code'] . "\n";
                        echo "Raw response:" . $response . "\n";
                    }
                }
                $jsonResponse = json_decode($response, TRUE);
                if (isset($jsonResponse['state'])) {
                    global $wpdb;
                    $bookings = $wpdb->get_results('SELECT post_id FROM ' . $wpdb->prefix . 'postmeta WHERE meta_key="paypal_id" AND meta_value="' . $paypal_id . '"');
                    if (isset($bookings[0])) {

                        //execute payment
                        $jsonEncode = json_encode(array(
                            'payer_id' => $payer_ID
                        ));
                        $execute_url = get_post_meta($bookings[0]->post_id, 'paypal_execute_url', true);
                        if ($execute_url != '') {
                            $jsonResponse = $this->execute_paypal_request($execute_url, $jsonEncode, $access_token['access_token']);
                            if (isset($jsonResponse['state'])) {
                                update_post_meta($bookings[0]->post_id, 'paypal_state', $jsonResponse['state']);

                                FAT_Event_Utils::update_number_of_book($bookings[0]->post_id);
                                //send mail
                                if( $jsonResponse['state']=='approved' ||  $jsonResponse['state']=='created'){
                                    try{
                                       FAT_Event_Utils::send_mail_callback($bookings[0]->post_id);
                                    }catch(Exception $err){}
                                }
                            }
                        } else {
                            $paypal_state = get_post_meta($bookings[0]->post_id, 'paypal_state', true);
                            if ($paypal_state === '') {
                                update_post_meta($bookings[0]->post_id, 'paypal_state', $jsonResponse['state']);
                            }
                        }
                    }
                }
                global $wp;
                $url_redirect = home_url($wp->request);
                if (isset($fat_event_setting['payment_notification']) && $fat_event_setting['payment_notification'] == 'page' && $fat_event_setting['payment_page_success'] && $fat_event_setting['payment_page_error']) {
                    $redirect_page_id =$jsonResponse['state'] == 'approved' ? $fat_event_setting['payment_page_success'] : $fat_event_setting['payment_page_error'];
                    $redirect_page_id = apply_filters( 'wpml_object_id',  $redirect_page_id, 'page' );
                    $url_redirect = get_permalink($redirect_page_id);
                }
                if (isset($fat_event_setting['payment_notification']) && $fat_event_setting['payment_notification'] == 'popup') {
                    $url_redirect = $jsonResponse['state'] == 'approved' ? add_query_arg(array('fat_event_notice' => 1), $url_redirect) : add_query_arg(array('fat_event_notice' => -1), $url_redirect);
                }
                if (wp_redirect($url_redirect)) {
                    exit;
                }
            }
        }

        public function myPOS_update_status()
        {
            if (isset($_GET['source']) && $_GET['source'] === 'fat_event_booking_myPOS' && isset($_REQUEST['action']) && isset($_REQUEST['sign'])) {
                $booking_id = $_REQUEST['bid'];
                $myPOS_sign = get_post_meta($booking_id, 'myPOS_sign', true);
                $myPOS_status = get_post_meta($booking_id, 'myPOS_status', true);

                if ($myPOS_sign == $_REQUEST['sign'] && $myPOS_status == '') {
                    require_once FAT_EVENT_DIR_PATH . '/libs/myPOS/IPC/Loader.php';
                    $fat_event_setting = get_option('fat_event_setting');
                    $private_key = $fat_event_setting['myPOS_private_key'];
                    $public_key = $fat_event_setting['myPOS_public_certificate'];
                    $checkout_url = $fat_event_setting['payment_api'] == 'live' ? 'https://www.mypos.eu/vmp/checkout' : 'https://mypos.eu/vmp/checkout-test/';

                    $cnf = new Config();
                    $cnf->setIpcURL($checkout_url);
                    /*$cnf->setLang('en');*/
                    $cnf->setPrivateKey($private_key);
                    $cnf->setAPIPublicKey($public_key);
                    $cnf->setKeyIndex($fat_event_setting['myPOS_key_index']);
                    $cnf->setSid($fat_event_setting['myPOS_storeID']);
                    $cnf->setVersion('1.3');
                    $cnf->setWallet($fat_event_setting['myPOS_client_number']);

                    try {
                        $responce = Response::getInstance($cnf, $_POST, Defines::COMMUNICATION_FORMAT_POST);
                        $data = $responce->getData(CASE_LOWER);

                        global $wp;
                        $url_redirect = home_url($wp->request);
                        if ($data['ipcmethod'] === 'IPCPurchaseNotify') {
                            update_post_meta($booking_id, 'cardtoken', $data['cardtoken']);
                            update_post_meta($booking_id, 'ipc_trnref', $data['ipc_trnref']);
                            status_header(200);
                            echo 'OK';
                            exit();

                        }
                        if ($data['ipcmethod'] === 'IPCPurchaseCancel' || $data['ipcmethod'] === 'IPCPurchaseRollback') {
                            wp_delete_post($booking_id);
                            if (isset($fat_event_setting['payment_notification']) && $fat_event_setting['payment_notification'] == 'page' && $fat_event_setting['payment_page_success'] && $fat_event_setting['payment_page_error']) {
                                $redirect_page_id = apply_filters( 'wpml_object_id',   $fat_event_setting['payment_page_error'], 'page' );
                                $url_redirect = get_permalink($redirect_page_id);
                            }
                            if (isset($fat_event_setting['payment_notification']) && $fat_event_setting['payment_notification'] == 'popup') {
                                $url_redirect = add_query_arg(array('fat_event_notice' => -1), $url_redirect);
                            }
                            wp_redirect($url_redirect);
                            exit();
                        }
                        if ($data['ipcmethod'] === 'IPCPurchaseOK') {
                            update_post_meta($booking_id, 'myPOS_status', 'IPCPurchaseOK');
                            FAT_Event_Utils::update_number_of_book($booking_id);
                            try{
                                FAT_Event_Utils::send_mail_callback($booking_id);
                            }catch(Exception $err){}

                            if (isset($fat_event_setting['payment_notification']) && $fat_event_setting['payment_notification'] == 'page' && $fat_event_setting['payment_page_success'] && $fat_event_setting['payment_page_error']) {
                                $redirect_page_id = apply_filters( 'wpml_object_id',   $fat_event_setting['payment_page_success'], 'page' );
                                $url_redirect = get_permalink($redirect_page_id);
                            }
                            if (isset($fat_event_setting['payment_notification']) && $fat_event_setting['payment_notification'] == 'popup') {
                                $url_redirect = add_query_arg(array('fat_event_notice' => 1), $url_redirect);
                            }
                            wp_redirect($url_redirect);
                            exit();
                        }

                    } catch (IPC_Exception $e) {
                        error_log(serialize($e));
                    }
                }
            }
        }

        public function myPOS_payment($first_name, $last_name, $email, $phone, $address, $country, $currency, $booking_id, $quantity, $price, $discount, $event_title)
        {
            require_once FAT_EVENT_DIR_PATH . '/libs/myPOS/IPC/Loader.php';
            $fat_event_setting = get_option('fat_event_setting');
            $private_key = $fat_event_setting['myPOS_private_key'];
            $public_key = $fat_event_setting['myPOS_public_certificate'];
            $checkout_url = $fat_event_setting['payment_api'] == 'live' ? 'https://www.mypos.eu/vmp/checkout' : 'https://mypos.eu/vmp/checkout-test';

            if ($private_key && $public_key) {
                $cnf = new Config();
                $cnf->setIpcURL($checkout_url);
                $cnf->setLang('en');
                $cnf->setPrivateKey($private_key);
                $cnf->setAPIPublicKey($public_key);
                $cnf->setEncryptPublicKey($public_key);
                $cnf->setKeyIndex($fat_event_setting['myPOS_key_index']);
                $cnf->setSid($fat_event_setting['myPOS_storeID']);
                $cnf->setVersion('1.3');
                $cnf->setWallet($fat_event_setting['myPOS_client_number']);

                $customer = new Customer();
                $customer->setFirstName($first_name);
                $customer->setLastName($last_name);
                $customer->setEmail($email);
                $customer->setPhone($phone);
                $customer->setAddress($address);

                $cart = new Cart;
                $cart->add($event_title, $quantity, $price); //name, quantity, price

                $sign = uniqid('fat_event_');
                $url_cancel = home_url('/');
                $url_cancel = add_query_arg(array('source' => 'fat_event_booking_myPOS', 'action' => 'myPOS_cancel', 'bid' => $booking_id, 'sign' => $sign), $url_cancel);
                $url_ok = home_url('/');
                $url_ok = add_query_arg(array('source' => 'fat_event_booking_myPOS', 'action' => 'myPOS_ok', 'bid' => $booking_id, 'sign' => $sign), $url_ok);
                $url_notify = home_url('/');
                $url_notify = add_query_arg(array('source' => 'fat_event_booking_myPOS', 'action' => 'myPOS_notify', 'bid' => $booking_id, 'sign' => $sign), $url_notify);

                update_post_meta($booking_id, 'myPOS_sign', $sign);
                update_post_meta($booking_id, 'myPOS_status', '');

                $purchase = new Purchase($cnf);
                $purchase->setUrlCancel($url_cancel); //User comes here after purchase cancelation
                $purchase->setUrlOk($url_ok); //User comes here after purchase success
                $purchase->setUrlNotify($url_notify); //IPC sends POST reuquest to this address with purchase status
                $purchase->setOrderID('fat_event_' . $booking_id); //Some unique ID
                $purchase->setCurrency($currency);
                $purchase->setCustomer($customer);
                $purchase->setCart($cart);

                $purchase->setCardTokenRequest(Purchase::CARD_TOKEN_REQUEST_PAY_AND_STORE);
                $purchase->setPaymentParametersRequired(Purchase::PURCHASE_TYPE_FULL);
                $purchase->setPaymentMethod(Purchase::PAYMENT_METHOD_BOTH);

                try {
                    $form = $purchase->process();
                    return array(
                        'code' => $booking_id,
                        'form' => $form
                    );
                } catch (IPC_Exception $ex) {
                    error_log($ex->getMessage());
                    return json_encode(array(
                        'code' => -1,
                        'message' => $ex->getMessage()
                    ));

                }
            }
        }

        private function create_signature($post, $private_key)
        {
            $concData = base64_encode(implode('-', $post));
            $privKeyObj = openssl_get_privatekey($private_key);
            openssl_sign($concData, $signature, $privKeyObj, OPENSSL_ALGO_SHA256);
            return base64_encode($signature);
        }
    }
}