<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/12/2018
 * Time: 9:39 AM
 */

if (!function_exists('fat_event_get_gallery_callback')) {
    function fat_event_get_gallery_callback()
    {
        $event_id = isset($_REQUEST['id']) ? $_REQUEST['id'] : 0;
        if ($event_id > 0) {
            $galleries = array();
            $event_title = get_the_title($event_id);
            $event_detail = get_post_meta($event_id, 'fat-mb-event-detail', true);
            $images = $event_detail['images'];

            if ($images) {
                $args_attachment = array(
                    'orderby' => 'post__in',
                    'post__in' => explode(',', $images),
                    'post_type' => 'attachment',
                    'posts_per_page' => '-1',
                    'post_status' => 'inherit');

                $attachments = new WP_Query($args_attachment);
                global $post;

                while ($attachments->have_posts()) : $attachments->the_post();
                    $galleries[] = array(
                        'subHtml' => '<div class="fat-event-title">' . $event_title . '</div>' . $post->post_title,
                        'thumb' => $post->guid,
                        'src' => $post->guid,
                        'href' => $post->guid,
                        'downloadUrl' => $post->guid
                    );
                endwhile;
                wp_reset_postdata();
            }
            echo json_encode($galleries);
        }
        wp_die();

    }

    add_action('wp_ajax_nopriv_fat_event_get_gallery', 'fat_event_get_gallery_callback');
    add_action('wp_ajax_fat_event_get_gallery', 'fat_event_get_gallery_callback');
}

if (!function_exists('fat_event_filter_callback')) {
    function fat_event_filter_callback()
    {
        $id = isset($_REQUEST['sc_id']) ? $_REQUEST['sc_id'] : 0;
        $layout = isset($_REQUEST['layout']) ? $_REQUEST['layout'] : '';
        if ($id > 0 && $layout) {
            $shortcode_config = get_post_meta($id, 'fat-mb-event-shortcode-config', true);
            $shortcode_config['filter_date'] = isset($_REQUEST['date']) && $_REQUEST['date'] != '' ? $_REQUEST['date'] : '';
            $shortcode_config['name'] = isset($_REQUEST['name']) ? $_REQUEST['name'] : '';
            $shortcode_config['tag'] = isset($_REQUEST['tag']) ? $_REQUEST['tag'] : '';
            $shortcode_config['categories'] = isset($_REQUEST['category']) && $_REQUEST['category'] !== '' && $_REQUEST['category'] !== '0' ? array($_REQUEST['category']) : $shortcode_config['categories'];
            $shortcode_config['locations'] = isset($_REQUEST['location']) && $_REQUEST['location'] !== '' && $_REQUEST['location'] !== '0' ? array($_REQUEST['location']) : $shortcode_config['locations'];
            $shortcode_config['organizers'] = isset($_REQUEST['organizer']) && $_REQUEST['organizer'] !== '' && $_REQUEST['organizer'] !== '0' ? array($_REQUEST['organizer']) : $shortcode_config['organizers'];
            $shortcode_config['current_page'] = isset($_REQUEST['current_page']) && $_REQUEST['current_page'] ? $_REQUEST['current_page'] : 1;

            ob_start();
            $layout_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/layouts/' . $layout . '.php';
            if (file_exists($layout_path)) {
                include $layout_path;
            }
            $ret = ob_get_contents();
            ob_end_clean();
            echo $ret;
        }
        wp_die();
    }

    add_action('wp_ajax_nopriv_fat_event_filter', 'fat_event_filter_callback');
    add_action('wp_ajax_fat_event_filter', 'fat_event_filter_callback');
}

if (!function_exists('fat_event_get_timetable_callback')) {
    function fat_event_get_timetable_callback()
    {
        $sc_id = isset($_REQUEST['sc_id']) ? $_REQUEST['sc_id'] : 0;
        $month = isset($_REQUEST['month']) ? $_REQUEST['month'] : '';
        $year = isset($_REQUEST['year']) ? $_REQUEST['year'] : '';
        $data_events = array();
        if ($sc_id > 0 && $month !== '' && $year !== '') {
            $shortcode_config = get_post_meta($sc_id, 'fat-mb-event-shortcode-config', true);
            $shortcode_config['timetable_view'] = isset($_REQUEST['view']) ? $_REQUEST['view'] : $shortcode_config['timetable_view'];
            $shortcode_config['categories'] = isset($_REQUEST['sc_category']) && $_REQUEST['sc_category'] ? $_REQUEST['sc_category'] : $shortcode_config['categories'];
            $shortcode_config['organizers'] = isset($_REQUEST['sc_organizer']) && $_REQUEST['sc_organizer'] ? $_REQUEST['sc_organizer'] : $shortcode_config['organizers'];
            $shortcode_config['limit'] = '';
            $shortcode_config['pagination'] = 'none';

            $ts = strtotime($month . ' ' . $year);
            $total_found = 0;
            $events = FAT_Event_Utils::get_events($shortcode_config, $total_found);
            $bg_color = '';
            $index = 0;

            $day_off = array();
            $is_day_off = 0;
            $start_date = '';
            $end_date = '';
            $event_title = '';
            $url = '';
            foreach ($events as $event) {
                $bg_color = FAT_Event_Utils::get_seat_color($event['id'], $event['start_date'], $event['end_date']);

                $is_day_off = 0;
                $day_off = get_post_meta($event['id'],'fat-mb-event-detail', true);
                $day_off = isset($day_off['day_off']) ? $day_off['day_off'] : array();

                if(isset($day_off['dof']) && is_array($day_off['dof'])){
                    $start_date = $event['start_date']->format('Y-m-d');
                    $end_date = $event['end_date']->format('Y-m-d');
                    foreach($day_off['dof'] as $dof){
                        $dof = explode(';',$dof);
                        if(count($dof)==2 && ( ($dof[0] <= $start_date && $start_date <= $dof[1]) || ($dof[0] <= $end_date && $end_date <= $dof[1]) ) ){
                            $is_day_off = 1;
                            break;
                        }
                    }
                }
                $event_title  = $is_day_off==1 ? esc_html__('Unfortunately this event is canceled','fat-event') : get_the_title($event['id']);
                $url = get_permalink($event['id']);
                $data_events[] = array(
                    'id' => $event['id'],
                    'title' => $event_title,
                    'start' => $event['all_day_event'] ? $event['start_date']->format('Y-m-d') : $event['start_date']->format('c'),
                    'start_date' => $event['start_date']->format('Y-m-d H:i:s'),
                    'end_date' => $event['end_date']->format('Y-m-d H:i:s'),
                    'color' => $bg_color,
                    'open_type' => isset($shortcode_config['open_detail_type']) && $shortcode_config['open_detail_type'] ? $shortcode_config['open_detail_type'] : 'single_window',
                    'url' => 'javascript:;',
                    'is_day_off' => $is_day_off
                );
                if (!$event['all_day_event']) {
                    $data_events[$index]['end'] = $event['end_date']->format('c');
                }
                if ($data_events[$index]['open_type'] === 'single_window' || $data_events[$index]['open_type'] =='current_window' ) {
                    $data_events[$index]['url'] = $event['link_detail'];
                }
                if($is_day_off){
                    $data_events[$index]['url']='#';
                }
                $index++;
            }
        }
        $data_events = json_encode($data_events);
        echo $data_events;
        wp_die();
    }

    add_action('wp_ajax_nopriv_fat_event_get_timetable', 'fat_event_get_timetable_callback');
    add_action('wp_ajax_fat_event_get_timetable', 'fat_event_get_timetable_callback');
}

if (!function_exists('fat_event_get_calendar_callback')) {
    function fat_event_get_calendar_callback()
    {
        $sc_id = isset($_REQUEST['sc_id']) ? $_REQUEST['sc_id'] : 0;
        $month = isset($_REQUEST['month']) ? $_REQUEST['month'] : '';
        $year = isset($_REQUEST['year']) ? $_REQUEST['year'] : '';

        $data_events = array();
        if ($sc_id > 0 && $month !== '' && $year !== '') {
            $shortcode_config = get_post_meta($sc_id, 'fat-mb-event-shortcode-config', true);
            $shortcode_config['timetable_view'] = isset($_REQUEST['view']) ? $_REQUEST['view'] : $shortcode_config['timetable_view'];
            $ts = strtotime($month . ' ' . $year);
            $start_of_month = date('m-01-Y 00:00:00', $ts);
            $end_of_month = date('m-t-Y 12:59:59', $ts);
            $start_of_month = DateTime::createFromFormat('m-d-Y H:i:s', $start_of_month);
            $end_of_month = DateTime::createFromFormat('m-d-Y H:i:s', $end_of_month);
            $total_found = 0;
            $shortcode_config['limit'] = '';
            $shortcode_config['pagination'] = 'none';
            $events = FAT_Event_Utils::get_events($shortcode_config, $total_found);
            $bg_color = '';
            $index = 0;
            $fat_event_setting = get_option('fat_event_setting');
            $date_format = isset($shortcode_config['date_format']) ? $shortcode_config['date_format'] : get_option('date_format');
            $single_time_format = $time_format = isset($fat_event_setting['single_time_format']) ? $fat_event_setting['single_time_format'] : 'H:i';
            foreach ($events as $event) {
                $bg_color = get_post_meta($event['id'], 'fat-mb-event-color', true);
                $bg_color = isset($bg_color['color']) && $bg_color['color'] ? $bg_color['color'] : '#3a87ad';
                $data_events[] = array(
                    'id' => $event['id'],
                    'eventName' => get_the_title($event['id']),
                    'date' => $event['all_day_event'] ? $event['start_date']->format('Y-m-d') : $event['start_date']->format('c'),
                    'day' =>  intval($event['start_date']->format('d')),
                    'month' => intval($event['start_date']->format('m')),
                    'year' => intval($event['start_date']->format('Y')),
                    'data_start' => $event['start_date']->format('U'),
                    'data_end' => $event['end_date']->format('U'),
                    'color' => $bg_color,
                    'link_detail' => $event['link_detail'],
                    'open_type' => isset($shortcode_config['open_detail_type']) && $shortcode_config['open_detail_type'] ? $shortcode_config['open_detail_type'] : 'single_window',
                );
                if (!$event['all_day_event']) {
                    $data_events[$index]['end'] = $event['end_date']->format('c');
                }

                if ($event['all_day_event']) {
                    if (date_diff($event['start_date'], $event['end_date'])->d == 0) {
                        $data_events[$index]['time'] = esc_html__('All day - ', 'fat-event') . $event['start_date']->format($event['date_format']);
                        $data_events[$index]['single_time'] = $data_events[$index]['time'];
                    }
                } else {
                    if (date_diff($event['start_date'], $event['end_date'])->d == 0) {
                        $data_events[$index]['time'] = $event['start_date']->format($single_time_format) . esc_html__(' to ', 'fat-event') . $event['end_date']->format($single_time_format) . ' - ' . $event['start_date']->format($event['date_format']);
                        $data_events[$index]['single_time'] = $event['start_date']->format($single_time_format). esc_html__(' to ','fat-event'). $event['end_date']->format($single_time_format).' - '. date_i18n($date_format,$event['start_date']->format('U'));
                    } else {
                        $data_events[$index]['time'] = $event['start_date']->format($single_time_format) . ' ' . $event['start_date']->format($event['date_format']) . esc_html__(' to ', 'fat-event') . $event['end_date']->format($single_time_format) . ' ' . $event['end_date']->format($event['date_format']);
                        $data_events[$index]['single_time'] = $event['start_date']->format($single_time_format.' '). date_i18n($date_format, $event['start_date']->format('U')) . esc_html__(' to ','fat-event'). $event['end_date']->format($single_time_format. ' '). date_i18n($date_format,$event['end_date']->format('U'));
                    }
                }

                $index++;
            }
        }
        $data_events = json_encode($data_events);
        echo $data_events;
        wp_die();
    }

    add_action('wp_ajax_nopriv_fat_event_get_calendar', 'fat_event_get_calendar_callback');
    add_action('wp_ajax_fat_event_get_calendar', 'fat_event_get_calendar_callback');
}

if (!function_exists('fat_event_get_event_detail_callback')) {
    function fat_event_get_event_detail_callback()
    {
        $id = isset($_REQUEST['id']) ? $_REQUEST['id'] : 0;
        $u_start_date = isset($_REQUEST['s_date']) ? $_REQUEST['s_date'] : '';
        $u_end_date = isset($_REQUEST['e_date']) ? $_REQUEST['e_date'] : '';

        if ($id > 0) {
            $fat_event_setting = get_option('fat_event_setting');
            $post = get_post($id);
            $content = $post->post_content;
            $content = wpautop($content, true);
            $content = do_shortcode($content);
            $content = str_replace(']]>', ']]&gt;', $content);
            $thumb = '';
            $single_image_size = get_post_meta($id, 'fat-mb-event-single-image-size', true);
            $width = isset($single_image_size['single_image_width']) && $single_image_size['single_image_width'] >= 0 ? $single_image_size['single_image_width'] : 1000;
            $height = isset($single_image_size['single_image_height']) && $single_image_size['single_image_height'] >= 0 ? $single_image_size['single_image_height'] : 300;
            if (has_post_thumbnail($id)) {
                $attachment_id = get_post_thumbnail_id($id);
                if (function_exists('fat_event_matthewruddy_image_resize_id') && $width > 0 && $height > 0) {
                    $thumb = fat_event_matthewruddy_image_resize_id($attachment_id, $width, $height);
                    $thumb = !($thumb instanceof WP_Error) && isset($thumb['url']) ? $thumb['url'] : wp_get_attachment_url($attachment_id);
                } else {
                    $thumb = wp_get_attachment_url($attachment_id);
                }
            }
            $mb_event_detail = get_post_meta($id, 'fat-mb-event-detail', true);
            $multiple_location = isset($mb_event_detail['multiple_location']) ? $mb_event_detail['multiple_location'] : 'no';

            $organizers = array();
            $list_location = array();
            $map_source = isset($fat_event_setting['map_source']) ? $fat_event_setting['map_source'] : 'google';

            $latitude = get_term_meta($mb_event_detail['location'], 'fat-mb-location-detail', true);
            $latitude = isset($latitude['map']) ? $latitude['map'] : '';

            if($multiple_location!='yes'){
                $organizer = isset($mb_event_detail['main_organizer']) ? get_term_by('id', $mb_event_detail['main_organizer'], FAT_EVENT_ORGANIZER_TAXONOMY) : '';
                $organizer_detail = get_term_meta($mb_event_detail['main_organizer'], 'fat-mb-organizer-detail', true);
                $organizer_thumb = isset($organizer_detail['thumbnail']) ? $organizer_detail['thumbnail'] : '';
                if ($organizer_thumb > 0 && function_exists('fat_event_matthewruddy_image_resize_id')) {
                    $organizer_thumb = fat_event_matthewruddy_image_resize_id($organizer_thumb, 200, 200);
                    $organizer_thumb = is_array($organizer_thumb) && isset($organizer_thumb['url']) ? $organizer_thumb['url'] : wp_get_attachment_url($organizer_thumb);
                }
                $organizers[] = array(
                    'name' => $organizer->name,
                    'thumb' => $organizer_thumb,
                    'email' => isset($organizer_detail['email']) ? $organizer_detail['email'] : '',
                    'website' => isset($organizer_detail['website']) ? $organizer_detail['website'] : '',
                    'facebook' => isset($organizer_detail['facebook']) ? $organizer_detail['facebook'] : '',
                    'twitter' => isset($organizer_detail['twitter']) ? $organizer_detail['twitter'] : '',
                    'linkedin' => isset($organizer_detail['linkedin']) ? $organizer_detail['linkedin'] : '',
                    'telephone' => isset($organizer_detail['telephone']) ? $organizer_detail['telephone']: ''
                );

                $list_location[] = array(
                    'id' => $mb_event_detail['location'],
                    'location' => FAT_Event_Utils::get_location_title($mb_event_detail['location'], ', '),
                    'latitude' => $map_source=='google' ? $latitude : ''
                );
            }


            $seats = isset($mb_event_detail['enable_booking'][0]) && $mb_event_detail['enable_booking'][0] === '1' ? $mb_event_detail['seats'] : 0;
            $num_of_book = 0;
            if (isset($mb_event_detail['enable_seat_available'][0]) && $mb_event_detail['enable_seat_available'][0] === '1') {
                if ($u_start_date != '' && $u_end_date != '') {
                    $num_of_book = get_post_meta($id, 'num_of_book_' . $u_start_date . '_' . $u_end_date, true);
                    $num_of_book = $num_of_book ? $num_of_book : 0;
                }

            }

            $event_section = get_post_meta($id, 'fat-mb-event-section', true);
            $event_detail = array(
                'id' => $id,
                'title' => get_the_title($id),
                'excerpt' => $post->post_excerpt,
                'content' => $content,
                'thumb' => $thumb,
                'location' => $list_location,
                'latitude' => $latitude,
                'organizer' => $organizers,
                'enable_booking' => isset($mb_event_detail['enable_booking'][0]) && $mb_event_detail['enable_booking'][0] === '1' ? 1 : 0,
                'fees' => isset($mb_event_detail['fees']) && $mb_event_detail['fees'] ? $mb_event_detail['fees'] : 0,
                'fees_type' => isset($mb_event_detail['fees_type']) ? $mb_event_detail['fees_type'] : 'fixed',
                'seats' => $seats,
                'enable_seat_available' => isset($mb_event_detail['enable_seat_available'][0]) ? $mb_event_detail['enable_seat_available'][0] : 0,
                'seats_available' => ($seats > $num_of_book) ? ($seats - $num_of_book) : 0,
                'payment' => $mb_event_detail['payment'],
                'external_link_booking' => $mb_event_detail['payment'] == 'external_link' ? $mb_event_detail['external_link_booking'] : 'javascript:;',
                'hourly_schedule' => array(),
                'link_detail' => $mb_event_detail['link_detail'] ? $mb_event_detail['link_detail'] : get_permalink($id),
                'link_more_info' => isset($mb_event_detail['link_more_info']) ? $mb_event_detail['link_more_info'] : '',
                'label_more_info' => isset($mb_event_detail['label_more_info']) ? $mb_event_detail['label_more_info'] : '',
                'other_organizer' => array()
            );

            if($multiple_location!='yes'){
                $other_organizer = isset($event_detail['other_organizer']) ? $mb_event_detail['other_organizer'] : '';
                $organizer = $organizer_detail = $organizer_thumb = '';
                if (is_array($other_organizer)) {
                    foreach ($other_organizer as $or) {
                        $organizer = get_term_by('id', $or, FAT_EVENT_ORGANIZER_TAXONOMY);
                        $organizer_detail = get_term_meta($or, 'fat-mb-organizer-detail', true);
                        $organizer_thumb = isset($organizer_detail['thumbnail']) ? $organizer_detail['thumbnail'] : '';
                        if ($organizer_thumb > 0 && function_exists('fat_event_matthewruddy_image_resize_id')) {
                            $organizer_thumb = fat_event_matthewruddy_image_resize_id($organizer_thumb, 80, 80);
                            $organizer_thumb = is_array($organizer_thumb) && isset($organizer_thumb['url']) ? $organizer_thumb['url'] : wp_get_attachment_url($organizer_thumb);
                        }
                        $event_detail['other_organizer'][] = array(
                            'organizer_thumb' => $organizer_thumb,
                            'organizer' => $organizer->name,
                            'organizer_website' => isset($organizer_detail['website']) ? $organizer_detail['website'] : '',
                            'organizer_phone' => isset($organizer_detail['telephone']) ? $organizer_detail['telephone'] : '',
                            'organizer_mail' => isset($organizer_detail['email']) ? $organizer_detail['email'] : '',
                            'organizer_facebook' => isset($organizer_detail['facebook']) ? $organizer_detail['facebook'] : '',
                            'organizer_twitter' => isset($organizer_detail['twitter']) ? $organizer_detail['twitter'] : '',
                            'organizer_linkedin' => isset($organizer_detail['linkedin']) ? $organizer_detail['linkedin'] : ''
                        );
                    }
                }
            }

            if ($event_detail['fees_type'] == 'package') {
                if (isset($mb_event_detail['fees_package']) && is_array($mb_event_detail['fees_package'])) {
                    $event_detail['fees_package'] = array();
                    for ($i = 0; $i < count($mb_event_detail['fees_package']['quantity']); $i++) {
                        $event_detail['fees_package'][] = array(
                            'quantity' => $mb_event_detail['fees_package']['quantity'][$i],
                            'fees' => $mb_event_detail['fees_package']['fees'][$i]
                        );
                    }
                }
            }
            if ($event_detail['fees_type'] == 'ticket_class') {
                if (isset($mb_event_detail['ticket_class']) && is_array($mb_event_detail['ticket_class'])) {
                    $event_detail['ticket_class'] = array();
                    $nob_key = $nob = '';
                    for ($i = 0; $i < count($mb_event_detail['ticket_class']['seats']); $i++) {
                        $nob_key = 'num_of_book_' . $u_start_date . '_' . $u_end_date . '_' . $mb_event_detail['ticket_class']['class_id'][$i];
                        $nob_key = get_post_meta($id, $nob_key, true);
                        $nob = $nob_key ? $nob_key : 0;
                        $event_detail['ticket_class'][] = array(
                            'class_id' => $mb_event_detail['ticket_class']['class_id'][$i],
                            'class' => $mb_event_detail['ticket_class']['class'][$i],
                            'seat' => $mb_event_detail['ticket_class']['seats'][$i],
                            'fees' => $mb_event_detail['ticket_class']['fees'][$i],
                            'number_of_book' => $nob,
                            'seat_available' => ($mb_event_detail['ticket_class']['seats'][$i] - $nob) > 0 ? $mb_event_detail['ticket_class']['seats'][$i] - $nob : 0,
                            'seat_label' => esc_html__('Seat available', 'fat-event')
                        );
                    }
                    $event_detail['ticket_class_loop'] = $event_detail['ticket_class'];
                    $event_detail['ticket_class'] = json_encode($event_detail['ticket_class']);
                }
            }

            $fat_event_setting = get_option('fat_event_setting');
            $decimal = isset($fat_event_setting['currency_decimal']) && $fat_event_setting['currency_decimal'] ? $fat_event_setting['currency_decimal'] : 0;
            $separator = isset($fat_event_setting['currency_separator']) ? $fat_event_setting['currency_separator'] : ',';

            $event_detail['fees_display'] = number_format($event_detail['fees'], $decimal, '.', $separator);
            $hourly_schedule = isset($mb_event_detail['schedule']) ? $mb_event_detail['schedule'] : '';

            if (is_array($hourly_schedule) && count($hourly_schedule['from']) > 0) {
                for ($i = 0; $i < count($hourly_schedule['from']); $i++){
                    if ($multiple_location == 'yes') {
                        $location = isset($hourly_schedule['location'][$i]) ? FAT_Event_Utils::get_location_title($hourly_schedule['location'][$i], ', ') : '';
                        $latitude = get_term_meta($hourly_schedule['location'][$i], 'fat-mb-location-detail', true);

                        if(isset($hourly_schedule['organizer'][$i]) && $hourly_schedule['organizer'][$i] && $hourly_schedule['organizer'][$i]!='hide'){
                            $organizer = isset($hourly_schedule['organizer'][$i]) ? get_term_by('id', $hourly_schedule['organizer'][$i], FAT_EVENT_ORGANIZER_TAXONOMY) : '';
                            $organizer_detail = get_term_meta($hourly_schedule['organizer'][$i], 'fat-mb-organizer-detail', true);
                            $organizer_thumb = isset($organizer_detail['thumbnail']) ? $organizer_detail['thumbnail'] : '';
                            if ($organizer_thumb > 0 && function_exists('fat_event_matthewruddy_image_resize_id')) {
                                $organizer_thumb = fat_event_matthewruddy_image_resize_id($organizer_thumb, 80, 80);
                                $organizer_thumb = is_array($organizer_thumb) && isset($organizer_thumb['url']) ? $organizer_thumb['url'] : wp_get_attachment_url($organizer_thumb);
                            }
                            $event_detail['organizer'][] = array(
                                'name' => $organizer->name,
                                'thumb' => $organizer_thumb,
                                'email' => isset($organizer_detail['email']) ? $organizer_detail['email'] : '',
                                'website' => isset($organizer_detail['website']) ? $organizer_detail['website'] : '',
                                'facebook' => isset($organizer_detail['facebook']) ? $organizer_detail['facebook'] : '',
                                'twitter' => isset($organizer_detail['twitter']) ? $organizer_detail['twitter'] : '',
                                'linkedin' => isset($organizer_detail['linkedin']) ? $organizer_detail['linkedin'] : '',
                                'telephone' => isset($organizer_detail['telephone']) ? $organizer_detail['telephone']: ''
                            );
                        }
                        $event_detail['location'][] = array(
                            'id' => $hourly_schedule['location'][$i],
                            'location' => $location,
                            'latitude' => isset($latitude['map']) && $map_source=='google' ? $latitude['map'] : ''
                        );
                    }
                    $event_detail['hourly_schedule'][] = array(
                        'from' => $hourly_schedule['from'][$i],
                        'to' => $hourly_schedule['to'][$i],
                        'title' => $hourly_schedule['title'][$i],
                        'description' => $hourly_schedule['description'][$i],
                        'location' => isset($location) ? $location : '',
                        'organizer' => isset($organizer->name) ? $organizer->name : ''
                    );
                }
            }

            //Amenities
            $amenities = get_post_meta($id, 'fat-mb-event-single-amenities', true);
            $list_amenities = array();
            $amenities_setting = isset($fat_event_setting['amenities']) ? $fat_event_setting['amenities'] : '';
            $amenities_key = '';
            if(is_array($amenities)){
                foreach($amenities as $key => $value){
                    if($value){
                        for($i=0; $i< count($amenities_setting['amenities_name']); $i++){
                            $amenities_key =  strtolower($amenities_setting['amenities_name'][$i]);
                            $amenities_key = str_replace(' ','_',$amenities_key);
                            if($amenities_key == $key){
                                $list_amenities[] = array(
                                    'name' => $value[0],
                                    'icon' => $amenities_setting['amenities_icon'][$i]
                                );
                            }
                        }
                    }
                }
            }
            $event_detail['amenities'] = $list_amenities;
            $event_detail['amenities_position'] = isset($fat_event_setting['amenities_position']) ? $fat_event_setting['amenities_position'] : '';
            $event_detail['enable_woocommerce'] = isset($fat_event_setting['enable_woocommerce']) ? $fat_event_setting['enable_woocommerce'] : 0;

            $disable_booking_before = isset($mb_event_detail['disable_booking_before']) && $mb_event_detail['disable_booking_before'] ? $mb_event_detail['disable_booking_before'] : 0;
            $allow_booking_after_event_started = isset($mb_event_detail['allow_booking_after_event_started']) && $mb_event_detail['allow_booking_after_event_started'] ? $mb_event_detail['allow_booking_after_event_started'] : 0;
            if($event_detail['enable_booking']){
                $event_start_date = DateTime::createFromFormat('U',$u_start_date);
                $now = current_time('mysql',0);
                $now = DateTime::createFromFormat('Y-m-d H:i:s', $now);
                $event_detail['enable_booking'] = (FAT_Event_Utils::diff_hours($now, $event_start_date) > $disable_booking_before);
                $event_detail['enable_booking'] = $disable_booking_before ==0 && $allow_booking_after_event_started > 0 ?  (FAT_Event_Utils::diff_hours($event_start_date, $now) <= $allow_booking_after_event_started) : $event_detail['enable_booking'];
            }


            echo json_encode($event_detail);
        } else {
            echo json_encode(array());
        }
        wp_die();
    }

    add_action('wp_ajax_nopriv_fat_event_get_event_detail', 'fat_event_get_event_detail_callback');
    add_action('wp_ajax_fat_event_get_event_detail', 'fat_event_get_event_detail_callback');
}

if (!function_exists('fat_event_booking_callback')) {
    function fat_event_booking_callback()
    {
        $event_id = isset($_REQUEST['id']) && $_REQUEST['id'] ? $_REQUEST['id'] : 0;
        $start_date = isset($_REQUEST['start_date']) ? $_REQUEST['start_date'] : '';
        $location = isset($_REQUEST['location']) ? $_REQUEST['location'] : '';
        $amenities = isset($_REQUEST['amenities']) ? $_REQUEST['amenities'] : '';
        $num_of_book_key = 'num_of_book_' . $start_date;
        $start_date = DateTime::createFromFormat('U', $start_date);
        $end_date = isset($_REQUEST['end_date']) ? $_REQUEST['end_date'] : '';
        $num_of_book_key = $num_of_book_key . '_' . $end_date;
        $end_date = $end_date ? DateTime::createFromFormat('U', $end_date) : '';

        $start_date_str = $start_date->format('Y-m-d H:i:s');

        $now = current_time( 'mysql', 0);
        $now_str = $now;
        $now = DateTime::createFromFormat('Y-m-d H:i:s',$now);
        $payment_type = isset($_REQUEST['paymentType']) && $_REQUEST['paymentType'] ? $_REQUEST['paymentType'] : 'offline';

        $event_detail = get_post_meta($event_id, 'fat-mb-event-detail', true);
        $allow_booking_after_event_started = isset($event_detail['allow_booking_after_event_started']) && $event_detail['allow_booking_after_event_started'] ? $event_detail['allow_booking_after_event_started'] : 0;

        error_log('allow_booking_after_event_started:'.$allow_booking_after_event_started);
        error_log('diff alow:'.FAT_Event_Utils::diff_hours( $start_date, $now));
        if ( (strtotime($start_date_str) < strtotime($now_str) && $allow_booking_after_event_started == 0 ) ||
            ($allow_booking_after_event_started > 0 && FAT_Event_Utils::diff_hours( $start_date, $now) > $allow_booking_after_event_started)) {
            echo json_encode(array(
                'code' => -1,
                'message' => esc_html__('You cannot booking once the event has started', 'fat-event')
            ));
            wp_die();
            return;
        }

        $violate = FAT_Event_Utils::is_violate_day_off($start_date, $end_date, $event_id);
        if($violate['violate']==1){
            echo json_encode(array(
                'code' => -1,
                'message' => $violate['message']
            ));
            wp_die();
            return;
        }

        $fat_event_setting = get_option('fat_event_setting');
        $currency = isset($fat_event_setting['currency']) ? $fat_event_setting['currency'] : 'USD';
        $currency_symbol = isset($fat_event_setting['currency_symbol']) ? $fat_event_setting['currency_symbol'] : '$';
        $currency_symbol = $currency_symbol ? $currency_symbol : $currency;

        $result = array();
        $event = get_post($event_id);
        $confirm_attention = uniqid();

        $disable_booking_before = isset($event_detail['disable_booking_before']) && $event_detail['disable_booking_before'] ? $event_detail['disable_booking_before'] : 0;
        if($disable_booking_before > 0 && FAT_Event_Utils::diff_hours($now, $start_date) <= $disable_booking_before){
            $message = esc_html__('You cannot make a reservation %s hours before the event starts', 'fat-event');
            echo json_encode(array(
                'code' => -1,
                'message' => sprintf($message, $disable_booking_before)
            ));
            wp_die();
            return;
        }

        $seats = isset($event_detail['enable_booking'][0]) && $event_detail['enable_booking'][0] === '1' ? $event_detail['seats'] : 0;
        $seats = $seats !== '' ? $seats : 0;

        if (isset($event)) {
            $another_field = array();
            if (isset($_REQUEST['data_form']) && $_REQUEST['data_form'] != '') {
                $data_form = $_REQUEST['data_form'];
                $firstName = isset($data_form['firstName']['value']) ? $data_form['firstName']['value'] : '';
                $lastName = isset($data_form['lastName']['value']) ? $data_form['lastName']['value'] : '';
                $firstName = isset($data_form['first_name']['value']) ? $data_form['first_name']['value'] : $firstName;
                $lastName = isset($data_form['last_name']['value']) ? $data_form['last_name']['value'] : $lastName;

                $phone = isset($data_form['phone']['value']) ? $data_form['phone']['value'] : '';
                $email = isset($data_form['email']['value']) ? $data_form['email']['value'] : '';
                $address = isset($data_form['address']['value']) ? $data_form['address']['value'] : '';
                $gender = isset($data_form['gender']['value']) ? $data_form['gender']['value'] : '';
                $department = isset($data_form['department']['value']) ? $data_form['department']['value'] : '';
                $company = isset($data_form['company']['value']) ? $data_form['company']['value'] : '';
                $country = isset($data_form['country']['value']) ? $data_form['country']['value'] : '';
                $note = isset($data_form['note']['value']) ? $data_form['note']['value'] : '';
            } else {
                $firstName = isset($_REQUEST['firstName']) ? $_REQUEST['firstName'] : '';
                $lastName = isset($_REQUEST['lastName']) ? $_REQUEST['lastName'] : '';
                $phone = isset($_REQUEST['phone']) ? $_REQUEST['phone'] : '';
                $email = isset($_REQUEST['email']) ? $_REQUEST['email'] : '';
                $address = isset($_REQUEST['address']) ? $_REQUEST['address'] : '';
                $gender = isset($_REQUEST['gender']) ? $_REQUEST['gender'] : '';
                $department = isset($_REQUEST['department']) ? $_REQUEST['department'] : '';
                $company = isset($_REQUEST['company']) ? $_REQUEST['company'] : '';
                $country = isset($_REQUEST['country']) ? $_REQUEST['country'] : '';
                $note = isset($_REQUEST['note']) ? $_REQUEST['note'] : '';
            }

            //check email blacklist
            $violate = FAT_Event_Utils::is_violate_email_blacklist($email);
            if($violate['violate']==1){
                echo json_encode(array(
                    'code' => -1,
                    'message' => $violate['message']
                ));
                wp_die();
                return;
            }


            $quantity = isset($_REQUEST['quantity']) ? $_REQUEST['quantity'] : 1;
            $quantity = $quantity > 0 ? $quantity : 1;
            $fees = isset($event_detail['fees']) ? $event_detail['fees'] : 0;
            $url = isset($_REQUEST['url']) ? $_REQUEST['url'] : esc_url(home_url());
            $coupon_code = isset($_REQUEST['coupon']) ? $_REQUEST['coupon'] : '';
            $ticket_class = '';
            $ticket_name = '';

            if (isset($event_detail['fees_type']) && $event_detail['fees_type'] !== 'fixed') {
                $is_exists_fees = false;
                if ($event_detail['fees_type'] == 'package') {
                    if (isset($event_detail['fees_package']) && is_array($event_detail['fees_package'])) {
                        for ($i = 0; $i < count($event_detail['fees_package']['quantity']); $i++) {
                            if ($event_detail['fees_package']['quantity'][$i] == $quantity) {
                                $fees = $total = $event_detail['fees_package']['fees'][$i];
                                $is_exists_fees = true;
                            }
                        }
                    }
                }

                if ($event_detail['fees_type'] == 'ticket_class') {
                    $ticket_class = $_REQUEST['ticket_class'] ? $_REQUEST['ticket_class'] : '';
                    $is_exists_fees = false;
                    if (isset($event_detail['ticket_class']) && is_array($event_detail['ticket_class'])) {
                        for ($i = 0; $i < count($event_detail['ticket_class']['class']); $i++) {
                            if ($event_detail['ticket_class']['class_id'][$i] == $ticket_class) {
                                $fees = $event_detail['ticket_class']['fees'][$i];
                                $ticket_name = $event_detail['ticket_class']['class'][$i];
                                $total = $fees * $quantity;
                                $is_exists_fees = true;
                                $seats = isset($event_detail['ticket_class']['seats'][$i]) && $event_detail['ticket_class']['seats'][$i] ? $event_detail['ticket_class']['seats'][$i] : 0;
                                $num_of_book_key .= '_' . $event_detail['ticket_class']['class_id'][$i];
                            }
                        }
                    }
                }

                if (!$is_exists_fees) {
                    $result = array(
                        'code' => -1,
                        'message' => esc_html__('The fees package don\'t exists', 'fat-event')
                    );
                    echo json_encode($result);
                    wp_die();
                    return;
                }
            }

            $num_book = get_post_meta($event_id, $num_of_book_key, true);
            $num_book = isset($num_book) && $num_book ? $num_book : 0;

            error_log('quantity:'.$quantity. ' seats:'.$seats. ' number of book:'.$num_book. ' number of book key:'.$num_of_book_key);

            if ($seats > 0 && $quantity > ($seats - $num_book)) {
                $result = array(
                    'code' => -1,
                    'message' => esc_html__('The number of tickets is greater than the number of seats available', 'fat-event')
                );
                echo json_encode($result);
                wp_die();
                return;
            }

            if ($firstName && $lastName && $email && $quantity) {
                $post = array(
                    'post_title' => $event->post_title,
                    'post_status' => 'publish',
                    'post_type' => FAT_EVENT_BOOKING_POST_TYPE
                );
                $booking_id = wp_insert_post($post);
                if ($booking_id > 0) {

                    $date_format = get_option('date_format');
                    $date_format = strpos($date_format, 'H:i:s') === FALSE ? $date_format . ' H:i:s' : $date_format;

                    $total_fees = $quantity * $fees;
                    $discount = $coupon_id = 0;

                    if ($coupon_code) {
                        $fat_utils = new FAT_Event_Utils();
                        $coupon = $fat_utils->get_coupon($coupon_code, $currency, $total_fees, '', $event_id);
                        if (isset($coupon['code']) && $coupon['code'] > 0 && isset($coupon['discount_type'])) {
                            $coupon_id = $coupon['coupon_id'];
                            if ($coupon['discount_type'] === 'percentage') {
                                $discount = ($total_fees * $coupon['amount']) / 100;
                            } else {
                                $discount = $coupon['amount'];
                            }

                        }
                    }

                    if (isset($data_form) && is_array($data_form)) {
                        $booking_detail = array(
                            'event_id' => $event_id,
                            'event_start_date' => $start_date ? $start_date->format($date_format) : '',
                            'event_end_date' => $end_date ? $end_date->format($date_format) : '',
                            'quantity' => $quantity,
                            'fees_type' => isset($event_detail['fees_type']) && $event_detail['fees_type'] ? $event_detail['fees_type'] : 'fixed',
                            'ticket_name' => $ticket_name,
                            'price' => $fees,
                            'total_price' => ($total_fees - $discount) > 0 ? ($total_fees - $discount) : 0,
                            'coupon' => $coupon_code,
                            'discount' => $discount,
                            'payment_type' => $payment_type,
                            'payment_title' => ucfirst($payment_type),
                            'process_status' => 'no_process'
                        );
                        foreach ($data_form as $k => $v) {
                            $booking_detail[$k] = is_array($v['value']) ? implode(',', $v['value']) : $v['value'];
                            if($k=='text-1621845678578'){
                                update_post_meta($booking_id, 'name_of_child', $v['value'], true);
                            }
                        }
                        add_post_meta($booking_id, 'fat-mb-event-booking-detail', $booking_detail);

                    } else {
                        add_post_meta($booking_id, 'fat-mb-event-booking-detail', array(
                            'event_id' => $event_id,
                            'event_start_date' => $start_date ? $start_date->format($date_format) : '',
                            'event_end_date' => $end_date ? $end_date->format($date_format) : '',
                            'first_name' => $firstName,
                            'last_name' => $lastName,
                            'email' => $email,
                            'phone' => $phone,
                            'address' => $address,
                            'gender' => $gender,
                            'department' => $department,
                            'company' => $company,
                            'country' => $country,
                            'quantity' => $quantity,
                            'fees_type' => isset($event_detail['fees_type']) && $event_detail['fees_type'] ? $event_detail['fees_type'] : 'fixed',
                            'price' => $fees,
                            'total_price' => ($total_fees - $discount) > 0 ? ($total_fees - $discount) : 0,
                            'coupon' => $coupon_code,
                            'discount' => $discount,
                            'payment_type' => $payment_type,
                            'note' => $note,
                            'payment_type' => $payment_type,
                            'payment_title' => ucfirst($payment_type),
                            'process_status' => 'no_process',
                        ));
                        add_post_meta($booking_id, 'email', $email);
                    }

                    if(is_array($amenities) && count($amenities)>0){
                        add_post_meta($booking_id, 'amenities', implode($amenities,'. '));
                    }

                    $num_book += $quantity;
                    $full_name = $firstName.' '. $lastName;

                    add_post_meta($booking_id, 'start_date', $start_date);
                    add_post_meta($booking_id, 'end_date', $end_date);
                    add_post_meta($booking_id, 'event_id', $event_id);
                    add_post_meta($booking_id, 'payment_type', $payment_type);
                    add_post_meta($booking_id, 'process_status', 'no_process');
                    add_post_meta($booking_id, 'attention_code', $confirm_attention);
                    add_post_meta($booking_id, 'attention_status', 0);
                    add_post_meta($booking_id, 'has_send', 0);
                    add_post_meta($booking_id, 'email', $email);
                    add_post_meta($booking_id, 'customer', $full_name);
                    add_post_meta($booking_id, 'ticket_name', $ticket_name);

                    // for compare
                    $booking_date_string = current_time( 'mysql', 0);
                    $booking_date_string = DateTime::createFromFormat('Y-m-d H:i:s',$booking_date_string);
                    add_post_meta($booking_id, 'start_date_string', $start_date->format('Y-m-d H:i:s'));
                    add_post_meta($booking_id, 'end_date_string', $end_date->format('Y-m-d H:i:s'));
                    add_post_meta($booking_id, 'start_date_str', $start_date->format('Y-m-d'));
                    add_post_meta($booking_id, 'booking_date_string', $booking_date_string->format('Y-m-d'));

                    $loc_orgs = FAT_Event_Utils::get_location_organizer($event_id);
                    add_post_meta($booking_id, 'location', $loc_orgs['location']);
                    add_post_meta($booking_id, 'organizer', $loc_orgs['organizer']);

                    $cat_list = get_the_terms( $event_id, FAT_EVENT_CATEGORY_TAXONOMY );
                    delete_post_meta($booking_id,'category');
                    foreach($cat_list as $cat){
                        add_post_meta($booking_id, 'category', $cat->term_id, false);
                    }

                    //add_post_meta($booking_id, 'another_field', $another_field);
                    if ($ticket_class) {
                        add_post_meta($booking_id, 'ticket_class_id', $ticket_class);
                    }

                    if (isset($data_form)) {
                        add_post_meta($booking_id, 'data_form', $data_form);
                    }

                    /** update meta for coupon */
                    if ($coupon_id > 0) {
                        $used = get_post_meta($coupon_id, 'fat_event_coupon_used', true);
                        $used = $used ? $used : 0;
                        $used++;
                        update_post_meta($coupon_id, 'fat_event_coupon_used', $used);

                        $clients = get_post_meta($coupon_id, 'fat_event_coupon_clients', '');
                        $clients = $clients && is_array($clients) ? $clients : array();
                        $clients[] = array(
                            'booking_id' => $booking_id,
                            'client' => $firstName . ' ' . $lastName,
                            'email' => $email
                        );
                        update_post_meta($coupon_id, 'fat_event_coupon_clients', $clients);
                    }

                    if ($payment_type === 'myPOS' && $fees > 0) {
                        $payment = new FAT_Event_Payment();
                        $payment_result = $payment->myPOS_payment($firstName, $lastName, $email, $phone, $address, $country, $currency, $booking_id, 1, ($total_fees - $discount), 0, $event->post_title);
                        if ($payment_result['code'] == -1) {
                            wp_delete_post($booking_id);
                        }
                        echo json_encode($payment_result);
                        wp_die();

                    } elseif ($payment_type === 'paypal' && $fees > 0) {
                        $payment = new FAT_Event_Payment();

                        $description = esc_html__('Booking ', 'fat-event') . $event->post_title;
                        $description .= esc_html__('  Customer:', 'fat-event') . $firstName. ' '.$lastName;
                        $description .= esc_html__('  Email:', 'fat-event') .$email;
                        $description .= esc_html__('  Start date:', 'fat-event') . $start_date->format($date_format);
                        $description .= esc_html__('  End date:', 'fat-event') . $end_date->format($date_format);
                        $description .= esc_html__('  Number of ticket:', 'fat-event') . $quantity;
                        $description .= esc_html__('  Fees: ', 'fat-event') . $fees . $currency_symbol;
                        if ($discount > 0) {
                            $description .= esc_html__(' Subtotal fees: ', 'fat-event') . $total_fees . $currency_symbol;
                            $description .= esc_html__(' Discount: ', 'fat-event') . $discount . $currency_symbol;
                            $description .= esc_html__(' Total fees: ', 'fat-event') . ($total_fees - $discount > 0 ? $total_fees - $discount : 0) . $currency_symbol;
                        } else {
                            $description .= esc_html__('  Total fees: ', 'fat-event') . $total_fees . $currency_symbol;
                        }
                        error_log('Paypal payment. data :' . $description);

                        $approve_url = '';
                        if ($total_fees - $discount > 0) {
                            $fees = ($total_fees - $discount)/$quantity;
                            $payment_result = $payment->payment($booking_id, $event_id, $quantity, $fees, ($total_fees - $discount), $currency, $event->post_title, $description, $url);
                        } else {
                            $payment_result = $payment->payment($booking_id, $event_id, $quantity, $fees, 0, $currency, $event->post_title, $description, $url);
                        }

                        if ($payment_result['result'] == -1) {
                            wp_delete_post($booking_id);
                            echo json_encode(array(
                                'code' => -1,
                                'message' => $payment_result['message']
                            ));
                            wp_die();
                        } else {
                            $approve_url = $payment_result['approval_url'];
                        }

                        $result = array(
                            'code' => $booking_id,
                            'url' => $approve_url,
                        );

                    } else {
                        if ($payment_type === 'stripe' && $fees > 0) {
                            $stripe_token = isset($_REQUEST['token']) && $_REQUEST['token'] ? $_REQUEST['token'] : '';
                            if ($stripe_token && isset($fat_event_setting['stripe_secret_key']) && $fat_event_setting['stripe_secret_key']) {
                                try {

                                    $description = esc_html__('Booking ', 'fat-event') . $event->post_title;
                                    $description .= esc_html__('  Customer:', 'fat-event') . $firstName. ' '.$lastName;
                                    $description .= esc_html__('  Email:', 'fat-event') .$email;
                                    $description .= esc_html__('  Start date:', 'fat-event') . $start_date->format($date_format);
                                    $description .= esc_html__('  End date:', 'fat-event') . $end_date->format($date_format);
                                    $description .= esc_html__('  Number of ticket:', 'fat-event') . $quantity;
                                    $description .= esc_html__('  Fees: ', 'fat-event') . $fees . $currency_symbol;
                                    if ($discount > 0) {
                                        $description .= esc_html__(' Subtotal fees: ', 'fat-event') . $total_fees . $currency_symbol;
                                        $description .= esc_html__(' Discount: ', 'fat-event') . $discount . $currency_symbol;
                                        $description .= esc_html__(' Total fees: ', 'fat-event') . ($total_fees - $discount > 0 ? $total_fees - $discount : 0) . $currency_symbol;
                                    } else {
                                        $description .= esc_html__('  Total fees: ', 'fat-event') . $total_fees . $currency_symbol;
                                    }

                                    $headers = array('Authorization: Bearer ' . $fat_event_setting['stripe_secret_key']);
                                    $ch = curl_init();
                                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                                    curl_setopt($ch, CURLOPT_POST, true);
                                    curl_setopt($ch, CURLOPT_URL, 'https://api.stripe.com/v1/charges');
                                    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(
                                        array(
                                            'amount' => ($total_fees - $discount) > 0 ? ($total_fees - $discount) * 100 : 0,
                                            'currency' => $currency,
                                            'source' => $stripe_token,
                                            'description' => $description
                                        )
                                    ));
                                    $response = curl_exec($ch);
                                    curl_close($ch);
                                    $response = json_decode($response);
                                    if (isset($response->error)) {
                                        $result = array(
                                            'code' => -1,
                                            'message' => $response->error->message
                                        );
                                        add_post_meta($booking_id, 'stripe_error', $response->error->message);
                                    } else {
                                        add_post_meta($booking_id, 'stripe_id', $response->id);
                                        add_post_meta($booking_id, 'stripe_balance_transaction', $response->balance_transaction);
                                        update_post_meta($event_id, $num_of_book_key, $num_book);

                                        $result = array(
                                            'code' => $booking_id,
                                            'message' => $fat_event_setting['payment_success_message'],
                                        );
                                        if(isset($fat_event_setting['payment_notification']) && $fat_event_setting['payment_notification'] == 'page'){
                                            $page_success_id = apply_filters( 'wpml_object_id',  $fat_event_setting['payment_page_success'], 'page' );
                                            $result['url'] = get_permalink($page_success_id);
                                        }

                                    }

                                } catch (Exception $e) {
                                    error_log(serialize($e));
                                }
                            } else {
                                $result = array(
                                    'code' => -1,
                                    'message' => $fat_event_setting['payment_error_message'] ? $fat_event_setting['payment_error_message'] : esc_html__('Sorry Stripe gateway configuration not ready', 'fat-event')
                                );
                            }

                        } else {
                            update_post_meta($event_id, $num_of_book_key, $num_book);
                            if (isset($fat_event_setting['payment_notification']) && $fat_event_setting['payment_notification'] === 'page') {
                                $page_success_id = apply_filters( 'wpml_object_id',  $fat_event_setting['payment_page_success'], 'page' );
                                $result = array(
                                    'code' => $booking_id,
                                    'url' => get_permalink($page_success_id)
                                );
                            } else {
                                $result = array(
                                    'code' => $booking_id,
                                    'message' => $fat_event_setting['payment_success_message']
                                );
                            }
                        }
                    }

                    if ($payment_type === 'offline') {
                        error_log('update number of book:'.$event_id. ' num_of_book_key:'.$num_of_book_key.' number:'.$num_book);
                        update_post_meta($event_id, $num_of_book_key, $num_book);
                        if (isset($fat_event_setting['payment_notification']) && $fat_event_setting['payment_notification'] === 'page') {
                            $page_success_id = apply_filters( 'wpml_object_id',  $fat_event_setting['payment_page_success'], 'page' );
                            $result = array(
                                'code' => $booking_id,
                                'url' => get_permalink($page_success_id)
                            );
                        } else {
                            $result = array(
                                'code' => $booking_id,
                                'message' => $fat_event_setting['payment_success_message']
                            );
                        }
                    }
                }
            } else {
                $result = array(
                    'code' => -1,
                    'message' => esc_html__('Please input first name, last name, email and choose quantity', 'fat-event')
                );
            }
        } else {
            $result = array(
                'code' => -1,
                'message' => esc_html__('Data is invalid', 'fat-event')
            );
        }

        echo json_encode($result);
        wp_die();
    }

    add_action('wp_ajax_nopriv_fat_event_booking', 'fat_event_booking_callback');
    add_action('wp_ajax_fat_event_booking', 'fat_event_booking_callback');
}

if (!function_exists('fat_event_booking_sendmail_callback')) {
    function fat_event_booking_sendmail_callback()
    {
        $booking_id = isset($_REQUEST['id']) && $_REQUEST['id'] ? $_REQUEST['id'] : 0;
        if ($booking_id) {
            FAT_Event_Utils::send_mail_callback($booking_id);
        }
        echo 'done';
        wp_die();
    }

    add_action('wp_ajax_nopriv_fat_event_booking_sendmail', 'fat_event_booking_sendmail_callback');
    add_action('wp_ajax_fat_event_booking_sendmail', 'fat_event_booking_sendmail_callback');
}

if (!function_exists('fat_event_create_callback')) {
    function fat_event_create_callback()
    {
        $result = array();
        $fat_event_setting = get_option('fat_event_setting');

        if (isset($fat_event_setting['enable_create_event'][0]) && $fat_event_setting['enable_create_event'][0] === '1') {
            $allow_user = isset($fat_event_setting['allow_user_create']) ? $fat_event_setting['allow_user_create'] : '';
            $allow_user = $allow_user!='' ? explode(',', $allow_user) : array();
            $current_user = get_current_user_id();
            if ($current_user == 0 || (count($allow_user) > 0 && !in_array($current_user, $allow_user))) {
                $result = array(
                    'code' => -999,
                    'message' => esc_html__('You don\'t have permission to create event', 'fat-event'),
                    'allow_user' => serialize($allow_user)
                );
            }
            $title = isset($_REQUEST['title']) && $_REQUEST['title'] ? $_REQUEST['title'] : esc_html__('Title of event', 'fat-event');
            $content = isset($_REQUEST['content']) ? $_REQUEST['content'] : '';
            $fat_mb_event_detail = isset($_REQUEST['fat_mb_event_detail']) ? $_REQUEST['fat_mb_event_detail'] : '';
            $fat_mb_event_bg_image = isset($_REQUEST['fat_mb_event_bg_image']) ? $_REQUEST['fat_mb_event_bg_image'] : '';
            $fat_mb_event_color = isset($_REQUEST['fat_mb_event_color']) ? $_REQUEST['fat_mb_event_color'] : '';
            $post = array(
                'post_title' => $title,
                'post_content' => $content,
                'post_status' => isset($fat_event_setting['enable_status']) && isset($fat_event_setting['enable_status'][0]) ? $fat_event_setting['enable_status'][0] : 'draft',
                'post_type' => FAT_EVENT_POST_TYPE
            );

            if (isset($_REQUEST['categories']) && $_REQUEST['categories']) {
                $post['tax_input'] = array(
                    FAT_EVENT_CATEGORY_TAXONOMY => $_REQUEST['categories']
                );
            }

            if (isset($_REQUEST['tags']) && $_REQUEST['tags']) {
                $post['tax_input'][FAT_EVENT_TAG_TAXONOMY] = explode(',', $_REQUEST['tags']);
            }

            $fat_mb_event_detail['custom_days'] = array(
                'repeat_on_date' => isset($fat_mb_event_detail['custom_days'][0]['repeat_on_date']) ? $fat_mb_event_detail['custom_days'][0]['repeat_on_date'] : array()
            );
            $fat_mb_event_detail['schedule'] = isset($fat_mb_event_detail['schedule'][0]) ? $fat_mb_event_detail['schedule'][0] : array();
            $fat_mb_event_detail['fees_package'] = isset($fat_mb_event_detail['fees_package'][0]) ? $fat_mb_event_detail['fees_package'][0] : array();
            $fat_mb_event_detail['ticket_class'] = isset($fat_mb_event_detail['ticket_class'][0]) ? $fat_mb_event_detail['ticket_class'][0] : array();

            $fat_mb_amenities = isset($_REQUEST['fat_mb_amenities']) ? $_REQUEST['fat_mb_amenities'] : '';
            $amenities = array();
            if(is_array($fat_mb_amenities)){
                $am_key = '';
                foreach ($fat_mb_amenities as $am){
                    $am_key = strtolower($am);
                    $am_key = str_replace(' ','_',$am_key);
                    $amenities[$am_key] = array($am);
                }
            }

            $event_id = wp_insert_post($post);
            if ($event_id > 0) {
                update_post_meta($event_id, 'fat-mb-event-detail', $fat_mb_event_detail);
                update_post_meta($event_id, 'fat-mb-event-bg-image', array(
                    'bg_image' => $fat_mb_event_bg_image
                ));
                update_post_meta($event_id, 'fat-mb-event-color', array(
                    'color' => $fat_mb_event_color
                ));

                if(is_array($amenities) && count($amenities)>0){
                    update_post_meta($event_id, 'fat-mb-event-single-amenities', $amenities);
                }

                if (isset($_REQUEST['feature_image']) && $_REQUEST['feature_image']) {
                    update_post_meta($event_id, '_thumbnail_id', $_REQUEST['feature_image']);
                }

                update_post_meta($event_id, 'start_date', $fat_mb_event_detail['start_date']);
                update_post_meta($event_id, 'end_date', $fat_mb_event_detail['end_date']);
                update_post_meta($event_id, 'opt_date_format', FAT_EVENT_DATETIME_FORMAT);
                do_action('fat_event_after_create',$event_id);

                $result = array(
                    'code' => 1,
                    'notification' => $fat_event_setting['event_create_notification'],
                    'message' => isset($fat_event_setting['event_create_success_message']) ? $fat_event_setting['event_create_success_message'] : esc_html__('Thank you for your event. Please wait for approve!', 'fat-event'),
                    'page' => isset($fat_event_setting['event_create_page_success']) && $fat_event_setting['event_create_page_success'] ? get_permalink($fat_event_setting['event_create_page_success']) : '',
                );
            }

        } else {
            $result = array(
                'code' => -1000,
                'message' => esc_html__('You don\'t have permission to create event', 'fat-event')
            );
        }

        echo json_encode($result);
        wp_die();
    }

    add_action('wp_ajax_nopriv_fat_event_create', 'fat_event_create_callback');
    add_action('wp_ajax_fat_event_create', 'fat_event_create_callback');
}

if (!function_exists('fat_event_apply_coupon_callback')) {
    function fat_event_apply_coupon_callback()
    {
        if (isset($_REQUEST['coupon']) && $_REQUEST['coupon'] != '') {
            $coupon_code = $_REQUEST['coupon'];
            $total_spend = isset($_REQUEST['total_spend']) && $_REQUEST['total_spend'] ? $_REQUEST['total_spend'] : 0;
            $currency = isset($_REQUEST['currency']) ? $_REQUEST['currency'] : '$';
            $event_id = isset($_REQUEST['event_id']) ? $_REQUEST['event_id'] : 0;
            $symbol_position = isset($_REQUEST['symbol_position']) ? $_REQUEST['symbol_position'] : '';
            $fat_utils = new FAT_Event_Utils();
            $coupon = $fat_utils->get_coupon($coupon_code, $currency, $total_spend, $symbol_position, $event_id);
            echo json_encode($coupon);
            wp_die();
            return;
        }
    }

    add_action('wp_ajax_nopriv_fat_event_apply_coupon', 'fat_event_apply_coupon_callback');
    add_action('wp_ajax_fat_event_apply_coupon', 'fat_event_apply_coupon_callback');
}

if (!function_exists('fat_event_wc_booking_callback')) {
    function fat_event_wc_booking_callback()
    {
        if (!class_exists('WooCommerce')) {
            echo json_encode(array(
                'code' => -1,
                'message' => esc_html__('WooCommerce don\'t exists on this site', 'fat-event')
            ));
            wp_die();
            return;
        }

        $start_date = isset($_REQUEST['start_date']) && $_REQUEST['start_date'] ? $_REQUEST['start_date'] : '';
        $end_date = isset($_REQUEST['end_date']) && $_REQUEST['end_date'] ? $_REQUEST['end_date'] : '';
        $num_of_book_key = 'num_of_book_' . $start_date . '_' . $end_date;
        $class_id = isset($_REQUEST['class_id']) ? $_REQUEST['class_id'] : '';
        $class_name = isset($_REQUEST['class_name']) ? $_REQUEST['class_name'] : '';
        $number_ticket = isset($_REQUEST['ticket_number']) ? $_REQUEST['ticket_number'] : 1;
        $max_seat = isset($_REQUEST['max_seat']) ? $_REQUEST['max_seat'] : 1;

        $start_date = DateTime::createFromFormat('U', $start_date);
        $start_date_str = $start_date->format('Y-m-d H:i:s');
        $end_date = $end_date ? DateTime::createFromFormat('U', $end_date) : '';
        $event_id = isset($_REQUEST['id']) && $_REQUEST['id'] ? $_REQUEST['id'] : 0;

        $now_str = current_time('mysql', 0);
        $now = DateTime::createFromFormat('Y-m-d H:i:s', $now_str);
        if (strtotime($start_date_str) < strtotime($now_str)) {
            echo json_encode(array(
                'code' => -1,
                'message' => esc_html__('You cannot booking once the event has started', 'fat-event')
            ));
            wp_die();
            return;
        }

        $event_detail = get_post_meta($event_id, 'fat-mb-event-detail', true);

        $fees_type = isset($event_detail['fees_type']) && $event_detail['fees_type'] ? $event_detail['fees_type'] : 'fixed';
        $price = isset($event_detail['fees']) && $fees_type == 'fixed' && $event_detail['fees'] ? $event_detail['fees'] : 0;
        $quantity = isset($cart_item['quantity']) && $cart_item['quantity'] ? $cart_item['quantity'] : 1;

        if ($fees_type == 'ticket_class' && isset($cart_item['class_id'])) {
            $ticket_class = isset($event_detail['ticket_class']) && $event_detail['ticket_class'] ? $event_detail['ticket_class'] : array();
            for ($i = 0; $i < count($ticket_class['class']); $i++) {
                if ($ticket_class['class_id'][$i] == $cart_item['class_id']) {
                    $price = $ticket_class['fees'][$i];
                }
            }
        }

        if ($fees_type == 'package') {
            $fees_package = isset($event_detail['fees_package']) ? $event_detail['fees_package'] : array();
            $default_price = 0;
            $price = 0;
            for ($i = 0; $i < count($fees_package['quantity']); $i++) {
                if ($fees_package['quantity'][$i] == '1') {
                    $default_price = $fees_package['fees'][$i];
                }
                if ($fees_package['quantity'][$i] == $quantity) {
                    $price = $fees_package['fees'][$i];
                }
            }
            $price = $price ? $price : $default_price;
        }

        if($fees_type=='ticket_class'){
            $num_of_book_key.= '_'.$class_id;

            $ticket_class = isset($event_detail['ticket_class']) && $event_detail['ticket_class'] ? $event_detail['ticket_class'] : array();
            for ($i = 0; $i < count($ticket_class['class']); $i++) {
                if ($ticket_class['class_id'][$i] == $class_id) {
                    $price = $ticket_class['fees'][$i];
                }
            }
        }
        $seats = isset($event_detail['enable_booking'][0]) && $event_detail['enable_booking'][0] === '1' ? $event_detail['seats'] : 0;
        $seats = $seats !== '' ? $seats : 0;
        $num_book = get_post_meta($event_id, $num_of_book_key, true);
        $num_book = isset($num_book) && $num_book ? $num_book : 0;


        if ($seats > 0 && $number_ticket > ($seats - $num_book)) {
            $result = array(
                'code' => -1,
                'message' => esc_html__('The number of tickets is greater than the number of seats available', 'fat-event')
            );
            echo json_encode($result);
            wp_die();
            return;
        }

        $fat_event_setting = get_option('fat_event_setting');
        $single_time_format = isset($fat_event_setting['single_time_format']) ? $fat_event_setting['single_time_format'] : 'H:i';
        $date_format = get_option('date_format');

        $products = get_posts(array(
            'post_type' => 'product',
            'meta_key' => '_event_product_id',
            'meta_value' => ($event_id.'_'.$price)
        ));
        $product_id = is_array($products) && count($products) > 0 ? $products[0]->ID : 0;
        if(!$product_id){
            $product_id = FAT_Event_Utils::addProduct($event_id, $price);
        }

        if($product_id){
            WC()->cart->empty_cart();
            $result = WC()->cart->add_to_cart($product_id, $number_ticket, 0, array(), array(
                'start_date' => $start_date->format($single_time_format . ' - '). date_i18n($date_format, $start_date->format('U')),
                's_date' => $start_date->format('U'),
                'end_date' => $end_date->format($single_time_format . ' - '). date_i18n($date_format, $end_date->format('U')),
                'e_date' => $end_date->format('U'),
                'fees_type' => $fees_type,
                'class_id' => $class_id,
                'class_name' => $class_name,
                'number_ticket' => $number_ticket,
                'max_seat' => $max_seat
            ));

            echo json_encode(array(
                'code' => 1,
                'message' => esc_html__('The event have been added to cart. Please go to cart page for check out', 'fat-event'),
                'url' => wc_get_cart_url()
            ));
            wp_die();
            return;
        }else{
            echo json_encode(array(
                'code' => -1,
                'message' => esc_html__('Product does not exist for this event', 'fat-event')
            ));
            wp_die();
            return;
        }

    }

    add_action('wp_ajax_nopriv_fat_event_wc_booking', 'fat_event_wc_booking_callback');
    add_action('wp_ajax_fat_event_wc_booking', 'fat_event_wc_booking_callback');
}