<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/9/2018
 * Time: 4:22 PM
 */

if (!function_exists('fat_event_save_location_callback')) {
    function fat_event_save_location_callback()
    {
        $name = isset($_POST['name']) ? $_POST['name'] : '';
        $address = isset($_POST['address']) ? $_POST['address'] : '';
        $location = isset($_POST['location']) ? $_POST['location'] : '';
        $thumb = isset($_POST['thumbnail']) ? $_POST['thumbnail'] : '';

        if ($name != '' && $address != '') {
            $result = wp_insert_term($name, FAT_EVENT_LOCATION_TAXONOMY, array());
            if (isset($result['term_id'])) {
                update_term_meta($result['term_id'], 'fat-mb-location-detail', array(
                    'address' => $address,
                    'map' => $location,
                    'thumbnail' => $thumb
                ));
            }
            echo json_encode(array(
                'result' => $result['term_id'],
            ));
        } else {
            echo json_encode(array(
                'result' => -1,
                'message' => esc_html__('Please input Name and Address', 'fat-event')
            ));
        }
        wp_die();
    }

    add_action("wp_ajax_fat_event_save_location", 'fat_event_save_location_callback');
}

if (!function_exists('fat_event_save_organizer_callback')) {
    function fat_event_save_organizer_callback()
    {
        $name = isset($_POST['name']) ? $_POST['name'] : '';
        $telephone = isset($_POST['telephone']) ? $_POST['telephone'] : '';
        $website = isset($_POST['website']) ? $_POST['website'] : '';
        $email = isset($_POST['email']) ? $_POST['email'] : '';
        $facebook = isset($_POST['facebook']) ? $_POST['facebook'] : '';
        $twitter = isset($_POST['twitter']) ? $_POST['twitter'] : '';
        $linkedin = isset($_POST['linkedin']) ? $_POST['linkedin'] : '';
        $thumb = isset($_POST['thumbnail']) ? $_POST['thumbnail'] : '';

        if ($name != '') {
            $result = wp_insert_term($name, FAT_EVENT_ORGANIZER_TAXONOMY, array());
            if (isset($result['term_id'])) {
                update_term_meta($result['term_id'], 'fat-mb-location-detail', array(
                    'telephone' => $telephone,
                    'website' => $website,
                    'email' => $email,
                    'facebook' => $facebook,
                    'twitter' => $twitter,
                    'linkedin' => $linkedin,
                    'thumbnail' => $thumb
                ));
            }
            echo json_encode(array(
                'result' => $result['term_id'],
            ));
        } else {
            echo json_encode(array(
                'result' => -1,
                'message' => esc_html__('Please input Name', 'fat-event')
            ));
        }
        wp_die();
    }

    add_action("wp_ajax_fat_event_save_organizer", 'fat_event_save_organizer_callback');
}

if (!function_exists('fat_event_get_attendees_callback')) {
    function fat_event_get_attendees_callback()
    {
        $event_id = isset($_POST['id']) ? $_POST['id'] : '';
        global $wpdb;
        $bookings = $wpdb->get_results('SELECT ID, post_date FROM ' . $wpdb->prefix . 'posts WHERE post_status="publish" AND post_type="' . FAT_EVENT_BOOKING_POST_TYPE . '"');
        $attendees = array();
        $attention_status = '';

        $custom_field = '';
        foreach ($bookings as $booking) {
            $booking_detail = get_post_meta($booking->ID, 'fat-mb-event-booking-detail', true);
            if (isset($booking_detail['event_id']) && $booking_detail['event_id'] == $event_id) {
                $attention_status = get_post_meta($booking->ID, 'attention_status', true);
                $location = get_post_meta($booking->ID, 'location_name', true);
                $amenities = get_post_meta($booking->ID, 'amenities', true);
                $ticket_name = get_post_meta($booking->ID, 'ticket_name', true);

                $address = isset($booking_detail['address']) ? $booking_detail['address'] : '';
                $company = isset($booking_detail['company']) ? $booking_detail['company'] : '';

                $data_form = get_post_meta($booking->ID,'data_form',true);
                if($company==''){
                    $company = isset($data_form['company']) ? $data_form['company'] : '';
                    $company = isset($company['value']) ? $company['value'] : '';
                }
                if($address==''){
                    $address = isset($data_form['address']) ? $data_form['address'] : '';
                    $address = isset($address['value']) ? $address['value'] : '';
                }
                $custom_field = '';
                foreach ($data_form as $key=>$field){
                    if($key!='first_name' && $key!='last_name' && $key!='phone' && $key!='email'  && $key!='company' && $key!='address'){
                        if(isset($field['value']) && $field['value']){
                            if(is_array($field['value'])){
                                $custom_field .= count($field['value']) > 0 && $field['value'][0] ? ( $field['label']. ':' .implode(',',$field['value']). '; ') : '';
                            }else{
                                $custom_field .= $field['label'].':'.$field['value'].'; ';
                            }
                        }
                    }

                }
                $attendees[] = array(
                    'full_name' => $booking_detail['first_name'] . ' ' . $booking_detail['last_name'],
                    'email' => $booking_detail['email'],
                    'phone' => $booking_detail['phone'],
                    'address' => $address,
                    'company' => $company,
                    'quantity' => $booking_detail['quantity'],
                    'ticket' => $ticket_name,
                    'price' => $booking_detail['price'],
                    'total_price' => $booking_detail['total_price'],
                    'start_date' =>  $booking_detail['event_start_date'],
                    'end_date' =>  $booking_detail['event_end_date'],
                    'process_status' => $booking_detail['process_status'],
                    'location' => $location,
                    'amenities' => $amenities,
                    'payment_type' => $booking_detail['payment_type'],
                    'attention_status' => $attention_status,
                    'custom_field' => $custom_field
                );
            }
        }
        echo json_encode( $attendees);
        wp_die();
    }

    add_action("wp_ajax_fat_event_get_attendees", 'fat_event_get_attendees_callback');
}

if(!function_exists('fat_event_save_booking_form_callback')){
    function fat_event_save_booking_form_callback(){
        if(isset($_REQUEST['form'])){
            if($_REQUEST['form']!=='[]'){
                $form_data =  $_REQUEST['form'];
                update_option('fat_event_booking_form',$form_data);
            }else{
                delete_option('fat_event_booking_form');
            }
            echo json_encode(array(
                'result' => 1,
                'message' => esc_html__('The booking form have been stored','fat-event')
            ));
        }else{
            echo json_encode(array(
                'result' => -1,
                'message' => esc_html__('Please drag a field from the right to this area','fat-event')
            ));
        }

        wp_die();
    }
    add_action("wp_ajax_fat_event_save_booking_form", 'fat_event_save_booking_form_callback');
}

if(!function_exists('fat_event_add_booking_callback')){
    function fat_event_add_booking_callback(){
        if(!is_admin()){
            echo json_encode(array(
                'code' => -1,
                'message' => esc_html__('You are not authorized to perform this function', 'fat-event')
            ));
            wp_die();
            return;
        }

        $firstName = isset($_REQUEST['firstName']) ? $_REQUEST['firstName'] : '';
        $lastName = isset($_REQUEST['lastName']) ? $_REQUEST['lastName'] : '';
        $phone = isset($_REQUEST['phone']) ? $_REQUEST['phone'] : '';
        $email = isset($_REQUEST['email']) ? $_REQUEST['email'] : '';
        $address = isset($_REQUEST['address']) ? $_REQUEST['address'] : '';
        $gender = isset($_REQUEST['gender']) ? $_REQUEST['gender'] : '';
        $department = isset($_REQUEST['department']) ? $_REQUEST['department'] : '';
        $company = isset($_REQUEST['company']) ? $_REQUEST['company'] : '';
        $country = isset($_REQUEST['country']) ? $_REQUEST['country'] : '';
        $note = isset($_REQUEST['note']) ? $_REQUEST['note'] : '';
        $quantity = isset($_REQUEST['quantity']) ? $_REQUEST['quantity'] : '';
        $fees = isset($event_detail['fees']) ? $event_detail['fees'] : 0;
        $url = isset($_REQUEST['url']) ? $_REQUEST['url'] : esc_url(home_url());
        $coupon_code = isset($_REQUEST['coupon']) ? $_REQUEST['coupon'] : '';
        $start_date = isset($_REQUEST['start_date']) ? $_REQUEST['start_date'] : '';
        $end_date = isset($_REQUEST['end_date']) ? $_REQUEST['end_date'] : '';
        $location = isset($_REQUEST['location']) ? $_REQUEST['location'] : '';
        $amenities = isset($_REQUEST['amenities']) ? $_REQUEST['amenities'] : '';
        $event_id = isset($_REQUEST['id']) && $_REQUEST['id'] ? $_REQUEST['id'] : 0;
        $ticket_class = $_REQUEST['ticket_class'] ? $_REQUEST['ticket_class'] : '';

        $num_of_book_key = 'num_of_book_' . $start_date;
        $start_date = DateTime::createFromFormat('U', $start_date);
        $start_date_str = $start_date->format('Y-m-d H:i:s');

        $num_of_book_key = $num_of_book_key . '_' . $end_date;
        $end_date = $end_date ? DateTime::createFromFormat('U', $end_date) : '';

        $violate = FAT_Event_Utils::is_violate_day_off($start_date, $end_date);
        if($violate['violate']==1){
            echo json_encode(array(
                'code' => -1,
                'message' => $violate['message']
            ));
            wp_die();
            return;
        }

        $result = array();

        $event = get_post($event_id);
        $confirm_attention = uniqid();
        $event_detail = get_post_meta($event_id, 'fat-mb-event-detail', true);

        $now = current_time( 'mysql', 0);
        $now_str = $now;
        $now = DateTime::createFromFormat('Y-m-d H:i:s',$now);
        if (strtotime($start_date_str) < strtotime($now_str)) {
            echo json_encode(array(
                'code' => -1,
                'message' => esc_html__('You cannot booking once the event has started', 'fat-event')
            ));
            wp_die();
            return;
        }

        $seats = isset($event_detail['enable_booking'][0]) && $event_detail['enable_booking'][0] === '1' ? $event_detail['seats'] : 0;
        $seats = $seats !== '' ? $seats : 0;

        if (isset($event)) {
            $ticket_class = '';
            if (isset($event_detail['fees_type']) && $event_detail['fees_type'] !== 'fixed') {
                $is_exists_fees = false;
                if ($event_detail['fees_type'] == 'package') {
                    if (isset($event_detail['fees_package']) && is_array($event_detail['fees_package'])) {
                        for ($i = 0; $i < count($event_detail['fees_package']['quantity']); $i++) {
                            if ($event_detail['fees_package']['quantity'][$i] == $quantity) {
                                $fees = $total = $event_detail['fees_package']['fees'][$i];
                                $is_exists_fees = true;
                            }
                        }
                    }
                }

                if ($event_detail['fees_type'] == 'ticket_class') {

                    $is_exists_fees = false;
                    if (isset($event_detail['ticket_class']) && is_array($event_detail['ticket_class'])) {
                        for ($i = 0; $i < count($event_detail['ticket_class']['class']); $i++) {
                            if ($event_detail['ticket_class']['class_id'][$i] == $ticket_class) {
                                $fees = $event_detail['ticket_class']['fees'][$i];
                                $total = $fees * $quantity;
                                $is_exists_fees = true;
                                $seats = isset($event_detail['ticket_class']['seats'][$i]) && $event_detail['ticket_class']['seats'][$i] ? $event_detail['ticket_class']['seats'][$i] : 0;
                                $num_of_book_key .= '_' . $event_detail['ticket_class']['class_id'][$i];
                            }
                        }
                    }
                }

                if (!$is_exists_fees) {
                    $result = array(
                        'code' => -1,
                        'message' => esc_html__('The fees package don\'t exists', 'fat-event')
                    );
                    echo json_encode($result);
                    wp_die();
                    return;
                }
            }

            $num_book = get_post_meta($event_id, $num_of_book_key, true);
            $num_book = isset($num_book) && $num_book ? $num_book : 0;

            if ($seats > 0 && $quantity > ($seats - $num_book)) {
                $result = array(
                    'code' => -1,
                    'message' => esc_html__('The number of tickets is greater than the number of seats available', 'fat-event')
                );
                echo json_encode($result);
                wp_die();
                return;
            }

            if ($firstName && $lastName && $email && $quantity) {
                $post = array(
                    'post_title' => esc_html__('Booking ', 'fat-event') . $event->post_title,
                    'post_status' => 'publish',
                    'post_type' => FAT_EVENT_BOOKING_POST_TYPE
                );
                $booking_id = wp_insert_post($post);
                if ($booking_id > 0) {

                    $date_format = get_option('date_format');
                    $date_format = strpos($date_format, 'H:i:s') === FALSE ? $date_format . ' H:i:s' : $date_format;

                    $total_fees = $quantity * $fees;
                    $discount = $coupon_id = 0;

                    add_post_meta($booking_id, 'fat-mb-event-booking-detail', array(
                        'event_id' => $event_id,
                        'event_start_date' => $start_date ? $start_date->format($date_format) : '',
                        'event_end_date' => $end_date ? $end_date->format($date_format) : '',
                        'first_name' => $firstName,
                        'last_name' => $lastName,
                        'email' => $email,
                        'phone' => $phone,
                        'address' => $address,
                        'gender' => $gender,
                        'department' => $department,
                        'company' => $company,
                        'country' => $country,
                        'quantity' => $quantity,
                        'fees_type' => isset($event_detail['fees_type']) && $event_detail['fees_type'] ? $event_detail['fees_type'] : 'fixed',
                        'price' => $fees,
                        'total_price' => ($total_fees - $discount) > 0 ? ($total_fees - $discount) : 0,
                        'coupon' => $coupon_code,
                        'discount' => $discount,
                        'payment_type' => 'offline',
                        'note' => $note,
                        'payment_title' => 'Offline',
                        'process_status' => 'no_process',
                    ));
                    add_post_meta($booking_id, 'email', $email);

                    if($location){
                        $location_name = FAT_Event_Utils::get_location_title($location, ', ');
                        add_post_meta($booking_id, 'location_id', $location);
                        add_post_meta($booking_id, 'location_name', $location_name);
                    }
                    if(is_array($amenities) && count($amenities)>0){
                        add_post_meta($booking_id, 'amenities', implode('. ',$amenities));
                    }

                    $num_book += $quantity;
                    update_post_meta($event_id, $num_of_book_key, $num_book);
                    add_post_meta($booking_id, 'start_date', $start_date);
                    add_post_meta($booking_id, 'end_date', $end_date);
                    add_post_meta($booking_id, 'event_id', $event_id);
                    add_post_meta($booking_id, 'payment_type', 'offline');
                    add_post_meta($booking_id, 'process_status', 'no_process');
                    add_post_meta($booking_id, 'attention_code', $confirm_attention);
                    add_post_meta($booking_id, 'attention_status', 0);
                    add_post_meta($booking_id, 'has_send', 0);
                    add_post_meta($booking_id, 'email', $email);

                    // for compare
                    $booking_date_string = current_time( 'mysql', 0);
                    $booking_date_string = DateTime::createFromFormat('Y-m-d H:i:s',$booking_date_string);
                    add_post_meta($booking_id, 'start_date_string', $start_date->format('Y-m-d H:i:s'));
                    add_post_meta($booking_id, 'end_date_string', $end_date->format('Y-m-d H:i:s'));
                    add_post_meta($booking_id, 'booking_date_string', $booking_date_string->format('Y-m-d'));

                    //add_post_meta($booking_id, 'another_field', $another_field);
                    if ($ticket_class) {
                        add_post_meta($booking_id, 'ticket_class_id', $ticket_class);
                    }

                    $result = array(
                        'code' => $booking_id,
                        'message' => esc_html__('Thank you for your booking. See you soon in our event!','fat-event')
                    );
                }
            } else {
                $result = array(
                    'code' => -1,
                    'message' => esc_html__('Please input first name, last name, email', 'fat-event')
                );
            }
        } else {
            $result = array(
                'code' => -1,
                'message' => esc_html__('Data is invalid', 'fat-event')
            );
        }

        echo json_encode($result);
        wp_die();
    }
    add_action("wp_ajax_fat_event_add_booking", 'fat_event_add_booking_callback');
}

if(!function_exists('fat_event_duplicate_callback')){
    function fat_event_duplicate_callback(){
        if(!is_admin()){
            echo json_encode(array(
                'code' => -1,
                'message' => esc_html__('You are not authorized to perform this function', 'fat-event')
            ));
            wp_die();
            return;
        }
        $post_id = isset($_REQUEST['id']) && $_REQUEST['id'] ? $_REQUEST['id'] : 0;
        if($post_id > 0){
            global $wpdb;
            $current_user = wp_get_current_user();
            $new_post_author = $current_user->ID;

            $sql = "SELECT post_title, post_content, post_name, post_excerpt, comment_status, ping_status, post_password, post_parent, menu_order, post_type, to_ping
                    FROM {$wpdb->prefix}posts
                    WHERE ID=%d";
            $sql = $wpdb->prepare($sql, $post_id);
            $post = $wpdb->get_results($sql);
            if(count($post) > 0){
                $post = $post[0];
                $args = array(
                    'comment_status' => $post->comment_status,
                    'ping_status'    => $post->ping_status,
                    'post_author'    => $new_post_author,
                    'post_content'   => $post->post_content,
                    'post_excerpt'   => $post->post_excerpt,
                    'post_name'      => $post->post_name,
                    'post_parent'    => $post->post_parent,
                    'post_password'  => $post->post_password,
                    'post_status'    => 'draft',
                    'post_title'     => $post->post_title,
                    'post_type'      => $post->post_type,
                    'to_ping'        => $post->to_ping,
                    'menu_order'     => $post->menu_order
                );
                $new_post_id = wp_insert_post( $args );

                $taxonomies = get_object_taxonomies($post->post_type);
                foreach ($taxonomies as $taxonomy) {
                    $post_terms = wp_get_object_terms($post_id, $taxonomy, array('fields' => 'slugs'));
                    wp_set_object_terms($new_post_id, $post_terms, $taxonomy, false);
                }

                $sql = "SELECT meta_key, meta_value FROM {$wpdb->prefix}postmeta WHERE post_id=%d";
                $sql = $wpdb->prepare($sql, $post_id);
                $post_meta_infos = $wpdb->get_results($sql);
                if (count($post_meta_infos)!=0) {
                    $sql_query = "INSERT INTO $wpdb->postmeta (post_id, meta_key, meta_value) ";
                    foreach ($post_meta_infos as $meta_info) {
                        $meta_key = $meta_info->meta_key;
                        if( $meta_key == '_wp_old_slug' ) continue;
                        $meta_value = addslashes($meta_info->meta_value);
                        $sql_query_sel[]= "SELECT $new_post_id, '$meta_key', '$meta_value'";
                    }
                    $sql_query.= implode(" UNION ALL ", $sql_query_sel);
                    $wpdb->query($sql_query);
                }
            }

            echo json_encode(array(
                'code' => 1,
                'message' => esc_html__('Event has been copied','fat-event')
            ));
            wp_die();
        }else{
            echo json_encode(array(
                'code' => -1,
            ));
            wp_die();
        }
    }
    add_action("wp_ajax_fat_event_duplicate", 'fat_event_duplicate_callback');
}

