<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/28/2018
 * Time: 2:23 PM
 */
$fat_event_setting = get_option('fat_event_setting');
$currency = isset($fat_event_setting['currency']) ? $fat_event_setting['currency'] : 'USD';
$currency_symbol = isset($fat_event_setting['currency_symbol']) ? $fat_event_setting['currency_symbol'] : '$';
$currency_symbol = $currency_symbol ? $currency_symbol : $currency;

$ticket_detail_label =  isset($fat_event_setting['ticket_detail_label']) && $fat_event_setting['ticket_detail_label'] ? $fat_event_setting['ticket_detail_label'] : esc_html__('Ticket Detail','fat-event');
$fees_label =  isset($fat_event_setting['fees_label']) && $fat_event_setting['fees_label'] ? $fat_event_setting['fees_label'] : esc_html__('Fees','fat-event');
$seats_label =  isset($fat_event_setting['seats_label']) && $fat_event_setting['seats_label'] ? $fat_event_setting['seats_label'] : esc_html__('Seats','fat-event');
$seats_available_label =  isset($fat_event_setting['seats_available_label']) && $fat_event_setting['seats_available_label'] ? $fat_event_setting['seats_available_label'] : esc_html__('Seats available','fat-event');
$book_now_label =  isset($fat_event_setting['booking_button_label']) && $fat_event_setting['booking_button_label'] ? $fat_event_setting['booking_button_label'] : esc_html__('Book Now','fat-event');
?>
<script type="text/html" id="tmpl-fat-event-popup-template">
    <div class="fat-event-popup-modal">
        <div class="fat-event-popup-inner">
            <div class="fat-event-popup-detail">
                <a class="fat-close-popup"><i class="fa fa-times-circle"></i></a>
                <div class="fat-event-popup-thumb">
                    <img src="{{data.thumb}}">
                    <div class="fat-event-popup-info">
                        <div class="fat-event-popup-title">
                            {{data.title}}
                        </div>
                        <# if(data.time !=''){ #>
                        <div class="fat-event-popup-time">
                            <i class="fa fa-clock-o"></i> {{data.time}}
                        </div>
                        <# } #>
                        <# _.each(data.location, function(item){ #>
                            <div class="fat-event-popup-location">
                                <i class="fa fa-map-marker"></i> {{{item.location}}}
                                <# if(item.latitude!=''){ #>
                                <a href="https://www.google.com/maps/dir/?api=1&destination={{{item.latitude}}}"
                                   target="_blank"><i
                                            class="fa fa-location-arrow"></i><?php esc_html_e('Get directions', 'fat-event'); ?>
                                </a>
                                <# } #>
                            </div>
                        <# }) #>
                    </div>
                </div>
                <div class="fat-event-popup-content-wrap">
                    <div class="fat-event-popup-content">
                        <# if(data.amenities_position=='top_content' && data.amenities.length>0){ #>
                            <div class="fat-event-amenities-wrap">
                                <ul class="fat-event-amenities">
                                    <# _.each(data.amenities, function(item){ #>
                                        <li><i class="{{item.icon}}"></i><span>{{item.name}}</span></li>
                                    <# }) #>
                                </ul>
                            </div>
                        <# } #>

                        {{{data.content}}}

                        <# if(data.link_more_info !='' && data.label_more_info !=''){ #>
                        <div class="more-detail-wrap">
                            <a href="{{data.link_more_info}}" target="_blank">{{data.label_more_info}}</a>
                        </div>
                        <# } #>

                        <# if(data.amenities_position=='bottom_content' && data.amenities.length>0){ #>
                            <div class="fat-event-amenities-wrap">
                                <ul class="fat-event-amenities">
                                    <# _.each(data.amenities, function(item){ #>
                                    <li><i class="{{item.icon}}"></i><span>{{item.name}}</span></li>
                                    <# }) #>
                                </ul>
                            </div>
                        <# } #>
                    </div>
                    <div class="fat-event-meta-wrap">
                        <# if(data.organizer !='' && data.organizer.length >0 && data.organizer[0].name !=null){ #>
                        <div class="fat-event-meta-inner organizer-section">
                            <h4 class="fat-event-meta-title"><?php esc_html_e('Organizer(s)', 'fat-event'); ?></h4>
                            <# _.each(data.organizer, function(item){ #>
                            <div class="fat-event-organizer">
                                <span class="organizer-thumb"><img src="{{item.thumb}}"></span>
                                <ul class="organizer-info">
                                    <li>{{{item.name}}}</li>
                                    <# if(item.telephone !='' ){ #>
                                    <li><i class="fa fa-phone"></i> {{item.telephone}}</li>
                                    <# } #>
                                    <# if(item.email !='' ){ #>
                                    <li><i class="fa fa-envelope"></i><a href="mailto:{{item.email}}">{{item.email}}</a></li>
                                    <# } #>
                                    <# if(item.website !='' ){ #>
                                    <li><i class="fa fa-desktop"></i><a href="{{item.website}}"> {{item.website}}</a></li>
                                    <# } #>
                                    <li class="organizer-social">
                                        <# if(item.facebook !='' ){ #>
                                        <span><a href="{{item.facebook}}" target="_blank"> <i class="fa fa-facebook"></i></a></span>
                                        <# } #>
                                        <# if(item.twitter !='' ){ #>
                                        <span><a href="{{item.twitter}}" target="_blank"> <i class="fa fa-twitter"></i></a></span>
                                        <# } #>
                                        <# if(item.linkedin !='' ){ #>
                                        <span><a href="{{item.linkedin}}" target="_blank"> <i class="fa fa-linkedin"></i></a></span>
                                        <# } #>
                                    </li>
                                </ul>
                            </div>

                        <# }) #>
                        </div>
                        <# }#>

                        <# if(data.other_organizer !='' ){ #>
                        <div class="fat-event-meta-inner other-organizer">
                            <h4 class="fat-event-meta-title"><?php esc_html_e('Other Organizer', 'fat-event'); ?></h4>
                            <# _.each(data.other_organizer, function(item, i){ #>
                            <div class="fat-event-organizer fat-event-other-organizer fat-mg-bottom-15">
                                <span class="organizer-thumb"><img src="{{item.organizer_thumb}}"></span>
                                <ul class="organizer-info">
                                    <li>{{{item.organizer}}}</li>
                                    <# if(item.organizer_phone !='' ){ #>
                                    <li><i class="fa fa-phone"></i> {{item.organizer_phone}}</li>
                                    <# } #>
                                    <# if(item.organizer_mail !='' ){ #>
                                    <li><i class="fa fa-envelope"></i><a href="mailto:{{data.organizer_mail}}"> {{item.organizer_mail}}</a></li>
                                    <# } #>
                                    <# if(item.organizer_website !='' ){ #>
                                    <li><i class="fa fa-desktop"></i><a href="{{data.organizer_website}}"> {{item.organizer_website}}</a></li>
                                    <# } #>
                                    <li class="organizer-social">
                                        <# if(item.organizer_facebook !='' ){ #>
                                        <span><a href="{{item.organizer_facebook}}" target="_blank"> <i class="fa fa-facebook"></i></a></span>
                                        <# } #>
                                        <# if(item.organizer_twitter !='' ){ #>
                                        <span><a href="{{item.organizer_twitter}}" target="_blank"> <i class="fa fa-twitter"></i></a></span>
                                        <# } #>
                                        <# if(item.organizer_linkedin !='' ){ #>
                                        <span><a href="{{item.organizer_linkedin}}" target="_blank"> <i class="fa fa-linkedin"></i></a></span>
                                        <# } #>
                                    </li>
                                </ul>
                            </div>
                            <# }) #>
                        </div>
                        <# } #>

                        <# if(_.size(data.hourly_schedule)>0 && data.hourly_schedule[0].from !='' ){ #>
                        <div class="fat-event-meta-inner schedule-section">
                            <h4 class="fat-event-meta-title"><?php esc_html_e('Schedule', 'fat-event'); ?></h4>
                            <ul class="fat-event-hourly-schedule">
                                <# _.each(data.hourly_schedule, function(item){ #>
                                <li>
                                    <i class="fa fa-clock-o"></i>
                                    {{item.from}} - {{item.to}} : {{item.title}}
                                    <# if (item.description!=''){ #>
                                        <p class="fat-event-schedule-desc">{{item.description}}</p>
                                    <# } #>
                                    <# if (item.location!='' && item.location!='hide'){ #>
                                        <p class="fat-event-schedule-location"><i
                                                    class="fa fa-map-marker"></i> {{item.location}}
                                        </p>
                                    <# } #>
                                </li>
                                <# }) #>
                            </ul>
                        </div>
                        <# } #>

                        <# if(data.amenities_position=='sidebar' && data.amenities.length>0){ #>
                            <div class="fat-event-meta-inner amenities-section">
                                <h4 class="fat-event-meta-title"><?php esc_html_e('Amenities', 'fat-event'); ?></h4>
                                <ul class="fat-event-amenities amenities-sidebar">
                                    <# _.each(data.amenities, function(item){ #>
                                    <li><i class="{{item.icon}}"></i><span>{{item.name}}</span></li>
                                    <# }) #>
                                </ul>
                            </div>
                        <# } #>

                        <# if(data.enable_booking > 0 ){ #>
                        <div class="fat-event-meta-inner ticket-section">
                            <h4 class="fat-event-meta-title"><?php echo esc_html($ticket_detail_label); ?></h4>
                            <ul class="fat-event-popup-fees">
                                <# if(data.fees_type=='package'){ #>
                                    <?php esc_html_e('Fees package:', 'fat-event'); ?>
                                    <ul class="fat-event-fees-package">
                                        <# _.each(data.fees_package, function(item){ #>
                                        <li>
                                            {{item.quantity}} <?php echo esc_html__(' Ticket', 'fat-event'); ?>
                                            -
                                            <?php echo(isset($fat_event_setting['symbol_position']) && $fat_event_setting['symbol_position'] === 'prefix' ? $currency_symbol : ''); ?>
                                            {{item.fees}}<?php echo(!isset($fat_event_setting['symbol_position']) || $fat_event_setting['symbol_position'] === 'suffix' ? $currency_symbol : ''); ?>
                                        </li>
                                        <# }) #>
                                    </ul>
                                <# } #>

                                <# if(data.fees_type=='ticket_class'){ #>
                                <?php esc_html_e('Ticket classification:', 'fat-event'); ?>
                                <ul class="fat-event-fees-package ">
                                    <# _.each(data.ticket_class_loop, function(item){ #>
                                    <li>
                                        {{item.class}}
                                        -
                                        <?php echo(isset($fat_event_setting['symbol_position']) && $fat_event_setting['symbol_position'] === 'prefix' ? $currency_symbol : ''); ?>
                                        {{item.fees}}<?php echo(!isset($fat_event_setting['symbol_position']) || $fat_event_setting['symbol_position'] === 'suffix' ? $currency_symbol : ''); ?>
                                        &nbsp;
                                        <# if(item.seat!='0' && item.seat!=''){ #>
                                        <span class="seat-info"><?php echo esc_html($seats_label); ?>
                                            {{item.seat}}
                                            </span>
                                            <# if(data.enable_seat_available=='1'){ #>
                                                <div data-ticket-id="{{item.class_id}}" data-seats="{{item.seat_available}}"
                                                     class="fat-event-seats-available"><?php echo esc_html__('Available: ', 'fat-event'); ?><span>{{item.seat_available}}</span></div>
                                            <# } #>
                                       <# } #>

                                    </li>
                                    <# }) #>
                                </ul>
                                <# } #>

                                <# if(data.fees_type=='fixed' || data.fees_type==''){ #>
                                <li> <?php echo esc_html($fees_label); ?>
                                    <strong>
                                        <?php echo (isset($fat_event_setting['symbol_position']) && $fat_event_setting['symbol_position']==='prefix' ? $currency_symbol : ''); ?>{{data.fees_display}}<?php echo (!isset($fat_event_setting['symbol_position']) || $fat_event_setting['symbol_position']==='suffix' ? $currency_symbol : ''); ?>
                                    </strong>

                                </li>
                                <# } #>

                                <# if(data.fees_type!='ticket_class'){ #>
                                    <# if(data.seats!='0' && data.seats!=''){ #>
                                    - <?php echo esc_html($seats_label); ?> <strong>{{data.seats}}</strong>
                                    <# } #>
                                    <# if(data.enable_seat_available=='1'){ #>
                                    <div data-seats="{{data.seats}}"
                                         class="fat-event-seats-available"><?php echo esc_html($seats_available_label); ?>
                                        <strong>{{data.seats_available}}</strong></div>
                                    <# } #>
                                <# } #>

                                <li><a class="fat-event-register" data-id="{{data.id}}" data-payment="{{data.payment}}"
                                       href="{{data.external_link_booking}}" target="_blank"
                                       data-fees-type="{{data.fees_type}}"
                                       data-fees-package="{{data.fees_package}}"
                                       data-ticket-class="{{data.ticket_class}}"
                                       data-start="{{data.start_date}}" data-end="{{data.end_date}}"
                                       data-fees="{{data.fees}}"><?php echo esc_html($book_now_label); ?> <i
                                                class="fa fa-long-arrow-right"></i></a></li>

                            </ul>

                            <# if(data.enable_woocommerce == 1){ #>
                            <div class="fat-event-price-variable" data-fees-type="{{data.fees_type}}">
                                <# if(data.fees_type == 'ticket_class'){ #>
                                <div class="ticket-class-wrap">
                                    <label><?php echo esc_html__('Select ticket', 'fat-event'); ?></label>
                                    <select name="ticket_class" id="ticket_class">
                                        <# _.each(data.ticket_class_loop, function(item){ #>
                                        <option value="{{item.class_id}}"
                                                data-class="{{item.class}}"
                                                data-seat="{{item.seat}}" data-seat-available="{{item.seat_available}}">
                                            {{item.class}}
                                        </option>
                                        <# }); #>
                                    </select>
                                </div>
                                <div class="ticket-number-wrap">
                                    <label><?php esc_html_e('Number of ticket', 'fat-event'); ?></label>
                                    <select name="ticket_number" id="ticket_number">
                                    </select>
                                </div>
                                <# } #>

                                <# if(data.fees_type == 'package'){ #>
                                <div class="ticket-number-wrap">
                                    <label><?php esc_html_e('Number of ticket', 'fat-event'); ?></label>
                                    <select name="ticket_number" id="ticket_number">
                                        <# _.each(data.fees_package, function(item){ #>
                                        <option value="{{item.quantity}}" data-seat="{{data.seats_available}}">
                                            {{item.quantity}}
                                        </option>
                                        <# }); #>
                                    </select>
                                </div>
                                <# } #>

                                <# if(data.fees_type == 'fixed'){ #>
                                <div class="ticket-number-wrap">
                                    <label><?php esc_html_e('Number of ticket', 'fat-event'); ?></label>
                                    <select name="ticket_number" id="ticket_number">
                                        <# for (var i = 1; i <= data.seats_available; i++) { #>
                                        <option value="{{i}}" data-seat="{{data.seats_available}}">
                                            {{i}}
                                        </option>
                                        <# }; #>
                                    </select>
                                </div>
                                <# } #>

                                <a href="javascript:" class="fat-bt-submit-to-WC"><?php echo esc_html__('Submit', 'fat-event'); ?></a>
                            </div>
                            <# } #>

                        </div>
                        <# } #>

                        <h4 class="fat-event-meta-title export-section"><?php esc_html_e('Export', 'fat-event'); ?></h4>
                        <div class="fat-event-export fat-mg-bottom-15">
                            <a target="_blank" href="<?php echo home_url('/').'?action=fat_event_export_ical';?>" class="fat-event-export-ical"><i class="fa fa-calendar"></i><?php echo esc_html__('Ical','fat-event');?></a>
                        </div>

                        <?php
                        $fat_event_setting = get_option('fat_event_setting');
                        if (isset($fat_event_setting['enable_social'][0]) && $fat_event_setting['enable_social'][0] === '1'):
                            ?>
                            <div class="fat-event-meta-inner share-section">
                                <h4 class="fat-event-meta-title"><?php esc_html_e('Share our event', 'fat-event'); ?></h4>
                                <div class="fat-event-share" data-link="{{data.link_detail}}" data-title="{{data.title}}"
                                     data-thumb="{{data.thumb}}">
                                    <?php if ($fat_event_setting['enable_facebook'][0] && $fat_event_setting['enable_facebook'][0] === '1'): ?>
                                        <a data-social="facebook" class="fat-event-share-facebook transition-30"
                                           href="javascript:"><i class="fa fa-facebook"></i></a>
                                    <?php endif; ?>
                                    <?php if (isset($fat_event_setting['enable_twitter'][0]) && $fat_event_setting['enable_twitter'][0] === '1'): ?>
                                        <a data-social="twitter" class="fat-event-share-twitter transition-30"
                                           href="javascript:"><i class="fa fa-twitter"></i></a>
                                    <?php endif; ?>
                                    <?php if ( isset($fat_event_setting['enable_google_plus'][0]) && $fat_event_setting['enable_google_plus'][0] === '1'): ?>
                                        <a data-social="google" class="fat-event-share-google-plus transition-30"
                                           href="javascript:"><i class="fa fa-google-plus"></i></a>
                                    <?php endif; ?>
                                    <?php if ( isset($fat_event_setting['enable_email'][0]) && $fat_event_setting['enable_email'][0] === '1'): ?>
                                        <a class="fat-event-share-mail transition-30"
                                           href="mailto:?subject={{data.title}}&body=Time: {{data.time}} %0ALocation: {{data.email_location}} %0AOrganizer: {{data.main_organizer_name}} %0A{{data.excerpt}}%0A{{data.link_detail}}"><i
                                                    class="fa fa-envelope-o"></i></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="fat-event-popup-button">
                </div>
            </div>

        </div>
    </div>
</script>
