<?php
$fat_event_setting = get_option('fat_event_setting');
$currency = isset($fat_event_setting['currency']) ? $fat_event_setting['currency'] : 'USD';
$currency_symbol = isset($fat_event_setting['currency_symbol']) ? $fat_event_setting['currency_symbol'] : '$';
$currency_symbol = $currency_symbol ? $currency_symbol : $currency;
$symbol_position = isset($fat_event_setting['symbol_position']) && $fat_event_setting['symbol_position'] ? $fat_event_setting['symbol_position'] : 'suffix';

$popup_class = 'fat-event-popup-modal booking-popup';
$popup_class .= isset($fat_event_setting['show_amenities_in_booking'][0]) && $fat_event_setting['show_amenities_in_booking'][0]=='1' ? ' show-amenities-field' : '';
?>
<script type="text/html" id="tmpl-fat-event-popup-booking-template">
    <div class="<?php echo esc_attr($popup_class);?>"
         data-currency-symbol="<?php echo esc_attr($currency_symbol); ?>"
         data-symbol-position="<?php echo esc_attr($symbol_position); ?>">
        <div class="fat-event-popup-inner">
            <div class="fat-event-popup-booking">
                <a class="fat-close-popup"><i class="fa fa-times-circle"></i></a>
                <div class="fat-form-field">
                    <div class="fat-popup-title">
                        <h4><?php esc_html_e('Booking form', 'fat-event'); ?></h4>
                    </div>
                    <div class="fat-popup-fields">

                        <div class="fat-popup-field fat-popup-field-half-size">
                            <label for="optEvent"><?php echo esc_html__('Select event', 'fat-event'); ?> <span
                                        style="color: red">*</span></label>
                            <select id="optEvent" required>
                            </select>
                            <div class="field-error-message">
                                <?php esc_html_e('Please choose event', 'fat-event'); ?>
                            </div>

                        </div>
                        <div class="fat-popup-field fat-popup-field-half-size">
                            <label for="optEventDate"><?php echo esc_html__('Select date', 'fat-event'); ?> <span
                                        style="color: red">*</span></label>
                            <select id="optEventDate" required >
                            </select>
                            <div class="field-error-message">
                                <?php echo esc_html__('Please choose event date','fat-event'); ?>
                            </div>
                        </div>

                        <div class="fat-popup-field fat-popup-field-half-size">
                            <label for="txtFirstName"><?php echo esc_html__('First name', 'fat-event'); ?> <span
                                    style="color: red">*</span></label>
                            <input type="text" id="txtFirstName" required
                                   placeholder="<?php echo esc_html__('First name', 'fat-event'); ?>">
                            <div class="field-error-message">
                                <?php esc_html_e('Please input first name', 'fat-event'); ?>
                            </div>
                        </div>
                        <div class="fat-popup-field fat-popup-field-half-size">
                            <label for="txtLastName"><?php echo esc_html__('Last name', 'fat-event'); ?> <span
                                    style="color: red">*</span></label>
                            <input type="text" id="txtLastName" required
                                   placeholder="<?php echo esc_html__('Last name', 'fat-event'); ?>">
                            <div class="field-error-message">
                                <?php esc_html_e('Please input last name', 'fat-event'); ?>
                            </div>
                        </div>

                        <div class="fat-popup-field fat-popup-field-half-size">
                            <label for="optGender"><?php echo esc_html__('Gender', 'fat-event'); ?></label>
                            <select id="optGender"
                                    placeholder="<?php echo esc_html__('Gender', 'fat-event'); ?>"
                                    data-error="">
                                <option value="male"><?php echo esc_html__('Male', 'fat-event'); ?></option>
                                <option value="female"><?php echo esc_html__('Female', 'fat-event'); ?></option>
                            </select>
                        </div>

                        <div class="fat-popup-field fat-popup-field-half-size">
                            <label for="txtEmail"><?php echo esc_html__('Email', 'fat-event'); ?> <span
                                    style="color: red">*</span></label>
                            <input type="email" id="txtEmail" required
                                   placeholder="<?php echo esc_html__('Email', 'fat-event'); ?>">
                            <div class="field-error-message">
                                <?php esc_html_e('Email is invalid', 'fat-event'); ?>
                            </div>
                        </div>

                        <div class="fat-popup-field fat-popup-field-half-size">
                            <label for="txtPhone"><?php echo esc_html__('Phone', 'fat-event'); ?> <span
                                    style="color: red">*</span></label>
                            <input type="text" id="txtPhone" required
                                   placeholder="<?php echo esc_html__('Phone', 'fat-event'); ?>"
                                   data-error="<?php esc_html_e('Please input phone number', 'fat-event'); ?>">
                        </div>
                        <div class="fat-popup-field fat-popup-field-half-size">
                            <label for="txtDepartment"><?php echo esc_html__('Department', 'fat-event'); ?></label>
                            <input type="text" id="txtDepartment"
                                   placeholder="<?php echo esc_html__('Department', 'fat-event'); ?>">

                        </div>

                        <div class="fat-popup-field">
                            <label for="txtCompany"><?php echo esc_html__('Company', 'fat-event'); ?></label>
                            <input type="text" id="txtCompany"
                                   placeholder="<?php echo esc_html__('Company', 'fat-event'); ?>">
                        </div>

                        <div class="fat-popup-field fat-popup-field-half-size">
                            <label for="txtAddress"><?php echo esc_html__('Address', 'fat-event'); ?></label>
                            <input type="text" id="txtAddress"
                                   placeholder="<?php echo esc_html__('Address', 'fat-event'); ?>">
                        </div>
                        <div class="fat-popup-field fat-popup-field-half-size">
                            <label for="optCountry"><?php echo esc_html__('Country', 'fat-event'); ?></label>
                            <select id="optCountry">
                                <?php if (isset($fat_event_setting['enable_country_limit'][0]) && $fat_event_setting['enable_country_limit'][0] == '1'
                                    && isset($fat_event_setting['allow_country']) && $fat_event_setting['allow_country']):
                                    foreach ($fat_event_setting['allow_country'] as $c) {
                                        ?>
                                        <option value="<?php echo esc_attr($c); ?>"><?php echo esc_html($c); ?></option>
                                    <?php } else: ?>
                                    <option value="Afghanistan">Afghanistan</option>
                                    <option value="Albania">Albania</option>
                                    <option value="Algeria">Algeria</option>
                                    <option value="Andorra">Andorra</option>
                                    <option value="Angola">Angola</option>
                                    <option value="Antigua and Barbuda">Antigua and Barbuda</option>
                                    <option value="Argentina">Argentina</option>
                                    <option value="Armenia">Armenia</option>
                                    <option value="Australia">Australia</option>
                                    <option value="Austria">Austria</option>
                                    <option value="Azerbaijan">Azerbaijan</option>
                                    <option value="The Bahamas">The Bahamas</option>
                                    <option value="Bahrain">Bahrain</option>
                                    <option value="Bangladesh">Bangladesh</option>
                                    <option value="Barbados">Barbados</option>
                                    <option value="Belarus">Belarus</option>
                                    <option value="Belgium">Belgium</option>
                                    <option value="Belize">Belize</option>
                                    <option value="Benin">Benin</option>
                                    <option value="Bhutan">Bhutan</option>
                                    <option value="Bolivia">Bolivia</option>
                                    <option value="Bosnia and Herzegovina">Bosnia and Herzegovina</option>
                                    <option value="Botswana">Botswana</option>
                                    <option value="Brazil">Brazil</option>
                                    <option value="Brunei">Brunei</option>
                                    <option value="Bulgaria">Bulgaria</option>
                                    <option value="Burkina Faso">Burkina Faso</option>
                                    <option value="Burundi">Burundi</option>
                                    <option value="Cabo Verde">Cabo Verde</option>
                                    <option value="Cambodia">Cambodia</option>
                                    <option value="Cameroon">Cameroon</option>
                                    <option value="Canada">Canada</option>
                                    <option value="Central African Republic">Central African Republic</option>
                                    <option value="Chad">Chad</option>
                                    <option value="Chile">Chile</option>
                                    <option value="China">China</option>
                                    <option value="Colombia">Colombia</option>
                                    <option value="Comoros">Comoros</option>
                                    <option value="Congo, Democratic  Republic of the">Congo, Democratic Republic
                                    </option>
                                    <option value="Congo, Republic of the">Congo, Republic of the</option>
                                    <option value="Costa Rica">Costa Rica</option>
                                    <option value="Côte d’Ivoire">Côte d’Ivoire</option>
                                    <option value="Croatia">Croatia</option>
                                    <option value="Cuba">Cuba</option>
                                    <option value="Cyprus">Cyprus</option>
                                    <option value="Czech Republic">Czech Republic</option>
                                    <option value="Denmark">Denmark</option>
                                    <option value="Djibouti">Djibouti</option>
                                    <option value="Dominica">Dominica</option>
                                    <option value="Dominican Republic">Dominican Republic</option>
                                    <option value="East Timor">East Timor</option>
                                    <option value="Ecuador">Ecuador</option>
                                    <option value="Egypt">Egypt</option>
                                    <option value="El Salvador">El Salvador</option>
                                    <option value="Equatorial Guinea">Equatorial Guinea</option>
                                    <option value="Eritrea">Eritrea</option>
                                    <option value="Estonia">Estonia</option>
                                    <option value="Ethiopia">Ethiopia</option>
                                    <option value="Fiji">Fiji</option>
                                    <option value="Finland">Finland</option>
                                    <option value="France">France</option>
                                    <option value="Gabon">Gabon</option>
                                    <option value="The Gambia">The Gambia</option>
                                    <option value="Georgia">Georgia</option>
                                    <option value="Germany">Germany</option>
                                    <option value="Ghana">Ghana</option>
                                    <option value="Greece">Greece</option>
                                    <option value="Grenada">Grenada</option>
                                    <option value="Guatemala">Guatemala</option>
                                    <option value="Guinea">Guinea</option>
                                    <option value="Guinea-Bissau">Guinea-Bissau</option>
                                    <option value="Guyana">Guyana</option>
                                    <option value="Haiti">Haiti</option>
                                    <option value="Honduras">Honduras</option>
                                    <option value="Hungary">Hungary</option>
                                    <option value="Iceland">Iceland</option>
                                    <option value="India">India</option>
                                    <option value="Indonesia">Indonesia</option>
                                    <option value="Iran">Iran</option>
                                    <option value="Iraq">Iraq</option>
                                    <option value="Ireland">Ireland</option>
                                    <option value="Israel">Israel</option>
                                    <option value="Italy">Italy</option>
                                    <option value="Jamaica">Jamaica</option>
                                    <option value="Japan">Japan</option>
                                    <option value="Jordan">Jordan</option>
                                    <option value="Kazakhstan">Kazakhstan</option>
                                    <option value="Kenya">Kenya</option>
                                    <option value="Kiribati">Kiribati</option>
                                    <option value="Korea, North">Korea, North</option>
                                    <option value="Korea, South">Korea, South</option>
                                    <option value="Kosovo">Kosovo</option>
                                    <option value="Kuwait">Kuwait</option>
                                    <option value="Kyrgyzstan">Kyrgyzstan</option>
                                    <option value="Laos">Laos</option>
                                    <option value="Latvia">Latvia</option>
                                    <option value="Lebanon">Lebanon</option>
                                    <option value="Lesotho">Lesotho</option>
                                    <option value="Liberia">Liberia</option>
                                    <option value="Libya">Libya</option>
                                    <option value="Liechtenstein">Liechtenstein</option>
                                    <option value="Lithuania">Lithuania</option>
                                    <option value="Luxembourg">Luxembourg</option>
                                    <option value="Macedonia">Macedonia</option>
                                    <option value="Madagascar">Madagascar</option>
                                    <option value="Malawi">Malawi</option>
                                    <option value="Malaysia">Malaysia</option>
                                    <option value="Maldives">Maldives</option>
                                    <option value="Mali">Mali</option>
                                    <option value="Malta">Malta</option>
                                    <option value="Marshall Islands">Marshall Islands</option>
                                    <option value="Mauritania">Mauritania</option>
                                    <option value="Mauritius">Mauritius</option>
                                    <option value="Mexico">Mexico</option>
                                    <option value="Micronesia,  Federated States of">Micronesia, Federated States
                                    </option>
                                    <option value="Moldova">Moldova</option>
                                    <option value="Monaco">Monaco</option>
                                    <option value="Mongolia">Mongolia</option>
                                    <option value="Montenegro">Montenegro</option>
                                    <option value="Morocco">Morocco</option>
                                    <option value="Mozambique">Mozambique</option>
                                    <option value="Myanmar">Myanmar</option>
                                    <option value="Namibia">Namibia</option>
                                    <option value="Nauru">Nauru</option>
                                    <option value="Nepal">Nepal</option>
                                    <option value="Netherlands">Netherlands</option>
                                    <option value="New Zealand">New Zealand</option>
                                    <option value="Nicaragua">Nicaragua</option>
                                    <option value="Niger">Niger</option>
                                    <option value="Nigeria">Nigeria</option>
                                    <option value="Norway">Norway</option>
                                    <option value="Oman">Oman</option>
                                    <option value="Pakistan">Pakistan</option>
                                    <option value="Palau">Palau</option>
                                    <option value="Panama">Panama</option>
                                    <option value="Papua New Guinea">Papua New Guinea</option>
                                    <option value="Paraguay">Paraguay</option>
                                    <option value="Peru">Peru</option>
                                    <option value="Philippines">Philippines</option>
                                    <option value="Poland">Poland</option>
                                    <option value="Portugal">Portugal</option>
                                    <option value="Qatar">Qatar</option>
                                    <option value="Romania">Romania</option>
                                    <option value="Russia">Russia</option>
                                    <option value="Rwanda">Rwanda</option>
                                    <option value="Saint Kitts and Nevis">Saint Kitts and Nevis</option>
                                    <option value="Saint Lucia">Saint Lucia</option>
                                    <option value="Saint Vincent and  the Grenadines">Saint Vincent and the
                                        Grenadines
                                    </option>
                                    <option value="Samoa">Samoa</option>
                                    <option value="San Marino">San Marino</option>
                                    <option value="Sao Tome and Principe">Sao Tome and Principe</option>
                                    <option value="Saudi Arabia">Saudi Arabia</option>
                                    <option value="Senegal">Senegal</option>
                                    <option value="Serbia">Serbia</option>
                                    <option value="Seychelles">Seychelles</option>
                                    <option value="Sierra Leone">Sierra Leone</option>
                                    <option value="Singapore">Singapore</option>
                                    <option value="Slovakia">Slovakia</option>
                                    <option value="Slovenia">Slovenia</option>
                                    <option value="Solomon Islands">Solomon Islands</option>
                                    <option value="Somalia">Somalia</option>
                                    <option value="South Africa">South Africa</option>
                                    <option value="Spain">Spain</option>
                                    <option value="Sri Lanka">Sri Lanka</option>
                                    <option value="Sudan">Sudan</option>
                                    <option value="Sudan, South">Sudan, South</option>
                                    <option value="Suriname">Suriname</option>
                                    <option value="Swaziland">Swaziland</option>
                                    <option value="Sweden">Sweden</option>
                                    <option value="Switzerland">Switzerland</option>
                                    <option value="Syria">Syria</option>
                                    <option value="Taiwan">Taiwan</option>
                                    <option value="Tajikistan">Tajikistan</option>
                                    <option value="Tanzania">Tanzania</option>
                                    <option value="Thailand">Thailand</option>
                                    <option value="Togo">Togo</option>
                                    <option value="Tonga">Tonga</option>
                                    <option value="Trinidad and Tobago">Trinidad and Tobago</option>
                                    <option value="Tunisia">Tunisia</option>
                                    <option value="Turkey">Turkey</option>
                                    <option value="Turkmenistan">Turkmenistan</option>
                                    <option value="Tuvalu">Tuvalu</option>
                                    <option value="Uganda">Uganda</option>
                                    <option value="Ukraine">Ukraine</option>
                                    <option value="United Arab Emirates">United Arab Emirates</option>
                                    <option value="United Kingdom">United Kingdom</option>
                                    <option value="United States">United States</option>
                                    <option value="Uruguay">Uruguay</option>
                                    <option value="Uzbekistan">Uzbekistan</option>
                                    <option value="Vanuatu">Vanuatu</option>
                                    <option value="Vatican City">Vatican City</option>
                                    <option value="Venezuela">Venezuela</option>
                                    <option value="Vietnam">Vietnam</option>
                                    <option value="Yemen">Yemen</option>
                                    <option value="Zambia">Zambia</option>
                                    <option value="Zimbabwe">Zimbabwe</option>
                                <?php endif; ?>
                            </select>
                        </div>

                        <div class="fat-popup-field fat-popup-field-half-size fat-event-quantity-info">
                            <label for="numQuantity"
                                   data-package-label="<?php echo esc_attr__('Tickets', 'fat-event'); ?>"
                                   data-package-title="<?php echo esc_attr__('Ticket', 'fat-event'); ?>">
                                <?php echo esc_html__('Quantity', 'fat-event'); ?>
                            </label>
                            <input type="number" id="numQuantity" value="1" min="1"
                                   placeholder="<?php echo esc_html__('Quantity', 'fat-event'); ?>"
                                   data-error="<?php esc_html_e('Please input quantity', 'fat-event'); ?>">
                        </div>

                        <div class="fat-popup-field fat-event-package-quantity-info fat-hidden-field">
                            <label for="numQuantity"
                                   data-package-label="<?php echo esc_attr__('Tickets', 'fat-event'); ?>"
                                   data-package-title="<?php echo esc_attr__('Ticket', 'fat-event'); ?>">
                                <?php echo esc_html__('Quantity', 'fat-event'); ?>
                            </label>
                            <select id="optPackageQuantity">

                            </select>
                        </div>

                        <div class="fat-popup-field fat-popup-field-one-third-size fat-event-ticket-class-info fat-hidden-field">
                            <label for="optTicketClass">
                                <?php echo esc_html__('Classification', 'fat-event'); ?>
                            </label>
                            <select name="optTicketClass" id="optTicketClass">

                            </select>
                        </div>

                        <div class="fat-popup-field fat-popup-field-half-size fat-event-fees-info"
                             data-symbol-position="<?php echo esc_attr($fat_event_setting['symbol_position']); ?>"
                             data-decimal="<?php echo isset($fat_event_setting['currency_decimal']) && $fat_event_setting['currency_decimal'] ? $fat_event_setting['currency_decimal'] : 0; ?>"
                             data-separator="<?php echo isset($fat_event_setting['currency_separator']) ? $fat_event_setting['currency_separator'] : ','; ?>"
                        >
                            <?php if (isset($fat_event_setting['symbol_position']) && $fat_event_setting['symbol_position'] === 'prefix'): ?>
                                x <?php echo esc_html($currency_symbol); ?><span class="fat-event-fees"></span>
                                = <?php echo esc_html($currency_symbol); ?><span
                                    class="fat-event-total-fees"></span>
                            <?php else: ?>
                                x <span class="fat-event-fees"></span><?php echo esc_html($currency_symbol); ?>
                                <span class=fat-event-discount></span>
                                =
                                <span class="fat-event-total-fees"></span><?php echo esc_html($currency_symbol); ?>
                            <?php endif; ?>
                        </div>

                        <?php if (isset($fat_event_setting['enable_coupon'][0]) && $fat_event_setting['enable_coupon'][0] == '1') : ?>
                            <div class="fat-coupon-wrap clear-both">
                                <div class="fat-popup-field fat-popup-field-half-size">
                                    <label for="txtCoupon"><?php echo esc_html__('Coupon', 'fat-event'); ?></label>
                                    <input type="text" id="txtCoupon" value=""
                                           placeholder="<?php echo esc_html__('Coupon code', 'fat-event'); ?>">
                                </div>
                                <div class="fat-popup-field fat-popup-field-half-size">
                                    <label>&nbsp;</label>
                                    <a href="javascript:" class="fat-popup-bt bt-apply-coupon"
                                       data-currency="<?php echo esc_attr($currency_symbol); ?>"><?php echo esc_html__('Apply coupon', 'fat-event'); ?></a>
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="fat-popup-field">
                            <label for="txtNote"><?php echo esc_html__('Note', 'fat-event'); ?></label>
                            <textarea id="txtNote"
                                      placeholder="<?php echo esc_html__('Note', 'fat-event'); ?>"></textarea>
                        </div>

                    </div>

                    <div class="fat-popup-field fat-popup-footer text-center">
                        <div class="fat-popup-error-message fat-hidden-field"></div>
                        <a href="javascript:" class="fat-popup-bt fat-popup-bt-submit fs-16 text-upper">
                            <span><?php esc_html_e('Booking now', 'fat-event'); ?></span>
                        </a>
                        <a href="javascript:" class="fat-popup-bt fat-popup-bt-cancel fs-16 text-upper">
                            <span><?php esc_html_e('Cancel', 'fat-event'); ?></span>
                        </a>
                    </div>
                </div>
            </div>

        </div>
    </div>
</script>
