<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/8/2018
 * Time: 4:28 PM
 */
$fat_event_setting = get_option('fat_event_setting');
?>
<script type="text/html" id="tmpl-fat-event-location-template">
    <div class="fat-event-popup-modal">
        <div class="fat-event-popup-inner fat-event-location-popup">
            <div class="fat-event-popup-title">
                <h4><?php echo esc_html__('Add new location', 'fat-event'); ?></h4>
                <a class="fat-close-popup"><i class="fa fa-times-circle"></i></a>
            </div>
            <div class="fat-event-field-group">
                <div class="fat-event-field fat-event-half-size-field">
                    <label><?php esc_html_e('Name', 'fat-event'); ?></label>
                    <input type="text" id="location_name" name="location_name" class="field-value">
                </div>
                <div class="fat-event-field fat-event-half-size-field" style="padding-left: 5px;">
                    <label><?php esc_html_e('Address', 'fat-event'); ?></label>
                    <input type="text" id="location_address" name="location_address" class="field-value">
                </div>
                <div class="fat-event-field ">
                    <label><?php esc_html_e('Map', 'fat-event'); ?></label>
                    <?php if( isset($fat_event_setting['map_source']) && $fat_event_setting['map_source']=='mapbox') : ?>
                        <input type="text" id="location_map" name="location_map" class="field-value fat-mapbox-location">
                        <div class="fat-mapbox-wrap">
                            <div class="fat-mapbox" id="fat_mapbox" data-access-token="<?php echo esc_attr($fat_event_setting['mapbox_access_token'] );?>">
                            </div>
                        </div>
                    <?php else: ?>
                        <input type="text" id="location_map" name="location_map" class="field-value fat-google-map-location">
                        <input type="text" name="location_map_search" class="search-box">
                        <div class="fat-google-map">
                        </div>
                    <?php endif; ?>
                </div>
                <div class="fat-event-field fat-cmb-images-wrap">
                    <label for="thumbnail"><?php echo esc_html__('Thumbnail','fat-event');?></label>
                    <div class="fat-add-single-image-wrap fat-cmb-field">
                        <input type="hidden" name="thumbnail" id="thumbnail" data-field-id="thumbnail" value="">
                        <div class="fat-list-image" data-input-id="thumbnail">
                        </div>
                        <a href="javascript:" class="fat-add-single-image" data-input-id="thumbnail"><?php echo esc_html__('Choice image','fat-event');?></a>
                    </div>
                </div>
            </div>
            <div class="fat-event-popup-button-group">
                <a class="fat-event-bt fat-bt-save"><?php esc_attr_e('Save', 'fat-event'); ?></a>
                <a class="fat-event-bt fat-bt-cancel"><?php esc_attr_e('Cancel', 'fat-event'); ?></a>
            </div>
        </div>
    </div>
</script>

<script type="text/html" id="tmpl-fat-event-organizer-template">
    <div class="fat-event-popup-modal">
        <div class="fat-event-popup-inner fat-event-organizer-popup">
            <div class="fat-event-popup-title">
                <h4><?php echo esc_html__('Add new organizer', 'fat-event'); ?></h4>
                <a class="fat-close-popup"><i class="fa fa-times-circle"></i></a>
            </div>
            <div class="fat-event-field-group">
                <div class="fat-event-field fat-event-half-size-field">
                    <label><?php esc_html_e('Name', 'fat-event'); ?></label>
                    <input type="text" id="name" name="name" class="field-value">
                </div>
                <div class="fat-event-field fat-event-half-size-field" style="padding-left: 5px;">
                    <label><?php esc_html_e('Telephone', 'fat-event'); ?></label>
                    <input type="text" id="telephone" name="telephone" class="field-value">
                </div>
                <div class="fat-event-field">
                    <label><?php esc_html_e('Website', 'fat-event'); ?></label>
                    <input type="text" id="website" name="website" class="field-value">
                </div>
                <div class="fat-event-field fat-event-half-size-field">
                    <label><?php esc_html_e('Email', 'fat-event'); ?></label>
                    <input type="text" id="email" name="email" class="field-value">
                </div>
                <div class="fat-event-field fat-event-half-size-field" style="padding-left: 5px;">
                    <label><?php esc_html_e('Facebook', 'fat-event'); ?></label>
                    <input type="text" id="facebook" name="facebook" class="field-value">
                </div>
                <div class="fat-event-field fat-event-half-size-field">
                    <label><?php esc_html_e('Twitter', 'fat-event'); ?></label>
                    <input type="text" id="twitter" name="twitter" class="field-value">
                </div>
                <div class="fat-event-field fat-event-half-size-field" style="padding-left: 5px;">
                    <label><?php esc_html_e('LinkedIn', 'fat-event'); ?></label>
                    <input type="text" id="linkedin" name="linkedin" class="field-value">
                </div>
                <div class="fat-event-field fat-cmb-images-wrap">
                    <label for="thumbnail">Thumbnail</label>
                    <div class="fat-add-single-image-wrap fat-cmb-field">
                        <input type="hidden" name="thumbnail" id="thumbnail" data-field-id="thumbnail" value="">
                        <div class="fat-list-image" data-input-id="thumbnail">
                        </div>
                        <a href="javascript:" class="fat-add-single-image" data-input-id="thumbnail"><?php echo esc_html__('Choice image','fat-event');?></a>
                    </div>
                </div>
            </div>
            <div class="fat-event-popup-button-group">
                <a class="fat-event-bt fat-bt-save"><?php esc_attr_e('Save', 'fat-event'); ?></a>
                <a class="fat-event-bt fat-bt-cancel"><?php esc_attr_e('Cancel', 'fat-event'); ?></a>
            </div>
        </div>
    </div>
</script>

<script type="text/html" id="tmpl-fat-event-attendees-template">
    <div class="fat-event-slide-modal">
        <div class="fat-event-slide-inner">
            <div class="fat-event-slide-title">
                <h4><?php echo esc_html__('List Attendees', 'fat-event'); ?></h4>
                <a class="fat-close-slide"><i class="fa fa-times-circle"></i></a>
            </div>
            <div class="fat-event-export-wrap">
                <a href="javascript:" class="fat-event-export-excel"><i class="fa fa-file-excel-o"></i><?php echo esc_html__('Export to Excel','fat-event');?></a>
            </div>
            <table cellpadding="0" cellspacing="0">
                <thead>
                    <th class="list-number"><?php echo esc_html__('No','fat-event');?></th>
                    <th class="full-name"><?php echo esc_html__('Full name','fat-event');?></th>
                    <th class="email"><?php echo esc_html__('Email','fat-event');?></th>
                    <th class="phone"><?php echo esc_html__('Phone','fat-event');?></th>
                    <th class="address"><?php echo esc_html__('Address','fat-event');?></th>
                    <th class="company"><?php echo esc_html__('Company','fat-event');?></th>
                    <th class="quantity"><?php echo esc_html__('Quantity','fat-event');?></th>
                    <th class="ticket"><?php echo esc_html__('Ticket name','fat-event');?></th>
                    <th class="price"><?php echo esc_html__('Price','fat-event');?></th>
                    <th class="total-price"><?php echo esc_html__('Total price','fat-event');?></th>
                    <th class="start-date"><?php echo esc_html__('Start date','fat-event');?></th>
                    <th class="end-date"><?php echo esc_html__('End date','fat-event');?></th>
                    <th class="location"><?php echo esc_html__('Location','fat-event');?></th>
                    <th class="amenities"><?php echo esc_html__('Amenities','fat-event');?></th>
                    <th class="custom-field" style="max-width: 200px"><?php echo esc_html__('Custom field','fat-event');?></th>
                    <th class="payment-type"><?php echo esc_html__('Payment type','fat-event');?></th>
                </thead>
                <tbody>
                <# _.each(data, function(item, i){ #>
                <tr>
                    <td  class="list-number text-center">{{i+1}}</td>
                    <td  class="full-name">{{{item.full_name}}}</td>
                    <td  class="email">{{{item.email}}}</td>
                    <td  class="phone">{{{item.phone}}}</td>
                    <td  class="address">{{{item.address}}}</td>
                    <td  class="company">{{{item.company}}}</td>
                    <td  class="quantity text-center">{{{item.quantity}}}</td>
                    <td  class="ticket ">{{{item.ticket}}}</td>
                    <td  class="price text-right">{{{item.price}}}</td>
                    <td  class="total-price text-right">{{{item.total_price}}}</td>
                    <td  class="start-date">{{{item.start_date}}}</td>
                    <td  class="end-date">{{{item.end_date}}}</td>
                    <td  class="location">{{{item.location}}}</td>
                    <td  class="amenities">{{{item.amenities}}}</td>
                    <td  class="custom-field" style="max-width: 200px">{{{item.custom_field}}}</td>
                    <td  class="payment-type text-right">{{{item.payment_type}}}</td>
                </tr>
                <# }) #>
                </tbody>
            </table>
           <!-- <div class="fat-event-export-wrap">
                <a href="javascript:" class="fat-event-export-excel"><i class="fa fa-file-excel-o"></i><?php /*echo esc_html__('Export to Excel','fat-event');*/?></a>
            </div>-->
        </div>
    </div>
</script>
