<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/30/2018
 * Time: 9:02 AM
 */
$bg =  get_post_meta($event['id'], 'fat-mb-event-bg-image', true);
$bg = isset($bg['bg_image']) ? $bg['bg_image'] : '';
if($bg!==''){
    $bg = 'background-image:url('.wp_get_attachment_image_url($bg, 'full').');';
}
?>
<div class="cd-timeline-block timeline-skin-03 <?php echo ($bg ? 'has-background' : ''); ?>" data-event-id="<?php echo esc_attr($event['id']); ?>">
    <div class="cd-timeline-node" style="background-color: <?php echo esc_attr($bd_color); ?>;"></div>
    <div class="cd-timeline-content" style="<?php echo esc_attr($bg);?>">
        <?php if($bg):?>
        <div class="fat-event-thumb-overlay"></div>
        <?php endif;?>
        <a href="<?php echo esc_attr($event['link_detail']); ?>" data-open-type="<?php echo esc_attr($event['open_detail_type']);?>"
           data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>" data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>"
           data-event-id="<?php echo esc_attr($event['id']); ?>"  data-time="<?php echo esc_attr($time);?>"  data-single-time="<?php echo esc_attr($single_time);?>">
            <h2><?php echo esc_html($event['title']); ?></h2>
        </a>
        <div>
            <span class="fat-event-meta-time">
                 <i class="fa fa-clock-o"></i>
                <?php if ($event['all_day_event'] === '1'): ?>
                    <span><?php esc_attr_e('All day', 'fat-event'); ?></span>
                <?php else: ?>
                    <span><?php echo esc_attr($event['start_date']->format($time_format)); ?>
                        - <?php echo esc_html($event['end_date']->format($time_format)); ?> </span>
                <?php endif; ?>
            </span>

            <?php if ($event['location'] && $event['location']!=='' && $event['location']!=='hide'): ?>
                <span class="fat-event-location">
                 <i class="fa fa-map-marker"></i>
                    <?php echo FAT_Event_Utils::get_location_title($event['location'], ' , '); ?>
                            </span>
            <?php endif; ?>
        </div>
        <div class="fat-event-except"><?php echo get_the_excerpt($event['id']); ?></div>
        <a href="<?php echo esc_attr($event['link_detail']); ?>" data-open-type="<?php echo esc_attr($event['open_detail_type']);?>"
           data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>" data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>"
           data-event-id="<?php echo esc_attr($event['id']); ?>"  data-time="<?php echo esc_attr($time);?>"
           class="cd-read-more"><?php echo esc_html__('View detail', 'fat-event'); ?></a>
        <span class="cd-date"><?php echo esc_html($event['start_date']->format($date_format)); ?></span>
    </div> <!-- cd-timeline-content -->
</div> <!-- cd-timeline-block -->