<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/30/2018
 * Time: 9:02 AM
 */

?>
<div class="cd-timeline-block timeline-skin-02" data-event-id="<?php echo esc_attr($event['id']); ?>">
    <div class="cd-timeline-node" style="background-color: <?php echo esc_attr($bd_color); ?>"></div>
    <div class="cd-timeline-content">
        <a href="<?php echo esc_attr($event['link_detail']); ?>" data-open-type="<?php echo esc_attr($event['open_detail_type']);?>"
           data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>" data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>"
           data-event-id="<?php echo esc_attr($event['id']); ?>"  data-time="<?php echo esc_attr($time);?>"  data-single-time="<?php echo esc_attr($single_time);?>">
            <h2><?php echo esc_html($event['title']); ?></h2>
        </a>
        <div>
            <span class="fat-event-meta-time">
                 <i class="fa fa-clock-o"></i>
                <?php if ($event['all_day_event'] === '1'): ?>
                    <span><?php esc_attr_e('All day', 'fat-event'); ?></span>
                <?php else: ?>
                    <span><?php echo esc_attr($event['start_date']->format($time_format)); ?>
                        - <?php echo esc_html($event['end_date']->format($time_format)); ?> </span>
                <?php endif; ?>
            </span>

            <?php if ($event['location'] && $event['location']!=='' && $event['location']!=='hide'): ?>
                <span class="fat-event-location">
                 <i class="fa fa-map-marker"></i>
                    <?php echo FAT_Event_Utils::get_location_title($event['location'], ' , '); ?>
                            </span>
            <?php endif; ?>
        </div>
        <?php
        $hourly_schedule = get_post_meta($event['id'], 'fat-mb-event-detail', true);
        $hourly_schedule = isset($hourly_schedule['schedule']) ? $hourly_schedule['schedule'] : '';
        if (is_array($hourly_schedule) && count($hourly_schedule['from']) > 0 && $hourly_schedule['from'][0]): ?>
        <h5><?php esc_html_e('Hourly schedule','fat-event');?></h5>
        <ul class="fat-event-hourly-schedule">
            <?php
            for ($i = 0; $i < count($hourly_schedule['from']); $i++) { ?>
                <li><?php echo sprintf('%s - %s : %s', $hourly_schedule['from'][$i], $hourly_schedule['to'][$i], $hourly_schedule['title'][$i]); ?> </li>
            <?php };
            endif;
            ?>
        </ul>
        <a href="<?php echo esc_attr($event['link_detail']); ?>" data-open-type="<?php echo esc_attr($event['open_detail_type']);?>"
           data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>" data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>"
           data-event-id="<?php echo esc_attr($event['id']); ?>"  data-time="<?php echo esc_attr($time);?>"
           class="cd-read-more"><?php echo esc_html__('View detail', 'maika'); ?></a>
        <span class="cd-date"><?php echo esc_html($event['start_date']->format($date_format)); ?></span>
    </div> <!-- cd-timeline-content -->
</div> <!-- cd-timeline-block -->