<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/12/2018
 * Time: 2:44 PM
 */
?>
<div class="skin-02 extra-skin-07 <?php echo esc_attr($item_class); ?>" data-event-id="<?php echo esc_attr($event['id']); ?>" data-time="<?php echo esc_attr($time);?>"
     data-single-time="<?php echo esc_attr($single_time);?>">
    <div class="fat-event-item-inner b-radius-5">
        <div class="fat-event-thumb has-hover-effect">
            <a href="<?php echo esc_url($event['link_detail']) ?>" data-open-type="<?php echo esc_attr($event['open_detail_type']);?>" target="<?php echo esc_attr($event['link_open_type']);?>"
               data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>" data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>">
                <img src="<?php echo ($layout === 'masonry' ? FAT_Event_Utils::get_thumbnail_image_masonry($event['id'], $width, $height):  FAT_Event_Utils::get_thumbnail_image($event['id'], $width, $height) ); ?>"
                     width="<?php echo esc_attr($width); ?>" height="<?php echo esc_attr($height); ?>">
            </a>
        </div>
        <div class="fat-event-info">
            <div class="fat-event-meta">
                <div class="fat-event-title">
                    <a href="<?php echo esc_url($event['link_detail']) ?>" data-open-type="<?php echo esc_attr($event['open_detail_type']);?>" target="<?php echo esc_attr($event['link_open_type']);?>"
                       data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>" data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>">
                        <?php echo get_the_title($event['id']); ?>
                    </a>
                </div>

                <div class="fat-event-meta-time">
                    <?php if ($event['all_day_event'] === '1'): ?>
                        <span><?php esc_attr_e('All day', 'fat-event'); ?></span>
                    <?php else: ?>
                        <span><?php echo date_i18n($date_format,$event['start_date']->format('U')). ' '. $event['start_date']->format($time_format);?></span>
                    <?php endif; ?>
                </div>

                <?php
                if ($event['location'] && $event['location']!=='' && $event['location']!=='hide'): ?>
                    <div class="fat-event-location">
                        <?php echo FAT_Event_Utils::get_location_title($event['location'], ', '); ?>
                    </div>
                <?php endif; ?>

                <div class="fat-event-except">
                    <?php echo get_the_excerpt($event['id']); ?>
                </div>
            </div>
        </div>
    </div>
</div>